/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db.partition;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.compiere.db.partition.RangePartitionColumn;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class RangePartitionInterval {
    private String columnName;
    private String name;
    private Object from;
    private Object to;
    private static Pattern yearMonthPattern = Pattern.compile("^([1-9]{1}[0-9]?)\\s+year(?:s)?\\s+([1-9]{1}[0-9]?)\\s+month(?:s)?$");
    private static Pattern yearPattern = Pattern.compile("^([1-9]{1}[0-9]?)\\s+(year)(?:s)?$");
    private static Pattern monthPattern = Pattern.compile("^([1-9]{1}[0-9]?)\\s+(month)(?:s)?$");

    public RangePartitionInterval(String columnName, String name, Object from, Object to) {
        this.columnName = columnName;
        this.name = name;
        this.from = from;
        this.to = to;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getName() {
        return this.name;
    }

    public Object getFrom() {
        return this.from;
    }

    public Object getTo() {
        return this.to;
    }

    public static String validateIntervalPattern(MColumn column) {
        if (DisplayType.isDate(column.getAD_Reference_ID()) || DisplayType.isTimestampWithTimeZone(column.getAD_Reference_ID())) {
            Matcher matcher = yearMonthPattern.matcher(column.getRangePartitionInterval());
            if (!matcher.matches()) {
                matcher = yearPattern.matcher(column.getRangePartitionInterval());
                if (!matcher.matches()) {
                    matcher = monthPattern.matcher(column.getRangePartitionInterval());
                    if (!matcher.matches()) {
                        return Msg.getMsg(Env.getCtx(), "InvalidRangePartitionInterval");
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        if (DisplayType.isNumeric(column.getAD_Reference_ID()) || DisplayType.isID(column.getAD_Reference_ID())) {
            Pattern pattern = Pattern.compile("^[1-9]\\d*$");
            Matcher matcher = pattern.matcher(column.getRangePartitionInterval());
            if (!matcher.matches()) {
                return Msg.getMsg(Env.getCtx(), "InvalidRangePartitionInterval");
            }
            return null;
        }
        return Msg.getMsg(Env.getCtx(), "RangePartitionKeyTypeNotSupported");
    }

    public static List<RangePartitionInterval> createInterval(MTable table2, RangePartitionColumn rangePartitionColumn, String trxName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        MColumn partitionKeyColumn = table2.getColumn(rangePartitionColumn.getColumnName());
        ArrayList<RangePartitionInterval> rangePartitionIntervals = new ArrayList<RangePartitionInterval>();
        if (DisplayType.isDate(partitionKeyColumn.getAD_Reference_ID()) || DisplayType.isTimestampWithTimeZone(partitionKeyColumn.getAD_Reference_ID())) {
            Interval interval = RangePartitionInterval.getInterval(partitionKeyColumn);
            Timestamp minValue = (Timestamp)rangePartitionColumn.getMinValue();
            Timestamp maxValue = (Timestamp)rangePartitionColumn.getMaxValue();
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(minValue.getTime());
            cal.set(cal.get(1), interval.months > 0 ? cal.get(2) : 0, 1);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTimeInMillis(maxValue.getTime());
            while (cal.before(cal2)) {
                String name = cal.get(1) + (String)(interval.months > 0 ? (cal.get(2) + 1 >= 10 ? "_" + (cal.get(2) + 1) : "_0" + (cal.get(2) + 1)) : "");
                String from = dateFormat.format(cal.getTime());
                cal.add(1, interval.years);
                cal.add(2, interval.months);
                String to = dateFormat.format(cal.getTime());
                RangePartitionInterval rangePartitionInterval = new RangePartitionInterval(rangePartitionColumn.getColumnName(), name, "'" + from + "'", "'" + to + "'");
                rangePartitionIntervals.add(rangePartitionInterval);
            }
        } else if (DisplayType.isNumeric(partitionKeyColumn.getAD_Reference_ID()) || DisplayType.isID(partitionKeyColumn.getAD_Reference_ID())) {
            Pattern pattern = Pattern.compile("^[1-9]\\d*$");
            Matcher matcher = pattern.matcher(rangePartitionColumn.getIntervalPattern());
            if (!matcher.matches()) {
                throw new IllegalArgumentException(Msg.getMsg(Env.getCtx(), "InvalidRangePartitionInterval") + " [" + String.valueOf(partitionKeyColumn) + "]");
            }
            BigDecimal interval = new BigDecimal(rangePartitionColumn.getIntervalPattern());
            BigDecimal minValue = (BigDecimal)rangePartitionColumn.getMinValue();
            BigDecimal maxValue = (BigDecimal)rangePartitionColumn.getMaxValue();
            BigDecimal value = minValue.divide(interval).setScale(0, RoundingMode.DOWN).multiply(interval);
            while (value.compareTo(maxValue) <= 0) {
                String name = String.valueOf(value.intValue());
                BigDecimal from = value;
                BigDecimal to = value = value.add(interval);
                RangePartitionInterval rangePartitionInterval = new RangePartitionInterval(rangePartitionColumn.getColumnName(), name, from, to);
                rangePartitionIntervals.add(rangePartitionInterval);
            }
        } else {
            throw new IllegalArgumentException(Msg.getMsg(Env.getCtx(), "RangePartitionKeyTypeNotSupported") + " [" + String.valueOf(partitionKeyColumn) + "]");
        }
        return rangePartitionIntervals;
    }

    public static Interval getInterval(MColumn partitionKeyColumn) {
        int years = 0;
        int months = 0;
        Matcher matcher = yearMonthPattern.matcher(partitionKeyColumn.getRangePartitionInterval());
        if (matcher.matches()) {
            years = Integer.parseInt(matcher.group(1));
            months = Integer.parseInt(matcher.group(2));
        } else {
            matcher = yearPattern.matcher(partitionKeyColumn.getRangePartitionInterval());
            if (matcher.matches()) {
                years = Integer.parseInt(matcher.group(1));
            } else {
                matcher = monthPattern.matcher(partitionKeyColumn.getRangePartitionInterval());
                if (matcher.matches()) {
                    months = Integer.parseInt(matcher.group(1));
                }
            }
        }
        if (years < 0 || months < 0 || years == 0 && months == 0) {
            throw new IllegalArgumentException(Msg.getMsg(Env.getCtx(), "InvalidRangePartitionInterval") + " [" + String.valueOf(partitionKeyColumn) + "]");
        }
        return new Interval(years, months);
    }

    public record Interval(int years, int months) {
    }
}

