/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.charts;

import java.util.regex.Pattern;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumData;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.zkoss.poi.ss.formula.SheetNameFormatter;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;

public class XSSFChartNumDataSource<T>
implements ChartDataSource<T> {
    private CTNumDataSource val;

    public XSSFChartNumDataSource(CTNumDataSource vat) {
        this.val = vat;
    }

    @Override
    public int getPointCount() {
        if (this.val != null) {
            if (this.isReference()) {
                return (int)this.val.getNumRef().getNumCache().getPtCount().getVal();
            }
            return (int)this.val.getNumLit().getPtCount().getVal();
        }
        return 0;
    }

    @Override
    public T getPointAt(int index) {
        if (this.val != null) {
            if (this.isReference()) {
                return (T)Double.valueOf(this.val.getNumRef().getNumCache().getPtArray(index).getV());
            }
            return (T)Double.valueOf(this.val.getNumLit().getPtArray(index).getV());
        }
        return null;
    }

    @Override
    public boolean isReference() {
        return this.val != null && this.val.isSetNumRef();
    }

    @Override
    public boolean isNumeric() {
        return this.val != null && (this.val.isSetNumRef() || this.val.isSetNumLit());
    }

    @Override
    public String getFormulaString() {
        return this.val != null ? this.val.getNumRef().getF() : null;
    }

    @Override
    public void renameSheet(String oldname, String newname) {
        if (this.isReference()) {
            String o = SheetNameFormatter.format(oldname);
            String n = SheetNameFormatter.format(newname);
            String ref = this.val.getNumRef().getF();
            Pattern p = Pattern.compile(o + "!", 16);
            String newref = p.matcher(ref).replaceAll(n + "!");
            if (!newref.equals(ref)) {
                this.val.getNumRef().setF(newref);
                CTNumData cache = this.val.getNumRef().getNumCache();
                if (cache != null) {
                    this.val.getNumRef().unsetNumCache();
                }
            }
        }
    }
}

