/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTAutoFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBreak;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCalcPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTConditionalFormatting;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataValidation;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataValidations;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHeaderFooter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTLegacyDrawing;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCells;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTOutlinePr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageBreak;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageMargins;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageSetUpPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPane;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPrintOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSelection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetCalcPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetFormatPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetView;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetViews;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTablePart;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableParts;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCalcMode;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellFormulaType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPane;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPaneState;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STUnsignedShortHex;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.WorksheetDocument;
import org.w3c.dom.Element;
import org.zkoss.poi.POIXMLDocumentPart;
import org.zkoss.poi.POIXMLException;
import org.zkoss.poi.hssf.record.PasswordRecord;
import org.zkoss.poi.hssf.util.PaneInformation;
import org.zkoss.poi.openxml4j.exceptions.InvalidFormatException;
import org.zkoss.poi.openxml4j.exceptions.PartAlreadyExistsException;
import org.zkoss.poi.openxml4j.opc.PackagePart;
import org.zkoss.poi.openxml4j.opc.PackageRelationship;
import org.zkoss.poi.openxml4j.opc.PackageRelationshipCollection;
import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.FormulaShifter;
import org.zkoss.poi.ss.formula.SheetNameFormatter;
import org.zkoss.poi.ss.usermodel.AutoFilter;
import org.zkoss.poi.ss.usermodel.Cell;
import org.zkoss.poi.ss.usermodel.CellRange;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.DataValidation;
import org.zkoss.poi.ss.usermodel.DataValidationHelper;
import org.zkoss.poi.ss.usermodel.FilterColumn;
import org.zkoss.poi.ss.usermodel.Footer;
import org.zkoss.poi.ss.usermodel.Header;
import org.zkoss.poi.ss.usermodel.PivotCache;
import org.zkoss.poi.ss.usermodel.PivotTable;
import org.zkoss.poi.ss.usermodel.Row;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.usermodel.SheetProtection;
import org.zkoss.poi.ss.util.CellRangeAddress;
import org.zkoss.poi.ss.util.CellRangeAddressList;
import org.zkoss.poi.ss.util.CellReference;
import org.zkoss.poi.ss.util.SSCellRange;
import org.zkoss.poi.ss.util.SheetUtil;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.Internal;
import org.zkoss.poi.util.POILogFactory;
import org.zkoss.poi.util.POILogger;
import org.zkoss.poi.xssf.model.CommentsTable;
import org.zkoss.poi.xssf.usermodel.XSSFAutoFilter;
import org.zkoss.poi.xssf.usermodel.XSSFCell;
import org.zkoss.poi.xssf.usermodel.XSSFClientAnchor;
import org.zkoss.poi.xssf.usermodel.XSSFComment;
import org.zkoss.poi.xssf.usermodel.XSSFConditionalFormatting;
import org.zkoss.poi.xssf.usermodel.XSSFDataValidation;
import org.zkoss.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.zkoss.poi.xssf.usermodel.XSSFDrawing;
import org.zkoss.poi.xssf.usermodel.XSSFEvenFooter;
import org.zkoss.poi.xssf.usermodel.XSSFEvenHeader;
import org.zkoss.poi.xssf.usermodel.XSSFFactory;
import org.zkoss.poi.xssf.usermodel.XSSFFirstFooter;
import org.zkoss.poi.xssf.usermodel.XSSFFirstHeader;
import org.zkoss.poi.xssf.usermodel.XSSFHyperlink;
import org.zkoss.poi.xssf.usermodel.XSSFName;
import org.zkoss.poi.xssf.usermodel.XSSFOddFooter;
import org.zkoss.poi.xssf.usermodel.XSSFOddHeader;
import org.zkoss.poi.xssf.usermodel.XSSFPrintSetup;
import org.zkoss.poi.xssf.usermodel.XSSFRelation;
import org.zkoss.poi.xssf.usermodel.XSSFRow;
import org.zkoss.poi.xssf.usermodel.XSSFSheetConditionalFormatting;
import org.zkoss.poi.xssf.usermodel.XSSFSheetProtection;
import org.zkoss.poi.xssf.usermodel.XSSFTable;
import org.zkoss.poi.xssf.usermodel.XSSFVMLDrawing;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;
import org.zkoss.poi.xssf.usermodel.helpers.ColumnHelper;
import org.zkoss.poi.xssf.usermodel.helpers.XSSFPivotTableHelpers;
import org.zkoss.poi.xssf.usermodel.helpers.XSSFRowShifter;

public class XSSFSheet
extends POIXMLDocumentPart
implements Sheet {
    private static final POILogger logger = POILogFactory.getLogger(XSSFSheet.class);
    protected CTSheet sheet;
    protected CTWorksheet worksheet;
    private TreeMap<Integer, XSSFRow> _rows;
    protected List<XSSFHyperlink> hyperlinks;
    private ColumnHelper columnHelper;
    private CommentsTable sheetComments;
    private Map<Integer, CTCellFormula> sharedFormulas;
    private TreeMap<String, XSSFTable> tables;
    private List<CellRangeAddress> arrayFormulas;
    private XSSFDataValidationHelper dataValidationHelper = new XSSFDataValidationHelper(this);
    private Header _oddHeader;
    private Header _evenHeader;
    private Header _firstHeader;
    private Footer _oddFooter;
    private Footer _evenFooter;
    private Footer _firstFooter;
    private List<XSSFConditionalFormatting> conditionalFormattings;
    private XSSFAutoFilter autoFilter;
    private List<PivotTable> _pivotTables;
    static final double XSSF_DEFAULT_COL_WIDTH = 9.142857;

    protected XSSFSheet() {
        this.onDocumentCreate();
    }

    protected XSSFSheet(PackagePart part, PackageRelationship rel) {
        super(part, rel);
    }

    @Override
    public XSSFWorkbook getWorkbook() {
        return (XSSFWorkbook)this.getParent();
    }

    @Override
    protected void onDocumentRead() {
        try {
            this.read(this.getPackagePart().getInputStream());
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
    }

    protected void read(InputStream is) throws IOException {
        try {
            this.worksheet = WorksheetDocument.Factory.parse((InputStream)is).getWorksheet();
        }
        catch (XmlException e) {
            throw new POIXMLException(e);
        }
        this.initRows(this.worksheet);
        this.columnHelper = new ColumnHelper(this.worksheet);
        for (POIXMLDocumentPart p : this.getRelations()) {
            if (p instanceof CommentsTable) {
                this.sheetComments = (CommentsTable)p;
                break;
            }
            if (!(p instanceof XSSFTable)) continue;
            this.tables.put(p.getPackageRelationship().getId(), (XSSFTable)p);
        }
        this.initHyperlinks();
        this.initAutofilter();
        this.initConditionalFormattings();
    }

    @Override
    protected void onDocumentCreate() {
        this.worksheet = XSSFSheet.newSheet();
        this.initRows(this.worksheet);
        this.columnHelper = new ColumnHelper(this.worksheet);
        this.hyperlinks = new ArrayList<XSSFHyperlink>();
    }

    private void initRows(CTWorksheet worksheet) {
        this._rows = new TreeMap();
        this.tables = new TreeMap();
        this.sharedFormulas = new HashMap<Integer, CTCellFormula>();
        this.arrayFormulas = new ArrayList<CellRangeAddress>();
        for (CTRow row : worksheet.getSheetData().getRowArray()) {
            XSSFRow r = new XSSFRow(row, this);
            this._rows.put(r.getRowNum(), r);
        }
    }

    private void initHyperlinks() {
        this.hyperlinks = new ArrayList<XSSFHyperlink>();
        if (!this.worksheet.isSetHyperlinks()) {
            return;
        }
        try {
            PackageRelationshipCollection hyperRels = this.getPackagePart().getRelationshipsByType(XSSFRelation.SHEET_HYPERLINKS.getRelation());
            for (CTHyperlink hyperlink : this.worksheet.getHyperlinks().getHyperlinkArray()) {
                PackageRelationship hyperRel = null;
                if (hyperlink.getId() != null) {
                    hyperRel = hyperRels.getRelationshipByID(hyperlink.getId());
                }
                this.hyperlinks.add(new XSSFHyperlink(hyperlink, hyperRel));
            }
        }
        catch (InvalidFormatException e) {
            throw new POIXMLException(e);
        }
    }

    private static CTWorksheet newSheet() {
        CTWorksheet worksheet = CTWorksheet.Factory.newInstance();
        CTSheetFormatPr ctFormat = worksheet.addNewSheetFormatPr();
        ctFormat.setDefaultRowHeight(15.0);
        CTSheetView ctView = worksheet.addNewSheetViews().addNewSheetView();
        ctView.setWorkbookViewId(0L);
        worksheet.addNewDimension().setRef("A1");
        worksheet.addNewSheetData();
        CTPageMargins ctMargins = worksheet.addNewPageMargins();
        ctMargins.setBottom(0.75);
        ctMargins.setFooter(0.3);
        ctMargins.setHeader(0.3);
        ctMargins.setLeft(0.7);
        ctMargins.setRight(0.7);
        ctMargins.setTop(0.75);
        return worksheet;
    }

    @Internal
    public CTWorksheet getCTWorksheet() {
        return this.worksheet;
    }

    public ColumnHelper getColumnHelper() {
        return this.columnHelper;
    }

    @Override
    public String getSheetName() {
        return this.sheet.getName();
    }

    @Override
    public int addMergedRegion(CellRangeAddress region) {
        region.validate(SpreadsheetVersion.EXCEL2007);
        this.validateArrayFormulas(region);
        CTMergeCells ctMergeCells = this.worksheet.isSetMergeCells() ? this.worksheet.getMergeCells() : this.worksheet.addNewMergeCells();
        CTMergeCell ctMergeCell = ctMergeCells.addNewMergeCell();
        ctMergeCell.setRef(region.formatAsString());
        return ctMergeCells.sizeOfMergeCellArray();
    }

    private void validateArrayFormulas(CellRangeAddress region) {
        int firstRow = region.getFirstRow();
        int firstColumn = region.getFirstColumn();
        int lastRow = region.getLastRow();
        int lastColumn = region.getLastColumn();
        for (int rowIn = firstRow; rowIn <= lastRow; ++rowIn) {
            for (int colIn = firstColumn; colIn <= lastColumn; ++colIn) {
                CellRangeAddress arrayRange;
                XSSFCell cell;
                XSSFRow row = this.getRow(rowIn);
                if (row == null || (cell = row.getCell(colIn)) == null || !cell.isPartOfArrayFormulaGroup() || (arrayRange = cell.getArrayFormulaRange()).getNumberOfCells() <= 1 || !arrayRange.isInRange(region.getFirstRow(), region.getFirstColumn()) && !arrayRange.isInRange(region.getFirstRow(), region.getFirstColumn())) continue;
                String msg = "The range " + region.formatAsString() + " intersects with a multi-cell array formula. You cannot merge cells of an array.";
                throw new IllegalStateException(msg);
            }
        }
    }

    @Override
    public void autoSizeColumn(int column) {
        this.autoSizeColumn(column, false);
    }

    @Override
    public void autoSizeColumn(int column, boolean useMergedCells) {
        double width = SheetUtil.getColumnWidth(this, column, useMergedCells);
        if (width != -1.0) {
            int maxColumnWidth = 65280;
            if ((width *= 256.0) > (double)maxColumnWidth) {
                width = maxColumnWidth;
            }
            this.setColumnWidth(column, (int)width);
            this.columnHelper.setColBestFit(column, true);
        }
    }

    @Override
    public XSSFDrawing createDrawingPatriarch() {
        POIXMLDocumentPart drawing = null;
        CTDrawing ctDrawing = this.getCTDrawing();
        if (ctDrawing == null) {
            int drawingNumber = this.getPackagePart().getPackage().getPartsByContentType(XSSFRelation.DRAWINGS.getContentType()).size() + 1;
            while (drawing == null) {
                try {
                    drawing = (XSSFDrawing)this.createRelationship(XSSFRelation.DRAWINGS, XSSFFactory.getInstance(), drawingNumber++);
                }
                catch (PartAlreadyExistsException partAlreadyExistsException) {}
            }
            String relId = drawing.getPackageRelationship().getId();
            ctDrawing = this.worksheet.addNewDrawing();
            ctDrawing.setId(relId);
        } else {
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (!(p instanceof XSSFDrawing)) continue;
                XSSFDrawing dr = (XSSFDrawing)p;
                String drId = dr.getPackageRelationship().getId();
                if (!drId.equals(ctDrawing.getId())) break;
                drawing = dr;
                break;
            }
            if (drawing == null) {
                logger.log(7, "Can't find drawing with id=" + ctDrawing.getId() + " in the list of the sheet's relationships");
            }
        }
        return drawing;
    }

    protected XSSFVMLDrawing getVMLDrawing(boolean autoCreate) {
        POIXMLDocumentPart drawing = null;
        CTLegacyDrawing ctDrawing = this.getCTLegacyDrawing();
        if (ctDrawing == null) {
            if (autoCreate) {
                int drawingNumber = this.getPackagePart().getPackage().getPartsByContentType(XSSFRelation.VML_DRAWINGS.getContentType()).size() + 1;
                while (drawing == null) {
                    try {
                        drawing = (XSSFVMLDrawing)this.createRelationship(XSSFRelation.VML_DRAWINGS, XSSFFactory.getInstance(), drawingNumber++);
                    }
                    catch (PartAlreadyExistsException partAlreadyExistsException) {}
                }
                String relId = drawing.getPackageRelationship().getId();
                ctDrawing = this.worksheet.addNewLegacyDrawing();
                ctDrawing.setId(relId);
            }
        } else {
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (!(p instanceof XSSFVMLDrawing)) continue;
                XSSFVMLDrawing dr = (XSSFVMLDrawing)p;
                String drId = dr.getPackageRelationship().getId();
                if (!drId.equals(ctDrawing.getId())) break;
                drawing = dr;
                break;
            }
            if (drawing == null) {
                logger.log(7, "Can't find VML drawing with id=" + ctDrawing.getId() + " in the list of the sheet's relationships");
            }
        }
        return drawing;
    }

    protected CTDrawing getCTDrawing() {
        return this.worksheet.getDrawing();
    }

    protected CTLegacyDrawing getCTLegacyDrawing() {
        return this.worksheet.getLegacyDrawing();
    }

    @Override
    public void createFreezePane(int colSplit, int rowSplit) {
        this.createFreezePane(colSplit, rowSplit, colSplit, rowSplit);
    }

    @Override
    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        CTSheetView ctView = this.getDefaultSheetView();
        if (colSplit == 0 && rowSplit == 0) {
            if (ctView.isSetPane()) {
                ctView.unsetPane();
            }
            ctView.setSelectionArray(null);
            return;
        }
        if (!ctView.isSetPane()) {
            ctView.addNewPane();
        }
        CTPane pane = ctView.getPane();
        if (colSplit > 0) {
            pane.setXSplit((double)colSplit);
        } else if (pane.isSetXSplit()) {
            pane.unsetXSplit();
        }
        if (rowSplit > 0) {
            pane.setYSplit((double)rowSplit);
        } else if (pane.isSetYSplit()) {
            pane.unsetYSplit();
        }
        pane.setState(STPaneState.FROZEN);
        if (rowSplit == 0) {
            pane.setTopLeftCell(new CellReference(0, leftmostColumn).formatAsString());
            pane.setActivePane(STPane.TOP_RIGHT);
        } else if (colSplit == 0) {
            pane.setTopLeftCell(new CellReference(topRow, 0).formatAsString());
            pane.setActivePane(STPane.BOTTOM_LEFT);
        } else {
            pane.setTopLeftCell(new CellReference(topRow, leftmostColumn).formatAsString());
            pane.setActivePane(STPane.BOTTOM_RIGHT);
        }
        ctView.setTopLeftCell(new CellReference(0, 0).formatAsString());
        ctView.setSelectionArray(null);
        CTSelection sel = ctView.addNewSelection();
        sel.setPane(pane.getActivePane());
    }

    @Deprecated
    public XSSFComment createComment() {
        return this.createDrawingPatriarch().createCellComment(new XSSFClientAnchor());
    }

    @Override
    public XSSFRow createRow(int rownum) {
        CTRow ctRow;
        XSSFRow prev = this._rows.get(rownum);
        if (prev != null) {
            ctRow = prev.getCTRow();
            ctRow.set((XmlObject)CTRow.Factory.newInstance());
        } else if (this._rows.isEmpty() || rownum > this._rows.lastKey()) {
            ctRow = this.worksheet.getSheetData().addNewRow();
        } else {
            int idx = this._rows.headMap(rownum).size();
            ctRow = this.worksheet.getSheetData().insertNewRow(idx);
        }
        XSSFRow r = new XSSFRow(ctRow, this);
        r.setRowNum(rownum);
        this._rows.put(rownum, r);
        return r;
    }

    @Override
    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        this.createFreezePane(xSplitPos, ySplitPos, leftmostColumn, topRow);
        this.getPane().setState(STPaneState.SPLIT);
        this.getPane().setActivePane(STPane.Enum.forInt((int)activePane));
    }

    @Override
    public XSSFComment getCellComment(int row, int column) {
        if (this.sheetComments == null) {
            return null;
        }
        String ref = new CellReference(row, column).formatAsString();
        CTComment ctComment = this.sheetComments.getCTComment(ref);
        if (ctComment == null) {
            return null;
        }
        XSSFVMLDrawing vml = this.getVMLDrawing(false);
        return new XSSFComment(this.sheetComments, ctComment, vml == null ? null : vml.findCommentShape(row, column));
    }

    public void removeCellComment(int row, int column) {
        XSSFVMLDrawing vd;
        CommentsTable ct = this.getCommentsTable(false);
        if (ct != null) {
            ct.removeComment(new CellReference(row, column).formatAsString());
        }
        if ((vd = this.getVMLDrawing(false)) != null) {
            vd.removeCommentShape(row, column);
        }
    }

    public XSSFHyperlink getHyperlink(int row, int column) {
        String ref = new CellReference(row, column).formatAsString();
        for (XSSFHyperlink hyperlink : this.hyperlinks) {
            if (!hyperlink.getCellRef().equals(ref)) continue;
            return hyperlink;
        }
        return null;
    }

    @Override
    public int[] getColumnBreaks() {
        if (!this.worksheet.isSetColBreaks() || this.worksheet.getColBreaks().sizeOfBrkArray() == 0) {
            return new int[0];
        }
        CTBreak[] brkArray = this.worksheet.getColBreaks().getBrkArray();
        int[] breaks = new int[brkArray.length];
        for (int i = 0; i < brkArray.length; ++i) {
            CTBreak brk = brkArray[i];
            breaks[i] = (int)brk.getId() - 1;
        }
        return breaks;
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        CTCol col = this.columnHelper.getColumn(columnIndex, false);
        double width = col == null || !col.isSetWidth() ? this.getXssfDefaultColumnWidth() : col.getWidth();
        return (int)(width * 256.0);
    }

    @Override
    public int getDefaultColumnWidth() {
        CTSheetFormatPr pr = this.worksheet.getSheetFormatPr();
        return pr == null ? 8 : (int)pr.getBaseColWidth();
    }

    @Override
    public short getDefaultRowHeight() {
        return (short)(this.getDefaultRowHeightInPoints() * 20.0f);
    }

    @Override
    public float getDefaultRowHeightInPoints() {
        CTSheetFormatPr pr = this.worksheet.getSheetFormatPr();
        return (float)(pr == null ? 0.0 : pr.getDefaultRowHeight());
    }

    private CTSheetFormatPr getSheetTypeSheetFormatPr() {
        return this.worksheet.isSetSheetFormatPr() ? this.worksheet.getSheetFormatPr() : this.worksheet.addNewSheetFormatPr();
    }

    @Override
    public CellStyle getColumnStyle(int column) {
        int idx = this.columnHelper.getColDefaultStyle(column);
        return this.getWorkbook().getCellStyleAt((short)(idx == -1 ? 0 : idx));
    }

    @Override
    public void setRightToLeft(boolean value) {
        CTSheetView view = this.getDefaultSheetView();
        view.setRightToLeft(value);
    }

    @Override
    public boolean isRightToLeft() {
        CTSheetView view = this.getDefaultSheetView();
        return view == null ? false : view.getRightToLeft();
    }

    @Override
    public boolean getDisplayGuts() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTOutlinePr outlinePr = sheetPr.getOutlinePr() == null ? CTOutlinePr.Factory.newInstance() : sheetPr.getOutlinePr();
        return outlinePr.getShowOutlineSymbols();
    }

    @Override
    public void setDisplayGuts(boolean value) {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTOutlinePr outlinePr = sheetPr.getOutlinePr() == null ? sheetPr.addNewOutlinePr() : sheetPr.getOutlinePr();
        outlinePr.setShowOutlineSymbols(value);
    }

    @Override
    public boolean isDisplayZeros() {
        CTSheetView view = this.getDefaultSheetView();
        return view == null ? true : view.getShowZeros();
    }

    @Override
    public void setDisplayZeros(boolean value) {
        CTSheetView view = this.getSheetTypeSheetView();
        view.setShowZeros(value);
    }

    @Override
    public int getFirstRowNum() {
        return this._rows.size() == 0 ? 0 : this._rows.firstKey();
    }

    @Override
    public boolean getFitToPage() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr psSetup = sheetPr == null || !sheetPr.isSetPageSetUpPr() ? CTPageSetUpPr.Factory.newInstance() : sheetPr.getPageSetUpPr();
        return psSetup.getFitToPage();
    }

    private CTSheetPr getSheetTypeSheetPr() {
        if (this.worksheet.getSheetPr() == null) {
            this.worksheet.setSheetPr(CTSheetPr.Factory.newInstance());
        }
        return this.worksheet.getSheetPr();
    }

    private CTHeaderFooter getSheetTypeHeaderFooter() {
        if (this.worksheet.getHeaderFooter() == null) {
            this.worksheet.setHeaderFooter(CTHeaderFooter.Factory.newInstance());
        }
        return this.worksheet.getHeaderFooter();
    }

    @Override
    public Footer getFooter() {
        return this.getOddFooter();
    }

    @Override
    public Header getHeader() {
        return this.getOddHeader();
    }

    public Footer getOddFooter() {
        if (this._oddFooter == null) {
            this._oddFooter = new XSSFOddFooter(this.getSheetTypeHeaderFooter());
        }
        return this._oddFooter;
    }

    @Override
    public Footer getEvenFooter() {
        if (this._evenFooter == null) {
            this._evenFooter = new XSSFEvenFooter(this.getSheetTypeHeaderFooter());
        }
        return this._evenFooter;
    }

    @Override
    public Footer getFirstFooter() {
        if (this._firstFooter == null) {
            this._firstFooter = new XSSFFirstFooter(this.getSheetTypeHeaderFooter());
        }
        return this._firstFooter;
    }

    public Header getOddHeader() {
        if (this._oddHeader == null) {
            this._oddHeader = new XSSFOddHeader(this.getSheetTypeHeaderFooter());
        }
        return this._oddHeader;
    }

    @Override
    public Header getEvenHeader() {
        if (this._evenHeader == null) {
            this._evenHeader = new XSSFEvenHeader(this.getSheetTypeHeaderFooter());
        }
        return this._evenHeader;
    }

    @Override
    public Header getFirstHeader() {
        if (this._firstHeader == null) {
            this._firstHeader = new XSSFFirstHeader(this.getSheetTypeHeaderFooter());
        }
        return this._firstHeader;
    }

    @Override
    public boolean getHorizontallyCenter() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getHorizontalCentered();
    }

    @Override
    public int getLastRowNum() {
        return this._rows.size() == 0 ? 0 : this._rows.lastKey();
    }

    @Override
    public short getLeftCol() {
        String cellRef = this.worksheet.getSheetViews().getSheetViewArray(0).getTopLeftCell();
        CellReference cellReference = new CellReference(cellRef);
        return cellReference.getCol();
    }

    @Override
    public double getMargin(short margin) {
        if (!this.worksheet.isSetPageMargins()) {
            return 0.0;
        }
        CTPageMargins pageMargins = this.worksheet.getPageMargins();
        switch (margin) {
            case 0: {
                return pageMargins.getLeft();
            }
            case 1: {
                return pageMargins.getRight();
            }
            case 2: {
                return pageMargins.getTop();
            }
            case 3: {
                return pageMargins.getBottom();
            }
            case 4: {
                return pageMargins.getHeader();
            }
            case 5: {
                return pageMargins.getFooter();
            }
        }
        throw new IllegalArgumentException("Unknown margin constant:  " + margin);
    }

    @Override
    public void setMargin(short margin, double size) {
        CTPageMargins pageMargins = this.worksheet.isSetPageMargins() ? this.worksheet.getPageMargins() : this.worksheet.addNewPageMargins();
        switch (margin) {
            case 0: {
                pageMargins.setLeft(size);
                break;
            }
            case 1: {
                pageMargins.setRight(size);
                break;
            }
            case 2: {
                pageMargins.setTop(size);
                break;
            }
            case 3: {
                pageMargins.setBottom(size);
                break;
            }
            case 4: {
                pageMargins.setHeader(size);
                break;
            }
            case 5: {
                pageMargins.setFooter(size);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown margin constant:  " + margin);
            }
        }
    }

    @Override
    public CellRangeAddress getMergedRegion(int index) {
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        if (ctMergeCells == null) {
            throw new IllegalStateException("This worksheet does not contain merged regions");
        }
        CTMergeCell ctMergeCell = ctMergeCells.getMergeCellArray(index);
        String ref = ctMergeCell.getRef();
        return CellRangeAddress.valueOf(ref);
    }

    @Override
    public int getNumMergedRegions() {
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        return ctMergeCells == null ? 0 : ctMergeCells.sizeOfMergeCellArray();
    }

    public int getNumHyperlinks() {
        return this.hyperlinks.size();
    }

    @Override
    public PaneInformation getPaneInformation() {
        CTPane pane = this.getDefaultSheetView().getPane();
        if (pane == null) {
            return null;
        }
        CellReference cellRef = pane.isSetTopLeftCell() ? new CellReference(pane.getTopLeftCell()) : null;
        return new PaneInformation((short)pane.getXSplit(), (short)pane.getYSplit(), (short)(cellRef == null ? 0 : cellRef.getRow()), cellRef == null ? (short)0 : cellRef.getCol(), (byte)(pane.getActivePane().intValue() - 1), pane.getState() == STPaneState.FROZEN || pane.getState() == STPaneState.FROZEN_SPLIT);
    }

    @Override
    public int getPhysicalNumberOfRows() {
        return this._rows.size();
    }

    @Override
    public XSSFPrintSetup getPrintSetup() {
        return new XSSFPrintSetup(this.worksheet);
    }

    @Override
    public boolean getProtect() {
        return this.worksheet.isSetSheetProtection() && this.sheetProtectionEnabled();
    }

    @Override
    public void protectSheet(String password) {
        if (password != null) {
            this.createProtectionFieldIfNotPresent();
            CTSheetProtection sheetProtection = this.worksheet.getSheetProtection();
            if (!password.isEmpty()) {
                sheetProtection.xsetPassword(this.stringToExcelPassword(PasswordRecord.hashPassword(password)));
            }
            sheetProtection.setSheet(true);
            if (sheetProtection.isSetScenarios() && !sheetProtection.getScenarios()) {
                sheetProtection.unsetScenarios();
            }
            if (sheetProtection.isSetObjects() && !sheetProtection.getObjects()) {
                sheetProtection.unsetObjects();
            }
        } else {
            CTSheetProtection sheetProtection = this.worksheet.getSheetProtection();
            if (sheetProtection != null) {
                if (sheetProtection.isSetScenarios()) {
                    sheetProtection.unsetScenarios();
                }
                if (sheetProtection.isSetObjects()) {
                    sheetProtection.unsetObjects();
                }
                if (this.isEmptySheetProtection()) {
                    this.worksheet.unsetSheetProtection();
                }
            }
        }
    }

    private boolean isEmptySheetProtection() {
        CTSheetProtection ct = this.worksheet.getSheetProtection();
        return ct == null || !ct.isSetAutoFilter() && !ct.isSetDeleteColumns() && !ct.isSetDeleteRows() && !ct.isSetFormatCells() && !ct.isSetFormatColumns() && !ct.isSetFormatRows() && !ct.isSetInsertColumns() && !ct.isSetInsertHyperlinks() && !ct.isSetInsertRows() && !ct.isSetObjects() && !ct.isSetPassword() && !ct.isSetPivotTables() && !ct.isSetScenarios() && !ct.isSetSelectLockedCells() && !ct.isSetSelectUnlockedCells() && !ct.isSetSheet() && !ct.isSetSort();
    }

    private STUnsignedShortHex stringToExcelPassword(short hashpass) {
        STUnsignedShortHex hexPassword = STUnsignedShortHex.Factory.newInstance();
        hexPassword.setStringValue(String.valueOf(HexDump.shortToHex(hashpass)).substring(2));
        return hexPassword;
    }

    @Override
    public XSSFRow getRow(int rownum) {
        return this._rows.get(rownum);
    }

    @Override
    public int[] getRowBreaks() {
        if (!this.worksheet.isSetRowBreaks() || this.worksheet.getRowBreaks().sizeOfBrkArray() == 0) {
            return new int[0];
        }
        CTBreak[] brkArray = this.worksheet.getRowBreaks().getBrkArray();
        int[] breaks = new int[brkArray.length];
        for (int i = 0; i < brkArray.length; ++i) {
            CTBreak brk = brkArray[i];
            breaks[i] = (int)brk.getId() - 1;
        }
        return breaks;
    }

    @Override
    public boolean getRowSumsBelow() {
        CTSheetPr sheetPr = this.worksheet.getSheetPr();
        CTOutlinePr outlinePr = sheetPr != null && sheetPr.isSetOutlinePr() ? sheetPr.getOutlinePr() : null;
        return outlinePr == null || outlinePr.getSummaryBelow();
    }

    @Override
    public void setRowSumsBelow(boolean value) {
        this.ensureOutlinePr().setSummaryBelow(value);
    }

    @Override
    public boolean getRowSumsRight() {
        CTSheetPr sheetPr = this.worksheet.getSheetPr();
        CTOutlinePr outlinePr = sheetPr != null && sheetPr.isSetOutlinePr() ? sheetPr.getOutlinePr() : CTOutlinePr.Factory.newInstance();
        return outlinePr.getSummaryRight();
    }

    @Override
    public void setRowSumsRight(boolean value) {
        this.ensureOutlinePr().setSummaryRight(value);
    }

    private CTOutlinePr ensureOutlinePr() {
        CTSheetPr sheetPr = this.worksheet.isSetSheetPr() ? this.worksheet.getSheetPr() : this.worksheet.addNewSheetPr();
        return sheetPr.isSetOutlinePr() ? sheetPr.getOutlinePr() : sheetPr.addNewOutlinePr();
    }

    @Override
    public boolean getScenarioProtect() {
        return this.worksheet.isSetSheetProtection() && this.worksheet.getSheetProtection().getScenarios();
    }

    @Override
    public short getTopRow() {
        String cellRef = this.getSheetTypeSheetView().getTopLeftCell();
        CellReference cellReference = new CellReference(cellRef);
        return (short)cellReference.getRow();
    }

    @Override
    public boolean getVerticallyCenter() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getVerticalCentered();
    }

    @Override
    public void groupColumn(int fromColumn, int toColumn) {
        this.groupColumn1Based(fromColumn + 1, toColumn + 1);
    }

    private void groupColumn1Based(int fromColumn, int toColumn) {
        CTCols ctCols = this.worksheet.getColsArray(0);
        CTCol ctCol = CTCol.Factory.newInstance();
        ctCol.setMin((long)fromColumn);
        ctCol.setMax((long)toColumn);
        this.columnHelper.addCleanColIntoCols(ctCols, ctCol);
        for (int index = fromColumn; index <= toColumn; ++index) {
            CTCol col = this.columnHelper.getColumn1Based(index, false);
            short outlineLevel = col.getOutlineLevel();
            col.setOutlineLevel((short)(outlineLevel + 1));
            index = (int)col.getMax();
        }
        this.worksheet.setColsArray(0, ctCols);
        this.setSheetFormatPrOutlineLevelCol();
    }

    @Override
    public void groupRow(int fromRow, int toRow) {
        for (int i = fromRow; i <= toRow; ++i) {
            XSSFRow xrow = this.getRow(i);
            if (xrow == null) {
                xrow = this.createRow(i);
            }
            CTRow ctrow = xrow.getCTRow();
            short outlineLevel = ctrow.getOutlineLevel();
            ctrow.setOutlineLevel((short)(outlineLevel + 1));
        }
        this.setSheetFormatPrOutlineLevelRow();
    }

    private short getMaxOutlineLevelRows() {
        short outlineLevel = 0;
        for (XSSFRow xrow : this._rows.values()) {
            outlineLevel = xrow.getCTRow().getOutlineLevel() > outlineLevel ? xrow.getCTRow().getOutlineLevel() : outlineLevel;
        }
        return outlineLevel;
    }

    private short getMaxOutlineLevelCols() {
        CTCols ctCols = this.worksheet.getColsArray(0);
        short outlineLevel = 0;
        for (CTCol col : ctCols.getColArray()) {
            outlineLevel = col.getOutlineLevel() > outlineLevel ? col.getOutlineLevel() : outlineLevel;
        }
        return outlineLevel;
    }

    @Override
    public boolean isColumnBroken(int column) {
        int[] colBreaks = this.getColumnBreaks();
        for (int i = 0; i < colBreaks.length; ++i) {
            if (colBreaks[i] != column) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isColumnHidden(int columnIndex) {
        CTCol col = this.columnHelper.getColumn(columnIndex, false);
        return col != null && col.getHidden();
    }

    @Override
    public boolean isDisplayFormulas() {
        return this.getSheetTypeSheetView().getShowFormulas();
    }

    @Override
    public boolean isDisplayGridlines() {
        return this.getSheetTypeSheetView().getShowGridLines();
    }

    @Override
    public void setDisplayGridlines(boolean show) {
        this.getSheetTypeSheetView().setShowGridLines(show);
    }

    @Override
    public boolean isDisplayRowColHeadings() {
        return this.getSheetTypeSheetView().getShowRowColHeaders();
    }

    @Override
    public void setDisplayRowColHeadings(boolean show) {
        this.getSheetTypeSheetView().setShowRowColHeaders(show);
    }

    @Override
    public boolean isPrintGridlines() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getGridLines();
    }

    @Override
    public void setPrintGridlines(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setGridLines(value);
    }

    @Override
    public boolean isRowBroken(int row) {
        int[] rowBreaks = this.getRowBreaks();
        for (int i = 0; i < rowBreaks.length; ++i) {
            if (rowBreaks[i] != row) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setRowBreak(int row) {
        CTPageBreak pgBreak;
        CTPageBreak cTPageBreak = pgBreak = this.worksheet.isSetRowBreaks() ? this.worksheet.getRowBreaks() : this.worksheet.addNewRowBreaks();
        if (!this.isRowBroken(row)) {
            CTBreak brk = pgBreak.addNewBrk();
            brk.setId((long)(row + 1));
            brk.setMan(true);
            brk.setMax((long)SpreadsheetVersion.EXCEL2007.getLastColumnIndex());
            pgBreak.setCount((long)pgBreak.sizeOfBrkArray());
            pgBreak.setManualBreakCount((long)pgBreak.sizeOfBrkArray());
        }
    }

    @Override
    public void removeColumnBreak(int column) {
        if (!this.worksheet.isSetColBreaks()) {
            return;
        }
        CTPageBreak pgBreak = this.worksheet.getColBreaks();
        CTBreak[] brkArray = pgBreak.getBrkArray();
        for (int i = 0; i < brkArray.length; ++i) {
            if (brkArray[i].getId() != (long)(column + 1)) continue;
            pgBreak.removeBrk(i);
        }
    }

    @Override
    public void removeMergedRegion(int index) {
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        CTMergeCell[] mergeCellsArray = new CTMergeCell[ctMergeCells.sizeOfMergeCellArray() - 1];
        for (int i = 0; i < ctMergeCells.sizeOfMergeCellArray(); ++i) {
            if (i < index) {
                mergeCellsArray[i] = ctMergeCells.getMergeCellArray(i);
                continue;
            }
            if (i <= index) continue;
            mergeCellsArray[i - 1] = ctMergeCells.getMergeCellArray(i);
        }
        if (mergeCellsArray.length > 0) {
            ctMergeCells.setMergeCellArray(mergeCellsArray);
        } else if (this.worksheet.isSetMergeCells()) {
            this.worksheet.unsetMergeCells();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeRow(Row row) {
        void var4_8;
        CTRow r;
        if (row.getSheet() != this) {
            throw new IllegalArgumentException("Specified row does not belong to this sheet");
        }
        ArrayList<XSSFCell> cellsToDelete = new ArrayList<XSSFCell>();
        for (Cell cell : row) {
            cellsToDelete.add((XSSFCell)cell);
        }
        for (XSSFCell xSSFCell : cellsToDelete) {
            row.removeCell(xSSFCell);
        }
        this._rows.remove(row.getRowNum());
        CTRow ctr = ((XSSFRow)row).getCTRow();
        boolean bl = false;
        Iterator iterator = this.worksheet.getSheetData().getRowList().iterator();
        while (iterator.hasNext() && (r = (CTRow)iterator.next()).getR() != ctr.getR()) {
            ++var4_8;
        }
        this.worksheet.getSheetData().removeRow((int)var4_8);
    }

    @Override
    public void removeRowBreak(int row) {
        if (!this.worksheet.isSetRowBreaks()) {
            return;
        }
        CTPageBreak pgBreak = this.worksheet.getRowBreaks();
        CTBreak[] brkArray = pgBreak.getBrkArray();
        for (int i = 0; i < brkArray.length; ++i) {
            if (brkArray[i].getId() != (long)(row + 1)) continue;
            pgBreak.removeBrk(i);
        }
    }

    @Override
    public void setForceFormulaRecalculation(boolean value) {
        CTCalcPr calcPr = this.getWorkbook().getCTWorkbook().getCalcPr();
        if (this.worksheet.isSetSheetCalcPr()) {
            CTSheetCalcPr calc = this.worksheet.getSheetCalcPr();
            calc.setFullCalcOnLoad(value);
        } else if (value) {
            CTSheetCalcPr calc = this.worksheet.addNewSheetCalcPr();
            calc.setFullCalcOnLoad(value);
        }
        if (value && calcPr != null && calcPr.getCalcMode() == STCalcMode.MANUAL) {
            calcPr.setCalcMode(STCalcMode.AUTO);
        }
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        if (this.worksheet.isSetSheetCalcPr()) {
            CTSheetCalcPr calc = this.worksheet.getSheetCalcPr();
            return calc.getFullCalcOnLoad();
        }
        return false;
    }

    @Override
    public Iterator<Row> rowIterator() {
        return this._rows.values().iterator();
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    @Override
    public boolean getAutobreaks() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr psSetup = sheetPr == null || !sheetPr.isSetPageSetUpPr() ? CTPageSetUpPr.Factory.newInstance() : sheetPr.getPageSetUpPr();
        return psSetup.getAutoPageBreaks();
    }

    @Override
    public void setAutobreaks(boolean value) {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr psSetup = sheetPr.isSetPageSetUpPr() ? sheetPr.getPageSetUpPr() : sheetPr.addNewPageSetUpPr();
        psSetup.setAutoPageBreaks(value);
    }

    @Override
    public void setColumnBreak(int column) {
        if (!this.isColumnBroken(column)) {
            CTPageBreak pgBreak = this.worksheet.isSetColBreaks() ? this.worksheet.getColBreaks() : this.worksheet.addNewColBreaks();
            CTBreak brk = pgBreak.addNewBrk();
            brk.setId((long)(column + 1));
            brk.setMan(true);
            brk.setMax((long)SpreadsheetVersion.EXCEL2007.getLastRowIndex());
            pgBreak.setCount((long)pgBreak.sizeOfBrkArray());
            pgBreak.setManualBreakCount((long)pgBreak.sizeOfBrkArray());
        }
    }

    @Override
    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
        if (collapsed) {
            this.collapseColumn(columnNumber);
        } else {
            this.expandColumn(columnNumber);
        }
    }

    private void collapseColumn(int columnNumber) {
        CTCol col;
        CTCols cols = this.worksheet.getColsArray(0);
        int colInfoIx = this.columnHelper.getIndexOfColumn(cols, col = this.columnHelper.getColumn(columnNumber, false));
        if (colInfoIx == -1) {
            return;
        }
        int groupStartColInfoIx = this.findStartOfColumnOutlineGroup(colInfoIx);
        CTCol columnInfo = cols.getColArray(groupStartColInfoIx);
        int lastColMax = this.setGroupHidden(groupStartColInfoIx, columnInfo.getOutlineLevel(), true);
        this.setColumn(lastColMax + 1, null, 0, null, null, Boolean.TRUE);
    }

    private void setColumn(int targetColumnIx, Short xfIndex, Integer style, Integer level, Boolean hidden, Boolean collapsed) {
        boolean columnChanged;
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol ci = null;
        int k = 0;
        for (k = 0; k < cols.sizeOfColArray(); ++k) {
            CTCol tci = cols.getColArray(k);
            if (tci.getMin() >= (long)targetColumnIx && tci.getMax() <= (long)targetColumnIx) {
                ci = tci;
                break;
            }
            if (tci.getMin() > (long)targetColumnIx) break;
        }
        if (ci == null) {
            CTCol nci = CTCol.Factory.newInstance();
            nci.setMin((long)targetColumnIx);
            nci.setMax((long)targetColumnIx);
            this.unsetCollapsed(collapsed, nci);
            this.columnHelper.addCleanColIntoCols(cols, nci);
            return;
        }
        boolean styleChanged = style != null && ci.getStyle() != (long)style.intValue();
        boolean levelChanged = level != null && ci.getOutlineLevel() != level.intValue();
        boolean hiddenChanged = hidden != null && ci.getHidden() != hidden.booleanValue();
        boolean collapsedChanged = collapsed != null && ci.getCollapsed() != collapsed.booleanValue();
        boolean bl = columnChanged = levelChanged || hiddenChanged || collapsedChanged || styleChanged;
        if (!columnChanged) {
            return;
        }
        if (ci.getMin() == (long)targetColumnIx && ci.getMax() == (long)targetColumnIx) {
            this.unsetCollapsed(collapsed, ci);
            return;
        }
        if (ci.getMin() == (long)targetColumnIx || ci.getMax() == (long)targetColumnIx) {
            if (ci.getMin() == (long)targetColumnIx) {
                ci.setMin((long)(targetColumnIx + 1));
            } else {
                ci.setMax((long)(targetColumnIx - 1));
                ++k;
            }
            CTCol nci = this.columnHelper.cloneCol(cols, ci);
            nci.setMin((long)targetColumnIx);
            this.unsetCollapsed(collapsed, nci);
            this.columnHelper.addCleanColIntoCols(cols, nci);
        } else {
            CTCol ciStart = ci;
            CTCol ciMid = this.columnHelper.cloneCol(cols, ci);
            CTCol ciEnd = this.columnHelper.cloneCol(cols, ci);
            int lastcolumn = (int)ci.getMax();
            ciStart.setMax((long)(targetColumnIx - 1));
            ciMid.setMin((long)targetColumnIx);
            ciMid.setMax((long)targetColumnIx);
            this.unsetCollapsed(collapsed, ciMid);
            this.columnHelper.addCleanColIntoCols(cols, ciMid);
            ciEnd.setMin((long)(targetColumnIx + 1));
            ciEnd.setMax((long)lastcolumn);
            this.columnHelper.addCleanColIntoCols(cols, ciEnd);
        }
    }

    private void unsetCollapsed(boolean collapsed, CTCol ci) {
        if (collapsed) {
            ci.setCollapsed(collapsed);
        } else if (ci.isSetCollapsed()) {
            ci.unsetCollapsed();
        }
    }

    private int setGroupHidden(int pIdx, int level, boolean hidden) {
        int idx;
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol columnInfo = cols.getColArray(idx);
        for (idx = pIdx; idx < cols.sizeOfColArray(); ++idx) {
            columnInfo.setHidden(hidden);
            if (idx + 1 >= cols.sizeOfColArray()) continue;
            CTCol nextColumnInfo = cols.getColArray(idx + 1);
            if (!this.isAdjacentBefore(columnInfo, nextColumnInfo) || nextColumnInfo.getOutlineLevel() < level) break;
            columnInfo = nextColumnInfo;
        }
        return (int)columnInfo.getMax();
    }

    private boolean isAdjacentBefore(CTCol col, CTCol other_col) {
        return col.getMax() == other_col.getMin() - 1L;
    }

    private int findStartOfColumnOutlineGroup(int pIdx) {
        CTCol prevColumnInfo;
        int idx;
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol columnInfo = cols.getColArray(pIdx);
        short level = columnInfo.getOutlineLevel();
        for (idx = pIdx; idx != 0 && this.isAdjacentBefore(prevColumnInfo = cols.getColArray(idx - 1), columnInfo) && prevColumnInfo.getOutlineLevel() >= level; --idx) {
            columnInfo = prevColumnInfo;
        }
        return idx;
    }

    private int findEndOfColumnOutlineGroup(int colInfoIndex) {
        CTCol nextColumnInfo;
        int idx;
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol columnInfo = cols.getColArray(colInfoIndex);
        short level = columnInfo.getOutlineLevel();
        for (idx = colInfoIndex; idx < cols.sizeOfColArray() - 1 && this.isAdjacentBefore(columnInfo, nextColumnInfo = cols.getColArray(idx + 1)) && nextColumnInfo.getOutlineLevel() >= level; ++idx) {
            columnInfo = nextColumnInfo;
        }
        return idx;
    }

    private void expandColumn(int columnIndex) {
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol col = this.columnHelper.getColumn(columnIndex, false);
        int colInfoIx = this.columnHelper.getIndexOfColumn(cols, col);
        int idx = this.findColInfoIdx((int)col.getMax(), colInfoIx);
        if (idx == -1) {
            return;
        }
        if (!this.isColumnGroupCollapsed(idx)) {
            return;
        }
        int startIdx = this.findStartOfColumnOutlineGroup(idx);
        int endIdx = this.findEndOfColumnOutlineGroup(idx);
        CTCol columnInfo = cols.getColArray(endIdx);
        if (!this.isColumnGroupHiddenByParent(idx)) {
            short outlineLevel = columnInfo.getOutlineLevel();
            boolean nestedGroup = false;
            for (int i = startIdx; i <= endIdx; ++i) {
                CTCol ci = cols.getColArray(i);
                if (outlineLevel == ci.getOutlineLevel()) {
                    if (ci.isSetHidden()) {
                        ci.unsetHidden();
                    }
                    if (!nestedGroup) continue;
                    nestedGroup = false;
                    ci.setCollapsed(true);
                    continue;
                }
                nestedGroup = true;
            }
        }
        this.setColumn((int)columnInfo.getMax() + 1, null, null, null, Boolean.FALSE, Boolean.FALSE);
    }

    private boolean isColumnGroupHiddenByParent(int idx) {
        CTCol prevInfo;
        CTCols cols = this.worksheet.getColsArray(0);
        short endLevel = 0;
        boolean endHidden = false;
        int endOfOutlineGroupIdx = this.findEndOfColumnOutlineGroup(idx);
        if (endOfOutlineGroupIdx < cols.sizeOfColArray()) {
            CTCol nextInfo = cols.getColArray(endOfOutlineGroupIdx + 1);
            if (this.isAdjacentBefore(cols.getColArray(endOfOutlineGroupIdx), nextInfo)) {
                endLevel = nextInfo.getOutlineLevel();
                endHidden = nextInfo.getHidden();
            }
        }
        short startLevel = 0;
        boolean startHidden = false;
        int startOfOutlineGroupIdx = this.findStartOfColumnOutlineGroup(idx);
        if (startOfOutlineGroupIdx > 0 && this.isAdjacentBefore(prevInfo = cols.getColArray(startOfOutlineGroupIdx - 1), cols.getColArray(startOfOutlineGroupIdx))) {
            startLevel = prevInfo.getOutlineLevel();
            startHidden = prevInfo.getHidden();
        }
        if (endLevel > startLevel) {
            return endHidden;
        }
        return startHidden;
    }

    private int findColInfoIdx(int columnValue, int fromColInfoIdx) {
        CTCols cols = this.worksheet.getColsArray(0);
        if (columnValue < 0) {
            throw new IllegalArgumentException("column parameter out of range: " + columnValue);
        }
        if (fromColInfoIdx < 0) {
            throw new IllegalArgumentException("fromIdx parameter out of range: " + fromColInfoIdx);
        }
        for (int k = fromColInfoIdx; k < cols.sizeOfColArray(); ++k) {
            CTCol ci = cols.getColArray(k);
            if (this.containsColumn(ci, columnValue)) {
                return k;
            }
            if (ci.getMin() > (long)fromColInfoIdx) break;
        }
        return -1;
    }

    private boolean containsColumn(CTCol col, int columnIndex) {
        return col.getMin() <= (long)columnIndex && (long)columnIndex <= col.getMax();
    }

    private boolean isColumnGroupCollapsed(int idx) {
        CTCols cols = this.worksheet.getColsArray(0);
        int endOfOutlineGroupIdx = this.findEndOfColumnOutlineGroup(idx);
        int nextColInfoIx = endOfOutlineGroupIdx + 1;
        if (nextColInfoIx >= cols.sizeOfColArray()) {
            return false;
        }
        CTCol nextColInfo = cols.getColArray(nextColInfoIx);
        CTCol col = cols.getColArray(endOfOutlineGroupIdx);
        if (!this.isAdjacentBefore(col, nextColInfo)) {
            return false;
        }
        return nextColInfo.getCollapsed();
    }

    @Override
    public void setColumnHidden(int columnIndex, boolean hidden) {
        this.columnHelper.setColHidden(columnIndex, hidden);
    }

    @Override
    public void setColumnWidth(int columnIndex, int width) {
        if (width > 65280) {
            throw new IllegalArgumentException("The maximum column width for an individual cell is 255 characters.");
        }
        this.columnHelper.setColWidth(columnIndex, (double)width / 256.0);
        this.columnHelper.setCustomWidth(columnIndex, true);
    }

    @Override
    public void setDefaultColumnStyle(int column, CellStyle style) {
        this.columnHelper.setColDefaultStyle((long)column, style);
    }

    @Override
    public void setDefaultColumnWidth(int width) {
        this.getSheetTypeSheetFormatPr().setBaseColWidth((long)width);
    }

    @Override
    public void setDefaultRowHeight(short height) {
        this.setDefaultRowHeightInPoints((float)height / 20.0f);
    }

    @Override
    public void setDefaultRowHeightInPoints(float height) {
        CTSheetFormatPr pr = this.getSheetTypeSheetFormatPr();
        pr.setDefaultRowHeight((double)height);
    }

    @Override
    public void setDisplayFormulas(boolean show) {
        this.getSheetTypeSheetView().setShowFormulas(show);
    }

    private CTSheetView getSheetTypeSheetView() {
        if (this.getDefaultSheetView() == null) {
            this.getSheetTypeSheetViews().setSheetViewArray(0, CTSheetView.Factory.newInstance());
        }
        return this.getDefaultSheetView();
    }

    @Override
    public void setFitToPage(boolean b) {
        this.getSheetTypePageSetUpPr().setFitToPage(b);
    }

    @Override
    public void setHorizontallyCenter(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setHorizontalCentered(value);
    }

    @Override
    public void setVerticallyCenter(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setVerticalCentered(value);
    }

    @Override
    public void setRowGroupCollapsed(int rowIndex, boolean collapse) {
        if (collapse) {
            this.collapseRow(rowIndex);
        } else {
            this.expandRow(rowIndex);
        }
    }

    private void collapseRow(int rowIndex) {
        XSSFRow row = this.getRow(rowIndex);
        if (row != null) {
            int startRow = this.findStartOfRowOutlineGroup(rowIndex);
            int lastRow = this.writeHidden(row, startRow, true);
            if (this.getRow(lastRow) != null) {
                this.getRow(lastRow).getCTRow().setCollapsed(true);
            } else {
                XSSFRow newRow = this.createRow(lastRow);
                newRow.getCTRow().setCollapsed(true);
            }
        }
    }

    private int findStartOfRowOutlineGroup(int rowIndex) {
        short level = this.getRow(rowIndex).getCTRow().getOutlineLevel();
        int currentRow = rowIndex;
        while (this.getRow(currentRow) != null) {
            if (this.getRow(currentRow).getCTRow().getOutlineLevel() < level) {
                return currentRow + 1;
            }
            --currentRow;
        }
        return currentRow;
    }

    private int writeHidden(XSSFRow xRow, int rowIndex, boolean hidden) {
        short level = xRow.getCTRow().getOutlineLevel();
        Iterator<Row> it = this.rowIterator();
        while (it.hasNext()) {
            xRow = (XSSFRow)it.next();
            if (xRow.getCTRow().getOutlineLevel() < level) continue;
            xRow.getCTRow().setHidden(hidden);
            ++rowIndex;
        }
        return rowIndex;
    }

    private void expandRow(int rowNumber) {
        if (rowNumber == -1) {
            return;
        }
        XSSFRow row = this.getRow(rowNumber);
        if (!row.getCTRow().isSetHidden()) {
            return;
        }
        int startIdx = this.findStartOfRowOutlineGroup(rowNumber);
        int endIdx = this.findEndOfRowOutlineGroup(rowNumber);
        if (!this.isRowGroupHiddenByParent(rowNumber)) {
            for (int i = startIdx; i < endIdx; ++i) {
                XSSFRow rowi = this.getRow(i);
                CTRow ctrowi = rowi.getCTRow();
                if (row.getCTRow().getOutlineLevel() == ctrowi.getOutlineLevel()) {
                    if (!ctrowi.isSetHidden()) continue;
                    ctrowi.unsetHidden();
                    continue;
                }
                if (this.isRowGroupCollapsed(i) || !ctrowi.isSetHidden()) continue;
                ctrowi.unsetHidden();
            }
        }
        if (this.getRow(endIdx).getCTRow().isSetCollapsed()) {
            this.getRow(endIdx).getCTRow().unsetCollapsed();
        }
    }

    public int findEndOfRowOutlineGroup(int row) {
        int currentRow;
        short level = this.getRow(row).getCTRow().getOutlineLevel();
        for (currentRow = row; currentRow < this.getLastRowNum() && this.getRow(currentRow) != null && this.getRow(currentRow).getCTRow().getOutlineLevel() >= level; ++currentRow) {
        }
        return currentRow;
    }

    private boolean isRowGroupHiddenByParent(int row) {
        boolean startHidden;
        short startLevel;
        boolean endHidden;
        short endLevel;
        int endOfOutlineGroupIdx = this.findEndOfRowOutlineGroup(row);
        if (this.getRow(endOfOutlineGroupIdx) == null) {
            endLevel = 0;
            endHidden = false;
        } else {
            endLevel = this.getRow(endOfOutlineGroupIdx).getCTRow().getOutlineLevel();
            endHidden = this.getRow(endOfOutlineGroupIdx).getCTRow().getHidden();
        }
        int startOfOutlineGroupIdx = this.findStartOfRowOutlineGroup(row);
        if (startOfOutlineGroupIdx < 0 || this.getRow(startOfOutlineGroupIdx) == null) {
            startLevel = 0;
            startHidden = false;
        } else {
            startLevel = this.getRow(startOfOutlineGroupIdx).getCTRow().getOutlineLevel();
            startHidden = this.getRow(startOfOutlineGroupIdx).getCTRow().getHidden();
        }
        if (endLevel > startLevel) {
            return endHidden;
        }
        return startHidden;
    }

    private boolean isRowGroupCollapsed(int row) {
        int collapseRow = this.findEndOfRowOutlineGroup(row) + 1;
        if (this.getRow(collapseRow) == null) {
            return false;
        }
        return this.getRow(collapseRow).getCTRow().getCollapsed();
    }

    @Override
    public void setZoom(int numerator, int denominator) {
        int zoom = 100 * numerator / denominator;
        this.setZoom(zoom);
    }

    public void setZoom(int scale) {
        if (scale < 10 || scale > 400) {
            throw new IllegalArgumentException("Valid scale values range from 10 to 400");
        }
        this.getSheetTypeSheetView().setZoomScale((long)scale);
    }

    @Override
    public void shiftRows(int startRow, int endRow, int n) {
        this.shiftRows(startRow, endRow, n, false, false);
    }

    @Override
    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        Iterator<Row> it = this.rowIterator();
        while (it.hasNext()) {
            XSSFRow row = (XSSFRow)it.next();
            int rownum = row.getRowNum();
            if (rownum < startRow) continue;
            if (!copyRowHeight) {
                row.setHeight((short)-1);
            }
            if (this.removeRow(startRow, endRow, n, rownum)) {
                int idx = this._rows.headMap(row.getRowNum()).size();
                this.worksheet.getSheetData().removeRow(idx);
                it.remove();
            } else if (rownum >= startRow && rownum <= endRow) {
                row.shift(n);
            }
            if (this.sheetComments == null) continue;
            CTCommentList lst = this.sheetComments.getCTComments().getCommentList();
            for (CTComment comment : lst.getCommentArray()) {
                CellReference ref = new CellReference(comment.getRef());
                if (ref.getRow() != rownum) continue;
                ref = new CellReference(rownum + n, ref.getCol());
                comment.setRef(ref.formatAsString());
            }
        }
        XSSFRowShifter rowShifter = new XSSFRowShifter(this);
        int sheetIndex = this.getWorkbook().getSheetIndex(this);
        FormulaShifter shifter = FormulaShifter.createForRowShift(sheetIndex, startRow, endRow, n);
        rowShifter.updateNamedRanges(shifter);
        rowShifter.updateFormulas(shifter);
        rowShifter.shiftMerged(startRow, endRow, n);
        rowShifter.updateConditionalFormatting(shifter);
        TreeMap<Integer, XSSFRow> map = new TreeMap<Integer, XSSFRow>();
        for (XSSFRow r : this._rows.values()) {
            map.put(r.getRowNum(), r);
        }
        this._rows = map;
    }

    @Override
    public void showInPane(short toprow, short leftcol) {
        CellReference cellReference = new CellReference((int)toprow, leftcol);
        String cellRef = cellReference.formatAsString();
        this.getPane().setTopLeftCell(cellRef);
    }

    @Override
    public void ungroupColumn(int fromColumn, int toColumn) {
        CTCols cols = this.worksheet.getColsArray(0);
        for (int index = fromColumn; index <= toColumn; ++index) {
            CTCol col = this.columnHelper.getColumn(index, false);
            if (col == null) continue;
            short outlineLevel = col.getOutlineLevel();
            col.setOutlineLevel((short)(outlineLevel - 1));
            index = (int)col.getMax();
            if (col.getOutlineLevel() > 0) continue;
            int colIndex = this.columnHelper.getIndexOfColumn(cols, col);
            this.worksheet.getColsArray(0).removeCol(colIndex);
        }
        this.worksheet.setColsArray(0, cols);
        this.setSheetFormatPrOutlineLevelCol();
    }

    @Override
    public void ungroupRow(int fromRow, int toRow) {
        for (int i = fromRow; i <= toRow; ++i) {
            XSSFRow xrow = this.getRow(i);
            if (xrow == null) continue;
            CTRow ctrow = xrow.getCTRow();
            short outlinelevel = ctrow.getOutlineLevel();
            ctrow.setOutlineLevel((short)(outlinelevel - 1));
            if (ctrow.getOutlineLevel() != 0 || xrow.getFirstCellNum() != -1) continue;
            this.removeRow(xrow);
        }
        this.setSheetFormatPrOutlineLevelRow();
    }

    private void setSheetFormatPrOutlineLevelRow() {
        short maxLevelRow = this.getMaxOutlineLevelRows();
        this.getSheetTypeSheetFormatPr().setOutlineLevelRow(maxLevelRow);
    }

    private void setSheetFormatPrOutlineLevelCol() {
        short maxLevelCol = this.getMaxOutlineLevelCols();
        this.getSheetTypeSheetFormatPr().setOutlineLevelCol(maxLevelCol);
    }

    private CTSheetViews getSheetTypeSheetViews() {
        if (this.worksheet.getSheetViews() == null) {
            this.worksheet.setSheetViews(CTSheetViews.Factory.newInstance());
            this.worksheet.getSheetViews().addNewSheetView();
        }
        return this.worksheet.getSheetViews();
    }

    @Override
    public boolean isSelected() {
        CTSheetView view = this.getDefaultSheetView();
        return view != null && view.getTabSelected();
    }

    @Override
    public void setSelected(boolean value) {
        CTSheetViews views = this.getSheetTypeSheetViews();
        for (CTSheetView view : views.getSheetViewArray()) {
            view.setTabSelected(value);
        }
    }

    @Deprecated
    public static void setCellComment(String cellRef, XSSFComment comment) {
        CellReference cellReference = new CellReference(cellRef);
        comment.setRow(cellReference.getRow());
        comment.setColumn(cellReference.getCol());
    }

    @Internal
    public void addHyperlink(XSSFHyperlink hyperlink) {
        this.hyperlinks.add(hyperlink);
    }

    public String getActiveCell() {
        return this.getSheetTypeSelection().getActiveCell();
    }

    public void setActiveCell(String cellRef) {
        CTSelection ctsel = this.getSheetTypeSelection();
        ctsel.setActiveCell(cellRef);
        ctsel.setSqref(Arrays.asList(cellRef));
    }

    public boolean hasComments() {
        if (this.sheetComments == null) {
            return false;
        }
        return this.sheetComments.getNumberOfComments() > 0;
    }

    protected int getNumberOfComments() {
        if (this.sheetComments == null) {
            return 0;
        }
        return this.sheetComments.getNumberOfComments();
    }

    private CTSelection getSheetTypeSelection() {
        if (this.getSheetTypeSheetView().sizeOfSelectionArray() == 0) {
            this.getSheetTypeSheetView().insertNewSelection(0);
        }
        return this.getSheetTypeSheetView().getSelectionArray(0);
    }

    private CTSheetView getDefaultSheetView() {
        int sz;
        CTSheetViews views = this.getSheetTypeSheetViews();
        int n = sz = views == null ? 0 : views.sizeOfSheetViewArray();
        if (sz == 0) {
            return null;
        }
        return views.getSheetViewArray(sz - 1);
    }

    protected CommentsTable getCommentsTable(boolean create) {
        if (this.sheetComments == null && create) {
            try {
                this.sheetComments = (CommentsTable)this.createRelationship(XSSFRelation.SHEET_COMMENTS, XSSFFactory.getInstance(), (int)this.sheet.getSheetId());
            }
            catch (PartAlreadyExistsException e) {
                this.sheetComments = (CommentsTable)this.createRelationship(XSSFRelation.SHEET_COMMENTS, XSSFFactory.getInstance(), -1);
            }
        }
        return this.sheetComments;
    }

    private CTPageSetUpPr getSheetTypePageSetUpPr() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        return sheetPr.isSetPageSetUpPr() ? sheetPr.getPageSetUpPr() : sheetPr.addNewPageSetUpPr();
    }

    private boolean removeRow(int startRow, int endRow, int n, int rownum) {
        if (rownum >= startRow + n && rownum <= endRow + n) {
            if (n > 0 && rownum > endRow) {
                return true;
            }
            if (n < 0 && rownum < startRow) {
                return true;
            }
        }
        return false;
    }

    private CTPane getPane() {
        if (this.getDefaultSheetView().getPane() == null) {
            this.getDefaultSheetView().addNewPane();
        }
        return this.getDefaultSheetView().getPane();
    }

    CTCellFormula getSharedFormula(int sid) {
        return this.sharedFormulas.get(sid);
    }

    void onReadCell(XSSFCell cell) {
        CTCell ct = cell.getCTCell();
        CTCellFormula f = ct.getF();
        if (f != null && f.getT() == STCellFormulaType.SHARED && f.isSetRef() && f.getStringValue() != null) {
            CTCellFormula sf = (CTCellFormula)f.copy();
            CellRangeAddress sfRef = CellRangeAddress.valueOf(sf.getRef());
            CellReference cellRef = new CellReference(cell);
            if (cellRef.getCol() > sfRef.getFirstColumn() || cellRef.getRow() > sfRef.getFirstRow()) {
                String effectiveRef = new CellRangeAddress(Math.max(cellRef.getRow(), sfRef.getFirstRow()), sfRef.getLastRow(), Math.max(cellRef.getCol(), sfRef.getFirstColumn()), sfRef.getLastColumn()).formatAsString();
                sf.setRef(effectiveRef);
            }
            this.sharedFormulas.put((int)f.getSi(), sf);
        }
        if (f != null && f.getT() == STCellFormulaType.ARRAY && f.getRef() != null) {
            this.arrayFormulas.add(CellRangeAddress.valueOf(f.getRef()));
        }
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        this.clearMemoryPackagePart(part);
        OutputStream out = part.getOutputStream();
        this.write(out);
        out.close();
    }

    protected void write(OutputStream out) throws IOException {
        CTCols col;
        if (this.worksheet.sizeOfColsArray() == 1 && (col = this.worksheet.getColsArray(0)).sizeOfColArray() == 0) {
            this.worksheet.setColsArray(null);
        }
        if (this.hyperlinks.size() > 0) {
            if (this.worksheet.getHyperlinks() == null) {
                this.worksheet.addNewHyperlinks();
            }
            CTHyperlink[] ctHls = new CTHyperlink[this.hyperlinks.size()];
            for (int i = 0; i < ctHls.length; ++i) {
                XSSFHyperlink hyperlink = this.hyperlinks.get(i);
                hyperlink.generateRelationIfNeeded(this.getPackagePart());
                ctHls[i] = hyperlink.getCTHyperlink();
            }
            this.worksheet.getHyperlinks().setHyperlinkArray(ctHls);
            this.hyperlinks.clear();
            try {
                PackageRelationshipCollection hyperRels = this.getPackagePart().getRelationshipsByType(XSSFRelation.SHEET_HYPERLINKS.getRelation());
                for (CTHyperlink hyperlink : this.worksheet.getHyperlinks().getHyperlinkArray()) {
                    PackageRelationship hyperRel = null;
                    if (hyperlink.getId() != null) {
                        hyperRel = hyperRels.getRelationshipByID(hyperlink.getId());
                    }
                    this.hyperlinks.add(new XSSFHyperlink(hyperlink, hyperRel));
                }
            }
            catch (InvalidFormatException e) {
                throw new POIXMLException(e);
            }
        } else if (this.worksheet.getHyperlinks() != null) {
            this.worksheet.unsetHyperlinks();
        }
        for (XSSFRow row : this._rows.values()) {
            row.onDocumentWrite();
        }
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTWorksheet.type.getName().getNamespaceURI(), "worksheet"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(map);
        this.writeCondtionalFormattings();
        this.worksheet.save(out, xmlOptions);
    }

    public boolean isAutoFilterLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getAutoFilter();
    }

    public boolean isDeleteColumnsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getDeleteColumns();
    }

    public boolean isDeleteRowsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getDeleteRows();
    }

    public boolean isFormatCellsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getFormatCells();
    }

    public boolean isFormatColumnsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getFormatColumns();
    }

    public boolean isFormatRowsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getFormatRows();
    }

    public boolean isInsertColumnsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getInsertColumns();
    }

    public boolean isInsertHyperlinksLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getInsertHyperlinks();
    }

    public boolean isInsertRowsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getInsertRows();
    }

    public boolean isPivotTablesLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getPivotTables();
    }

    public boolean isSortLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getSort();
    }

    public boolean isObjectsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getObjects();
    }

    public boolean isScenariosLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getScenarios();
    }

    public boolean isSelectLockedCellsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getSelectLockedCells();
    }

    public boolean isSelectUnlockedCellsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getSelectUnlockedCells();
    }

    public boolean isSheetLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getSheet();
    }

    public void enableLocking() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setSheet(true);
    }

    public void disableLocking() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setSheet(false);
    }

    public void lockAutoFilter() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setAutoFilter(true);
    }

    public void lockDeleteColumns() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setDeleteColumns(true);
    }

    public void lockDeleteRows() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setDeleteRows(true);
    }

    public void lockFormatCells() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setDeleteColumns(true);
    }

    public void lockFormatColumns() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setFormatColumns(true);
    }

    public void lockFormatRows() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setFormatRows(true);
    }

    public void lockInsertColumns() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setInsertColumns(true);
    }

    public void lockInsertHyperlinks() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setInsertHyperlinks(true);
    }

    public void lockInsertRows() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setInsertRows(true);
    }

    public void lockPivotTables() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setPivotTables(true);
    }

    public void lockSort() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setSort(true);
    }

    public void lockObjects() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setObjects(true);
    }

    public void lockScenarios() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setScenarios(true);
    }

    public void lockSelectLockedCells() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setSelectLockedCells(true);
    }

    public void lockSelectUnlockedCells() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setSelectUnlockedCells(true);
    }

    private void createProtectionFieldIfNotPresent() {
        if (this.worksheet.getSheetProtection() == null) {
            CTSheetProtection sheetProtection = CTSheetProtection.Factory.newInstance();
            sheetProtection.setObjects(true);
            sheetProtection.setScenarios(true);
            this.worksheet.setSheetProtection(sheetProtection);
        }
    }

    private boolean sheetProtectionEnabled() {
        return this.worksheet.getSheetProtection().getSheet();
    }

    boolean isCellInArrayFormulaContext(XSSFCell cell) {
        for (CellRangeAddress range : this.arrayFormulas) {
            if (!range.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            return true;
        }
        return false;
    }

    XSSFCell getFirstCellInArrayFormula(XSSFCell cell) {
        for (CellRangeAddress range : this.arrayFormulas) {
            if (!range.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            return this.getRow(range.getFirstRow()).getCell(range.getFirstColumn());
        }
        return null;
    }

    private CellRange<XSSFCell> getCellRange(CellRangeAddress range) {
        int firstRow = range.getFirstRow();
        int firstColumn = range.getFirstColumn();
        int lastRow = range.getLastRow();
        int lastColumn = range.getLastColumn();
        int height = lastRow - firstRow + 1;
        int width = lastColumn - firstColumn + 1;
        ArrayList<XSSFCell> temp = new ArrayList<XSSFCell>(height * width);
        for (int rowIn = firstRow; rowIn <= lastRow; ++rowIn) {
            for (int colIn = firstColumn; colIn <= lastColumn; ++colIn) {
                XSSFCell cell;
                XSSFRow row = this.getRow(rowIn);
                if (row == null) {
                    row = this.createRow(rowIn);
                }
                if ((cell = row.getCell(colIn)) == null) {
                    cell = row.createCell(colIn);
                }
                temp.add(cell);
            }
        }
        return SSCellRange.create(firstRow, firstColumn, height, width, temp, XSSFCell.class);
    }

    public CellRange<XSSFCell> setArrayFormula(String formula, CellRangeAddress range) {
        CellRange<XSSFCell> cr = this.getCellRange(range);
        XSSFCell mainArrayFormulaCell = cr.getTopLeftCell();
        mainArrayFormulaCell.setCellArrayFormula(formula, range);
        this.arrayFormulas.add(range);
        return cr;
    }

    public CellRange<XSSFCell> removeArrayFormula(Cell cell) {
        if (cell.getSheet() != this) {
            throw new IllegalArgumentException("Specified cell does not belong to this sheet.");
        }
        for (CellRangeAddress range : this.arrayFormulas) {
            if (!range.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            this.arrayFormulas.remove(range);
            CellRange<XSSFCell> cr = this.getCellRange(range);
            for (XSSFCell c : cr) {
                c.setCellType(3);
            }
            return cr;
        }
        String ref = ((XSSFCell)cell).getCTCell().getR();
        throw new IllegalArgumentException("Cell " + ref + " is not part of an array formula.");
    }

    @Override
    public DataValidationHelper getDataValidationHelper() {
        return this.dataValidationHelper;
    }

    @Override
    public List<DataValidation> getDataValidations() {
        ArrayList<DataValidation> xssfValidations = new ArrayList<DataValidation>();
        CTDataValidations dataValidations = this.worksheet.getDataValidations();
        if (dataValidations != null && dataValidations.getCount() > 0L) {
            for (CTDataValidation ctDataValidation : dataValidations.getDataValidationArray()) {
                CellRangeAddressList addressList = new CellRangeAddressList();
                List sqref = ctDataValidation.getSqref();
                for (String stRef : sqref) {
                    String[] regions = stRef.split(" ");
                    for (int i = 0; i < regions.length; ++i) {
                        String[] parts = regions[i].split(":");
                        CellReference begin = new CellReference(parts[0]);
                        CellReference end = parts.length > 1 ? new CellReference(parts[1]) : begin;
                        CellRangeAddress cellRangeAddress = new CellRangeAddress(begin.getRow(), end.getRow(), begin.getCol(), end.getCol());
                        addressList.addCellRangeAddress(cellRangeAddress);
                    }
                }
                XSSFDataValidation xssfDataValidation = new XSSFDataValidation(addressList, ctDataValidation);
                xssfValidations.add(xssfDataValidation);
            }
        }
        return xssfValidations;
    }

    @Override
    public void addValidationData(DataValidation dataValidation) {
        XSSFDataValidation xssfDataValidation = (XSSFDataValidation)dataValidation;
        CTDataValidations dataValidations = this.worksheet.getDataValidations();
        if (dataValidations == null) {
            dataValidations = this.worksheet.addNewDataValidations();
        }
        int currentCount = dataValidations.sizeOfDataValidationArray();
        CTDataValidation newval = dataValidations.addNewDataValidation();
        newval.set((XmlObject)xssfDataValidation.getCtDdataValidation());
        dataValidations.setCount((long)(currentCount + 1));
    }

    public XSSFTable createTable() {
        if (!this.worksheet.isSetTableParts()) {
            this.worksheet.addNewTableParts();
        }
        CTTableParts tblParts = this.worksheet.getTableParts();
        CTTablePart tbl = tblParts.addNewTablePart();
        int tableNumber = this.getPackagePart().getPackage().getPartsByContentType(XSSFRelation.TABLE.getContentType()).size() + 1;
        POIXMLDocumentPart table = null;
        while (table == null) {
            try {
                table = (XSSFTable)this.createRelationship(XSSFRelation.TABLE, XSSFFactory.getInstance(), tableNumber++);
            }
            catch (PartAlreadyExistsException partAlreadyExistsException) {}
        }
        tbl.setId(table.getPackageRelationship().getId());
        this.tables.put(tbl.getId(), (XSSFTable)table);
        return table;
    }

    public List<XSSFTable> getTables() {
        ArrayList<XSSFTable> tableList = new ArrayList<XSSFTable>(this.tables.values());
        return tableList;
    }

    @Override
    public XSSFSheetConditionalFormatting getSheetConditionalFormatting() {
        return new XSSFSheetConditionalFormatting(this);
    }

    public void setTabColor(int colorIndex) {
        CTSheetPr pr = this.worksheet.getSheetPr();
        if (pr == null) {
            pr = this.worksheet.addNewSheetPr();
        }
        CTColor color = CTColor.Factory.newInstance();
        color.setIndexed((long)colorIndex);
        pr.setTabColor(color);
    }

    @Override
    public CellRangeAddress getRepeatingRows() {
        return this.getRepeatingRowsOrColums(true);
    }

    @Override
    public CellRangeAddress getRepeatingColumns() {
        return this.getRepeatingRowsOrColums(false);
    }

    @Override
    public void setRepeatingRows(CellRangeAddress rowRangeRef) {
        CellRangeAddress columnRangeRef = this.getRepeatingColumns();
        this.setRepeatingRowsAndColumns(rowRangeRef, columnRangeRef);
    }

    @Override
    public void setRepeatingColumns(CellRangeAddress columnRangeRef) {
        CellRangeAddress rowRangeRef = this.getRepeatingRows();
        this.setRepeatingRowsAndColumns(rowRangeRef, columnRangeRef);
    }

    private void setRepeatingRowsAndColumns(CellRangeAddress rowDef, CellRangeAddress colDef) {
        int col1 = -1;
        int col2 = -1;
        int row1 = -1;
        int row2 = -1;
        if (rowDef != null) {
            row1 = rowDef.getFirstRow();
            row2 = rowDef.getLastRow();
            if (row1 == -1 && row2 != -1 || row1 < -1 || row2 < -1 || row1 > row2) {
                throw new IllegalArgumentException("Invalid row range specification");
            }
        }
        if (colDef != null) {
            col1 = colDef.getFirstColumn();
            col2 = colDef.getLastColumn();
            if (col1 == -1 && col2 != -1 || col1 < -1 || col2 < -1 || col1 > col2) {
                throw new IllegalArgumentException("Invalid column range specification");
            }
        }
        int sheetIndex = this.getWorkbook().getSheetIndex(this);
        boolean removeAll = rowDef == null && colDef == null;
        XSSFName name = this.getWorkbook().getBuiltInName("_xlnm.Print_Titles", sheetIndex);
        if (removeAll) {
            if (name != null) {
                this.getWorkbook().removeName(name);
            }
            return;
        }
        if (name == null) {
            name = this.getWorkbook().createBuiltInName("_xlnm.Print_Titles", sheetIndex);
        }
        String reference = XSSFSheet.getReferenceBuiltInRecord(name.getSheetName(), col1, col2, row1, row2);
        name.setRefersToFormula(reference);
        if (!this.worksheet.isSetPageSetup() || !this.worksheet.isSetPageMargins()) {
            this.getPrintSetup().setValidSettings(false);
        }
    }

    private static String getReferenceBuiltInRecord(String sheetName, int startC, int endC, int startR, int endR) {
        CellReference colRef = new CellReference(sheetName, 0, startC, true, true);
        CellReference colRef2 = new CellReference(sheetName, 0, endC, true, true);
        CellReference rowRef = new CellReference(sheetName, startR, 0, true, true);
        CellReference rowRef2 = new CellReference(sheetName, endR, 0, true, true);
        String escapedName = SheetNameFormatter.format(sheetName);
        String c = "";
        String r = "";
        if (startC != -1 || endC != -1) {
            c = escapedName + "!$" + colRef.getCellRefParts()[2] + ":$" + colRef2.getCellRefParts()[2];
        }
        if (!(startR == -1 && endR == -1 || rowRef.getCellRefParts()[1].equals("0") || rowRef2.getCellRefParts()[1].equals("0"))) {
            r = escapedName + "!$" + rowRef.getCellRefParts()[1] + ":$" + rowRef2.getCellRefParts()[1];
        }
        StringBuffer rng = new StringBuffer();
        rng.append(c);
        if (rng.length() > 0 && r.length() > 0) {
            rng.append(',');
        }
        rng.append(r);
        return rng.toString();
    }

    private CellRangeAddress getRepeatingRowsOrColums(boolean rows) {
        int sheetIndex = this.getWorkbook().getSheetIndex(this);
        XSSFName name = this.getWorkbook().getBuiltInName("_xlnm.Print_Titles", sheetIndex);
        if (name == null) {
            return null;
        }
        String refStr = name.getRefersToFormula();
        if (refStr == null) {
            return null;
        }
        String[] parts = refStr.split(",");
        int maxRowIndex = SpreadsheetVersion.EXCEL2007.getLastRowIndex();
        int maxColIndex = SpreadsheetVersion.EXCEL2007.getLastColumnIndex();
        for (String part : parts) {
            CellRangeAddress range = CellRangeAddress.valueOf(part);
            if (!(range.getFirstColumn() == 0 && range.getLastColumn() == maxColIndex || range.getFirstColumn() == -1 && range.getLastColumn() == -1 ? rows : (range.getFirstRow() == 0 && range.getLastRow() == maxRowIndex || range.getFirstRow() == -1 && range.getLastRow() == -1) && !rows)) continue;
            return range;
        }
        return null;
    }

    protected TreeMap<Integer, XSSFRow> getRows() {
        return this._rows;
    }

    protected void setRows(TreeMap<Integer, XSSFRow> rows) {
        this._rows = rows;
    }

    @Override
    public boolean isAutoFilterMode() {
        return this.worksheet.getAutoFilter() != null;
    }

    @Override
    public CellRangeAddress removeAutoFilter() {
        CTSheetPr sheetPr = this.worksheet.getSheetPr();
        if (sheetPr != null) {
            sheetPr.setFilterMode(false);
        }
        if (this.worksheet.isSetAutoFilter()) {
            this.worksheet.unsetAutoFilter();
        }
        this.autoFilter = null;
        XSSFWorkbook wb = this.getWorkbook();
        int sheetIndex = this.getWorkbook().getSheetIndex(this);
        XSSFName name = wb.getBuiltInName("_xlnm._FilterDatabase", sheetIndex);
        wb.removeName(name);
        return CellRangeAddress.valueOf(name.getRefersToFormula());
    }

    @Override
    public AutoFilter getAutoFilter() {
        return this.autoFilter;
    }

    public void setAutoFilterMode(boolean b) {
        if (!b && this.isAutoFilterMode()) {
            this.removeAutoFilter();
        }
    }

    public boolean isFilterMode() {
        List<FilterColumn> fcs;
        if (this.autoFilter != null && (fcs = this.autoFilter.getFilterColumns()) != null) {
            for (FilterColumn fc : fcs) {
                List<String> filters = fc.getFilters();
                if (filters.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeValidationData(DataValidation dataValidation) {
        XSSFDataValidation xssfDataValidation = (XSSFDataValidation)dataValidation;
        CTDataValidations dataValidations = this.worksheet.getDataValidations();
        if (dataValidations == null) {
            return;
        }
        int currentCount = dataValidations.sizeOfDataValidationArray();
        CTDataValidation[] dvArray = dataValidations.getDataValidationArray();
        for (int i = 0; i < dvArray.length; ++i) {
            if (!dvArray[i].equals(xssfDataValidation.getCtDdataValidation())) continue;
            dataValidations.removeDataValidation(i);
        }
        dataValidations.setCount((long)(currentCount - 1));
    }

    private void initAutofilter() {
        CTAutoFilter af = this.worksheet.getAutoFilter();
        if (af != null) {
            this.autoFilter = new XSSFAutoFilter(af, this.getWorkbook());
        }
    }

    @Override
    public AutoFilter setAutoFilter(CellRangeAddress range) {
        CTAutoFilter ctaf;
        if (this.isAutoFilterMode()) {
            this.removeAutoFilter();
            if (range == null) {
                return null;
            }
        }
        if ((ctaf = this.worksheet.getAutoFilter()) == null) {
            ctaf = this.worksheet.addNewAutoFilter();
        }
        String ref = range.formatAsString();
        ctaf.setRef(ref);
        int left = range.getFirstColumn();
        int top = range.getFirstRow();
        int right = range.getLastColumn();
        int bottom = range.getLastRow();
        XSSFWorkbook wb = this.getWorkbook();
        int sheetIndex = this.getWorkbook().getSheetIndex(this);
        XSSFName name = wb.getBuiltInName("_xlnm._FilterDatabase", sheetIndex);
        if (name == null) {
            name = wb.createBuiltInName("_xlnm._FilterDatabase", sheetIndex);
            name.getCTName().setHidden(true);
        }
        CellReference r1 = new CellReference(this.getSheetName(), top, left, true, true);
        CellReference r2 = new CellReference(null, bottom, right, true, true);
        String fmla = r1.formatAsString() + ":" + r2.formatAsString();
        name.setRefersToFormula(fmla);
        CTSheetPr sheetPr = this.worksheet.getSheetPr();
        if (sheetPr == null) {
            sheetPr = this.worksheet.addNewSheetPr();
        }
        sheetPr.setFilterMode(true);
        this.autoFilter = new XSSFAutoFilter(ctaf);
        for (int i = 0; i < this.getNumMergedRegions(); ++i) {
            CellRangeAddress mrng = this.getMergedRegion(i);
            int t = mrng.getFirstRow();
            int b = mrng.getLastRow();
            int l = mrng.getFirstColumn();
            int r = mrng.getLastColumn();
            if (t != top || l > right || l < left) continue;
            for (int c = l; c < r; ++c) {
                int colId = c - left;
                XSSFAutoFilter.XSSFFilterColumn fc = (XSSFAutoFilter.XSSFFilterColumn)this.autoFilter.getOrCreateFilterColumn(colId);
                fc.setProperties(null, 1, null, false);
            }
        }
        return this.autoFilter;
    }

    @Override
    public DataValidation getDataValidation(int row, int col) {
        List<DataValidation> dvs = this.getDataValidations();
        if (dvs != null) {
            for (DataValidation dv : dvs) {
                CellRangeAddressList addrList = dv.getRegions();
                int len = addrList.countRanges();
                for (int j = 0; j < len; ++j) {
                    CellRangeAddress addr = addrList.getCellRangeAddress(j);
                    if (!addr.isInRange(row, col)) continue;
                    return dv;
                }
            }
        }
        return null;
    }

    @Override
    public List<PivotTable> getPivotTables() {
        if (this._pivotTables == null) {
            this._pivotTables = XSSFPivotTableHelpers.instance.getHelper().initPivotTables(this);
        }
        return this._pivotTables;
    }

    @Override
    public PivotTable createPivotTable(CellReference destination, String name, PivotCache pivotCache) {
        return XSSFPivotTableHelpers.instance.getHelper().createPivotTable(destination, name, pivotCache, this);
    }

    @Override
    public boolean isColumnCustom(int columnIndex) {
        return this.getColumnHelper().getCustomWidth(columnIndex);
    }

    @Override
    public SheetProtection getOrCreateSheetProtection() {
        this.createProtectionFieldIfNotPresent();
        return new XSSFSheetProtection(this.worksheet.getSheetProtection());
    }

    public void setPasswordHash(short hashpass) {
        CTSheetProtection sheetProtection = this.worksheet.getSheetProtection();
        if (sheetProtection != null && this.sheetProtectionEnabled()) {
            sheetProtection.xsetPassword(this.stringToExcelPassword(hashpass));
        }
    }

    public short getPasswordHash() {
        CTSheetProtection sheetProtection = this.worksheet.getSheetProtection();
        if (sheetProtection != null && this.sheetProtectionEnabled()) {
            byte[] bytes = sheetProtection.getPassword();
            return bytes == null ? (short)0 : (short)(bytes[0] << 8 | bytes[1]);
        }
        return 0;
    }

    @Override
    public boolean isDiffOddEven() {
        return this.getSheetTypeHeaderFooter().getDifferentOddEven();
    }

    @Override
    public void setDiffOddEven(boolean flag) {
        this.getSheetTypeHeaderFooter().setDifferentOddEven(flag);
    }

    @Override
    public boolean isDiffFirst() {
        return this.getSheetTypeHeaderFooter().getDifferentFirst();
    }

    @Override
    public void setDiffFirst(boolean flag) {
        this.getSheetTypeHeaderFooter().setDifferentFirst(flag);
    }

    @Override
    public boolean isScaleWithDoc() {
        return this.getSheetTypeHeaderFooter().getScaleWithDoc();
    }

    @Override
    public void setScalWithDoc(boolean flag) {
        this.getSheetTypeHeaderFooter().setScaleWithDoc(flag);
    }

    @Override
    public boolean isAlignMargins() {
        return this.getSheetTypeHeaderFooter().getAlignWithMargins();
    }

    @Override
    public void setAlignMargins(boolean flag) {
        this.getSheetTypeHeaderFooter().setAlignWithMargins(flag);
    }

    @Override
    public boolean isPrintHeadings() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getHeadings();
    }

    @Override
    public void setPrintHeadings(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setHeadings(value);
    }

    public double getXssfDefaultColumnWidth() {
        CTSheetFormatPr pr = this.worksheet.getSheetFormatPr();
        return pr == null ? 9.142857 : (pr.isSetDefaultColWidth() ? pr.getDefaultColWidth() : (pr.isSetBaseColWidth() ? this.getXssfDefaultColumnWidthPerBaseColWidth((int)pr.getBaseColWidth()) : 9.142857));
    }

    public XSSFTable getTableByRowCol(int rowIdx, int colIdx) {
        for (XSSFTable tb : this.tables.values()) {
            CellReference cr1 = tb.getStartCellReference();
            CellReference cr2 = tb.getEndCellReference();
            if (cr1.getRow() > rowIdx || rowIdx > cr2.getRow() || cr1.getCol() > colIdx || colIdx > cr2.getCol()) continue;
            return tb;
        }
        return null;
    }

    public String getHashValue() {
        CTSheetProtection sheetProtection = this.worksheet.getSheetProtection();
        if (sheetProtection != null && this.sheetProtectionEnabled()) {
            SimpleValue hashValue = (SimpleValue)sheetProtection.selectAttribute("", "hashValue");
            return hashValue == null ? null : hashValue.getStringValue();
        }
        return null;
    }

    public void setHashValue(String hashValue) {
        this.createProtectionFieldIfNotPresent();
        CTSheetProtection sheetProtection = this.worksheet.getSheetProtection();
        if (hashValue != null) {
            ((Element)sheetProtection.getDomNode()).setAttribute("hashValue", hashValue);
        } else {
            ((Element)sheetProtection.getDomNode()).removeAttribute("hashValue");
        }
    }

    public String getSaltValue() {
        CTSheetProtection sheetProtection = this.worksheet.getSheetProtection();
        if (sheetProtection != null && this.sheetProtectionEnabled()) {
            SimpleValue saltValue = (SimpleValue)sheetProtection.selectAttribute("", "saltValue");
            return saltValue == null ? null : saltValue.getStringValue();
        }
        return null;
    }

    public void setSaltValue(String saltValue) {
        this.createProtectionFieldIfNotPresent();
        CTSheetProtection sheetProtection = this.worksheet.getSheetProtection();
        if (saltValue != null) {
            ((Element)sheetProtection.getDomNode()).setAttribute("saltValue", saltValue);
        } else {
            ((Element)sheetProtection.getDomNode()).removeAttribute("saltValue");
        }
    }

    public String getSpinCount() {
        CTSheetProtection sheetProtection = this.worksheet.getSheetProtection();
        if (sheetProtection != null && this.sheetProtectionEnabled()) {
            SimpleValue spinCount = (SimpleValue)sheetProtection.selectAttribute("", "spinCount");
            return spinCount == null ? null : spinCount.getStringValue();
        }
        return null;
    }

    public void setSpinCount(String spinCount) {
        this.createProtectionFieldIfNotPresent();
        CTSheetProtection sheetProtection = this.worksheet.getSheetProtection();
        if (spinCount != null) {
            ((Element)sheetProtection.getDomNode()).setAttribute("spinCount", spinCount);
        } else {
            ((Element)sheetProtection.getDomNode()).removeAttribute("spinCount");
        }
    }

    public String getAlgName() {
        CTSheetProtection sheetProtection = this.worksheet.getSheetProtection();
        if (sheetProtection != null && this.sheetProtectionEnabled()) {
            SimpleValue algName = (SimpleValue)sheetProtection.selectAttribute("", "algorithmName");
            return algName == null ? null : algName.getStringValue();
        }
        return null;
    }

    public void setAlgName(String algName) {
        this.createProtectionFieldIfNotPresent();
        CTSheetProtection sheetProtection = this.worksheet.getSheetProtection();
        if (algName != null) {
            ((Element)sheetProtection.getDomNode()).setAttribute("algorithmName", algName);
        } else {
            ((Element)sheetProtection.getDomNode()).removeAttribute("algorithmName");
        }
    }

    public double getXssfDefaultColumnWidthPerBaseColWidth(int baseWidth) {
        int charWidth = this.getWorkbook().getCharWidth();
        int defaultPx = this.defaultColumnWidthToPx(baseWidth, charWidth);
        return this.pxToCTChar(defaultPx, charWidth);
    }

    private int defaultColumnWidthToPx(int columnWidth, int charWidth) {
        int w;
        int diff = (w = columnWidth * charWidth + 5) % 8;
        return w + (diff > 0 ? 8 - diff : 0);
    }

    private int pxToFileChar256(int px, int charWidth) {
        double w = px;
        return (int)Math.floor(w * 256.0 / (double)charWidth + 0.5);
    }

    private double pxToCTChar(int px, int charWidth) {
        return (double)this.pxToFileChar256(px, charWidth) / 256.0;
    }

    private void initConditionalFormattings() {
        int sz = this.worksheet.sizeOfConditionalFormattingArray();
        if (sz == 0) {
            return;
        }
        this.conditionalFormattings = new ArrayList<XSSFConditionalFormatting>();
        for (int j = 0; j < sz; ++j) {
            CTConditionalFormatting ctfm = this.worksheet.getConditionalFormattingArray(j);
            XSSFConditionalFormatting fm = new XSSFConditionalFormatting(ctfm, this);
            this.conditionalFormattings.add(fm);
        }
    }

    public List<XSSFConditionalFormatting> getConditionalFormattings() {
        return this.conditionalFormattings;
    }

    public void addCondtionalFormatting(XSSFConditionalFormatting cf) {
        if (this.conditionalFormattings == null) {
            this.conditionalFormattings = new ArrayList<XSSFConditionalFormatting>();
        }
        this.conditionalFormattings.add(cf);
    }

    private void writeCondtionalFormattings() {
        if (this.conditionalFormattings != null) {
            CTConditionalFormatting[] ctcfs = new CTConditionalFormatting[this.conditionalFormattings.size()];
            int j = 0;
            for (XSSFConditionalFormatting cf : this.conditionalFormattings) {
                ctcfs[j++] = cf.getCTConditionalFormatting();
            }
            this.worksheet.setConditionalFormattingArray(ctcfs);
        }
    }
}

