/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.eval;

import org.zkoss.poi.ss.formula.eval.HyperlinkEval;
import org.zkoss.poi.ss.formula.eval.NumericValueEval;
import org.zkoss.poi.ss.formula.eval.StringValueEval;
import org.zkoss.poi.ss.usermodel.Hyperlink;

public final class BoolEval
implements NumericValueEval,
StringValueEval,
HyperlinkEval {
    private boolean _value;
    public static final BoolEval FALSE = new BoolEval(false);
    public static final BoolEval TRUE = new BoolEval(true);
    private Hyperlink _hyperlink;

    public static final BoolEval valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    private BoolEval(boolean value) {
        this._value = value;
    }

    public boolean getBooleanValue() {
        return this._value;
    }

    @Override
    public double getNumberValue() {
        return this._value ? 1.0 : 0.0;
    }

    @Override
    public String getStringValue() {
        return this._value ? "TRUE" : "FALSE";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this.getStringValue());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void setHyperlink(Hyperlink hyperlink) {
        this._hyperlink = hyperlink;
    }

    @Override
    public Hyperlink getHyperlink() {
        return this._hyperlink;
    }
}

