/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import java.util.ArrayList;
import java.util.List;
import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.util.LittleEndianOutput;

public class ExternSheetRecord
extends StandardRecord {
    public static final short sid = 23;
    private List<RefSubRecord> _list = new ArrayList<RefSubRecord>();

    public ExternSheetRecord() {
    }

    public ExternSheetRecord(RecordInputStream in) {
        int nItems = in.readShort();
        for (int i = 0; i < nItems; ++i) {
            RefSubRecord rec = new RefSubRecord(in);
            this._list.add(rec);
        }
    }

    public int getNumOfRefs() {
        return this._list.size();
    }

    public void addREFRecord(RefSubRecord rec) {
        this._list.add(rec);
    }

    public int getNumOfREFRecords() {
        return this._list.size();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int nItems = this._list.size();
        sb.append("[EXTERNSHEET]\n");
        sb.append("   numOfRefs     = ").append(nItems).append("\n");
        for (int i = 0; i < nItems; ++i) {
            sb.append("refrec         #").append(i).append(": ");
            sb.append(this.getRef(i).toString());
            sb.append('\n');
        }
        sb.append("[/EXTERNSHEET]\n");
        return sb.toString();
    }

    @Override
    protected int getDataSize() {
        return 2 + this._list.size() * 6;
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        int nItems = this._list.size();
        out.writeShort(nItems);
        for (int i = 0; i < nItems; ++i) {
            this.getRef(i).serialize(out);
        }
    }

    private RefSubRecord getRef(int i) {
        return this._list.get(i);
    }

    @Override
    public short getSid() {
        return 23;
    }

    public int getExtbookIndexFromRefIndex(int refIndex) {
        return this.getRef(refIndex).getExtBookIndex();
    }

    public int findRefIndexFromExtBookIndex(int extBookIndex) {
        int nItems = this._list.size();
        for (int i = 0; i < nItems; ++i) {
            if (this.getRef(i).getExtBookIndex() != extBookIndex) continue;
            return i;
        }
        return -1;
    }

    public int getFirstSheetIndexFromRefIndex(int extRefIndex) {
        return this.getRef(extRefIndex).getFirstSheetIndex();
    }

    public int getLastSheetIndexFromRefIndex(int extRefIndex) {
        return this.getRef(extRefIndex).getLastSheetIndex();
    }

    public int addRef(int extBookIndex, int firstSheetIndex, int lastSheetIndex) {
        this._list.add(new RefSubRecord(extBookIndex, firstSheetIndex, lastSheetIndex));
        return this._list.size() - 1;
    }

    public int getRefIxForSheet(int externalBookIndex, int sheetIndex, int sheetIndex2) {
        int nItems = this._list.size();
        for (int i = 0; i < nItems; ++i) {
            RefSubRecord ref = this.getRef(i);
            if (ref.getExtBookIndex() != externalBookIndex || ref.getFirstSheetIndex() != sheetIndex || ref.getLastSheetIndex() != sheetIndex2) continue;
            return i;
        }
        return -1;
    }

    public static ExternSheetRecord combine(ExternSheetRecord[] esrs) {
        ExternSheetRecord result = new ExternSheetRecord();
        for (int i = 0; i < esrs.length; ++i) {
            ExternSheetRecord esr = esrs[i];
            int nRefs = esr.getNumOfREFRecords();
            for (int j = 0; j < nRefs; ++j) {
                result.addREFRecord(esr.getRef(j));
            }
        }
        return result;
    }

    public void removeSheet(int sheetIndex, int internalBookIndex) {
        for (RefSubRecord ref : this._list) {
            if (ref.getExtBookIndex() != internalBookIndex) continue;
            int diff = ref.getFirstSheetIndex() - sheetIndex;
            if (diff > 0) {
                ref.setFirstSheetIndex(ref.getFirstSheetIndex() - 1);
            } else if (diff == 0) {
                ref.setFirstSheetIndex(-1);
            }
            int diff2 = ref.getLastSheetIndex() - sheetIndex;
            if (diff2 > 0) {
                ref.setLastSheetIndex(ref.getLastSheetIndex() - 1);
                continue;
            }
            if (diff2 != 0) continue;
            ref.setLastSheetIndex(-1);
        }
    }

    public void updateSheetIndex(int oldIndex, int newIndex, int internalBookIndex) {
        for (RefSubRecord ref : this._list) {
            if (ref.getExtBookIndex() != internalBookIndex) continue;
            int firstIndex = ref.getFirstSheetIndex();
            int lastIndex = ref.getLastSheetIndex();
            if (oldIndex > newIndex) {
                if (firstIndex >= newIndex && firstIndex <= oldIndex) {
                    ref.setFirstSheetIndex(this.calculateNewIndex(oldIndex, newIndex, firstIndex));
                }
                if (lastIndex < newIndex || lastIndex > oldIndex) continue;
                ref.setLastSheetIndex(this.calculateNewIndex(oldIndex, newIndex, lastIndex));
                continue;
            }
            if (oldIndex >= newIndex) continue;
            if (firstIndex >= oldIndex && firstIndex <= newIndex) {
                ref.setFirstSheetIndex(this.calculateNewIndex(oldIndex, newIndex, firstIndex));
            }
            if (lastIndex < oldIndex || lastIndex > newIndex) continue;
            ref.setLastSheetIndex(this.calculateNewIndex(oldIndex, newIndex, lastIndex));
        }
    }

    private int calculateNewIndex(int oldIndex, int newIndex, int currentIndex) {
        if (oldIndex == currentIndex) {
            return newIndex;
        }
        if (oldIndex > newIndex) {
            return currentIndex + 1;
        }
        return currentIndex - 1;
    }

    private static final class RefSubRecord {
        public static final int ENCODED_SIZE = 6;
        private int _extBookIndex;
        private int _firstSheetIndex;
        private int _lastSheetIndex;

        public RefSubRecord(int extBookIndex, int firstSheetIndex, int lastSheetIndex) {
            this._extBookIndex = extBookIndex;
            this._firstSheetIndex = firstSheetIndex;
            this._lastSheetIndex = lastSheetIndex;
        }

        public RefSubRecord(RecordInputStream in) {
            this(in.readShort(), in.readShort(), in.readShort());
        }

        public int getExtBookIndex() {
            return this._extBookIndex;
        }

        public int getFirstSheetIndex() {
            return this._firstSheetIndex;
        }

        public int getLastSheetIndex() {
            return this._lastSheetIndex;
        }

        public void setFirstSheetIndex(int sheetIdx) {
            this._firstSheetIndex = sheetIdx;
        }

        public void setLastSheetIndex(int sheetIdx) {
            this._lastSheetIndex = sheetIdx;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("extBook=").append(this._extBookIndex);
            buffer.append(" firstSheet=").append(this._firstSheetIndex);
            buffer.append(" lastSheet=").append(this._lastSheetIndex);
            return buffer.toString();
        }

        public void serialize(LittleEndianOutput out) {
            out.writeShort(this._extBookIndex);
            out.writeShort(this._firstSheetIndex);
            out.writeShort(this._lastSheetIndex);
        }
    }
}

