/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hslf.record;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.zkoss.poi.ddf.DefaultEscherRecordFactory;
import org.zkoss.poi.ddf.EscherBSERecord;
import org.zkoss.poi.ddf.EscherContainerRecord;
import org.zkoss.poi.ddf.EscherDggRecord;
import org.zkoss.poi.ddf.EscherRecord;
import org.zkoss.poi.hslf.record.Record;
import org.zkoss.poi.hslf.record.RecordAtom;
import org.zkoss.poi.hslf.record.RecordTypes;
import org.zkoss.poi.util.LittleEndian;

public final class PPDrawingGroup
extends RecordAtom {
    private byte[] _header = new byte[8];
    private EscherContainerRecord dggContainer;
    private EscherDggRecord dgg;

    protected PPDrawingGroup(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        byte[] contents = new byte[len];
        System.arraycopy(source, start, contents, 0, len);
        DefaultEscherRecordFactory erf = new DefaultEscherRecordFactory();
        EscherRecord child = erf.createRecord(contents, 0);
        child.fillFields(contents, 0, erf);
        this.dggContainer = (EscherContainerRecord)child.getChild(0);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.PPDrawingGroup.typeID;
    }

    @Override
    public Record[] getChildRecords() {
        return null;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Iterator<EscherRecord> iter = this.dggContainer.getChildIterator();
        while (iter.hasNext()) {
            EscherRecord r = iter.next();
            if (r.getRecordId() == -4095) {
                EscherContainerRecord bstore = (EscherContainerRecord)r;
                ByteArrayOutputStream b2 = new ByteArrayOutputStream();
                Iterator<EscherRecord> it = bstore.getChildIterator();
                while (it.hasNext()) {
                    EscherBSERecord bse = (EscherBSERecord)it.next();
                    byte[] b = new byte[44];
                    bse.serialize(0, b);
                    b2.write(b);
                }
                byte[] bstorehead = new byte[8];
                LittleEndian.putShort(bstorehead, 0, bstore.getOptions());
                LittleEndian.putShort(bstorehead, 2, bstore.getRecordId());
                LittleEndian.putInt(bstorehead, 4, b2.size());
                bout.write(bstorehead);
                bout.write(b2.toByteArray());
                continue;
            }
            bout.write(r.serialize());
        }
        int size = bout.size();
        LittleEndian.putInt(this._header, 4, size + 8);
        out.write(this._header);
        byte[] dgghead = new byte[8];
        LittleEndian.putShort(dgghead, 0, this.dggContainer.getOptions());
        LittleEndian.putShort(dgghead, 2, this.dggContainer.getRecordId());
        LittleEndian.putInt(dgghead, 4, size);
        out.write(dgghead);
        out.write(bout.toByteArray());
    }

    public EscherContainerRecord getDggContainer() {
        return this.dggContainer;
    }

    public EscherDggRecord getEscherDggRecord() {
        if (this.dgg == null) {
            Iterator<EscherRecord> it = this.dggContainer.getChildIterator();
            while (it.hasNext()) {
                EscherRecord r = it.next();
                if (!(r instanceof EscherDggRecord)) continue;
                this.dgg = (EscherDggRecord)r;
                break;
            }
        }
        return this.dgg;
    }
}

