/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.api.AreaRef;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.impl.SheetImpl;
import io.keikai.model.CellRegion;
import io.keikai.model.SAutoFilter;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColorFilter;
import io.keikai.model.SCustomFilter;
import io.keikai.model.SCustomFilters;
import io.keikai.model.SDynamicFilter;
import io.keikai.model.SExtraStyle;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SSheet;
import io.keikai.model.STable;
import io.keikai.model.STop10Filter;
import io.keikai.model.impl.AbstractAutoFilterAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.AutoFilterImpl;
import io.keikai.model.impl.FillImpl;
import io.keikai.model.impl.FontImpl;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.format.FormatContext;
import io.keikai.model.sys.format.FormatEngine;
import io.keikai.model.sys.format.FormatResult;
import io.keikai.model.util.Strings;
import io.keikai.range.SRange;
import io.keikai.range.SRanges;
import io.keikai.range.impl.FilterRowInfo;
import io.keikai.range.impl.FilterRowInfoComparator;
import io.keikai.ui.Spreadsheet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.zkoss.json.JSONArray;
import org.zkoss.poi.ss.usermodel.ZssContext;
import org.zkoss.poi.ss.util.CellReference;
import org.zkoss.util.resource.Labels;

class AutoFilterDefaultHandler
implements Serializable {
    private static final long serialVersionUID = -8371978786540085707L;
    private static final SFill BLANK_FILL = FillImpl.BLANK_FILL;
    private static final SFont BLANK_FONT = FontImpl.BLANK_FONT;
    private FilterRowInfo blankRowInfo;
    private static final Comparable BLANK_VALUE = new Comparable(){

        public int compareTo(Object o) {
            return BLANK_VALUE.equals(o) ? 0 : 1;
        }
    };

    AutoFilterDefaultHandler() {
    }

    AreaRef processFilter(Spreadsheet spreadsheet, Sheet sheet, int row, int col, int field) {
        SCustomFilters customFilters;
        SSheet worksheet = ((SheetImpl)sheet).getNative();
        STable table = ((AbstractSheetAdv)worksheet).getTableByRowCol(row, col);
        SAutoFilter autoFilter = table == null ? worksheet.getAutoFilter() : table.getAutoFilter();
        int index = field - 1;
        SAutoFilter.NFilterColumn filterColumn = autoFilter.getFilterColumn(index, false);
        String rangeAddr = autoFilter.getRegion().getReferenceString();
        SRange range = SRanges.range((SSheet)worksheet, (String)rangeAddr);
        SColorFilter colorFilter = filterColumn == null ? null : filterColumn.getColorFilter();
        SExtraStyle extraStyle = colorFilter == null ? null : colorFilter.getExtraStyle();
        SFill filterFill = extraStyle == null ? null : extraStyle.getFill();
        boolean byFontColor = colorFilter == null ? false : colorFilter.isByFontColor();
        SCustomFilters custFilters = filterColumn == null ? null : filterColumn.getCustomFilters();
        SDynamicFilter dynaFilter = filterColumn == null ? null : filterColumn.getDynamicFilter();
        STop10Filter top10Filter = filterColumn == null ? null : filterColumn.getTop10Filter();
        int bottom = range.getLastRow();
        Object[] results = this.scanRows(field, filterColumn, range, worksheet, table, filterFill, byFontColor, custFilters, dynaFilter, top10Filter);
        SortedSet orderedRowInfos = (SortedSet)results[0];
        if (bottom != (Integer)results[1]) {
            CellRegion region = new CellRegion(range.getRow(), range.getColumn(), bottom, range.getLastColumn());
            rangeAddr = region.getReferenceString();
        }
        int type = (Integer)results[3];
        Set ccitems = (Set)results[2];
        Set fcitems = (Set)results[4];
        String colName = (String)results[5];
        SCustomFilters sCustomFilters = customFilters = filterColumn == null ? null : filterColumn.getCustomFilters();
        if (filterColumn != null) {
            ((AbstractAutoFilterAdv.FilterColumnImpl)filterColumn).setFilterType(type);
        }
        ((AutoFilterImpl)autoFilter).setCachedSet(index, orderedRowInfos);
        ((AutoFilterImpl)autoFilter).setFilterType(index, type);
        spreadsheet.smartUpdate("autoFilterPopup", this.convertFilterInfoToJSON(row, col, field, rangeAddr, orderedRowInfos, type, ccitems, filterFill, fcitems, byFontColor, customFilters, dynaFilter, top10Filter, colName));
        AreaRef filterArea = new AreaRef(rangeAddr);
        return filterArea;
    }

    private Map convertFilterInfoToJSON(int row, int col, int field, String rangeAddr, SortedSet<FilterRowInfo> orderedRowInfos, int type, Set<SFill> ccitems, SFill filterFill, Set<SFill> fcitems, boolean byFontColor, SCustomFilters custFilters, SDynamicFilter dynaFilter, STop10Filter top10Filter, String colName) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        boolean selectAll = filterFill == null && custFilters == null && dynaFilter == null && top10Filter == null;
        boolean select = false;
        ArrayList sortedItems = new ArrayList();
        for (FilterRowInfo info : orderedRowInfos) {
            if (info == this.blankRowInfo) {
                data.put("blank", info.isSelected());
                if (info.isSelected()) {
                    select = true;
                    continue;
                }
                selectAll = false;
                continue;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            sortedItems.add(hashMap);
            hashMap.put("v", info.getDisplay());
            if (info.isSelected()) {
                hashMap.put("s", "t");
                select = true;
                continue;
            }
            selectAll = false;
        }
        if (filterFill != null) {
            Object fg = filterFill.getFillColor().getHtmlColor();
            Object bg = filterFill.getBackColor().getHtmlColor();
            if (filterFill.getFillPattern() == SFill.FillPattern.SOLID && !byFontColor) {
                String string = fg;
                fg = bg;
                bg = string;
            }
            filterFill = new FillImpl(filterFill.getFillPattern(), (String)fg, (String)bg);
            data.put("colorpat", filterFill.getFillPattern().name());
            data.put("colorfg", fg);
            data.put("colorbg", bg);
            data.put("fontColor", byFontColor);
        }
        ArrayList ccfills = new ArrayList();
        for (SFill sFill : ccitems) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            ccfills.add(item);
            if (sFill.getFillPattern() == SFill.FillPattern.NONE) {
                item.put("t", "No Fill");
            } else {
                item.put("t", "");
                if (sFill.getFillPattern() == SFill.FillPattern.SOLID) {
                    item.put("bk", "background: " + sFill.getBackColor().getHtmlColor());
                } else {
                    item.put("bk", ((FillImpl)sFill).getFillPatternHtml());
                }
            }
            if (sFill.equals(filterFill)) {
                item.put("s", true);
            }
            item.put("pat", sFill.getFillPattern().name());
            item.put("fg", sFill.getFillColor().getHtmlColor());
            item.put("bg", sFill.getBackColor().getHtmlColor());
        }
        ArrayList fcfills = new ArrayList();
        for (SFill fill : fcitems) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            fcfills.add(item);
            if (fill.getFillPattern() == SFill.FillPattern.NONE) {
                item.put("t", "Auto");
            } else {
                item.put("t", "");
                item.put("bk", "background: " + fill.getFillColor().getHtmlColor());
            }
            if (fill.equals(filterFill)) {
                item.put("s", true);
            }
            item.put("pat", fill.getFillPattern().name());
            item.put("fg", fill.getFillColor().getHtmlColor());
            item.put("bg", fill.getBackColor().getHtmlColor());
        }
        data.put("ccitems", ccfills);
        data.put("fcitems", fcfills);
        data.put("type", type);
        SCustomFilter sCustomFilter = custFilters == null ? null : custFilters.getCustomFilter1();
        SCustomFilter f2 = custFilters == null ? null : custFilters.getCustomFilter2();
        SAutoFilter.FilterOp f1op = null;
        SAutoFilter.FilterOp f2op = null;
        if (custFilters != null) {
            boolean isAnd = custFilters.isAnd();
            data.put("and", isAnd);
            HashMap<String, String> f1Map = new HashMap<String, String>();
            data.put("f1", f1Map);
            f1Map.put("val", sCustomFilter.getValue());
            f1op = sCustomFilter.getOperator();
            f1Map.put("op", f1op.name());
            if (f2 != null) {
                HashMap<String, String> f2Map = new HashMap<String, String>();
                data.put("f2", f2Map);
                f2Map.put("val", sCustomFilter.getValue());
                f2op = f2.getOperator();
                f2Map.put("op", f2op.name());
            }
        }
        ArrayList<Map> vitems = new ArrayList<Map>();
        ArrayList<Map> pitems = new ArrayList<Map>();
        SAutoFilter.FilterOp targetOp = null;
        SAutoFilter.FilterOp targetOp2 = null;
        if (custFilters != null) {
            if (f1op == SAutoFilter.FilterOp.greaterThanOrEqual && f2op == SAutoFilter.FilterOp.lessThanOrEqual && type != 3) {
                f1op = type == 1 ? SAutoFilter.FilterOp.betweenDates : SAutoFilter.FilterOp.between;
                f2op = null;
            }
            targetOp = f1op != null && f2op == null ? f1op : (f1op != null && f2op != null ? SAutoFilter.FilterOp.custom : null);
        } else if (dynaFilter != null) {
            targetOp = SAutoFilter.FilterOp.valueOf((String)dynaFilter.getType());
            switch (targetOp) {
                case Q1: 
                case Q2: 
                case Q3: 
                case Q4: 
                case M1: 
                case M2: 
                case M3: 
                case M4: 
                case M5: 
                case M6: 
                case M7: 
                case M8: 
                case M9: 
                case M10: 
                case M11: 
                case M12: {
                    targetOp2 = targetOp;
                    targetOp = SAutoFilter.FilterOp.allDatesInPeriod;
                }
            }
        } else if (top10Filter != null) {
            targetOp = SAutoFilter.FilterOp.top10;
        }
        if (type == 3) {
            this.opToJson(vitems, SAutoFilter.FilterOp.equal, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.notEqual, targetOp, true);
            this.opToJson(vitems, SAutoFilter.FilterOp.beginWith, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.endWith, targetOp, true);
            this.opToJson(vitems, SAutoFilter.FilterOp.contains, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.notContains, targetOp, true);
            this.opToJson(vitems, SAutoFilter.FilterOp.custom, targetOp, false);
        } else if (type == 2) {
            this.opToJson(vitems, SAutoFilter.FilterOp.equal, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.notEqual, targetOp, true);
            this.opToJson(vitems, SAutoFilter.FilterOp.greaterThan, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.greaterThanOrEqual, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.lessThan, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.lessThanOrEqual, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.between, targetOp, true);
            this.opToJson(vitems, SAutoFilter.FilterOp.top10, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.aboveAverage, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.belowAverage, targetOp, true);
            this.opToJson(vitems, SAutoFilter.FilterOp.custom, targetOp, false);
        } else if (type == 1) {
            this.opToJson(vitems, SAutoFilter.FilterOp.equal, targetOp, true);
            this.opToJson(vitems, SAutoFilter.FilterOp.before, targetOp == SAutoFilter.FilterOp.lessThan ? SAutoFilter.FilterOp.before : targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.after, targetOp == SAutoFilter.FilterOp.greaterThan ? SAutoFilter.FilterOp.after : targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.betweenDates, targetOp, true);
            this.opToJson(vitems, SAutoFilter.FilterOp.tomorrow, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.today, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.yesterday, targetOp, true);
            this.opToJson(vitems, SAutoFilter.FilterOp.nextWeek, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.thisWeek, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.lastWeek, targetOp, true);
            this.opToJson(vitems, SAutoFilter.FilterOp.nextMonth, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.thisMonth, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.lastMonth, targetOp, true);
            this.opToJson(vitems, SAutoFilter.FilterOp.nextQuarter, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.thisQuarter, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.lastQuarter, targetOp, true);
            this.opToJson(vitems, SAutoFilter.FilterOp.nextYear, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.thisYear, targetOp, false);
            this.opToJson(vitems, SAutoFilter.FilterOp.lastYear, targetOp, true);
            this.opToJson(vitems, SAutoFilter.FilterOp.yearToDate, targetOp, true);
            this.opToJson(vitems, SAutoFilter.FilterOp.allDatesInPeriod, targetOp, true);
            this.opToJson(vitems, SAutoFilter.FilterOp.custom, targetOp, false);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.Q1, (Enum)targetOp2, false);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.Q2, (Enum)targetOp2, false);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.Q3, (Enum)targetOp2, false);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.Q4, (Enum)targetOp2, true);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.M1, (Enum)targetOp2, false);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.M2, (Enum)targetOp2, false);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.M3, (Enum)targetOp2, false);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.M4, (Enum)targetOp2, false);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.M5, (Enum)targetOp2, false);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.M6, (Enum)targetOp2, false);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.M7, (Enum)targetOp2, false);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.M8, (Enum)targetOp2, false);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.M9, (Enum)targetOp2, false);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.M10, (Enum)targetOp2, false);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.M11, (Enum)targetOp2, false);
            this.opToJson2(pitems, (Enum)SAutoFilter.FilterOp.M12, (Enum)targetOp2, false);
        }
        data.put("vitems", vitems);
        data.put("vitem", targetOp == null ? null : targetOp.name());
        if (!pitems.isEmpty()) {
            data.put("pitems", pitems);
            data.put("pitem", targetOp2 == null ? null : targetOp2.name());
        }
        data.put("items", sortedItems);
        data.put("row", row);
        data.put("col", col);
        data.put("field", field);
        data.put("range", rangeAddr);
        data.put("select", selectAll ? "all" : (select ? "mix" : "none"));
        data.put("colName", colName);
        return data;
    }

    private void opToJson(ArrayList<Map> vitems, SAutoFilter.FilterOp op, SAutoFilter.FilterOp targetOp, boolean border) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        vitems.add(item);
        item.put("op", op.name());
        item.put("t", Labels.getLabel((String)("zssex.valuedlg." + op.name())));
        if (targetOp == op) {
            item.put("s", true);
        }
        if (border) {
            item.put("b", true);
        }
    }

    private void opToJson2(ArrayList<Map> vitems, Enum op, Enum targetOp, boolean border) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        vitems.add(item);
        item.put("op", op.name());
        item.put("t", Labels.getLabel((String)("zssex.perdlg." + op.name())));
        if (targetOp == op) {
            item.put("s", true);
        }
        if (border) {
            item.put("b", true);
        }
    }

    private Object[] scanRows(int field, SAutoFilter.NFilterColumn fc, SRange range, SSheet worksheet, STable table, SFill filterFill, boolean byFontColor, SCustomFilters custFilters, SDynamicFilter dynaFilter, STop10Filter top10Filter) {
        TreeSet<FilterRowInfo> orderedRowInfos = new TreeSet<FilterRowInfo>((Comparator<FilterRowInfo>)new FilterRowInfoComparator());
        LinkedHashSet<SFill> ccitems = new LinkedHashSet<SFill>();
        LinkedHashSet<SFill> fcitems = new LinkedHashSet<SFill>();
        int[] types = new int[]{0, 0, 0};
        this.blankRowInfo = new FilterRowInfo((Object)BLANK_VALUE, "(Blanks)");
        Set criteria1 = fc == null ? null : fc.getCriteria1();
        boolean hasBlank = false;
        boolean hasSelectedBlank = false;
        int top = range.getRow() + 1;
        int bottom = range.getLastRow();
        int columnIndex = range.getColumn() + field - 1;
        SFont defaultFont = worksheet.getBook().getDefaultFont();
        FormatEngine fe = EngineFactory.getInstance().createFormatEngine();
        boolean isItemFilter = filterFill == null && custFilters == null && dynaFilter == null && top10Filter == null;
        SCell cell = worksheet.getCell(range.getRow(), columnIndex);
        Object colName = null;
        if (!cell.isNull() && cell.getType() != SCell.CellType.BLANK) {
            FormatResult fr = fe.format(cell, new FormatContext(ZssContext.getCurrent().getLocale()));
            colName = fr.getText();
        }
        if (colName == null || Strings.isBlank(colName)) {
            String ab = CellReference.convertNumToColString((int)columnIndex);
            colName = "(Column " + ab + ")";
        }
        for (int i = top; i <= bottom; ++i) {
            if (isItemFilter && (criteria1 == null || criteria1.isEmpty()) && worksheet.getRow(i).isHidden()) continue;
            SCell c = worksheet.getCell(i, columnIndex);
            SCellStyle style = c.isNull() ? null : c.getCellStyle();
            SFill ccfill = style == null ? BLANK_FILL : style.getFill();
            ccitems.add(ccfill);
            SFont font = style == null ? null : style.getFont();
            boolean isDefaultFont = defaultFont.equals(font);
            SFill fcfill = font == null || isDefaultFont ? BLANK_FILL : new FillImpl(SFill.FillPattern.SOLID, font.getColor(), null);
            fcitems.add(fcfill);
            int type0 = 3;
            if (!c.isNull() && c.getType() != SCell.CellType.BLANK) {
                FormatResult fr = fe.format(c, new FormatContext(ZssContext.getCurrent().getLocale()));
                String displaytxt = fr.getText();
                if (!hasBlank && displaytxt.trim().isEmpty()) {
                    hasBlank = true;
                    hasSelectedBlank = this.prepareBlankRow(criteria1, hasSelectedBlank, isItemFilter);
                } else {
                    int type;
                    Object val = c.getValue();
                    if (c.getType() == SCell.CellType.NUMBER && fr.isDateFormatted()) {
                        val = c.getDateValue();
                    }
                    type0 = ((type = FilterRowInfo.getType((Object)val)) == 4 ? 2 : type) - 1;
                    FilterRowInfo rowInfo = new FilterRowInfo(val, displaytxt);
                    orderedRowInfos.add(rowInfo);
                    if (isItemFilter && (criteria1 == null || criteria1.isEmpty() || criteria1.contains(displaytxt))) {
                        rowInfo.setSelected(true);
                    }
                }
            } else if (!hasBlank) {
                hasBlank = true;
                hasSelectedBlank = this.prepareBlankRow(criteria1, hasSelectedBlank, isItemFilter);
            }
            if (type0 >= 3) continue;
            types[type0] = types[type0] + 1;
        }
        if (table == null) {
            int blm = Integer.MAX_VALUE;
            SSheet sheet = range.getSheet();
            for (STable tb : sheet.getTables()) {
                CellRegion rgn = tb.getAllRegion().getRegion();
                int l = rgn.getColumn();
                int r = rgn.getLastColumn();
                int t = rgn.getRow();
                if (l > columnIndex || columnIndex > r || t <= bottom || blm < t) continue;
                blm = t - 1;
            }
            int maxblm = Math.min(blm, worksheet.getEndRowIndex());
            int left = range.getColumn();
            int right = range.getLastColumn();
            boolean leaveLoop = false;
            for (int i = bottom + 1; i <= maxblm; ++i) {
                SCell c = worksheet.getCell(i, columnIndex);
                int type0 = 3;
                if (!c.isNull() && c.getType() != SCell.CellType.BLANK) {
                    FormatResult fr = fe.format(c, new FormatContext(ZssContext.getCurrent().getLocale()));
                    String displaytxt = fr.getText();
                    if (!hasBlank && displaytxt.trim().isEmpty()) {
                        hasBlank = true;
                        hasSelectedBlank = this.prepareBlankRow(criteria1, hasSelectedBlank, isItemFilter);
                    } else {
                        int type;
                        Object val = c.getValue();
                        if (c.getType() == SCell.CellType.NUMBER && fr.isDateFormatted()) {
                            val = c.getDateValue();
                        }
                        type0 = ((type = FilterRowInfo.getType((Object)val)) == 4 ? 2 : type) - 1;
                        FilterRowInfo rowInfo = new FilterRowInfo(val, displaytxt);
                        orderedRowInfos.add(rowInfo);
                        if (filterFill == null && custFilters == null && (criteria1 == null || criteria1.isEmpty() || criteria1.contains(displaytxt))) {
                            rowInfo.setSelected(true);
                        }
                    }
                } else {
                    int[] ltrb = this.getMergedMinMax(worksheet, i, columnIndex);
                    if (ltrb == null) {
                        if (this.neighborIsBlank(worksheet, left, right, i, columnIndex)) {
                            bottom = i - 1;
                            leaveLoop = true;
                        }
                    } else {
                        i = ltrb[3];
                    }
                    if (!leaveLoop && !hasBlank) {
                        hasBlank = true;
                        hasSelectedBlank = this.prepareBlankRow(criteria1, hasSelectedBlank, isItemFilter);
                    }
                }
                if (leaveLoop) break;
                if (type0 < 3) {
                    types[type0] = types[type0] + 1;
                }
                SCellStyle style = c.isNull() ? null : c.getCellStyle();
                SFill ccfill = style == null ? BLANK_FILL : style.getFill();
                ccitems.add(ccfill);
                SFont font = style == null ? null : style.getFont();
                SFill fcfill = font == null ? BLANK_FILL : new FillImpl(SFill.FillPattern.SOLID, font.getColor(), null);
                fcitems.add(fcfill);
            }
        }
        if (hasBlank) {
            orderedRowInfos.add(this.blankRowInfo);
        }
        int candidate = 2;
        int max = types[2];
        if (max < types[1]) {
            candidate = 1;
            max = types[1];
        }
        if (max < types[0]) {
            candidate = 0;
        }
        return new Object[]{orderedRowInfos, bottom, ccitems.size() > 1 ? ccitems : Collections.EMPTY_SET, new Integer(candidate + 1), fcitems.size() > 1 ? fcitems : Collections.EMPTY_SET, colName};
    }

    private boolean prepareBlankRow(Set criteria1, boolean hasSelectedBlank, boolean isItemFilter) {
        boolean noFilterApplied;
        boolean bl = noFilterApplied = criteria1 == null || criteria1.isEmpty();
        if (isItemFilter && !hasSelectedBlank && (noFilterApplied || criteria1.contains("="))) {
            this.blankRowInfo.setSelected(true);
            return true;
        }
        return hasSelectedBlank;
    }

    private int[] getMergedMinMax(SSheet worksheet, int row, int col) {
        CellRegion merged = worksheet.getMergedRegion(row, col);
        if (merged == null) {
            return null;
        }
        int l = merged.getColumn();
        int t = merged.getRow();
        SCell c0 = worksheet.getCell(t, l);
        if (!c0.isNull() && c0.getType() != SCell.CellType.BLANK) {
            return new int[]{l, t, merged.getLastColumn(), merged.getLastRow()};
        }
        return null;
    }

    private boolean neighborIsBlank(SSheet sheet, int left, int right, int row, int col) {
        for (int j = left; j <= right; ++j) {
            if (j == col) continue;
            SCell c = sheet.getCell(row, j);
            if (!c.isNull() && c.getType() != SCell.CellType.BLANK) {
                return false;
            }
            CellRegion merged = sheet.getMergedRegion(row, j);
            if (merged == null) continue;
            int l = merged.getColumn();
            int t = merged.getRow();
            SCell c0 = sheet.getCell(t, l);
            if (c0.isNull() || c0.getType() == SCell.CellType.BLANK) continue;
            return false;
        }
        return true;
    }

    void applyFilter(Spreadsheet spreadsheet, Sheet selectedSheet, String cellRangeAddr, boolean selectAll, int field, Object criteria, SAutoFilter.FilterOp op) {
        SRange range = SRanges.range((SSheet)((SheetImpl)selectedSheet).getNative(), (String)cellRangeAddr);
        switch (op) {
            case cellColor: 
            case fontColor: 
            case and: 
            case or: {
                JSONArray ary = (JSONArray)criteria;
                range.enableAutoFilter(field, op, (Object)ary.toArray((Object[])new String[ary.size()]), null, Boolean.valueOf(true));
                break;
            }
            case Q1: 
            case Q2: 
            case Q3: 
            case Q4: 
            case M1: 
            case M2: 
            case M3: 
            case M4: 
            case M5: 
            case M6: 
            case M7: 
            case M8: 
            case M9: 
            case M10: 
            case M11: 
            case M12: 
            case aboveAverage: 
            case belowAverage: 
            case tomorrow: 
            case today: 
            case yesterday: 
            case nextWeek: 
            case thisWeek: 
            case lastWeek: 
            case nextMonth: 
            case thisMonth: 
            case lastMonth: 
            case nextQuarter: 
            case thisQuarter: 
            case lastQuarter: 
            case nextYear: 
            case thisYear: 
            case lastYear: 
            case yearToDate: {
                range.enableAutoFilter(field, op, null, null, Boolean.valueOf(true));
                break;
            }
            default: {
                if (selectAll) {
                    range.enableAutoFilter(field, SAutoFilter.FilterOp.values, null, null, Boolean.valueOf(true));
                    break;
                }
                JSONArray ary = (JSONArray)criteria;
                range.enableAutoFilter(field, SAutoFilter.FilterOp.values, (Object)ary.toArray((Object[])new String[ary.size()]), null, Boolean.valueOf(true));
            }
        }
    }
}

