
(function () {

zss.Panel = zk.$extends(zk.Widget, {
	widgetName: 'Panel',
	$o: zk.$void, 
	$init: function (sheet, hide, start, end, data, isCorner) {
		this.$supers(zss.Panel, '$init', []);
		
		this.sheet = sheet;
		this.hidehead = hide;
		this.isCorner = isCorner;
		
		this.headers = this.initHeaders_(sheet, start, end, data, isCorner);
		this.block = this.initFrozenBlock_(sheet, start, end, data);
	},
	
	getHeader: function (index) {
		var headers = this.headers;
		for(var j = 0, len = headers.length; j < len; ++j)
			if (headers[j].index == index)
				return headers[j];
		return null;
	},
	
	initHeaders_: function (sheet, start, end, data, isCorner) {
		
		return null;
	},
	isEmptyHeader: function() {
		return !(this.headers && this.headers.length > 0);
	},
	
	initFrozenBlock_: function (sheet, start, end, data) {
		
		return null;
	},
	createHeaders_: function (dir, start, end) {
		var sheet = this.sheet,
			headers = this.getHeaderData_(),
			isInsert = this.isInsert_(dir),
			type = this.getHeaderType_(),
			html = '',
			hs = [];
		if ('jump' == dir)
			this._clearAllHeader();
		
		for (var i = start, j = 0; i <= end; i++) {
			var h = new zss.Header(sheet, type, headers[i]);
			isInsert ? this.insertHeader_(j++, h) : this.appendHeader_(h);
		}
		this.updateSelectionCSS_();
	},
	updateSelectionCSS_: function () {
		
	},
	_clearAllHeader: function () {
		var hs = this.headers,
			size = hs ? hs.length : 0;
		this.removeChildFromStart_(size);
	},
	
	getHeaderData_: function () {
		
	},
	
	getFrozenData_: function () {
		
	},
	
	getFrozenHeaderData_: function () {
		
	},
	getHeaderType_: function () {
		
	},
	isInsert_: function (dir) {
		
	},
	
	appendHeader_: function (header) {
		this.appendChild(header, true);
		jq(this.hcomp).append(header.getHtml());
		header.bind_();
		this.headers.push(header);
	},
	
	insertHeader_: function (index, header) {
		var headers = this.headers,
			sibling = headers[index];
		if (!sibling) {
			this.appendHeader_(header);
		} else {
			this.insertBefore(header, sibling, true);
			headers.splice(index, 0, header);
			var $anchor = jq(header.getHtmlEpilogHalf());
			$anchor.insertBefore(sibling.$n());
			jq(header.getHtmlPrologHalf()).insertBefore($anchor);
			header.bind_();	
		}
	},
	
	create_: function (dir, headerStart, headerEnd, frozenStart, frozenEnd, createFrozenOnly) {
		
	},
	
	removeChildFromStart_: function (size) {
		if (this.hidehead)
			return;
		var headers = this.headers;
		while (size--) {
			if (!headers.length)
				return;
			headers.shift().detach();
		}
	},
	
	removeChildFromEnd_: function (size) {
		if (this.hidehead) return;
		
		var headers = this.headers;
		while (size--) {
			if (!headers.length)
				return;
			headers.pop().detach();
		}
	},
	removeHeader_: function (index, size) {
		var ctrl,
			headers = this.headers;
		
		if (index > headers.length) return;

		
		var rem = headers.slice(index, index + size);
		var tail = headers.slice(index + size, headers.length);
		headers.length = index;
		headers.push.apply(headers, tail);
		
		var header = rem.pop();
		for (; header; header = rem.pop()) {
			header.detach();
		}
	},
	bind_: function () {
		this.$supers(zss.Panel, 'bind_', arguments);
		
		var n = this.comp = this.$n();
		n.ctrl = this;
		zk(n).disableSelection();

		this.padcomp = this.$n('pad'),
		this.icomp = this.$n('real'),
		this.hcomp = this.icomp.firstChild,
		this.wpcomp = this.$n(this.type+'wp');
		
		if (this.block) {
			this.bindFrozenCtrl_();
			
			
			var sheet = this.sheet;
			if(sheet.editorFocusMark) {
				var dummy = "";
				for (var id in sheet.editorFocusMark) {
					var focusMark = sheet.editorFocusMark[id];
					this.addEditorFocus(id, dummy);
				}
			}
		}
	},
	bindFrozenCtrl_: function () {
		
	},
	unbindFrozenCtrl_: function () {
		if (this.selArea) {
			this.selArea.cleanup();
			this.selArea = null;
		}
		if (this.selChgArea) {
			this.selChgArea.cleanup();
			this.selChgArea = null;
		}
		if (this.focusMark) {
			this.focusMark.cleanup();
			this.focusMark = null;
		}
		if (this.hlArea) {
			this.hlArea.cleanup();
			this.hlArea = null;
		}
	},
	unbind_: function () {
		
		if (this.headers) {
			this.headers.splice(0, this.headers.length);
		}
		
		
		if (this.editorFocusMark) {
			for (var id in this.editorFocusMark) {
				var focusMark = this.editorFocusMark[id];
				this._removeEditorFocusMark(focusMark);
			}
			this.editorFocusMark = null;
		}
		
		this.unbindFrozenCtrl_();
		this.comp = this.comp.ctrl = this.padcomp = this.wpcomp = this.icomp = 
		this.hcomp = this.headers = this.block = this.sheet = null;
		this.$supers(zss.Panel, 'unbind_', arguments);
	},
	getTypeAttr_: function () {
		
	},
	hasPad_: function () {
		return false;
	},
	doTooltipOver_: zk.$void,
	doTooltipOut_: zk.$void,
	doClick_: zk.$void,
	doMouseDown_: function (evt) {
		this.sheet._doMousedown(evt);
	},
	doMouseUp_: function (evt) {
		this.sheet._doMouseup(evt);
	},
	doRightClick_: function (evt) {
		this.sheet._doMouserightclick(evt);
	},
	doDoubleClick_: function (evt) {
		this.sheet._doMousedblclick(evt);
	},
	doMouseOver_: function (evt) {
		var n = evt.domTarget;
		if (n.getAttribute('zs.t') == "SBoun")
			n.parentNode.ctrlref._processDrag(true, false);
		if (n.getAttribute('zs.t') == "SBoun2")
			n.parentNode.ctrlref._processDrag(true, true);
	},
	doMouseOut_: function (evt) {
		var n = evt.domTarget;
		if (n.getAttribute('zs.t') == "SBoun")
			n.parentNode.ctrlref._processDrag(false, false);
		if (n.getAttribute('zs.t') == "SBoun2")
			n.parentNode.ctrlref._processDrag(false, true);
	},
	redraw: function (out) {
		var type = this.type,
			type = this.isCorner ? 'corner' + type : type,
			uid = this.uuid;
		out.push('<div id="', uid, '" class="zs', type, ' zsfz', type, '" zs.t="',
				this.getTypeAttr_(), '">', 
				(this.hasPad_() ? '<div id="' + uid + '-pad" class="zs' + type + 'pad"></div>' : ''),
				'<div id="', uid, '-real" class="zs', type, 
				'i"><div id="', uid, '-head" class="zs', type, 'head">');

		
		var hs = this.headers,
			size = hs.length;
		for (var i = 0; i < size; i++) {
			out.push(hs[i].getHtml());
		}

		out.push('</div>'); 
		if (this.block) { 
			this.block.redraw(out);
			out.push('<div id="', uid, '-select" class="zsselect" zs.t="SSelect">',
					'<div class="zsselecti" zs.t="SSelInner"></div><div class="zsseldot" zs.t="SSelDot"></div></div>',
					'<div id="', uid, '-selchg" class="zsselchg" zs.t="SSelChg"><div class="zsselchgi"></div></div>',
					'<div id="', uid, '-focmark" class="zsfocmark" zs.t="SFocus"><div class="zsfocmarki"></div></div>',
					'<div id="', uid, '-highlight" class="zshighlight" zs.t="SHighlight"><div class="zshighlighti"></div></div>');
					
		}
		out.push('</div>');
		out.push('<div id="', uid, '-',type,'wp" class="zswidgetpanel" zs.t="SWidgetpanel"></div>');
		out.push('</div>');
	},
	
	addEditorFocus : function(id, name){
		if (this.editorFocusMark && this.editorFocusMark[id])
			return;
		if (this.block) {
			var sheet = this.sheet,
				focusmarkcmp = this.$n('focmark'), 
				x = focusmarkcmp,
				div = x.cloneNode(true);
			
			div.id = div.id + '_' + id;
			div.style.borderWidth = "3px";
			x.parentNode.appendChild(div);
			this.addEditorFocus_(id, name, div);
		}
	},
	
	addEditorFocus_ : function(id, name, div) {
		
	},
	
	removeEditorFocus : function(id){
		if (this.block) {
			if (!this.editorFocusMark)
				return;
			var ctrl = this.editorFocusMark[id];
			this._removeEditorFocusMark(ctrl);
			this.editorFocusMark[id] = null;
		}
	},
	
	_removeEditorFocusMark : function(ctrl) {
		if (ctrl) {
			ctrl.comp.parentNode.removeChild(ctrl.comp);
			ctrl.cleanup();
		}
	},
	
	moveEditorFocus : function(id, name, color, row, col){
		if (this.block) {
			if(!this.editorFocusMark || !this.editorFocusMark[id]){
				this.addEditorFocus(id, name);
			}
			this.editorFocusMark[id].relocate(row, col);
			this.editorFocusMark[id].showMark(color, name); 
		}
	}
});

zss.LeftPanel = zk.$extends(zss.Panel, {
	widgetName: 'LeftPanel',
	type: 'left',
	initHeaders_: function (sheet, start, end, data, isCorner) {		
		var ary = [],
			headers = data.rowHeaders,
			type = zss.Header.VER,
			leftHeaders = isCorner ? sheet.lp.headers : null,
			j = 0;
		for (var i = start; i <= end; i++) {
			var h = new zss.Header(sheet, type, headers[i], leftHeaders ? leftHeaders[j++] : null);
			this.appendChild(h, true);
			ary.push(h);
		}
		return ary;
	},
	
	create_: function (dir, rowStart, rowEnd, frozenColStart, forzenColEnd, createFrozenOnly) {
		if (!createFrozenOnly)
			this.createHeaders_(dir, rowStart, rowEnd);
		
		var createFrozen = frozenColStart >= 0 && forzenColEnd >= 0;
		if ('jump' == dir && createFrozen) {
			var oldBlock = this.block;
			this.block = new zss.CellBlockCtrl(this.sheet, rowStart, frozenColStart, rowEnd, forzenColEnd, this.getFrozenData_(), 'left'); 
			oldBlock ? oldBlock.replaceWidget(this.block) : this.appendChild(this.block);
		} else if (this.block && createFrozen) {
			this.block.create_(dir, rowStart, frozenColStart, rowEnd, forzenColEnd, this.getFrozenData_());
		}
	},
	initFrozenBlock_: function (sheet, tRow, bRow, data) {
		var c = sheet.frozenCol;
		if (c > -1) {
			var b = new zss.CellBlockCtrl(sheet, tRow, 0, bRow, c, data, 'left');
			this.appendChild(b, true);
			return b;
		}
		return null;
	},
	getHeaderData_: function () {
		
		if(this.isCorner) {
			return this.sheet._wgt._cacheCtrl.getSelectedSheet().topFrozen.rowHeaders;
		} else {
			return this.sheet._wgt._cacheCtrl.getSelectedSheet().rowHeaders;
		}
	},
	getFrozenData_: function () {
		var a = this.sheet._wgt._cacheCtrl.getSelectedSheet(),
			f = a.leftFrozen;
		return f ? f : a;
	},
	getFrozenHeaderData_: function () {
		var leftFrozen = this.getFrozenData_();
		return leftFrozen ? leftFrozen.columnHeaders : null;
	},
	getHeaderType_: function () {
		return zss.Header.VER;
	},
	isInsert_: function (dir) {
		return 'north' == dir; 
	},
	bindFrozenCtrl_: function () {
		var sheet = this.sheet,
			selArea = this.$n('select'),
			selChg = selArea.nextSibling,
			focus = selChg.nextSibling,
			highlight = focus.nextSibling;
		
		this.selArea = new zss.SelAreaCtrlLeft(sheet, selArea, sheet.initparm.selrange.clone());
		this.selChgArea = new zss.SelChgCtrlLeft(sheet, selChg);
		this.focusMark = new zss.FocusMarkCtrlLeft(sheet, focus, sheet.initparm.focus.clone());
		this.hlArea = new zss.HighlightLeft(sheet, highlight, sheet.initparm.hlrange.clone(), "inner");
	},
	
	addEditorFocus_ : function(id, name, div) {
		if(!this.editorFocusMark)
			this.editorFocusMark = new Object();
		this.editorFocusMark[id] = new zss.FocusMarkCtrlLeft(this.sheet, div, new zss.Pos(0, 0));
	},
	getTypeAttr_: function () {
		return 'SLeftPanel';
	},
	hasPad_: function () {
		return true;
	},
	removeChildFromStart_: function (size) {
		if (this.block) {
			this.block.removeRowsFromStart_(size);
		}
		this.$supers(zss.LeftPanel, 'removeChildFromStart_', arguments);
	},
	removeChildFromEnd_: function (size) {
		if (this.block) {
			this.block.removeRowsFromEnd_(size);
		}
		this.$supers(zss.LeftPanel, 'removeChildFromEnd_', arguments);
	},
	_updateHeight: function (height) {
		jq(this.comp).css('height', jq.px0(height));
		this.height = height;
		this._updateBlockHeight();
	},	
	_updateTopPos: function (toppos) {
		jq(this.icomp).css('top', jq.px(toppos));
		jq(this.wpcomp).css('top', jq.px(toppos-this.sheet.topHeight));
		this.toppos = toppos;
		this._updateBlockHeight();
	},
	_updateTopPadding: function (toppad) {
		if (this.toppad == toppad) return;
		jq(this.padcomp).css('height', jq.px0(toppad));
		this.toppad = toppad;	
		
		if (this.selArea)
			this.selArea.relocate();

		if (this.selChgArea)
			this.selChgArea.relocate();

		if (this.focusMark) {
			var pos = this.sheet.getLastFocus();
			this.focusMark.relocate(pos.row, pos.column);
		}
		this._updateBlockHeight();
	},
	_updateBlockHeight: function () {
		if (!this.block) return;
		var height = this.height,
			toppos = this.toppos,
			toppad = this.toppad;
		
		height = height - (toppos ? toppos : 0) - (toppad ? toppad : 0);






		if (height < 0) height = 0;
		jq(this.block.comp).css('height', jq.px0(height));
	},
	
	updateSelectionCSS: function (from, to, remove) {
		var i = this.headers.length,
			header;
		while (i--) {
			header = this.headers[i];
			if (header.index >= from && header.index <= to)
				jq(header.comp)[remove ? 'removeClass' : 'addClass']("zsleft-sel");
		}
	},
	
	updateSelectionCSS_: function () {
		var sheet = this.sheet,
			wgt = sheet._wgt,
			selRange = sheet.selArea.lastRange;
		if (!wgt.isSheetCSSReady())
			return;
		
		if (selRange) {
			var top = selRange.top,
				bottom = selRange.bottom;
			this.updateSelectionCSS(top, bottom, false || sheet.state == zss.SSheetCtrl.NOFOCUS);
		}
	},
	
	appendZSW: function (col, zsw) {
		if (this.block)
			this.block.appendZSW(col, zsw);
	},
	
	appendZSH: function (row, zsh) {
		if (this.block)
			this.block.appendZSH(row, zsh);
		
		
		if(this.isEmptyHeader()) {
			return;
		}
		
		var top = this.headers[0].index,
			bottom = top + this.headers.length - 1; 
		if (top > row || bottom < row) return;
		
		var index = row - top,
			header = this.headers[index];
		header.appendZSH(zsh);
	},
	
	insertNewColumn: function (col, size) {
		if (this.block)
			this.block.insertNewColumn(col, size);
	},
	
	insertNewRow: function (row, size, extnm) {
		if (this.block)
			this.block.insertNewRow(row, size);

		
		if(this.isEmptyHeader()) {
			return;
		}

		var top = this.headers[0].index,
			bottom = top + this.headers.length - 1; 
		if (row > (bottom + 1) || row < top) return;
		
		var index = row - top,
			ctrl,
			rowHeaders = this.getHeaderData_(),
			type = zss.Header.VER;
		
		
		var sheet = this.sheet,
			selRange = sheet.selArea.lastRange;
		if (sheet.state != zss.SSheetCtrl.NOFOCUS && selRange) {
			var top = selRange.top,
				bottom = selRange.bottom;
			if (row <= bottom && (row+size-1) >= top)
				this.updateSelectionCSS(top, bottom, true);
		}
			
		for (var i = 0; i < size; i++) {
			var r = row + i;
			ctrl = new zss.Header(sheet, type, rowHeaders[r]);
			this.insertHeader_(index + i, ctrl);
		}
		extnm = extnm.slice(size, extnm.length);
		this.shiftHeaderInfo(index + size, row + size, extnm);
	},
	
	shiftHeaderInfo: function (index, newrow, extnm) {
		var size = this.headers.length,
			j = 0;
		for (var i = index; i < size; i++) {
			if(!extnm[j]) zk.log("undefined header to assing>>"+(newrow+j),"always");
			this.headers[i].resetInfo(newrow + j, extnm[j]);
			j++;
		}
	},
	
	removeColumn: function (col, size) {
		if (this.block)
			this.block.removeColumn(col, size);
	},
	
	removeRow: function (row, size, extnm) {
		if (this.block)
			this.block.removeRow(row, size);

		
		if(this.isEmptyHeader()) {
			return;
		}

		var top = this.headers[0].index,
			bottom = top + this.headers.length - 1; 
		if(row > (bottom+1) || row < top) return;
		
		var index = row - top;
		if ((row + size) > bottom)
			size = bottom - row + 1;

		this.removeHeader_(index, size);
		this.shiftHeaderInfo(index, row, extnm);
	},
	_fixSize: function() {
		var sheet = this.sheet,
			wgt = sheet._wgt,
			lw = sheet.leftWidth,
			leftw = lw-1,
			fzc = sheet.frozenCol,
			name = wgt.getSelectorPrefix(),
			sid = wgt.getSheetCSSId();
		
		if (fzc > -1)
			leftw = leftw + sheet.custColWidth.getStartPixel(fzc + 1);

		zcss.setRule(name + " .zsleft", ["width"], [(fzc > -1 ? leftw - 1 : leftw) + "px"], true, sid);
		zcss.setRule(name + " .zslefti", ["width"], [leftw + "px"], true, sid);
	}
});
})();