/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.IllegalOpArgumentException;
import io.keikai.api.Range;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.model.InvalidModelOpException;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.UserActionHandler;
import java.io.Serializable;
import org.zkoss.util.resource.Labels;
import org.zkoss.zul.Messagebox;

public abstract class AbstractHandler
implements UserActionHandler,
Serializable {
    private static final long serialVersionUID = -3596700452009821943L;

    @Override
    public boolean isEnabled(Book book, Sheet sheet) {
        return true;
    }

    protected void showProtectMessage() {
        String message = Labels.getLabel((String)"zss.actionhandler.msg.sheet_protected");
        this.showWarnMessage(message);
    }

    protected void showInfoMessage(String message) {
        String title = Labels.getLabel((String)"zss.actionhandler.msg.info_title");
        Messagebox.show((String)message, (String)title, (int)1, (String)"z-messagebox-icon z-messagebox-information");
    }

    protected void showWarnMessage(String message) {
        String title = Labels.getLabel((String)"zss.actionhandler.msg.warn_title");
        Messagebox.show((String)message, (String)title, (int)1, (String)"z-messagebox-icon z-messagebox-exclamation");
    }

    @Override
    public boolean process(UserActionContext ctx) {
        try {
            return this.processAction(ctx);
        }
        catch (IllegalOpArgumentException x) {
            this.showInfoMessage(Labels.getLabel((String)"zss.actionhandler.msg.illegal_range_operation") + " : " + x.getMessage());
            return true;
        }
        catch (InvalidModelOpException x) {
            this.showInfoMessage(Labels.getLabel((String)"zss.actionhandler.msg.illegal_range_operation") + " : " + x.getMessage());
            return true;
        }
    }

    protected boolean checkInCornerFreezePanel(Range range) {
        Sheet sheet = range.getSheet();
        int fzr = sheet.getRowFreeze();
        int fzc = sheet.getColumnFreeze();
        return fzr > 0 && fzc > 0 && range.getRow() < fzr && range.getColumn() < fzc;
    }

    protected boolean checkSelectAllVisibleRow(UserActionContext ctx) {
        Spreadsheet ss = ctx.getSpreadsheet();
        AreaRef sel = ctx.getSelection();
        return sel.getRow() == 0 && sel.getLastRow() >= ss.getCurrentMaxVisibleRows() - 1;
    }

    protected boolean checkSelectAllVisibleColumn(UserActionContext ctx) {
        Spreadsheet ss = ctx.getSpreadsheet();
        AreaRef sel = ctx.getSelection();
        return sel.getColumn() == 0 && sel.getLastColumn() >= ss.getCurrentMaxVisibleColumns() - 1;
    }

    protected boolean checkSelectAllVisibleRowColumn(UserActionContext ctx) {
        Spreadsheet ss = ctx.getSpreadsheet();
        AreaRef sel = ctx.getSelection();
        return sel.getRow() == 0 && sel.getLastRow() >= ss.getCurrentMaxVisibleRows() - 1 && sel.getColumn() == 0 && sel.getLastColumn() >= ss.getCurrentMaxVisibleColumns() - 1;
    }

    protected abstract boolean processAction(UserActionContext var1);
}

