/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api.model.impl;

import io.keikai.api.UnitUtil;
import io.keikai.api.model.Color;
import io.keikai.api.model.Font;
import io.keikai.api.model.impl.ColorImpl;
import io.keikai.api.model.impl.EnumUtil;
import io.keikai.api.model.impl.ModelRef;
import io.keikai.api.model.impl.SimpleRef;
import io.keikai.model.SBook;
import io.keikai.model.SColor;
import io.keikai.model.SFont;
import java.io.Serializable;

public class FontImpl
implements Font,
Serializable {
    private static final long serialVersionUID = -349583235023683769L;
    protected ModelRef<SBook> _bookRef;
    protected ModelRef<SFont> _fontRef;

    public FontImpl(ModelRef<SBook> book, ModelRef<SFont> font) {
        this._bookRef = book;
        this._fontRef = font;
    }

    @Override
    public String getFontName() {
        return this.getNative().getName();
    }

    public SFont getNative() {
        return this._fontRef.get();
    }

    public ModelRef<SFont> getRef() {
        return this._fontRef;
    }

    @Override
    public Color getColor() {
        return new ColorImpl(this._bookRef, new SimpleRef<SColor>(this.getNative().getColor()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._fontRef == null ? 0 : this._fontRef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FontImpl other = (FontImpl)obj;
        return !(this._fontRef == null ? other._fontRef != null : !this._fontRef.equals(other._fontRef));
    }

    @Override
    public Font.Boldweight getBoldweight() {
        return EnumUtil.toFontBoldweight(this.getNative().getBoldweight());
    }

    @Override
    public int getFontHeight() {
        return UnitUtil.pointToTwip(this.getFontHeightInPoint());
    }

    @Override
    public boolean isItalic() {
        return this.getNative().isItalic();
    }

    @Override
    public boolean isStrikeout() {
        return this.getNative().isStrikeout();
    }

    @Override
    public Font.TypeOffset getTypeOffset() {
        return EnumUtil.toFontTypeOffset(this.getNative().getTypeOffset());
    }

    @Override
    public Font.Underline getUnderline() {
        return EnumUtil.toFontUnderline(this.getNative().getUnderline());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.getNative()).append("]");
        sb.append(this.getFontName());
        return sb.toString();
    }

    @Override
    public int getFontHeightInPoint() {
        return this.getNative().getHeightPoints();
    }
}

