/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula;

import org.zkoss.poi.ss.formula.LazyAreaEval;
import org.zkoss.poi.ss.formula.SheetRefEvaluator;
import org.zkoss.poi.ss.formula.eval.AreaEval;
import org.zkoss.poi.ss.formula.eval.HyperlinkEval;
import org.zkoss.poi.ss.formula.eval.RefEvalBase;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.ptg.AreaI;
import org.zkoss.poi.ss.usermodel.Hyperlink;
import org.zkoss.poi.ss.util.CellReference;

public final class LazyRefEval
extends RefEvalBase
implements HyperlinkEval {
    private final SheetRefEvaluator _evaluator;
    private Hyperlink _hyperlink;

    public LazyRefEval(int rowIndex, int columnIndex, boolean rowRel, boolean colRel, SheetRefEvaluator sre) {
        super(rowIndex, columnIndex, rowRel, colRel);
        if (sre == null) {
            throw new IllegalArgumentException("sre must not be null");
        }
        this._evaluator = sre;
    }

    @Override
    public ValueEval getInnerValueEval() {
        return this._evaluator.getEvalForCell(this.getRow(), this.getColumn());
    }

    @Override
    public AreaEval offset(int relFirstRowIx, int relLastRowIx, int relFirstColIx, int relLastColIx) {
        AreaI.OffsetArea area = new AreaI.OffsetArea(this.getRow(), this.getColumn(), relFirstRowIx, relLastRowIx, relFirstColIx, relLastColIx);
        return new LazyAreaEval(area, this._evaluator);
    }

    public String getSheetName() {
        return this._evaluator.getSheetName();
    }

    public String getLastSheetName() {
        return this._evaluator.getLastSheetName();
    }

    public String getBookName() {
        return this._evaluator.getBookName();
    }

    public String toString() {
        CellReference cr = new CellReference(this.getRow(), this.getColumn());
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        String bookName = this._evaluator.getBookName();
        if (bookName != null) {
            sb.append('[').append(bookName).append(']');
        }
        sb.append(this._evaluator.getSheetName());
        if (!this.getSheetName().equals(this.getLastSheetName())) {
            sb.append(':').append(this._evaluator.getLastSheetName());
        }
        sb.append('!');
        sb.append(cr.formatAsString());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void setHyperlink(Hyperlink hyperlink) {
        this._hyperlink = hyperlink;
    }

    @Override
    public Hyperlink getHyperlink() {
        return this._hyperlink;
    }

    @Override
    public boolean isHidden() {
        return this._evaluator.isHidden(this._evaluator.getSheetIndex(), this.getRow(), this.getColumn());
    }
}

