/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.LittleEndianOutput;

public final class DefaultRowHeightRecord
extends StandardRecord {
    private static final BitField fUnsynced = BitFieldFactory.getInstance(1);
    private static final BitField fDyZero = BitFieldFactory.getInstance(2);
    private static final BitField fExAsc = BitFieldFactory.getInstance(4);
    private static final BitField fExDsc = BitFieldFactory.getInstance(4);
    public static final short sid = 549;
    private short bits;
    private short miyRw;
    public static final short DEFAULT_ROW_HEIGHT = 300;

    public DefaultRowHeightRecord() {
        this.setRowHeight((short)300);
    }

    public DefaultRowHeightRecord(RecordInputStream in) {
        this.bits = in.readShort();
        this.miyRw = in.readShort();
    }

    public short getRowHeight() {
        return this.miyRw;
    }

    public void setRowHeight(short height) {
        if (height < 1 || height > 8179) {
            height = (short)300;
        }
        this.miyRw = height;
    }

    public boolean isDefaultChanged() {
        return fUnsynced.isSet(this.bits);
    }

    public void setDefaultChanged(boolean flag) {
        this.bits = (short)fUnsynced.setBoolean(this.bits, flag);
    }

    public boolean isZeroHeight() {
        return fDyZero.isSet(this.bits);
    }

    public void setZeroHeight(boolean flag) {
        this.bits = (short)fDyZero.setBoolean(this.bits, flag);
    }

    public boolean isThickTopBorder() {
        return fExAsc.isSet(this.bits);
    }

    public void setThickTopBorder(boolean flag) {
        this.bits = (short)fExAsc.setBoolean(this.bits, flag);
    }

    public boolean isThickBottomBorder() {
        return fExDsc.isSet(this.bits);
    }

    public void setThickBottomBorder(boolean flag) {
        this.bits = (short)fExDsc.setBoolean(this.bits, flag);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DEFAULTROWHEIGHT]\n");
        buffer.append("    .bits           = ").append(Integer.toHexString(this.bits)).append("\n");
        buffer.append("       .fUnsynced           = ").append(this.isDefaultChanged()).append("\n");
        buffer.append("       .fDyZero             = ").append(this.isZeroHeight()).append("\n");
        buffer.append("       .fExAsc              = ").append(this.isThickTopBorder()).append("\n");
        buffer.append("       .fExDsc              = ").append(this.isThickBottomBorder()).append("\n");
        buffer.append("    .rowheight      = ").append(Integer.toHexString(this.getRowHeight())).append("\n");
        buffer.append("[/DEFAULTROWHEIGHT]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.bits);
        out.writeShort(this.miyRw);
    }

    @Override
    protected int getDataSize() {
        return 4;
    }

    @Override
    public short getSid() {
        return 549;
    }

    @Override
    public Object clone() {
        DefaultRowHeightRecord rec = new DefaultRowHeightRecord();
        rec.bits = this.bits;
        rec.miyRw = this.miyRw;
        return rec;
    }
}

