/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.app.impl;

import io.keikai.api.model.Book;
import io.keikai.app.BookInfo;
import io.keikai.app.BookManager;
import io.keikai.app.BookRepository;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zkoss.lang.Library;

public class BookManagerImpl
implements BookManager,
Serializable {
    private static final long serialVersionUID = -2811375696946379394L;
    private static final Logger logger = Logger.getLogger(BookManagerImpl.class.getName());
    protected BookRepository repo;
    private static BookManagerImpl bookManagerImpl;

    @Override
    public Book readBook(BookInfo info) throws IOException {
        return this.repo.load(info);
    }

    @Override
    public BookInfo updateBook(BookInfo info, Book book) throws IOException {
        return this.repo.save(info, book);
    }

    @Override
    public BookInfo saveBook(BookInfo info, Book book) throws IOException {
        BookInfo newInfo = this.repo.saveAs(info.getName(), book);
        this.readBook(newInfo);
        return newInfo;
    }

    @Override
    public void deleteBook(BookInfo info) throws IOException {
        this.repo.delete(info);
    }

    @Override
    public void detachBook(BookInfo info) throws IOException {
    }

    @Override
    public boolean isBookAttached(BookInfo info) {
        return false;
    }

    @Override
    public void saveAll() throws IOException {
    }

    protected BookManagerImpl(BookRepository repo) {
        this.repo = repo;
    }

    public static BookManagerImpl getInstance(BookRepository repo) {
        if (bookManagerImpl == null) {
            String clz = Library.getProperty((String)"io.keikai.app.BookManager.class");
            if (clz != null && Boolean.valueOf(Library.getProperty((String)"zssapp.collaboration.disabled")) != Boolean.TRUE) {
                try {
                    bookManagerImpl = (BookManagerImpl)Class.forName(clz).getDeclaredConstructor(BookRepository.class).newInstance(repo);
                }
                catch (Exception e) {
                    bookManagerImpl = new BookManagerImpl(repo);
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            } else {
                bookManagerImpl = new BookManagerImpl(repo);
            }
        }
        return bookManagerImpl;
    }

    @Override
    public void shutdownAutoFileSaving() {
    }
}

