/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.client.impl.protocol.task.MessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.instance.impl.NodeState;
import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.hotrestart.InternalHotRestartService;
import com.hazelcast.internal.metrics.ExcludedMetricTargets;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricTarget;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.StaticMetricsProvider;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.SerializationServiceV1;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.LatencyDistribution;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.MwCounter;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.spi.exception.CallerNotMemberException;
import com.hazelcast.spi.exception.PartitionMigratingException;
import com.hazelcast.spi.exception.ResponseAlreadySentException;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationservice.BlockingOperation;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.Notifier;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationAccessor;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandler;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandlerFactory;
import com.hazelcast.spi.impl.operationservice.Operations;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import com.hazelcast.spi.impl.operationservice.impl.OperationBackupHandler;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.OutboundResponseHandler;
import com.hazelcast.spi.impl.operationservice.impl.operations.Backup;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionIteratingOperation;
import com.hazelcast.spi.impl.operationservice.impl.responses.CallTimeoutResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.ErrorResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.splitbrainprotection.impl.SplitBrainProtectionServiceImpl;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

@ExcludedMetricTargets(value={MetricTarget.MANAGEMENT_CENTER})
public class OperationRunnerImpl
extends OperationRunner
implements StaticMetricsProvider {
    static final int AD_HOC_PARTITION_ID = -2;
    private final ILogger logger;
    private final OperationServiceImpl operationService;
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    @Probe(name="executedOperationsCount", level=ProbeLevel.DEBUG)
    private final Counter executedOperationsCounter;
    private final Address thisAddress;
    private final boolean staleReadOnMigrationEnabled;
    private final Counter failedBackupsCounter;
    private final OperationBackupHandler backupHandler;
    private final int genericId;
    private InternalPartition internalPartition;
    private final OutboundResponseHandler outboundResponseHandler;
    private final ConcurrentMap<Class, LatencyDistribution> opLatencyDistributions;

    OperationRunnerImpl(OperationServiceImpl operationService, int partitionId, int genericId, Counter failedBackupsCounter, ConcurrentMap<Class, LatencyDistribution> opLatencyDistributions) {
        super(partitionId);
        this.genericId = genericId;
        this.operationService = operationService;
        this.logger = operationService.node.getLogger(OperationRunnerImpl.class);
        this.node = operationService.node;
        this.thisAddress = this.node.getThisAddress();
        this.nodeEngine = operationService.nodeEngine;
        this.outboundResponseHandler = operationService.outboundResponseHandler;
        this.staleReadOnMigrationEnabled = !this.node.getProperties().getBoolean(ClusterProperty.DISABLE_STALE_READ_ON_PARTITION_MIGRATION);
        this.failedBackupsCounter = failedBackupsCounter;
        this.backupHandler = operationService.backupHandler;
        this.opLatencyDistributions = opLatencyDistributions;
        this.executedOperationsCounter = partitionId == -2 ? MwCounter.newMwCounter() : SwCounter.newSwCounter();
    }

    public OperationBackupHandler getBackupHandler() {
        return this.backupHandler;
    }

    @Override
    public long executedOperationsCount() {
        return this.executedOperationsCounter.get();
    }

    @Override
    public void provideStaticMetrics(MetricsRegistry registry) {
        if (this.partitionId >= 0) {
            MetricDescriptor descriptor = registry.newMetricDescriptor().withPrefix("operation.partition").withDiscriminator("partitionId", String.valueOf(this.partitionId));
            registry.registerStaticMetrics(descriptor, this);
        } else if (this.partitionId == -1) {
            MetricDescriptor descriptor = registry.newMetricDescriptor().withPrefix("operation.generic").withDiscriminator("genericId", String.valueOf(this.genericId));
            registry.registerStaticMetrics(descriptor, this);
        } else {
            registry.registerStaticMetrics(this, "operation.adhoc");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Runnable task) {
        long startNanos = System.nanoTime();
        boolean publishCurrentTask = this.publishCurrentTask();
        if (publishCurrentTask) {
            this.currentTask = task;
        }
        try {
            task.run();
        }
        finally {
            if (publishCurrentTask) {
                this.currentTask = null;
            }
            if (this.opLatencyDistributions != null) {
                Class<?> c = task.getClass();
                LatencyDistribution distribution = this.opLatencyDistributions.computeIfAbsent(c, k -> new LatencyDistribution());
                distribution.done(startNanos);
            }
        }
    }

    private boolean publishCurrentTask() {
        boolean isClientRunnable = this.currentTask instanceof MessageTask;
        return this.getPartitionId() != -2 && (this.currentTask == null || isClientRunnable);
    }

    @Override
    public boolean run(Operation op) {
        return this.run(op, System.nanoTime());
    }

    public boolean metWithPreconditions(Operation op) {
        this.checkNodeState(op);
        if (this.timeout(op)) {
            return false;
        }
        this.ensureNoPartitionProblems(op);
        this.ensureNoSplitBrain(op);
        return true;
    }

    public void ensureNodeAndClusterHealth(Operation op) {
        this.checkNodeState(op);
        this.ensureNoPartitionProblems(op);
        this.ensureNoSplitBrain(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean run(Operation op, long startNanos) {
        block13: {
            this.executedOperationsCounter.inc();
            boolean publishCurrentTask = this.publishCurrentTask();
            if (publishCurrentTask) {
                this.currentTask = op;
            }
            try {
                if (!this.metWithPreconditions(op)) {
                    boolean bl = false;
                    return bl;
                }
                if (op.isTenantAvailable()) {
                    op.pushThreadContext();
                    op.beforeRun();
                    this.call(op);
                    break block13;
                }
                boolean bl = true;
                return bl;
            }
            catch (Throwable e) {
                this.handleOperationError(op, e);
            }
            finally {
                op.afterRunFinal();
                if (publishCurrentTask) {
                    this.currentTask = null;
                }
                op.popThreadContext();
                if (this.opLatencyDistributions != null) {
                    LatencyDistribution distribution;
                    Class<?> c = op.getClass();
                    if (op instanceof PartitionIteratingOperation) {
                        c = ((PartitionIteratingOperation)op).getOperationFactory().getClass();
                    }
                    if ((distribution = (LatencyDistribution)this.opLatencyDistributions.get(c)) == null) {
                        distribution = this.opLatencyDistributions.computeIfAbsent(c, k -> new LatencyDistribution());
                    }
                    distribution.recordNanos(System.nanoTime() - startNanos);
                }
            }
        }
        return false;
    }

    private void call(Operation op) throws Exception {
        CallStatus callStatus = op.call();
        switch (callStatus.ordinal()) {
            case 0: {
                int backupAcks = this.backupHandler.sendBackups(op);
                Object response = op.getResponse();
                if (backupAcks > 0) {
                    response = new NormalResponse(response, op.getCallId(), backupAcks, op.isUrgent());
                }
                try {
                    op.sendResponse(response);
                }
                catch (ResponseAlreadySentException e) {
                    this.logOperationError(op, e);
                }
                this.afterRun(op);
                break;
            }
            case 1: {
                this.backupHandler.sendBackups(op);
                this.afterRun(op);
                break;
            }
            case 3: {
                op.afterRun();
                Offload offload = (Offload)callStatus;
                offload.init(this.nodeEngine, this.operationService.asyncOperations);
                offload.start();
                break;
            }
            case 2: {
                this.nodeEngine.getOperationParker().park((BlockingOperation)((Object)op));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void checkNodeState(Operation op) {
        NodeState state = this.node.getState();
        if (state == NodeState.ACTIVE) {
            return;
        }
        Address localAddress = this.node.getThisAddress();
        if (state == NodeState.SHUT_DOWN) {
            throw new HazelcastInstanceNotActiveException("Member " + localAddress + " is shut down! Operation: " + op);
        }
        if (op instanceof AllowedDuringPassiveState) {
            return;
        }
        if (this.nodeEngine.getClusterService().getClusterState() == ClusterState.PASSIVE) {
            throw new IllegalStateException("Cluster is in " + (Object)((Object)ClusterState.PASSIVE) + " state! Operation: " + op);
        }
        InternalHotRestartService hotRestartService = this.node.getNodeExtension().getInternalHotRestartService();
        if (hotRestartService.isEnabled() && !hotRestartService.isStartCompleted()) {
            throw new RetryableHazelcastException("Recovery from persistence is still in progress. Operation: " + op);
        }
    }

    private void ensureNoSplitBrain(Operation op) {
        SplitBrainProtectionServiceImpl splitBrainProtectionService = this.operationService.nodeEngine.getSplitBrainProtectionService();
        splitBrainProtectionService.ensureNoSplitBrain(op);
    }

    public boolean timeout(Operation op) {
        if (!this.operationService.isCallTimedOut(op)) {
            return false;
        }
        op.sendResponse(new CallTimeoutResponse(op.getCallId(), op.isUrgent()));
        return true;
    }

    private void afterRun(Operation op) {
        try {
            Notifier notifier;
            op.afterRun();
            if (op instanceof Notifier && (notifier = (Notifier)((Object)op)).shouldNotify()) {
                this.operationService.nodeEngine.getOperationParker().unpark(notifier);
            }
        }
        catch (Throwable e) {
            this.logOperationError(op, e);
        }
    }

    private void ensureNoPartitionProblems(Operation op) {
        int partitionId = op.getPartitionId();
        if (partitionId < 0) {
            return;
        }
        if (partitionId != this.getPartitionId()) {
            throw new IllegalStateException("wrong partition, expected: " + this.getPartitionId() + " but found:" + partitionId);
        }
        if (this.internalPartition == null) {
            this.internalPartition = this.nodeEngine.getPartitionService().getPartition(partitionId);
        }
        if (!this.isAllowedToRetryDuringMigration(op) && this.internalPartition.isMigrating()) {
            throw new PartitionMigratingException(this.thisAddress, partitionId, op.getClass().getName(), op.getServiceName());
        }
        PartitionReplica owner = this.internalPartition.getReplica(op.getReplicaIndex());
        if (op.validatesTarget() && (owner == null || !owner.isIdentical(this.node.getLocalMember()))) {
            MemberImpl target = owner != null ? this.node.getClusterService().getMember(owner.address(), owner.uuid()) : null;
            throw new WrongTargetException(this.node.getLocalMember(), target, partitionId, op.getReplicaIndex(), op.getClass().getName(), op.getServiceName());
        }
    }

    private boolean isAllowedToRetryDuringMigration(Operation op) {
        return op instanceof ReadonlyOperation && this.staleReadOnMigrationEnabled || Operations.isMigrationOperation(op);
    }

    public void handleOperationError(Operation operation, Throwable e) {
        if (e instanceof OutOfMemoryError) {
            OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)e);
        }
        try {
            operation.onExecutionFailure(e);
        }
        catch (Throwable t) {
            this.logger.warning("While calling 'operation.onFailure(e)'... op: " + operation + ", error: " + e, t);
        }
        operation.logError(e);
        if (operation instanceof Backup) {
            this.failedBackupsCounter.inc();
            return;
        }
        this.sendResponseAfterOperationError(operation, e);
    }

    private void sendResponseAfterOperationError(Operation operation, Throwable e) {
        try {
            if (this.node.getState() != NodeState.SHUT_DOWN) {
                operation.sendResponse(e);
            } else if (operation.executedLocally()) {
                operation.sendResponse(new HazelcastInstanceNotActiveException());
            }
        }
        catch (Throwable t) {
            this.logger.warning("While sending op error... op: " + operation + ", error: " + e, t);
        }
    }

    private void logOperationError(Operation op, Throwable e) {
        if (e instanceof OutOfMemoryError) {
            OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)e);
        }
        op.logError(e);
    }

    @Override
    public boolean run(Packet packet) throws Exception {
        long startNanos = System.nanoTime();
        boolean publishCurrentTask = this.publishCurrentTask();
        if (publishCurrentTask) {
            this.currentTask = packet;
        }
        ServerConnection connection = packet.getConn();
        Address caller = connection.getRemoteAddress();
        UUID callerUuid = connection.getRemoteUuid();
        Operation op = null;
        try {
            Object object = this.nodeEngine.toObject(packet);
            op = (Operation)object;
            op.setNodeEngine(this.nodeEngine);
            OperationAccessor.setCallerAddress(op, caller);
            OperationAccessor.setConnection(op, connection);
            this.setCallerUuidIfNotSet(op, callerUuid);
            this.setOperationResponseHandler(op);
            if (!this.ensureValidMember(op)) {
                boolean bl = false;
                return bl;
            }
            if (publishCurrentTask) {
                this.currentTask = null;
            }
            boolean bl = this.run(op, startNanos);
            return bl;
        }
        catch (Throwable throwable) {
            long callId = this.extractOperationCallId(packet);
            this.outboundResponseHandler.send(connection.getConnectionManager(), caller, new ErrorResponse(throwable, callId, packet.isUrgent()));
            this.logOperationDeserializationException(throwable, callId);
            throw ExceptionUtil.rethrow(throwable);
        }
        finally {
            if (op != null) {
                op.clearThreadContext();
            }
            if (publishCurrentTask) {
                this.currentTask = null;
            }
        }
    }

    private long extractOperationCallId(Data data) throws IOException {
        ObjectDataInput input = ((SerializationServiceV1)this.node.getSerializationService()).initDataSerializableInputAndSkipTheHeader(data);
        return input.readLong();
    }

    private void setOperationResponseHandler(Operation op) {
        OperationResponseHandler handler = this.outboundResponseHandler;
        if (op.getCallId() == 0L) {
            if (op.returnsResponse()) {
                throw new HazelcastException("Operation " + op + " wants to return a response, but doesn't have a call ID");
            }
            handler = OperationResponseHandlerFactory.createEmptyResponseHandler();
        }
        op.setOperationResponseHandler(handler);
    }

    private boolean ensureValidMember(Operation op) {
        if (this.node.clusterService.getMember(op.getCallerAddress()) != null || Operations.isJoinOperation(op) || Operations.isWanReplicationOperation(op)) {
            return true;
        }
        CallerNotMemberException error = new CallerNotMemberException(this.thisAddress, op.getCallerAddress(), op.getPartitionId(), op.getClass().getName(), op.getServiceName());
        this.handleOperationError(op, error);
        return false;
    }

    private void setCallerUuidIfNotSet(Operation op, UUID callerUuid) {
        if (op.getCallerUuid() != null) {
            return;
        }
        if (callerUuid != null) {
            op.setCallerUuid(callerUuid);
        }
    }

    private void logOperationDeserializationException(Throwable t, long callId) {
        boolean returnsResponse;
        boolean bl = returnsResponse = callId != 0L;
        if (t instanceof RetryableException) {
            Level level;
            Level level2 = level = returnsResponse ? Level.FINEST : Level.WARNING;
            if (this.logger.isLoggable(level)) {
                this.logger.log(level, t.getClass().getName() + ": " + t.getMessage());
            }
        } else if (t instanceof OutOfMemoryError) {
            try {
                this.logException(t.getMessage(), t, Level.SEVERE);
            }
            catch (Throwable ignored) {
                this.logger.severe(ignored.getMessage(), t);
            }
        } else if (t instanceof HazelcastSerializationException) {
            if (!this.node.getClusterService().isJoined()) {
                this.logException("A serialization exception occurred while joining a cluster, is this member compatible with other members of the cluster?", t, Level.SEVERE);
            } else {
                this.logException(t.getMessage(), t, this.nodeEngine.isRunning() ? Level.SEVERE : Level.FINEST);
            }
        } else {
            this.logException(t.getMessage(), t, this.nodeEngine.isRunning() ? Level.SEVERE : Level.FINEST);
        }
    }

    private void logException(String message, Throwable t, Level level) {
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, message, t);
        }
    }
}

