/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.internal.util.TimeStripUtil;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordReaderWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public abstract class AbstractRecord<V>
implements Record<V> {
    private static final int NUMBER_OF_INTS = 6;
    protected int version;
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Record can be accessed by only its own partition thread.")
    protected volatile int hits;
    private volatile int lastAccessTime = -1;
    private volatile int lastUpdateTime = -1;
    private int creationTime = -1;
    private int lastStoredTime = -1;

    AbstractRecord() {
    }

    @Override
    public RecordReaderWriter getMatchingRecordReaderWriter() {
        return RecordReaderWriter.DATA_RECORD_WITH_STATS_READER_WRITER;
    }

    @Override
    public final int getVersion() {
        return this.version;
    }

    @Override
    public final void setVersion(int version) {
        this.version = version;
    }

    @Override
    public long getLastAccessTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.lastAccessTime);
    }

    @Override
    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = TimeStripUtil.stripBaseTime(lastAccessTime);
    }

    @Override
    public long getLastUpdateTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.lastUpdateTime);
    }

    @Override
    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = TimeStripUtil.stripBaseTime(lastUpdateTime);
    }

    @Override
    public long getCreationTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.creationTime);
    }

    @Override
    public void setCreationTime(long creationTime) {
        this.creationTime = TimeStripUtil.stripBaseTime(creationTime);
    }

    @Override
    public int getHits() {
        return this.hits;
    }

    @Override
    public void setHits(int hits) {
        this.hits = hits;
    }

    @Override
    public long getCost() {
        return JVMUtil.OBJECT_HEADER_SIZE + 24;
    }

    @Override
    public long getLastStoredTime() {
        if (this.lastStoredTime == -1) {
            return 0L;
        }
        return TimeStripUtil.recomputeWithBaseTime(this.lastStoredTime);
    }

    @Override
    public void setLastStoredTime(long lastStoredTime) {
        this.lastStoredTime = TimeStripUtil.stripBaseTime(lastStoredTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRecord that = (AbstractRecord)o;
        if (this.version != that.version) {
            return false;
        }
        if (this.hits != that.hits) {
            return false;
        }
        if (this.lastAccessTime != that.lastAccessTime) {
            return false;
        }
        if (this.lastUpdateTime != that.lastUpdateTime) {
            return false;
        }
        if (this.creationTime != that.creationTime) {
            return false;
        }
        return this.lastStoredTime == that.lastStoredTime;
    }

    public int hashCode() {
        int result = this.version;
        result = 31 * result + this.hits;
        result = 31 * result + this.lastAccessTime;
        result = 31 * result + this.lastUpdateTime;
        result = 31 * result + this.creationTime;
        result = 31 * result + this.lastStoredTime;
        return result;
    }

    @Override
    public int getRawCreationTime() {
        return this.creationTime;
    }

    @Override
    public int getRawLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public int getRawLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void setRawCreationTime(int creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public void setRawLastAccessTime(int lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    @Override
    public void setRawLastUpdateTime(int lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Override
    public int getRawLastStoredTime() {
        return this.lastStoredTime;
    }

    @Override
    public void setRawLastStoredTime(int time) {
        this.lastStoredTime = time;
    }

    public String toString() {
        return "AbstractRecord{, version=" + this.version + ", hits=" + this.hits + ", lastAccessTime=" + this.lastAccessTime + ", lastUpdateTime=" + this.lastUpdateTime + ", creationTime=" + this.creationTime + '}';
    }
}

