/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.annotation.EvolvingApi;
import com.hazelcast.jet.config.JetConfigDataSerializerHook;
import com.hazelcast.jet.config.JobClassLoaderFactory;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.config.ResourceType;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.spi.annotation.Beta;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JobConfig
implements IdentifiedDataSerializable {
    private static final long SNAPSHOT_INTERVAL_MILLIS_DEFAULT = TimeUnit.SECONDS.toMillis(10L);
    private transient boolean locked;
    private String name;
    private ProcessingGuarantee processingGuarantee = ProcessingGuarantee.NONE;
    private long snapshotIntervalMillis = SNAPSHOT_INTERVAL_MILLIS_DEFAULT;
    private boolean autoScaling = true;
    private boolean suspendOnFailure;
    private boolean splitBrainProtectionEnabled;
    private boolean enableMetrics = true;
    private boolean storeMetricsAfterJobCompletion;
    private long maxProcessorAccumulatedRecords = -1L;
    private long timeoutMillis;
    private String initialSnapshotName;
    private JobClassLoaderFactory classLoaderFactory;
    private Map<String, ResourceConfig> resourceConfigs = new LinkedHashMap<String, ResourceConfig>();
    private Map<String, String> serializerConfigs = new HashMap<String, String>();
    private Map<String, Object> arguments = new HashMap<String, Object>();
    private Map<String, List<String>> customClassPaths = new HashMap<String, List<String>>();

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nonnull
    public JobConfig setName(@Nullable String name) {
        this.throwIfLocked();
        this.name = name;
        return this;
    }

    public boolean isSplitBrainProtectionEnabled() {
        return this.splitBrainProtectionEnabled;
    }

    @Nonnull
    public JobConfig setSplitBrainProtection(boolean isEnabled) {
        this.throwIfLocked();
        this.splitBrainProtectionEnabled = isEnabled;
        return this;
    }

    public boolean isAutoScaling() {
        return this.autoScaling;
    }

    public JobConfig setAutoScaling(boolean enabled) {
        this.throwIfLocked();
        this.autoScaling = enabled;
        return this;
    }

    public boolean isSuspendOnFailure() {
        return this.suspendOnFailure;
    }

    public JobConfig setSuspendOnFailure(boolean suspendOnFailure) {
        this.throwIfLocked();
        this.suspendOnFailure = suspendOnFailure;
        return this;
    }

    @Nonnull
    public ProcessingGuarantee getProcessingGuarantee() {
        return this.processingGuarantee;
    }

    @Nonnull
    public JobConfig setProcessingGuarantee(@Nonnull ProcessingGuarantee processingGuarantee) {
        this.throwIfLocked();
        this.processingGuarantee = processingGuarantee;
        return this;
    }

    public long getSnapshotIntervalMillis() {
        return this.snapshotIntervalMillis;
    }

    @Nonnull
    public JobConfig setSnapshotIntervalMillis(long snapshotInterval) {
        this.throwIfLocked();
        Preconditions.checkNotNegative(snapshotInterval, "snapshotInterval can't be negative");
        this.snapshotIntervalMillis = snapshotInterval;
        return this;
    }

    @Nonnull
    public JobConfig addClass(Class ... classes) {
        ReflectionUtils.nestedClassesOf(classes).forEach(this::addClass);
        return this;
    }

    @Nonnull
    public JobConfig addPackage(String ... packages) {
        Preconditions.checkNotNull(packages, "Packages cannot be null");
        ReflectionUtils.Resources resources = ReflectionUtils.resourcesOf(packages);
        resources.classes().forEach(classResource -> this.add(classResource.getUrl(), classResource.getId(), ResourceType.CLASS));
        resources.nonClasses().forEach(this::addClasspathResource);
        return this;
    }

    @Nonnull
    public JobConfig addJar(@Nonnull URL url) {
        this.throwIfLocked();
        return this.add(url, JobConfig.filenamePart(url), ResourceType.JAR);
    }

    @Nonnull
    public JobConfig addJar(@Nonnull File file) {
        JobConfig.ensureIsFile(file);
        return this.addJar(JobConfig.fileToUrl(file));
    }

    @Nonnull
    public JobConfig addJar(@Nonnull String path) {
        return this.addJar(new File(path));
    }

    @Nonnull
    public JobConfig addJarsInZip(@Nonnull URL url) {
        return this.add(url, JobConfig.filenamePart(url), ResourceType.JARS_IN_ZIP);
    }

    @Nonnull
    public JobConfig addJarsInZip(@Nonnull File file) {
        JobConfig.ensureIsFile(file);
        return this.addJarsInZip(JobConfig.fileToUrl(file));
    }

    @Nonnull
    public JobConfig addJarsInZip(@Nonnull String path) {
        return this.addJarsInZip(new File(path));
    }

    @Nonnull
    public JobConfig addClasspathResource(@Nonnull URL url) {
        return this.addClasspathResource(url, JobConfig.filenamePart(url));
    }

    @Nonnull
    public JobConfig addClasspathResource(@Nonnull URL url, @Nonnull String id) {
        return this.add(url, id, ResourceType.CLASSPATH_RESOURCE);
    }

    @Nonnull
    public JobConfig addClasspathResource(@Nonnull File file) {
        JobConfig.ensureIsFile(file);
        return this.addClasspathResource(JobConfig.fileToUrl(file), file.getName());
    }

    @Nonnull
    public JobConfig addClasspathResource(@Nonnull File file, @Nonnull String id) {
        JobConfig.ensureIsFile(file);
        return this.add(JobConfig.fileToUrl(file), id, ResourceType.CLASSPATH_RESOURCE);
    }

    @Nonnull
    public JobConfig addClasspathResource(@Nonnull String path) {
        return this.addClasspathResource(new File(path));
    }

    @Nonnull
    public JobConfig addClasspathResource(@Nonnull String path, @Nonnull String id) {
        return this.addClasspathResource(new File(path), id);
    }

    @Nonnull
    @Beta
    public JobConfig addCustomClasspath(@Nonnull String name, @Nonnull String path) {
        this.throwIfLocked();
        List classpathItems = this.customClassPaths.computeIfAbsent(name, k -> new ArrayList());
        classpathItems.add(path);
        return this;
    }

    @Nonnull
    @Beta
    public JobConfig addCustomClasspaths(@Nonnull String name, @Nonnull List<String> paths) {
        this.throwIfLocked();
        List classpathItems = this.customClassPaths.computeIfAbsent(name, k -> new ArrayList());
        classpathItems.addAll(paths);
        return this;
    }

    @Nonnull
    public JobConfig attachFile(@Nonnull URL url) {
        return this.attachFile(url, JobConfig.filenamePart(url));
    }

    @Nonnull
    public JobConfig attachFile(@Nonnull URL url, @Nonnull String id) {
        JobConfig.ensureHasPath(url);
        return this.add(url, id, ResourceType.FILE);
    }

    @Nonnull
    public JobConfig attachFile(@Nonnull File file) {
        return this.attachFile(file, file.getName());
    }

    @Nonnull
    public JobConfig attachFile(@Nonnull File file, @Nonnull String id) {
        JobConfig.ensureIsFile(file);
        return this.attachFile(JobConfig.fileToUrl(file), id);
    }

    @Nonnull
    public JobConfig attachFile(@Nonnull String path) {
        return this.attachFile(new File(path));
    }

    @Nonnull
    public JobConfig attachFile(@Nonnull String path, @Nonnull String id) {
        return this.attachFile(new File(path), id);
    }

    @Nonnull
    public JobConfig attachDirectory(@Nonnull URL url) {
        return this.attachDirectory(url, JobConfig.urlToFile(url).getName());
    }

    @Nonnull
    public JobConfig attachDirectory(@Nonnull URL url, @Nonnull String id) {
        JobConfig.ensureHasPath(url);
        JobConfig.ensureIsDirectory(JobConfig.urlToFile(url));
        return this.add(url, id, ResourceType.DIRECTORY);
    }

    @Nonnull
    public JobConfig attachDirectory(@Nonnull String path) {
        return this.attachDirectory(new File(path));
    }

    @Nonnull
    public JobConfig attachDirectory(@Nonnull String path, @Nonnull String id) {
        return this.attachDirectory(new File(path), id);
    }

    @Nonnull
    public JobConfig attachDirectory(@Nonnull File file) {
        return this.attachDirectory(file, file.getName());
    }

    @Nonnull
    public JobConfig attachDirectory(@Nonnull File file, @Nonnull String id) {
        return this.attachDirectory(JobConfig.fileToUrl(file), id);
    }

    @Nonnull
    public JobConfig attachAll(@Nonnull Map<String, File> idToFile) {
        this.throwIfLocked();
        for (Map.Entry<String, File> e : idToFile.entrySet()) {
            File file = e.getValue();
            if (!file.canRead()) {
                throw new JetException("Not readable: " + file);
            }
            if (file.isDirectory()) {
                this.attachDirectory(file, e.getKey());
                continue;
            }
            if (file.isFile()) {
                this.attachFile(file, e.getKey());
                continue;
            }
            throw new JetException("Neither a regular file nor a directory: " + file);
        }
        return this;
    }

    @Nonnull
    private static String filenamePart(@Nonnull URL url) {
        String filename = new File(url.getPath()).getName();
        Preconditions.checkHasText(filename, "URL has no path: " + url);
        return filename;
    }

    private static void ensureHasPath(@Nonnull URL url) {
        if (url.getPath().isEmpty()) {
            throw new IllegalArgumentException("URL has no path part: " + url.toExternalForm());
        }
    }

    private static void ensureIsFile(@Nonnull File file) {
        if (!file.isFile() || !file.canRead()) {
            throw new JetException("Not an existing, readable file: " + file);
        }
    }

    private static void ensureIsDirectory(@Nonnull File path) {
        if (!path.isDirectory() || !path.canRead()) {
            throw new JetException("Not an existing, readable directory: " + path);
        }
    }

    private static URL fileToUrl(@Nonnull File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid file: " + file, e);
        }
    }

    private static File urlToFile(@Nonnull URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid directory URL: " + url.toExternalForm(), e);
        }
    }

    @Nonnull
    @PrivateApi
    public Map<String, ResourceConfig> getResourceConfigs() {
        return this.resourceConfigs;
    }

    public Map<String, List<String>> getCustomClassPaths() {
        return this.customClassPaths;
    }

    @Nonnull
    @EvolvingApi
    public <T, S extends StreamSerializer<T>> JobConfig registerSerializer(@Nonnull Class<T> clazz, @Nonnull Class<S> serializerClass) {
        this.throwIfLocked();
        Preconditions.checkFalse(this.serializerConfigs.containsKey(clazz.getName()), "Serializer for " + clazz + " already registered");
        this.serializerConfigs.put(clazz.getName(), serializerClass.getName());
        return this;
    }

    @Nonnull
    @PrivateApi
    public Map<String, String> getSerializerConfigs() {
        return this.serializerConfigs;
    }

    private void addClass(@Nonnull Class<?> clazz) {
        this.throwIfLocked();
        ResourceConfig cfg = new ResourceConfig(clazz);
        this.resourceConfigs.put(cfg.getId(), cfg);
    }

    private JobConfig add(@Nonnull URL url, @Nonnull String id, @Nonnull ResourceType resourceType) {
        this.throwIfLocked();
        Preconditions.checkHasText(id, "Resource ID is blank");
        ResourceConfig cfg = new ResourceConfig(url, id, resourceType);
        if (this.resourceConfigs.putIfAbsent(id, cfg) != null) {
            throw new IllegalArgumentException("Resource with id:" + id + " already exists");
        }
        return this;
    }

    @Nonnull
    public JobConfig setArgument(String key, Object value) {
        this.throwIfLocked();
        this.arguments.put(key, value);
        return this;
    }

    @Nullable
    public <T> T getArgument(String key) {
        return (T)this.arguments.get(key);
    }

    @Nonnull
    public JobConfig setClassLoaderFactory(@Nullable JobClassLoaderFactory classLoaderFactory) {
        this.throwIfLocked();
        this.classLoaderFactory = classLoaderFactory;
        return this;
    }

    @Nullable
    public JobClassLoaderFactory getClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    @Nullable
    public String getInitialSnapshotName() {
        return this.initialSnapshotName;
    }

    @Nonnull
    public JobConfig setInitialSnapshotName(@Nullable String initialSnapshotName) {
        this.throwIfLocked();
        this.initialSnapshotName = initialSnapshotName;
        return this;
    }

    public boolean isMetricsEnabled() {
        return this.enableMetrics;
    }

    @Nonnull
    public JobConfig setMetricsEnabled(boolean enabled) {
        this.throwIfLocked();
        this.enableMetrics = enabled;
        return this;
    }

    public boolean isStoreMetricsAfterJobCompletion() {
        return this.storeMetricsAfterJobCompletion;
    }

    public JobConfig setStoreMetricsAfterJobCompletion(boolean storeMetricsAfterJobCompletion) {
        this.throwIfLocked();
        this.storeMetricsAfterJobCompletion = storeMetricsAfterJobCompletion;
        return this;
    }

    public long getMaxProcessorAccumulatedRecords() {
        return this.maxProcessorAccumulatedRecords;
    }

    public JobConfig setMaxProcessorAccumulatedRecords(long maxProcessorAccumulatedRecords) {
        this.throwIfLocked();
        Preconditions.checkTrue(maxProcessorAccumulatedRecords > 0L || maxProcessorAccumulatedRecords == -1L, "maxProcessorAccumulatedRecords must be a positive number or -1");
        this.maxProcessorAccumulatedRecords = maxProcessorAccumulatedRecords;
        return this;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public JobConfig setTimeoutMillis(long timeoutMillis) {
        this.throwIfLocked();
        Preconditions.checkNotNegative(timeoutMillis, "timeoutMillis can't be negative");
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    @Override
    public int getFactoryId() {
        return JetConfigDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeObject((Object)this.processingGuarantee);
        out.writeLong(this.snapshotIntervalMillis);
        out.writeBoolean(this.autoScaling);
        out.writeBoolean(this.suspendOnFailure);
        out.writeBoolean(this.splitBrainProtectionEnabled);
        SerializationUtil.writeMap(this.resourceConfigs, out);
        out.writeObject(this.serializerConfigs);
        out.writeObject(this.arguments);
        out.writeObject(this.customClassPaths);
        out.writeObject(this.classLoaderFactory);
        out.writeString(this.initialSnapshotName);
        out.writeBoolean(this.enableMetrics);
        out.writeBoolean(this.storeMetricsAfterJobCompletion);
        out.writeLong(this.maxProcessorAccumulatedRecords);
        out.writeLong(this.timeoutMillis);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.processingGuarantee = (ProcessingGuarantee)((Object)in.readObject());
        this.snapshotIntervalMillis = in.readLong();
        this.autoScaling = in.readBoolean();
        this.suspendOnFailure = in.readBoolean();
        this.splitBrainProtectionEnabled = in.readBoolean();
        this.resourceConfigs = SerializationUtil.readMap(in);
        this.serializerConfigs = (Map)in.readObject();
        this.arguments = (Map)in.readObject();
        this.customClassPaths = (Map)in.readObject();
        this.classLoaderFactory = (JobClassLoaderFactory)in.readObject();
        this.initialSnapshotName = in.readString();
        this.enableMetrics = in.readBoolean();
        this.storeMetricsAfterJobCompletion = in.readBoolean();
        this.maxProcessorAccumulatedRecords = in.readLong();
        this.timeoutMillis = in.readLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobConfig jobConfig = (JobConfig)o;
        return this.snapshotIntervalMillis == jobConfig.snapshotIntervalMillis && this.autoScaling == jobConfig.autoScaling && this.suspendOnFailure == jobConfig.suspendOnFailure && this.splitBrainProtectionEnabled == jobConfig.splitBrainProtectionEnabled && this.enableMetrics == jobConfig.enableMetrics && this.storeMetricsAfterJobCompletion == jobConfig.storeMetricsAfterJobCompletion && Objects.equals(this.name, jobConfig.name) && this.processingGuarantee == jobConfig.processingGuarantee && Objects.equals(this.resourceConfigs, jobConfig.resourceConfigs) && Objects.equals(this.customClassPaths, jobConfig.customClassPaths) && Objects.equals(this.serializerConfigs, jobConfig.serializerConfigs) && Objects.equals(this.arguments, jobConfig.arguments) && Objects.equals(this.classLoaderFactory, jobConfig.classLoaderFactory) && Objects.equals(this.initialSnapshotName, jobConfig.initialSnapshotName) && this.maxProcessorAccumulatedRecords == jobConfig.maxProcessorAccumulatedRecords && this.timeoutMillis == jobConfig.timeoutMillis;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.processingGuarantee, this.snapshotIntervalMillis, this.autoScaling, this.suspendOnFailure, this.splitBrainProtectionEnabled, this.enableMetrics, this.storeMetricsAfterJobCompletion, this.resourceConfigs, this.customClassPaths, this.serializerConfigs, this.arguments, this.classLoaderFactory, this.initialSnapshotName, this.maxProcessorAccumulatedRecords, this.timeoutMillis});
    }

    public String toString() {
        return "JobConfig {name=" + this.name + ", processingGuarantee=" + (Object)((Object)this.processingGuarantee) + ", snapshotIntervalMillis=" + this.snapshotIntervalMillis + ", autoScaling=" + this.autoScaling + ", suspendOnFailure=" + this.suspendOnFailure + ", splitBrainProtectionEnabled=" + this.splitBrainProtectionEnabled + ", enableMetrics=" + this.enableMetrics + ", storeMetricsAfterJobCompletion=" + this.storeMetricsAfterJobCompletion + ", resourceConfigs=" + this.resourceConfigs + ", serializerConfigs=" + this.serializerConfigs + ", arguments=" + this.arguments + ", classLoaderFactory=" + this.classLoaderFactory + ", initialSnapshotName=" + this.initialSnapshotName + ", maxProcessorAccumulatedRecords=" + this.maxProcessorAccumulatedRecords + ", timeoutMillis=" + this.timeoutMillis + "}";
    }

    private void throwIfLocked() {
        if (this.locked) {
            throw new IllegalStateException("JobConfig is already locked");
        }
    }

    @PrivateApi
    public void lock() {
        this.locked = true;
    }
}

