/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.util;

import com.hazelcast.internal.tpcengine.util.BitUtil;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import java.util.Queue;

public final class CircularQueue<E> {
    private long head;
    private long tail = -1L;
    private final E[] array;
    private final int mask;
    private final int capacity;

    public CircularQueue(int capacity) {
        int fixedCapacity;
        this.capacity = fixedCapacity = BitUtil.nextPowerOfTwo(Preconditions.checkPositive(capacity, "capacity"));
        this.array = new Object[fixedCapacity];
        this.mask = fixedCapacity - 1;
    }

    public boolean isFull() {
        return this.tail - this.head + 1L == (long)this.capacity;
    }

    public int remaining() {
        return this.capacity - this.size();
    }

    public int capacity() {
        return this.capacity;
    }

    public int size() {
        return (int)(this.tail - this.head + 1L);
    }

    public boolean isEmpty() {
        return this.tail < this.head;
    }

    public void add(E item) {
        if (!this.offer(item)) {
            throw new IllegalStateException("CircularQueue is full");
        }
    }

    public int drainFrom(Queue<E> src) {
        E item;
        int remaining = this.remaining();
        int count = 0;
        for (int k = 0; k < remaining && (item = src.poll()) != null; ++k) {
            ++count;
            long t = this.tail + 1L;
            int index = (int)(t & (long)this.mask);
            this.array[index] = item;
            this.tail = t;
        }
        return count;
    }

    public E peek() {
        if (this.tail < this.head) {
            return null;
        }
        long h = this.head;
        int index = (int)(h & (long)this.mask);
        return this.array[index];
    }

    public boolean offer(E item) {
        Preconditions.checkNotNull(item, "item");
        if (this.tail - this.head + 1L == (long)this.capacity) {
            return false;
        }
        long t = this.tail + 1L;
        int index = (int)(t & (long)this.mask);
        this.array[index] = item;
        this.tail = t;
        return true;
    }

    public E poll() {
        if (this.tail < this.head) {
            return null;
        }
        long h = this.head;
        int index = (int)(h & (long)this.mask);
        E item = this.array[index];
        this.array[index] = null;
        this.head = h + 1L;
        return item;
    }
}

