/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.config.MerkleTreeConfig;

public final class MerkleTreeConfigCodec {
    private static final int ENABLED_FIELD_OFFSET = 0;
    private static final int DEPTH_FIELD_OFFSET = 1;
    private static final int ENABLED_SET_FIELD_OFFSET = 5;
    private static final int INITIAL_FRAME_SIZE = 6;

    private MerkleTreeConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, MerkleTreeConfig merkleTreeConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[6]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, merkleTreeConfig.isEnabled());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 1, merkleTreeConfig.getDepth());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 5, merkleTreeConfig.isEnabledSet());
        clientMessage.add(initialFrame);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static MerkleTreeConfig decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        boolean enabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        int depth = FixedSizeTypesCodec.decodeInt(initialFrame.content, 1);
        boolean isEnabledSetExists = false;
        boolean enabledSet = false;
        if (initialFrame.content.length >= 6) {
            enabledSet = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 5);
            isEnabledSetExists = true;
        }
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createMerkleTreeConfig(enabled, depth, isEnabledSetExists, enabledSet);
    }
}

