/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.DataPersistenceConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.EventJournalConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.EvictionConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.HotRestartConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.ListenerConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MergePolicyConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MerkleTreeConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.WanReplicationRefCodec;
import com.hazelcast.client.impl.protocol.codec.holder.CacheConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.EvictionConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import com.hazelcast.config.DataPersistenceConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.internal.serialization.Data;
import java.util.List;

public final class CacheConfigHolderCodec {
    private static final int BACKUP_COUNT_FIELD_OFFSET = 0;
    private static final int ASYNC_BACKUP_COUNT_FIELD_OFFSET = 4;
    private static final int READ_THROUGH_FIELD_OFFSET = 8;
    private static final int WRITE_THROUGH_FIELD_OFFSET = 9;
    private static final int STORE_BY_VALUE_FIELD_OFFSET = 10;
    private static final int MANAGEMENT_ENABLED_FIELD_OFFSET = 11;
    private static final int STATISTICS_ENABLED_FIELD_OFFSET = 12;
    private static final int DISABLE_PER_ENTRY_INVALIDATION_EVENTS_FIELD_OFFSET = 13;
    private static final int INITIAL_FRAME_SIZE = 14;

    private CacheConfigHolderCodec() {
    }

    public static void encode(ClientMessage clientMessage, CacheConfigHolder cacheConfigHolder) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[14]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, cacheConfigHolder.getBackupCount());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 4, cacheConfigHolder.getAsyncBackupCount());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 8, cacheConfigHolder.isReadThrough());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 9, cacheConfigHolder.isWriteThrough());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 10, cacheConfigHolder.isStoreByValue());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 11, cacheConfigHolder.isManagementEnabled());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 12, cacheConfigHolder.isStatisticsEnabled());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 13, cacheConfigHolder.isDisablePerEntryInvalidationEvents());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, cacheConfigHolder.getName());
        CodecUtil.encodeNullable(clientMessage, cacheConfigHolder.getManagerPrefix(), StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, cacheConfigHolder.getUriString(), StringCodec::encode);
        StringCodec.encode(clientMessage, cacheConfigHolder.getInMemoryFormat());
        EvictionConfigHolderCodec.encode(clientMessage, cacheConfigHolder.getEvictionConfigHolder());
        CodecUtil.encodeNullable(clientMessage, cacheConfigHolder.getWanReplicationRef(), WanReplicationRefCodec::encode);
        StringCodec.encode(clientMessage, cacheConfigHolder.getKeyClassName());
        StringCodec.encode(clientMessage, cacheConfigHolder.getValueClassName());
        CodecUtil.encodeNullable(clientMessage, cacheConfigHolder.getCacheLoaderFactory(), DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, cacheConfigHolder.getCacheWriterFactory(), DataCodec::encode);
        DataCodec.encode(clientMessage, cacheConfigHolder.getExpiryPolicyFactory());
        CodecUtil.encodeNullable(clientMessage, cacheConfigHolder.getHotRestartConfig(), HotRestartConfigCodec::encode);
        CodecUtil.encodeNullable(clientMessage, cacheConfigHolder.getEventJournalConfig(), EventJournalConfigCodec::encode);
        CodecUtil.encodeNullable(clientMessage, cacheConfigHolder.getSplitBrainProtectionName(), StringCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, cacheConfigHolder.getListenerConfigurations(), DataCodec::encode);
        MergePolicyConfigCodec.encode(clientMessage, cacheConfigHolder.getMergePolicyConfig());
        ListMultiFrameCodec.encodeNullable(clientMessage, cacheConfigHolder.getCachePartitionLostListenerConfigs(), ListenerConfigHolderCodec::encode);
        CodecUtil.encodeNullable(clientMessage, cacheConfigHolder.getMerkleTreeConfig(), MerkleTreeConfigCodec::encode);
        DataPersistenceConfigCodec.encode(clientMessage, cacheConfigHolder.getDataPersistenceConfig());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static CacheConfigHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int backupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        int asyncBackupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 4);
        boolean readThrough = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 8);
        boolean writeThrough = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 9);
        boolean storeByValue = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 10);
        boolean managementEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 11);
        boolean statisticsEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 12);
        boolean disablePerEntryInvalidationEvents = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 13);
        String name = StringCodec.decode(iterator);
        String managerPrefix = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        String uriString = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        String inMemoryFormat = StringCodec.decode(iterator);
        EvictionConfigHolder evictionConfigHolder = EvictionConfigHolderCodec.decode(iterator);
        WanReplicationRef wanReplicationRef = CodecUtil.decodeNullable(iterator, WanReplicationRefCodec::decode);
        String keyClassName = StringCodec.decode(iterator);
        String valueClassName = StringCodec.decode(iterator);
        Data cacheLoaderFactory = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        Data cacheWriterFactory = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        Data expiryPolicyFactory = DataCodec.decode(iterator);
        HotRestartConfig hotRestartConfig = CodecUtil.decodeNullable(iterator, HotRestartConfigCodec::decode);
        EventJournalConfig eventJournalConfig = CodecUtil.decodeNullable(iterator, EventJournalConfigCodec::decode);
        String splitBrainProtectionName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        List<Data> listenerConfigurations = ListMultiFrameCodec.decodeNullable(iterator, DataCodec::decode);
        MergePolicyConfig mergePolicyConfig = MergePolicyConfigCodec.decode(iterator);
        List<ListenerConfigHolder> cachePartitionLostListenerConfigs = ListMultiFrameCodec.decodeNullable(iterator, ListenerConfigHolderCodec::decode);
        boolean isMerkleTreeConfigExists = false;
        MerkleTreeConfig merkleTreeConfig = null;
        if (!iterator.peekNext().isEndFrame()) {
            merkleTreeConfig = CodecUtil.decodeNullable(iterator, MerkleTreeConfigCodec::decode);
            isMerkleTreeConfigExists = true;
        }
        boolean isDataPersistenceConfigExists = false;
        DataPersistenceConfig dataPersistenceConfig = null;
        if (!iterator.peekNext().isEndFrame()) {
            dataPersistenceConfig = DataPersistenceConfigCodec.decode(iterator);
            isDataPersistenceConfigExists = true;
        }
        CodecUtil.fastForwardToEndFrame(iterator);
        return new CacheConfigHolder(name, managerPrefix, uriString, backupCount, asyncBackupCount, inMemoryFormat, evictionConfigHolder, wanReplicationRef, keyClassName, valueClassName, cacheLoaderFactory, cacheWriterFactory, expiryPolicyFactory, readThrough, writeThrough, storeByValue, managementEnabled, statisticsEnabled, hotRestartConfig, eventJournalConfig, splitBrainProtectionName, listenerConfigurations, mergePolicyConfig, disablePerEntryInvalidationEvents, cachePartitionLostListenerConfigs, isMerkleTreeConfigExists, merkleTreeConfig, isDataPersistenceConfigExists, dataPersistenceConfig);
    }
}

