/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.operation.AsyncJobOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class GetJobSubmissionTimeOperation
extends AsyncJobOperation
implements AllowedDuringPassiveState {
    private boolean isLightJob;

    public GetJobSubmissionTimeOperation() {
    }

    public GetJobSubmissionTimeOperation(long jobId, boolean isLightJob) {
        super(jobId);
        this.isLightJob = isLightJob;
    }

    public CompletableFuture<Long> doRun() {
        return this.getJobCoordinationService().getJobSubmissionTime(this.jobId(), this.isLightJob);
    }

    @Override
    public int getClassId() {
        return 20;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.isLightJob);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.isLightJob = in.readBoolean();
    }
}

