/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.BiPredicateEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperation2;
import com.hazelcast.jet.aggregate.AggregateOperation3;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.impl.JetEvent;
import com.hazelcast.jet.impl.pipeline.FunctionAdapter;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.JoinClause;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

class JetEventFunctionAdapter
extends FunctionAdapter {
    JetEventFunctionAdapter() {
    }

    @Nonnull
    public <T, K> FunctionEx<? super JetEvent<T>, ? extends K> adaptKeyFn(@Nonnull FunctionEx<? super T, ? extends K> keyFn) {
        return e -> keyFn.apply((Object)e.payload());
    }

    @Nonnull
    <T> ToLongFunctionEx<? super JetEvent<T>> adaptTimestampFn() {
        return JetEvent::timestamp;
    }

    @Nonnull
    <T, R> FunctionEx<? super JetEvent<T>, ?> adaptMapFn(@Nonnull FunctionEx<? super T, ? extends R> mapFn) {
        return e -> JetEvent.jetEvent(e.timestamp(), mapFn.apply((Object)e.payload()));
    }

    @Nonnull
    <T> PredicateEx<? super JetEvent<T>> adaptFilterFn(@Nonnull PredicateEx<? super T> filterFn) {
        return e -> filterFn.test((Object)e.payload());
    }

    @Nonnull
    <T, R> FunctionEx<? super JetEvent<T>, ? extends Traverser<JetEvent<R>>> adaptFlatMapFn(@Nonnull FunctionEx<? super T, ? extends Traverser<R>> flatMapFn) {
        return e -> ((Traverser)flatMapFn.apply((Object)e.payload())).map(r -> JetEvent.jetEvent(e.timestamp(), r));
    }

    @Nonnull
    <S, K, T, R> TriFunction<? super S, ? super K, ? super JetEvent<T>, ? extends JetEvent<R>> adaptStatefulMapFn(@Nonnull TriFunction<? super S, ? super K, ? super T, ? extends R> mapFn) {
        return (state, key, e) -> JetEvent.jetEvent(e.timestamp(), mapFn.apply((Object)state, (Object)key, (Object)e.payload()));
    }

    @Nonnull
    <S, K, R> TriFunction<? super S, ? super K, ? super Long, ? extends JetEvent<R>> adaptOnEvictFn(@Nonnull TriFunction<? super S, ? super K, ? super Long, ? extends R> onEvictFn) {
        return (s, k, wm) -> JetEvent.jetEvent(wm, onEvictFn.apply((Object)s, (Object)k, (Long)wm));
    }

    @Nonnull
    <S, K, T, R> TriFunction<? super S, ? super K, ? super JetEvent<T>, ? extends Traverser<JetEvent<R>>> adaptStatefulFlatMapFn(@Nonnull TriFunction<? super S, ? super K, ? super T, ? extends Traverser<R>> flatMapFn) {
        return (state, key, e) -> ((Traverser)flatMapFn.apply((Object)state, (Object)key, (Object)e.payload())).map(r -> JetEvent.jetEvent(e.timestamp(), r));
    }

    @Nonnull
    <S, K, R> TriFunction<? super S, ? super K, ? super Long, ? extends Traverser<JetEvent<R>>> adaptOnEvictFlatMapFn(@Nonnull TriFunction<? super S, ? super K, ? super Long, ? extends Traverser<R>> onEvictFn) {
        return (s, k, wm) -> ((Traverser)onEvictFn.apply((Object)s, (Object)k, (Long)wm)).map(r -> JetEvent.jetEvent(wm, r));
    }

    @Nonnull
    <S, T, R> BiFunctionEx<? super S, ? super JetEvent<T>, ? extends JetEvent<R>> adaptMapUsingServiceFn(@Nonnull BiFunctionEx<? super S, ? super T, ? extends R> mapFn) {
        return (s, e) -> JetEvent.jetEvent(e.timestamp(), mapFn.apply((Object)s, (Object)e.payload()));
    }

    @Nonnull
    <S, T> BiPredicateEx<? super S, ? super JetEvent<T>> adaptFilterUsingServiceFn(@Nonnull BiPredicateEx<? super S, ? super T> filterFn) {
        return (s, e) -> filterFn.test((Object)s, (Object)e.payload());
    }

    @Nonnull
    <S, T, R> BiFunctionEx<? super S, ? super JetEvent<T>, ? extends Traverser<JetEvent<R>>> adaptFlatMapUsingServiceFn(@Nonnull BiFunctionEx<? super S, ? super T, ? extends Traverser<R>> flatMapFn) {
        return (s, e) -> ((Traverser)flatMapFn.apply((Object)s, (Object)e.payload())).map(r -> JetEvent.jetEvent(e.timestamp(), r));
    }

    @Override
    @Nonnull
    <S, T, R> BiFunctionEx<? super S, ?, ? extends CompletableFuture<Traverser<?>>> adaptFlatMapUsingServiceAsyncFn(@Nonnull BiFunctionEx<? super S, ? super T, ? extends CompletableFuture<Traverser<R>>> flatMapAsyncFn) {
        return (s, e) -> ((CompletableFuture)flatMapAsyncFn.apply((Object)s, (Object)e.payload())).thenApply(trav -> trav.map(re -> JetEvent.jetEvent(e.timestamp(), re)));
    }

    @Override
    @Nonnull
    <S, T, R> BiFunctionEx<? super S, ? super List<?>, ? extends CompletableFuture<List<Traverser<?>>>> adaptFlatMapUsingServiceAsyncBatchedFn(@Nonnull BiFunctionEx<? super S, ? super List<T>, ? extends CompletableFuture<List<Traverser<R>>>> flatMapAsyncBatchedFn) {
        BiFunctionEx<Object, List, CompletableFuture> fn = (s, input) -> ((CompletableFuture)flatMapAsyncBatchedFn.apply((Object)s, (Object)Util.toList(input, JetEvent::payload))).thenApply(travList -> {
            List output = travList;
            JetEventFunctionAdapter.requireSizeMatch(output, input);
            for (int i = 0; i < output.size(); ++i) {
                long timestamp = ((JetEvent)input.get(i)).timestamp();
                output.set(i, ((Traverser)output.get(i)).map(r -> JetEvent.jetEvent(timestamp, r)));
            }
            return output;
        });
        return fn;
    }

    @Nonnull
    <T, STR extends CharSequence> FunctionEx<? super JetEvent<T>, ? extends STR> adaptToStringFn(@Nonnull FunctionEx<? super T, ? extends STR> toStringFn) {
        return e -> (CharSequence)toStringFn.apply((Object)e.payload());
    }

    @Nonnull
    public <K, T0, T1, T1_OUT> JoinClause<? extends K, ? super JetEvent<T0>, ? super T1, ? extends T1_OUT> adaptJoinClause(@Nonnull JoinClause<? extends K, ? super T0, ? super T1, ? extends T1_OUT> joinClause) {
        return JoinClause.onKeys(this.adaptKeyFn(joinClause.leftKeyFn()), joinClause.rightKeyFn()).projecting(joinClause.rightProjectFn());
    }

    @Nonnull
    public <T, T1, R> BiFunctionEx<? super JetEvent<T>, ? super T1, ?> adaptHashJoinOutputFn(@Nonnull BiFunctionEx<? super T, ? super T1, ? extends R> mapToOutputFn) {
        return (e, t1) -> JetEvent.jetEvent(e.timestamp(), mapToOutputFn.apply((Object)e.payload(), (Object)t1));
    }

    @Nonnull
    <T, T1, T2, R> TriFunction<? super JetEvent<T>, ? super T1, ? super T2, ?> adaptHashJoinOutputFn(@Nonnull TriFunction<? super T, ? super T1, ? super T2, ? extends R> mapToOutputFn) {
        return (e, t1, t2) -> JetEvent.jetEvent(e.timestamp(), mapToOutputFn.apply((Object)e.payload(), (Object)t1, (Object)t2));
    }

    @Override
    @Nonnull
    <A, R> AggregateOperation<A, ? extends R> adaptAggregateOperation(@Nonnull AggregateOperation<A, ? extends R> aggrOp) {
        if (aggrOp instanceof AggregateOperation1) {
            return this.adaptAggregateOperation1((AggregateOperation1)aggrOp);
        }
        if (aggrOp instanceof AggregateOperation2) {
            return JetEventFunctionAdapter.adaptAggregateOperation2((AggregateOperation2)aggrOp);
        }
        if (aggrOp instanceof AggregateOperation3) {
            return JetEventFunctionAdapter.adaptAggregateOperation3((AggregateOperation3)aggrOp);
        }
        BiConsumerEx[] adaptedAccFns = new BiConsumerEx[aggrOp.arity()];
        Arrays.setAll(adaptedAccFns, i -> JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn(i)));
        return aggrOp.withAccumulateFns(adaptedAccFns);
    }

    @Nonnull
    <T, A, R> AggregateOperation1<? super JetEvent<T>, A, ? extends R> adaptAggregateOperation1(@Nonnull AggregateOperation1<? super T, A, ? extends R> aggrOp) {
        return aggrOp.withAccumulateFn(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn()));
    }

    @Nonnull
    static <T0, T1, A, R> AggregateOperation2<? super JetEvent<T0>, ? super JetEvent<T1>, A, ? extends R> adaptAggregateOperation2(@Nonnull AggregateOperation2<? super T0, ? super T1, A, ? extends R> aggrOp) {
        return aggrOp.withAccumulateFn0(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn0())).withAccumulateFn1(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn1()));
    }

    @Nonnull
    static <T0, T1, T2, A, R> AggregateOperation3<? super JetEvent<T0>, ? super JetEvent<T1>, ? super JetEvent<T2>, A, ? extends R> adaptAggregateOperation3(@Nonnull AggregateOperation3<? super T0, ? super T1, ? super T2, A, ? extends R> aggrOp) {
        return aggrOp.withAccumulateFn0(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn0())).withAccumulateFn1(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn1())).withAccumulateFn2(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn2()));
    }

    @Nonnull
    private static <A, T> BiConsumerEx<? super A, ? super JetEvent<T>> adaptAccumulateFn(@Nonnull BiConsumerEx<? super A, ? super T> accumulateFn) {
        return (acc, t) -> accumulateFn.accept((Object)acc, (Object)t.payload());
    }
}

