/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.partition.ChunkSupplier;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.NonFragmentedServiceNamespace;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionReplicaVersionManager;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.partition.ReplicaErrorLogger;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.MigrationManager;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.operation.AbstractPartitionOperation;
import com.hazelcast.internal.partition.operation.PartitionReplicaSyncResponse;
import com.hazelcast.internal.partition.operation.PartitionReplicaSyncRetryResponse;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class PartitionReplicaSyncRequest
extends AbstractPartitionOperation
implements PartitionAwareOperation,
MigrationCycleOperation {
    protected volatile Collection<ServiceNamespace> namespaces;

    public PartitionReplicaSyncRequest() {
        this.namespaces = Collections.emptyList();
    }

    public PartitionReplicaSyncRequest(Collection<ServiceNamespace> namespaces, int partitionId, int replicaIndex) {
        this.namespaces = namespaces;
        this.setPartitionId(partitionId);
        this.setReplicaIndex(replicaIndex);
    }

    @Override
    public void beforeRun() {
        int syncReplicaIndex = this.getReplicaIndex();
        if (syncReplicaIndex < 1 || syncReplicaIndex > 6) {
            throw new IllegalArgumentException("Replica index " + syncReplicaIndex + " should be in the range [1-" + 6 + "]");
        }
    }

    @Override
    public void run() {
        Integer permits = this.getPermits();
        if (permits == null) {
            return;
        }
        this.sendOperationsForNamespaces(permits);
        if (!this.namespaces.isEmpty()) {
            this.logNotEnoughPermits();
            this.sendRetryResponse();
        }
    }

    protected int partitionId() {
        return this.getPartitionId();
    }

    @Nullable
    protected Integer getPermits() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        if (!partitionService.areMigrationTasksAllowed()) {
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("Migration is paused! Cannot process request. partitionId=" + this.partitionId() + ", replicaIndex=" + this.getReplicaIndex() + ", namespaces=" + this.namespaces);
            }
            this.sendRetryResponse();
            return null;
        }
        if (!this.checkPartitionOwner()) {
            this.sendRetryResponse();
            return null;
        }
        int permits = partitionService.getReplicaManager().tryAcquireReplicaSyncPermits(this.namespaces.size());
        if (permits == 0) {
            this.logNotEnoughPermits();
            this.sendRetryResponse();
            return null;
        }
        return permits;
    }

    protected void logNotEnoughPermits() {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Not enough permits available! Cannot process request. partitionId=" + this.partitionId() + ", replicaIndex=" + this.getReplicaIndex() + ", namespaces=" + this.namespaces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendOperationsForNamespaces(int permits) {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        try {
            PartitionReplicationEvent event = new PartitionReplicationEvent(this.getCallerAddress(), this.partitionId(), this.getReplicaIndex());
            Iterator<ServiceNamespace> iterator = this.namespaces.iterator();
            for (int i = 0; i < permits; ++i) {
                ServiceNamespace namespace = iterator.next();
                List<Operation> operations = Collections.emptyList();
                List<ChunkSupplier> chunkSuppliers = Collections.emptyList();
                if (NonFragmentedServiceNamespace.INSTANCE.equals(namespace)) {
                    operations = this.createNonFragmentedReplicationOperations(event);
                } else {
                    Collection<ChunkSupplier> collection = chunkSuppliers = this.isChunkedMigrationEnabled() ? this.collectChunkSuppliers(event, namespace) : chunkSuppliers;
                    if (CollectionUtil.isEmpty(chunkSuppliers)) {
                        operations = this.createFragmentReplicationOperations(event, namespace);
                    }
                }
                this.sendOperations(operations, chunkSuppliers, namespace);
                while (this.hasRemainingChunksToSend(chunkSuppliers)) {
                    this.sendOperations(operations, chunkSuppliers, namespace);
                }
                iterator.remove();
            }
        }
        finally {
            partitionService.getReplicaManager().releaseReplicaSyncPermits(permits);
        }
    }

    protected boolean hasRemainingChunksToSend(Collection<ChunkSupplier> chunkSuppliers) {
        if (!this.isChunkedMigrationEnabled()) {
            return false;
        }
        Iterator<ChunkSupplier> iterator = chunkSuppliers.iterator();
        while (iterator.hasNext()) {
            ChunkSupplier chunkSupplier = iterator.next();
            if (chunkSupplier.hasNext()) {
                return true;
            }
            iterator.remove();
        }
        return false;
    }

    protected void sendOperations(Collection<Operation> operations, Collection<ChunkSupplier> chunkSuppliers, ServiceNamespace ns) {
        if (CollectionUtil.isEmpty(operations) && CollectionUtil.isEmpty(chunkSuppliers)) {
            this.logNoReplicaDataFound(this.partitionId(), ns, this.getReplicaIndex());
            this.sendResponse(null, null, ns);
        } else {
            this.sendResponse(operations, chunkSuppliers, ns);
        }
    }

    protected boolean checkPartitionOwner() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        PartitionStateManager partitionStateManager = partitionService.getPartitionStateManager();
        InternalPartitionImpl partition = partitionStateManager.getPartitionImpl(this.partitionId());
        PartitionReplica owner = partition.getOwnerReplicaOrNull();
        NodeEngine nodeEngine = this.getNodeEngine();
        if (owner == null || !owner.isIdentical(nodeEngine.getLocalMember())) {
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("This node is not owner partition. Cannot process request. partitionId=" + this.partitionId() + ", replicaIndex=" + this.getReplicaIndex() + ", namespaces=" + this.namespaces);
            }
            return false;
        }
        return true;
    }

    protected void sendRetryResponse() {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = this.partitionId();
        int replicaIndex = this.getReplicaIndex();
        PartitionReplicaSyncRetryResponse response = new PartitionReplicaSyncRetryResponse(this.namespaces);
        response.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        Address target = this.getCallerAddress();
        OperationService operationService = nodeEngine.getOperationService();
        operationService.send(response, target);
    }

    private void sendResponse(Collection<Operation> operations, Collection<ChunkSupplier> chunkSuppliers, ServiceNamespace ns) {
        NodeEngine nodeEngine = this.getNodeEngine();
        PartitionReplicaSyncResponse syncResponse = this.createResponse(operations, chunkSuppliers, ns);
        Address target = this.getCallerAddress();
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Sending sync response to -> " + target + " for partitionId=" + this.partitionId() + ", replicaIndex=" + this.getReplicaIndex() + ", namespaces=" + ns);
        }
        syncResponse.setTarget(target);
        OperationService operationService = nodeEngine.getOperationService();
        operationService.send(syncResponse, target);
    }

    protected PartitionReplicaSyncResponse createResponse(Collection<Operation> operations, Collection<ChunkSupplier> chunkSuppliers, ServiceNamespace ns) {
        int partitionId = this.partitionId();
        int replicaIndex = this.getReplicaIndex();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        PartitionReplicaVersionManager versionManager = partitionService.getPartitionReplicaVersionManager();
        long[] versions = versionManager.getPartitionReplicaVersionsForSync(partitionId, ns);
        PartitionReplicaSyncResponse syncResponse = new PartitionReplicaSyncResponse(operations, chunkSuppliers, ns, versions, this.isChunkedMigrationEnabled(), this.getMaxTotalChunkedDataInBytes(), this.getLogger(), partitionId);
        syncResponse.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        return syncResponse;
    }

    protected final boolean isChunkedMigrationEnabled() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        return partitionService.getMigrationManager().isChunkedMigrationEnabled();
    }

    protected final int getMaxTotalChunkedDataInBytes() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        MigrationManager migrationManager = partitionService.getMigrationManager();
        return migrationManager.getMaxTotalChunkedDataInBytes();
    }

    private void logNoReplicaDataFound(int partitionId, ServiceNamespace namespace, int replicaIndex) {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("No replica data is found for partitionId=" + partitionId + ", replicaIndex=" + replicaIndex + ", namespace= " + namespace);
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        SerializationUtil.writeCollection(this.namespaces, out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.namespaces = SerializationUtil.readCollection(in);
    }

    @Override
    public int getClassId() {
        return 9;
    }
}

