/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.internal.services.SplitBrainProtectionAwareService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MapSplitBrainProtectionAwareService
implements SplitBrainProtectionAwareService {
    private static final Object NULL_OBJECT = new Object();
    private final MapServiceContext mapServiceContext;
    private final ConcurrentMap<String, Object> splitBrainProtectionConfigCache = new ConcurrentHashMap<String, Object>();
    private final ContextMutexFactory splitBrainProtectionConfigCacheMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, Object> splitBrainProtectionConfigConstructor = new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            MapContainer mapContainer = MapSplitBrainProtectionAwareService.this.mapServiceContext.getMapContainer(name);
            String splitBrainProtectionName = mapContainer.getSplitBrainProtectionName();
            return splitBrainProtectionName == null ? NULL_OBJECT : splitBrainProtectionName;
        }
    };

    public MapSplitBrainProtectionAwareService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
    }

    @Override
    public String getSplitBrainProtectionName(String name) {
        Object splitBrainProtectionName = ConcurrencyUtil.getOrPutSynchronized(this.splitBrainProtectionConfigCache, name, this.splitBrainProtectionConfigCacheMutexFactory, this.splitBrainProtectionConfigConstructor);
        return splitBrainProtectionName == NULL_OBJECT ? null : (String)splitBrainProtectionName;
    }

    public void onDestroy(String name) {
        this.splitBrainProtectionConfigCache.remove(name);
    }
}

