/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.json.JsonEscape;
import com.hazelcast.internal.serialization.impl.FieldOperations;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.nio.serialization.FieldKind;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class AbstractGenericRecord
implements InternalGenericRecord {
    protected abstract Object getClassIdentifier();

    public boolean equals(Object o) {
        Set<String> thisFieldNames;
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractGenericRecord)) {
            return false;
        }
        AbstractGenericRecord that = (AbstractGenericRecord)o;
        if (!that.getClassIdentifier().equals(this.getClassIdentifier())) {
            return false;
        }
        Set<String> thatFieldNames = that.getFieldNames();
        if (!Objects.equals(thatFieldNames, thisFieldNames = this.getFieldNames())) {
            return false;
        }
        for (String fieldName : thatFieldNames) {
            FieldKind thisKind;
            FieldKind thatKind = that.getFieldKind(fieldName);
            if (thatKind != (thisKind = this.getFieldKind(fieldName))) {
                return false;
            }
            if (!(FieldOperations.isArrayKind(thatKind) ? !Objects.deepEquals(this.readAny(fieldName), that.readAny(fieldName)) : !Objects.equals(this.readAny(fieldName), that.readAny(fieldName)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Objects.hash(this.getClassIdentifier());
        Set<String> thisFieldNames = this.getFieldNames();
        for (String fieldName : thisFieldNames) {
            FieldKind fieldKind = this.getFieldKind(fieldName);
            result = 31 * result + FieldOperations.fieldOperations(fieldKind).hashCode(this, fieldName);
        }
        return result;
    }

    public final <T> T readAny(@Nonnull String fieldName) {
        FieldKind kind = this.getFieldKind(fieldName);
        return (T)FieldOperations.fieldOperations(kind).readGenericRecordOrPrimitive(this, fieldName);
    }

    protected void writeFieldsToStringBuilder(StringBuilder stringBuilder) {
        Set<String> fieldNames = this.getFieldNames();
        stringBuilder.append("{");
        int size = fieldNames.size();
        int i = 0;
        for (String fieldName : fieldNames) {
            ++i;
            JsonEscape.writeEscaped(stringBuilder, fieldName);
            stringBuilder.append(": ");
            FieldKind fieldKind = this.getFieldKind(fieldName);
            FieldOperations.fieldOperations(fieldKind).writeJsonFormattedField(stringBuilder, this, fieldName);
            if (size == i) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
    }
}

