/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.TpcToken;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ExperimentalAuthenticationCodec;
import com.hazelcast.client.impl.protocol.task.AuthenticationBaseMessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.UsernamePasswordCredentials;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;

public class ExperimentalAuthenticationMessageTask
extends AuthenticationBaseMessageTask<ExperimentalAuthenticationCodec.RequestParameters> {
    public ExperimentalAuthenticationMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected ExperimentalAuthenticationCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        ExperimentalAuthenticationCodec.RequestParameters parameters = ExperimentalAuthenticationCodec.decodeRequest(clientMessage);
        assert (parameters.uuid != null);
        this.clientUuid = parameters.uuid;
        this.clusterName = parameters.clusterName;
        this.credentials = new UsernamePasswordCredentials(parameters.username, parameters.password);
        this.clientSerializationVersion = parameters.serializationVersion;
        this.clientVersion = parameters.clientHazelcastVersion;
        this.clientName = parameters.clientName;
        this.labels = Collections.unmodifiableSet(new HashSet<String>(parameters.labels));
        return parameters;
    }

    @Override
    protected void setTpcTokenToEndpoint() {
        if (!this.nodeEngine.getTpcServerBootstrap().isEnabled()) {
            return;
        }
        TpcToken token = new TpcToken();
        this.endpoint.setTpcToken(token);
    }

    @Override
    protected ClientMessage encodeAuth(byte status, Address thisAddress, UUID uuid, byte serializationVersion, String serverVersion, int partitionCount, UUID clusterId, boolean clientFailoverSupported, List<Integer> tpcPorts, byte[] tpcToken) {
        return ExperimentalAuthenticationCodec.encodeResponse(status, thisAddress, uuid, serializationVersion, serverVersion, partitionCount, clusterId, clientFailoverSupported, tpcPorts, tpcToken);
    }

    @Override
    protected String getClientType() {
        return ((ExperimentalAuthenticationCodec.RequestParameters)this.parameters).clientType;
    }
}

