/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.VerticalBox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MAttachmentEntry;
import org.compiere.util.CLogger;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Separator;

public class UPSHtmlLabelWindow
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -3700882367300286247L;
    private List<MAttachmentEntry> images;
    private List<MAttachmentEntry> htmls;
    private Listbox html;
    private Iframe content;
    private static final CLogger log = CLogger.getCLogger(UPSHtmlLabelWindow.class);

    public UPSHtmlLabelWindow(List<MAttachmentEntry> htmls, List<MAttachmentEntry> images) {
        this.htmls = htmls;
        this.images = images;
        this.init();
    }

    private void init() {
        this.setBorder("normal");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "730px");
        VerticalBox box = new VerticalBox();
        this.appendChild((Component)box);
        this.html = ListboxFactory.newDropdownListbox();
        for (MAttachmentEntry entry : this.htmls) {
            this.html.appendItem(entry.getName(), entry);
        }
        this.html.setSelectedIndex(0);
        this.html.addEventListener("onSelect", this);
        box.appendChild((Component)this.html);
        box.appendChild((Component)new Separator());
        this.content = new Iframe();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.content, "500px");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.content, "700px");
        this.content.setId("content");
        this.content.setName(this.content.getUuid());
        box.appendChild((Component)this.content);
        ConfirmPanel panel = new ConfirmPanel(false);
        panel.addActionListener(this);
        Button btn = panel.createButton("Print");
        panel.addButton(btn);
        btn.addEventListener("onClick", this);
        box.appendChild((Component)new Separator());
        box.appendChild((Component)panel);
        try {
            this.loadContent();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void loadContent() throws Exception {
        MAttachmentEntry entry = (MAttachmentEntry)this.html.getSelectedItem().getValue();
        String htmlData = new String(entry.getData());
        String name = entry.getName();
        name = name.substring(0, name.length() - 5);
        String imageName = name + ".gif";
        MAttachmentEntry imageEntry = null;
        for (MAttachmentEntry i : this.images) {
            if (!i.getName().equals(imageName)) continue;
            imageEntry = i;
            break;
        }
        if (imageEntry != null) {
            File tmp = File.createTempFile(name, ".gif");
            Object object = null;
            Object var8_9 = null;
            try (FileOutputStream os = new FileOutputStream(tmp);){
                os.write(imageEntry.getData());
                os.flush();
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
            if (Executions.getCurrent() != null) {
                HttpServletRequest request = (HttpServletRequest)Executions.getCurrent().getNativeRequest();
                String url = request.getContextPath() + "/gif.jsp?f=" + URLEncoder.encode(tmp.getAbsolutePath(), "UTF-8");
                htmlData = htmlData.replace("./" + imageName, url);
            }
        }
        AMedia media = new AMedia(entry.getName(), null, entry.getContentType(), htmlData);
        this.content.setContent((Media)media);
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null && Executions.getCurrent() != null) {
            try {
                this.loadContent();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget().getId().equals("Ok")) {
            this.detach();
        } else if (event.getTarget() == this.html) {
            this.loadContent();
        } else if (event.getTarget().getId().equals("Print")) {
            this.content.focus();
            String script = "frames['" + this.content.getUuid() + "'].contentWindow.print()";
            if (Executions.getCurrent() != null) {
                Clients.response((AuResponse)new AuScript(script));
            }
        }
    }
}

