/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ToolBar;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WYesNoEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.grid.WQuickEntry;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.WGadgets;
import org.compiere.model.MMenu;
import org.compiere.model.MRole;
import org.compiere.model.MUserPreference;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.A;
import org.zkoss.zul.Div;
import org.zkoss.zul.Space;
import org.zkoss.zul.Window;

public class WPreference
extends WQuickEntry
implements EventListener<Event>,
ValueChangeListener {
    private static final long serialVersionUID = 3259434079666571595L;
    private static final CLogger log = CLogger.getCLogger(WPreference.class);
    private static final String LINE_DIV_STYLE = "background-color: transparent !important; border: none; margin: 5px;";
    private WYesNoEditor adempiereSys;
    private WYesNoEditor logMigrationScript;
    private WGadgets gadgets;
    private A addgadgets;
    private A morePreferences;
    private A myProfile;
    private MUserPreference preferences = null;
    private int recordId = 0;

    public WPreference() {
        super(Env.getZoomWindowID((int)200174, (int)0));
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
        }
        Boolean canAccessPreference = MRole.getDefault().getWindowAccess(this.m_AD_Window_ID);
        if (canAccessPreference != null && canAccessPreference.booleanValue()) {
            this.initPOs();
            this.loadPreferences();
            this.moveMigrationScriptComment();
        }
        this.setTitle("");
    }

    private void loadPreferences() {
        this.preferences = MUserPreference.getUserPreference((int)Env.getAD_User_ID((Properties)Env.getCtx()), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        this.recordId = this.preferences.get_ID();
        if (this.getQuickFields() > 0) {
            this.loadRecord(this.recordId);
        }
    }

    protected void jbInit() throws Exception {
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "230px");
        this.setBorder("normal");
        this.setClosable(true);
        this.setSizable(true);
        this.appendChild((Component)this.centerPanel);
        this.init();
    }

    private void init() {
        Boolean access;
        Boolean access2;
        Div div = new Div();
        div.setStyle(LINE_DIV_STYLE);
        this.morePreferences = new A();
        this.morePreferences.setLabel(Msg.translate((Properties)Env.getCtx(), (String)"MorePreferences"));
        this.morePreferences.addEventListener("onClick", (EventListener)this);
        int windowID = Env.getZoomWindowID((int)200174, (int)this.recordId);
        if (windowID > 0 && (access2 = MRole.getDefault().getWindowAccess(windowID)) != null && access2.booleanValue()) {
            div.appendChild((Component)this.morePreferences);
        }
        this.appendChild((Component)div);
        MMenu myProfileMenu = MMenu.get((int)53246);
        div = new Div();
        div.setStyle(LINE_DIV_STYLE);
        this.myProfile = new A();
        this.myProfile.setLabel(myProfileMenu.get_Translation("Name"));
        this.myProfile.addEventListener("onClick", (EventListener)this);
        windowID = MMenu.get((int)53246).getAD_Window_ID();
        if (windowID > 0 && (access = MRole.getDefault().getWindowAccess(windowID)) != null && access.booleanValue()) {
            div.appendChild((Component)this.myProfile);
        }
        this.appendChild((Component)div);
        div = new Div();
        div.setStyle(LINE_DIV_STYLE);
        this.addgadgets = new A();
        this.addgadgets.setLabel(Msg.translate((Properties)Env.getCtx(), (String)"ManageGadgets"));
        this.addgadgets.addEventListener("onClick", (EventListener)this);
        div.appendChild((Component)this.addgadgets);
        this.appendChild((Component)div);
        if (Env.getAD_Client_ID((Properties)Env.getCtx()) <= 20 && Env.getAD_User_ID((Properties)Env.getCtx()) <= 102) {
            this.appendChild((Component)new Space());
            this.adempiereSys = new WYesNoEditor("AdempiereSys", Msg.getMsg((Properties)Env.getCtx(), (String)"AdempiereSys", (boolean)true), null, false, false, true);
            this.adempiereSys.getComponent().setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"AdempiereSys", (boolean)false));
            div = new Div();
            div.setStyle(LINE_DIV_STYLE);
            div.appendChild((Component)this.adempiereSys.getComponent());
            this.appendChild((Component)div);
            this.adempiereSys.setValue(Env.getCtx().getProperty("AdempiereSys"));
            this.adempiereSys.addValueChangeListener(this);
            this.logMigrationScript = new WYesNoEditor("LogMigrationScript", Msg.getMsg((Properties)Env.getCtx(), (String)"LogMigrationScript", (boolean)true), null, false, false, true);
            this.logMigrationScript.getComponent().setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"LogMigrationScript", (boolean)false));
            div = new Div();
            div.setStyle(LINE_DIV_STYLE);
            div.appendChild((Component)this.logMigrationScript.getComponent());
            this.appendChild((Component)div);
            this.logMigrationScript.setValue(Env.getCtx().getProperty("LogMigrationScript"));
            this.logMigrationScript.addValueChangeListener(this);
        }
        ToolBar toolbar = new ToolBar();
        toolbar.setAlign("end");
        this.appendChild((Component)toolbar);
        ToolBarButton btn = new ToolBarButton("");
        btn.setName("btnSave");
        if (ThemeManager.isUseFontIconForImage()) {
            btn.setIconSclass("z-icon-Save");
        } else {
            btn.setImage(ThemeManager.getThemeResource("images/Save24.png"));
        }
        btn.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Save"));
        btn.addEventListener("onClick", this);
        toolbar.appendChild((Component)btn);
        toolbar.setStyle("border: none");
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("large-toolbarbutton", (HtmlBasedComponent)btn);
        }
    }

    private void moveMigrationScriptComment() {
        Component field;
        Component parent;
        if (this.logMigrationScript == null) {
            return;
        }
        WEditor commentEditor = null;
        for (WEditor editor : this.quickEditors) {
            if (!"MigrationScriptComment".equals(editor.getColumnName())) continue;
            commentEditor = editor;
            break;
        }
        if (commentEditor != null && (parent = (field = commentEditor.getComponent()).getParent()) != null) {
            parent.detach();
            Div div = new Div();
            div.setStyle(LINE_DIV_STYLE);
            Label label = commentEditor.getLabel();
            LayoutUtils.removeSclass("field-label", (HtmlBasedComponent)label);
            if (!label.getValue().endsWith(":")) {
                label.setValue(label.getValue() + ":");
            }
            div.appendChild((Component)label);
            this.insertBefore((Component)div, this.logMigrationScript.getComponent().getParent().getNextSibling());
            Component ref = div.getNextSibling();
            div = new Div();
            div.setStyle(LINE_DIV_STYLE);
            div.appendChild(field);
            this.insertBefore((Component)div, ref);
        }
    }

    @Override
    public void onEvent(Event event) throws Exception {
        String nameEvent = event.getName();
        Component com = event.getTarget();
        if ("onClick".equals(nameEvent)) {
            if (com instanceof ToolBarButton) {
                this.onSave();
            }
            if (com == this.addgadgets) {
                this.gadgets = new WGadgets();
                this.gadgets.setClosable(true);
                this.gadgets.setSizable(true);
                if (ClientInfo.maxWidth(699)) {
                    ZKUpdateUtil.setWidth((HtmlBasedComponent)this.gadgets, "90%");
                } else if (ClientInfo.maxWidth(999)) {
                    ZKUpdateUtil.setWidth((HtmlBasedComponent)this.gadgets, "70%");
                } else {
                    ZKUpdateUtil.setWidth((HtmlBasedComponent)this.gadgets, "50%");
                }
                if (ClientInfo.maxHeight(699)) {
                    ZKUpdateUtil.setHeight((HtmlBasedComponent)this.gadgets, "80%");
                } else {
                    ZKUpdateUtil.setHeight((HtmlBasedComponent)this.gadgets, "60%");
                }
                this.gadgets.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"DashboardGadgets"));
                this.gadgets.setAttribute("mode", Window.Mode.HIGHLIGHTED);
                AEnv.showWindow(this.gadgets);
                this.gadgets.focus();
            } else if (com == this.morePreferences) {
                AEnv.zoom(200174, this.recordId);
                this.detach();
            } else if (com == this.myProfile) {
                MMenu myProfileMenu = MMenu.get((int)53246);
                AEnv.zoom(myProfileMenu.getAD_Window_ID(), null);
                this.detach();
            }
        }
    }

    private void onSave() {
        this.actionSave();
        if (this.logMigrationScript != null) {
            Env.getCtx().setProperty("LogMigrationScript", (Boolean)this.logMigrationScript.getValue() != false ? "Y" : "N");
            Env.getCtx().setProperty("P|LogMigrationScript", (Boolean)this.logMigrationScript.getValue() != false ? "Y" : "N");
        }
        if (this.adempiereSys != null) {
            Env.getCtx().setProperty("AdempiereSys", (Boolean)this.adempiereSys.getValue() != false ? "Y" : "N");
            Env.getCtx().setProperty("P|AdempiereSys", (Boolean)this.adempiereSys.getValue() != false ? "Y" : "N");
        }
        this.detach();
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        if (evt.getSource() instanceof WYesNoEditor) {
            if (evt.getSource() == this.logMigrationScript) {
                Env.getCtx().setProperty("LogMigrationScript", (Boolean)this.logMigrationScript.getValue() != false ? "Y" : "N");
                Env.getCtx().setProperty("P|LogMigrationScript", (Boolean)this.logMigrationScript.getValue() != false ? "Y" : "N");
                this.dynamicDisplay();
            } else if (evt.getSource() == this.adempiereSys) {
                Env.getCtx().setProperty("AdempiereSys", (Boolean)this.adempiereSys.getValue() != false ? "Y" : "N");
                Env.getCtx().setProperty("P|AdempiereSys", (Boolean)this.adempiereSys.getValue() != false ? "Y" : "N");
            }
        }
        super.valueChange(evt);
    }
}

