/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.info;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.Borderlayout;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.info.InfoWindow;
import org.adempiere.webui.panel.InfoPAttributeInstancePanel;
import org.adempiere.webui.panel.InvoiceHistory;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.EmbedWinInfo;
import org.compiere.model.GridField;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Center;
import org.zkoss.zul.South;

public class InfoProductWindow
extends InfoWindow {
    private static final long serialVersionUID = -640644572459126094L;
    protected Tabbox tabbedPane;
    protected WListbox warehouseTbl;
    protected String m_sqlWarehouse;
    protected WListbox substituteTbl;
    protected String m_sqlSubstitute;
    protected WListbox relatedTbl;
    protected String m_sqlRelated;
    protected WListbox m_tableAtp;
    protected Checkbox chbShowDetailAtp;
    protected WListbox productpriceTbl;
    protected String m_sqlProductprice;
    protected Textbox fieldDescription;
    protected int m_M_AttributeSetInstance_ID;
    protected Borderlayout contentBorderLayout;
    protected Button m_PAttributeButton;
    protected int m_M_Locator_ID;

    public InfoProductWindow(int WindowNo, String tableName, String keyColumn, String queryValue, boolean multipleSelection, String whereClause, int AD_InfoWindow_ID) {
        this(WindowNo, tableName, keyColumn, queryValue, multipleSelection, whereClause, AD_InfoWindow_ID, true);
    }

    public InfoProductWindow(int WindowNo, String tableName, String keyColumn, String queryValue, boolean multipleSelection, String whereClause, int AD_InfoWindow_ID, boolean lookup) {
        super(WindowNo, tableName, keyColumn, queryValue, multipleSelection, whereClause, AD_InfoWindow_ID, lookup);
    }

    public InfoProductWindow(int WindowNo, String tableName, String keyColumn, String queryValue, boolean multipleSelection, String whereClause, int AD_InfoWindow_ID, boolean lookup, GridField field) {
        super(WindowNo, tableName, keyColumn, queryValue, multipleSelection, whereClause, AD_InfoWindow_ID, lookup, field);
    }

    public InfoProductWindow(int WindowNo, String tableName, String keyColumn, String queryValue, boolean multipleSelection, String whereClause, int AD_InfoWindow_ID, boolean lookup, GridField field, String predefinedContextVariables) {
        super(WindowNo, tableName, keyColumn, queryValue, multipleSelection, whereClause, AD_InfoWindow_ID, lookup, field, predefinedContextVariables);
    }

    @Override
    protected String getSQLWhere() {
        if (!this.isQueryByUser && this.prevWhereClause != null) {
            return this.prevWhereClause;
        }
        StringBuilder where = new StringBuilder(super.getSQLWhere());
        if (this.getSelectedWarehouseId() > 0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("p.IsSummary='N' ");
        }
        this.prevWhereClause = where.toString();
        if (MSysConfig.getBooleanValue((String)"INFO_PRODUCT_SHOW_PRODUCTS_WITHOUT_PRICE", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()))) {
            this.prevWhereClause = this.prevWhereClause.replaceAll("AND pr.M_PriceList_Version_ID = \\?", "AND (pr.M_PriceList_Version_ID=? OR pr.M_PriceList_Version_ID IS NULL)");
        }
        return this.prevWhereClause;
    }

    @Override
    protected void renderWindow() {
        super.renderWindow();
        this.m_PAttributeButton = this.confirmPanel.createButton("PAttribute");
        this.confirmPanel.addComponentsLeft(this.m_PAttributeButton);
        this.m_PAttributeButton.setEnabled(false);
        this.m_PAttributeButton.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                InfoProductWindow.this.onPAttributeClick();
            }
        });
        this.m_PAttributeButton.setVisible(true);
    }

    @Override
    protected void renderContentPane(Center center) {
        ColumnInfo[] s_layoutWarehouse = new ColumnInfo[]{new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Warehouse"), "Warehouse", String.class, true, "Warehouse"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyAvailable"), "sum(QtyAvailable)", Double.class, true, "QtyAvailable"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyOnHand"), "sum(QtyOnHand)", Double.class, true, "QtyOnHand"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyReserved"), "sum(QtyReserved)", Double.class, true, "QtyReserved")};
        String s_sqlFrom = " M_PRODUCT_STOCK_V ";
        String s_sqlWhere = "M_Product_ID = ?";
        this.warehouseTbl = ListboxFactory.newDataTableAutoSize();
        this.m_sqlWarehouse = this.warehouseTbl.prepareTable(s_layoutWarehouse, s_sqlFrom, s_sqlWhere, false, "M_PRODUCT_STOCK_V");
        this.m_sqlWarehouse = String.valueOf(this.m_sqlWarehouse) + " GROUP BY Warehouse";
        this.warehouseTbl.setMultiSelection(false);
        this.warehouseTbl.setShowTotals(true);
        this.warehouseTbl.setwListBoxName("AD_InfoWindow_UU|" + this.infoWindow.getAD_InfoWindow_UU() + "|stock");
        ColumnInfo[] s_layoutSubstitute = new ColumnInfo[]{new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Warehouse"), "orgname", String.class, true, "orgname"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Value"), "(Select Value from M_Product p where p.M_Product_ID=M_PRODUCT_SUBSTITUTERELATED_V.Substitute_ID)", String.class, true, "Value"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Name"), "Name", String.class, true, "Name"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyAvailable"), "QtyAvailable", Double.class, true, "QtyAvailable"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyOnHand"), "QtyOnHand", Double.class, true, "QtyOnHand"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyReserved"), "QtyReserved", Double.class, true, "QtyReserved"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"PriceStd"), "PriceStd", Double.class, true, "PriceStd")};
        s_sqlFrom = "M_PRODUCT_SUBSTITUTERELATED_V";
        s_sqlWhere = "M_Product_ID = ? AND M_PriceList_Version_ID = ? and RowType = 'S'";
        this.substituteTbl = ListboxFactory.newDataTableAutoSize();
        this.m_sqlSubstitute = this.substituteTbl.prepareTable(s_layoutSubstitute, s_sqlFrom, s_sqlWhere, false, "M_PRODUCT_SUBSTITUTERELATED_V");
        this.substituteTbl.setMultiSelection(false);
        this.substituteTbl.setwListBoxName("AD_InfoWindow_UU|" + this.infoWindow.getAD_InfoWindow_UU() + "|substitute");
        ColumnInfo[] s_layoutRelated = new ColumnInfo[]{new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Warehouse"), "orgname", String.class, true, "orgname"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Value"), "(Select Value from M_Product p where p.M_Product_ID=M_PRODUCT_SUBSTITUTERELATED_V.Substitute_ID)", String.class, true, "Value"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Name"), "Name", String.class, true, "Name"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyAvailable"), "QtyAvailable", Double.class, true, "QtyAvailable"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyOnHand"), "QtyOnHand", Double.class, true, "QtyOnHand"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyReserved"), "QtyReserved", Double.class, true, "QtyReserved"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"PriceStd"), "PriceStd", Double.class, true, "PriceStd")};
        s_sqlFrom = "M_PRODUCT_SUBSTITUTERELATED_V";
        s_sqlWhere = "M_Product_ID = ? AND M_PriceList_Version_ID = ? and RowType = 'R'";
        this.relatedTbl = ListboxFactory.newDataTableAutoSize();
        this.m_sqlRelated = this.relatedTbl.prepareTable(s_layoutRelated, s_sqlFrom, s_sqlWhere, false, "M_PRODUCT_SUBSTITUTERELATED_V");
        this.relatedTbl.setMultiSelection(false);
        this.relatedTbl.setwListBoxName("AD_InfoWindow_UU|" + this.infoWindow.getAD_InfoWindow_UU() + "|related");
        ColumnInfo[] s_LayoutAtp = new ColumnInfo[]{new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Date"), "Date", String.class, true, "Date"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyOnHand"), "QtyOnHand", Double.class, true, "QtyOnHand"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"), "C_BPartner_ID", Double.class, true, "C_BPartner_ID"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyOrdered"), "QtyOrdered", Double.class, true, "QtyOrdered"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyReserved"), "QtyReserved", Double.class, true, "QtyReserved"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"M_Locator_ID"), "M_Locator_ID", Double.class, true, "M_Locator_ID"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"M_AttributeSetInstance_ID"), "M_AttributeSetInstance_ID", Double.class, true, "M_AttributeSetInstance_ID"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"), "DocumentNo", Double.class, true, "DocumentNo"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"M_Warehouse_ID"), "M_Warehouse_ID", Double.class, true, "M_Warehouse_ID")};
        this.m_tableAtp = ListboxFactory.newDataTableAutoSize();
        this.m_tableAtp.setMultiSelection(false);
        this.m_tableAtp.prepareTable(s_LayoutAtp, "M_Storage", null, false, "M_Storage");
        this.m_tableAtp.setwListBoxName("AD_InfoWindow_UU|" + this.infoWindow.getAD_InfoWindow_UU() + "|ATP");
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        list.add(new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"PriceListVersion"), "plv.Name", String.class, true, "PriceListVersion"));
        list.add(new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"ValidFrom"), "plv.ValidFrom", Timestamp.class, true, "ValidFrom"));
        if (MRole.getDefault().isColumnAccess(251, 3027, false)) {
            list.add(new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"PriceList"), "bomPriceList(pp.M_Product_ID, pp.M_PriceList_Version_ID) AS PriceList", Double.class, true, "PriceList"));
        }
        if (MRole.getDefault().isColumnAccess(251, 3028, false)) {
            list.add(new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"PriceStd"), "bomPriceStd(pp.M_Product_ID, pp.M_PriceList_Version_ID) AS PriceStd", Double.class, true, "PriceStd"));
        }
        if (MRole.getDefault().isColumnAccess(251, 3028, false) && MRole.getDefault().isColumnAccess(251, 3029, false)) {
            list.add(new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Margin"), "bomPriceStd(pp.M_Product_ID, pp.M_PriceList_Version_ID)-bomPriceLimit(pp.M_Product_ID, pp.M_PriceList_Version_ID) AS Margin", Double.class, true, "Margin"));
        }
        if (MRole.getDefault().isColumnAccess(251, 3029, false)) {
            list.add(new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"PriceLimit"), "bomPriceLimit(pp.M_Product_ID, pp.M_PriceList_Version_ID) AS PriceLimit", Double.class, true, "PriceLimit"));
        }
        ColumnInfo[] s_layoutProductPrice = new ColumnInfo[list.size()];
        list.toArray(s_layoutProductPrice);
        s_sqlFrom = "M_ProductPrice pp INNER JOIN M_PriceList_Version plv ON (pp.M_PriceList_Version_ID = plv.M_PriceList_Version_ID)";
        s_sqlWhere = "pp.M_Product_ID = ? AND plv.IsActive = 'Y' AND pp.IsActive = 'Y'";
        this.productpriceTbl = ListboxFactory.newDataTableAutoSize();
        this.m_sqlProductprice = this.productpriceTbl.prepareTable(s_layoutProductPrice, s_sqlFrom, s_sqlWhere, false, "pp") + " ORDER BY plv.ValidFrom DESC";
        this.productpriceTbl.setMultiSelection(false);
        this.productpriceTbl.setwListBoxName("AD_InfoWindow_UU|" + this.infoWindow.getAD_InfoWindow_UU() + "|price");
        this.tabbedPane = new Tabbox();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.tabbedPane, "100%");
        Tabpanels tabPanels = new Tabpanels();
        this.tabbedPane.appendChild((Component)tabPanels);
        Tabs tabs = new Tabs();
        this.tabbedPane.appendChild((Component)tabs);
        Tab tab = new Tab(Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"WarehouseStock")));
        tabs.appendChild((Component)tab);
        Tabpanel desktopTabPanel = new Tabpanel();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)desktopTabPanel, "100%");
        desktopTabPanel.appendChild((Component)this.warehouseTbl);
        tabPanels.appendChild((Component)desktopTabPanel);
        tab = new Tab(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
        tabs.appendChild((Component)tab);
        desktopTabPanel = new Tabpanel();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)desktopTabPanel, "100%");
        this.fieldDescription = new Textbox();
        this.fieldDescription.setMultiline(true);
        this.fieldDescription.setReadonly(true);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldDescription, "1");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fieldDescription, "99%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.fieldDescription, "99%");
        desktopTabPanel.appendChild((Component)this.fieldDescription);
        tabPanels.appendChild((Component)desktopTabPanel);
        tab = new Tab(Msg.translate((Properties)Env.getCtx(), (String)"Substitute_ID"));
        tabs.appendChild((Component)tab);
        desktopTabPanel = new Tabpanel();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)desktopTabPanel, "100%");
        desktopTabPanel.appendChild((Component)this.substituteTbl);
        tabPanels.appendChild((Component)desktopTabPanel);
        tab = new Tab(Msg.translate((Properties)Env.getCtx(), (String)"RelatedProduct_ID"));
        tabs.appendChild((Component)tab);
        desktopTabPanel = new Tabpanel();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)desktopTabPanel, "100%");
        desktopTabPanel.appendChild((Component)this.relatedTbl);
        tabPanels.appendChild((Component)desktopTabPanel);
        tab = new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"ATP"));
        tabs.appendChild((Component)tab);
        desktopTabPanel = new Tabpanel();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)desktopTabPanel, "100%");
        desktopTabPanel.appendChild((Component)this.m_tableAtp);
        this.chbShowDetailAtp = new Checkbox();
        this.chbShowDetailAtp.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"showDetailAtp", (boolean)true));
        this.chbShowDetailAtp.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"showDetailAtp", (boolean)false));
        this.chbShowDetailAtp.addActionListener(new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (InfoProductWindow.this.contentPanel.getLayout() != null) {
                    int M_Warehouse_ID = InfoProductWindow.this.getSelectedWarehouseId();
                    Integer m_M_Product_ID = InfoProductWindow.this.getIntSelectedRowKey(208);
                    if (m_M_Product_ID != null) {
                        InfoProductWindow.this.initAtpTab(M_Warehouse_ID, m_M_Product_ID);
                    }
                }
            }
        });
        desktopTabPanel.appendChild((Component)this.chbShowDetailAtp);
        tabPanels.appendChild((Component)desktopTabPanel);
        tab = new Tab(Msg.translate((Properties)Env.getCtx(), (String)"Price"));
        tabs.appendChild((Component)tab);
        desktopTabPanel = new Tabpanel();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)desktopTabPanel, "100%");
        desktopTabPanel.appendChild((Component)this.productpriceTbl);
        tabPanels.appendChild((Component)desktopTabPanel);
        int height = SessionManager.getAppDesktop().getClientInfo().desktopHeight * 90 / 100;
        this.contentBorderLayout = new Borderlayout();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.contentBorderLayout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.contentBorderLayout, "100%");
        if (this.isLookup()) {
            this.contentBorderLayout.setStyle("border: none; position: relative; ");
        } else {
            this.contentBorderLayout.setStyle("border: none; position: absolute; ");
        }
        this.contentBorderLayout.appendCenter((Component)this.contentPanel);
        this.contentBorderLayout.getCenter().setAutoscroll(false);
        South south = new South();
        int detailHeight = height * 25 / 100;
        ZKUpdateUtil.setHeight((HtmlBasedComponent)south, detailHeight + "px");
        south.setCollapsible(true);
        south.setSplittable(true);
        south.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"Related Information"));
        south.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"Related Information"));
        south.setSclass("south-collapsible-with-title");
        if (ClientInfo.maxHeight(699)) {
            south.setOpen(false);
            ZKUpdateUtil.setHeight((HtmlBasedComponent)south, "100%");
        }
        this.contentBorderLayout.appendChild((Component)south);
        this.tabbedPane.setSclass("info-product-tabbedpane");
        south.appendChild((Component)this.tabbedPane);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabbedPane, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.tabbedPane, "1");
        center.appendChild((Component)this.contentBorderLayout);
        this.contentPanel.addActionListener(new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                int row = InfoProductWindow.this.contentPanel.getSelectedRow();
                if (row >= 0) {
                    Object value;
                    int M_Warehouse_ID = InfoProductWindow.this.getSelectedWarehouseId();
                    int M_PriceList_Version_ID = InfoProductWindow.this.getSelectedPriceListVersionId();
                    int i = 0;
                    while (i < InfoProductWindow.this.columnInfos.length) {
                        if (InfoProductWindow.this.columnInfos[i].getGridField() != null && InfoProductWindow.this.columnInfos[i].getGridField().getColumnName().equals("Value")) {
                            InfoProductWindow.this.refresh(M_Warehouse_ID, M_PriceList_Version_ID);
                            if (!ClientInfo.minHeight(700)) break;
                            InfoProductWindow.this.contentBorderLayout.getSouth().setOpen(true);
                            break;
                        }
                        ++i;
                    }
                    InfoProductWindow.this.m_PAttributeButton.setEnabled(false);
                    int colIdx = InfoProductWindow.this.findColumnIndex("IsInstanceAttribute");
                    if (colIdx >= 0 && (value = InfoProductWindow.this.contentPanel.getValueAt(row, colIdx)) != null && value.toString().equals("true")) {
                        InfoProductWindow.this.m_PAttributeButton.setEnabled(true);
                    }
                }
            }
        });
        this.warehouseTbl.repaint();
        this.substituteTbl.repaint();
        this.relatedTbl.repaint();
        this.productpriceTbl.repaint();
        this.m_tableAtp.repaint();
        if (this.embeddedWinList.size() > 0) {
            for (EmbedWinInfo embeddedWin : this.embeddedWinList) {
                if (!(embeddedWin.getInfoTbl() instanceof WListbox)) continue;
                tab = new Tab(embeddedWin.getInfowin().get_Translation("Name"));
                tabs.appendChild((Component)tab);
                desktopTabPanel = new Tabpanel();
                ZKUpdateUtil.setHeight((HtmlBasedComponent)desktopTabPanel, "100%");
                desktopTabPanel.appendChild((Component)((WListbox)embeddedWin.getInfoTbl()));
                tabPanels.appendChild((Component)desktopTabPanel);
                ((WListbox)embeddedWin.getInfoTbl()).repaint();
            }
        }
    }

    protected void onPAttributeClick() {
        Integer productInteger = this.getIntSelectedRowKey(208);
        if (productInteger == null) {
            this.m_PAttributeButton.setEnabled(false);
            return;
        }
        String productName = (String)this.contentPanel.getValueAt(this.contentPanel.getSelectedRow(), this.findColumnIndex("Name"));
        if (productInteger == null || productInteger == 0) {
            return;
        }
        int M_Warehouse_ID = this.getSelectedWarehouseId();
        if (M_Warehouse_ID <= 0) {
            return;
        }
        String title = this.getSelectedWarehouseLabel() + " - " + productName;
        int C_BPartner_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_BPartner_ID");
        final InfoPAttributeInstancePanel pai = new InfoPAttributeInstancePanel(this, title, M_Warehouse_ID, 0, productInteger, C_BPartner_ID);
        pai.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                InfoProductWindow.this.m_M_AttributeSetInstance_ID = pai.getM_AttributeSetInstance_ID();
                InfoProductWindow.this.m_M_Locator_ID = pai.getM_Locator_ID();
            }
        });
    }

    protected String getSelectedWarehouseLabel() {
        for (WEditor editor : this.editors) {
            if (editor.getGridField() == null || !editor.getGridField().getColumnName().equals("M_Warehouse_ID")) continue;
            Number value = (Number)editor.getValue();
            if (value == null) break;
            return editor.getDisplay();
        }
        return "";
    }

    protected int getSelectedPriceListVersionId() {
        for (WEditor editor : this.editors) {
            if (editor.getGridField() == null || !editor.getGridField().getColumnName().equals("M_PriceList_Version_ID")) continue;
            Number value = (Number)editor.getValue();
            if (value == null) break;
            return value.intValue();
        }
        return 0;
    }

    protected int getSelectedWarehouseId() {
        for (WEditor editor : this.editors) {
            if (editor.getGridField() == null || !editor.getGridField().getColumnName().equals("M_Warehouse_ID")) continue;
            Number value = (Number)editor.getValue();
            if (value == null) break;
            return value.intValue();
        }
        return 0;
    }

    @Override
    protected void initParameters() {
        int M_Warehouse_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"M_Warehouse_ID");
        String usePriceList = Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"+UsePriceListInProductInfo");
        int M_PriceList_Version_ID = 0;
        if ("Y".equalsIgnoreCase(usePriceList)) {
            int M_PriceList_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"M_PriceList_ID");
            M_PriceList_Version_ID = this.findPLV(M_PriceList_ID);
        }
        if (M_Warehouse_ID == 0) {
            M_Warehouse_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"#M_Warehouse_ID");
        }
        if (M_Warehouse_ID != 0) {
            this.setWarehouse(M_Warehouse_ID);
        } else {
            for (WEditor editor : this.editors) {
                if (editor.getGridField() == null || !editor.getGridField().getColumnName().equals("M_Warehouse_ID")) continue;
                if (editor.getValue() == null || (M_Warehouse_ID = ((Integer)editor.getValue()).intValue()) <= 0) break;
                Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (String)"M_Warehouse_ID", (int)M_Warehouse_ID);
                Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (int)1113, (String)"M_Warehouse_ID", (String)Integer.toString(M_Warehouse_ID));
                break;
            }
        }
        if (M_PriceList_Version_ID != 0) {
            this.setPriceListVersion(M_PriceList_Version_ID);
        } else {
            for (WEditor editor : this.editors) {
                if (editor.getGridField() == null || !editor.getGridField().getColumnName().equals("M_PriceList_Version_ID")) continue;
                if (editor.getValue() == null || (M_PriceList_Version_ID = ((Integer)editor.getValue()).intValue()) <= 0) break;
                Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (String)"M_PriceList_Version_ID", (int)M_PriceList_Version_ID);
                Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (int)1113, (String)"M_PriceList_Version_ID", (String)Integer.toString(M_PriceList_Version_ID));
                break;
            }
        }
    }

    protected int findPLV(int M_PriceList_ID) {
        int retValue;
        block11: {
            Timestamp priceDate = null;
            String dateStr = Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"DateOrdered");
            if (dateStr != null && dateStr.length() > 0) {
                priceDate = Env.getContextAsDate((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"DateOrdered");
            } else {
                dateStr = Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"DateInvoiced");
                if (dateStr != null && dateStr.length() > 0) {
                    priceDate = Env.getContextAsDate((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"DateInvoiced");
                }
            }
            if (priceDate == null) {
                priceDate = new Timestamp(System.currentTimeMillis());
            }
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("M_PriceList_ID=" + M_PriceList_ID + " - " + String.valueOf(priceDate));
            }
            retValue = 0;
            String sql = "SELECT plv.M_PriceList_Version_ID, plv.ValidFrom FROM M_PriceList pl, M_PriceList_Version plv WHERE pl.M_PriceList_ID=plv.M_PriceList_ID AND plv.IsActive='Y' AND pl.M_PriceList_ID=? ORDER BY plv.ValidFrom DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, M_PriceList_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next() && retValue == 0) {
                        Timestamp plDate = rs.getTimestamp(2);
                        if (priceDate.before(plDate)) continue;
                        retValue = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    protected void setWarehouse(int M_Warehouse_ID) {
        for (WEditor editor : this.editors) {
            if (editor.getGridField() == null || !editor.getGridField().getColumnName().equals("M_Warehouse_ID")) continue;
            editor.setValue(M_Warehouse_ID);
            Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (String)"M_Warehouse_ID", (int)M_Warehouse_ID);
            Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (int)1113, (String)"M_Warehouse_ID", (String)Integer.toString(M_Warehouse_ID));
            return;
        }
    }

    protected void setPriceListVersion(int M_PriceList_Version_ID) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("M_PriceList_Version_ID=" + M_PriceList_Version_ID);
        }
        for (WEditor editor : this.editors) {
            if (editor.getGridField() == null || !editor.getGridField().getColumnName().equals("M_PriceList_Version_ID")) continue;
            editor.setValue(M_PriceList_Version_ID);
            Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (String)"M_PriceList_Version_ID", (int)M_PriceList_Version_ID);
            Env.setContext((Properties)this.infoContext, (int)this.p_WindowNo, (int)1113, (String)"M_PriceList_Version_ID", (String)Integer.toString(M_PriceList_Version_ID));
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("NOT found");
        }
    }

    protected void refresh(int M_Warehouse_ID, int M_PriceList_Version_ID) {
        ResultSet rs;
        CPreparedStatement pstmt;
        String sql;
        int m_M_Product_ID;
        block26: {
            block24: {
                block22: {
                    m_M_Product_ID = this.getIntSelectedRowKey(208);
                    sql = this.m_sqlWarehouse;
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest(sql);
                    }
                    pstmt = null;
                    rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)sql, null);
                            pstmt.setInt(1, m_M_Product_ID);
                            rs = pstmt.executeQuery();
                            this.warehouseTbl.loadTable(rs);
                        }
                        catch (Exception e) {
                            this.log.log(Level.WARNING, sql, (Throwable)e);
                            DB.close((ResultSet)rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
                sql = "SELECT DocumentNote FROM M_Product WHERE M_Product_ID=?";
                this.fieldDescription.setText(DB.getSQLValueString(null, (String)sql, (int)m_M_Product_ID));
                sql = this.m_sqlSubstitute;
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest(sql);
                }
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        pstmt.setInt(1, m_M_Product_ID);
                        pstmt.setInt(2, M_PriceList_Version_ID);
                        rs = pstmt.executeQuery();
                        this.substituteTbl.loadTable(rs);
                    }
                    catch (Exception e) {
                        this.log.log(Level.WARNING, sql, (Throwable)e);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            sql = this.m_sqlRelated;
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(sql);
            }
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, m_M_Product_ID);
                    pstmt.setInt(2, M_PriceList_Version_ID);
                    rs = pstmt.executeQuery();
                    this.relatedTbl.loadTable(rs);
                }
                catch (Exception e) {
                    this.log.log(Level.WARNING, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block26;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.initAtpTab(M_Warehouse_ID, m_M_Product_ID);
        sql = this.m_sqlProductprice;
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(sql);
        }
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, m_M_Product_ID);
                rs = pstmt.executeQuery();
                this.productpriceTbl.loadTable(rs);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, sql, (Throwable)e);
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    protected void initAtpTab(int m_M_Warehouse_ID, int m_M_Product_ID) {
        Vector data;
        block27: {
            Vector<Object> line;
            ResultSet rs;
            CPreparedStatement pstmt;
            double qty;
            Object sql;
            boolean showDetail;
            block25: {
                showDetail = this.isShowDetailATP();
                sql = "SELECT s.QtyOnHand, s.QtyReserved, s.QtyOrdered, productAttribute(s.M_AttributeSetInstance_ID), s.M_AttributeSetInstance_ID,";
                if (!showDetail) {
                    sql = "SELECT SUM(s.QtyOnHand), SUM(s.QtyReserved), SUM(s.QtyOrdered), productAttribute(s.M_AttributeSetInstance_ID), 0,";
                }
                sql = (String)sql + " w.Name, l.Value FROM M_Storage s INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) LEFT JOIN M_LocatorType lt ON (l.M_LocatorType_ID=lt.M_LocatorType_ID) INNER JOIN M_Warehouse w ON (l.M_Warehouse_ID=w.M_Warehouse_ID) WHERE M_Product_ID=?";
                if (m_M_Warehouse_ID != 0) {
                    sql = (String)sql + " AND l.M_Warehouse_ID=?";
                }
                if (this.m_M_AttributeSetInstance_ID > 0) {
                    sql = (String)sql + " AND s.M_AttributeSetInstance_ID=?";
                }
                sql = (String)sql + " AND (s.QtyOnHand<>0 OR s.QtyReserved<>0 OR s.QtyOrdered<>0)";
                sql = (String)sql + " AND COALESCE(lt.IsAvailableForReservation,'Y')='Y'";
                if (!showDetail) {
                    sql = (String)sql + " GROUP BY productAttribute(s.M_AttributeSetInstance_ID), w.Name, l.Value";
                }
                sql = (String)sql + " ORDER BY l.Value";
                data = new Vector();
                qty = 0.0;
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        pstmt.setInt(1, m_M_Product_ID);
                        if (m_M_Warehouse_ID != 0) {
                            pstmt.setInt(2, m_M_Warehouse_ID);
                        }
                        if (this.m_M_AttributeSetInstance_ID > 0) {
                            pstmt.setInt(3, this.m_M_AttributeSetInstance_ID);
                        }
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            line = new Vector<Object>(9);
                            line.add(null);
                            double qtyOnHand = rs.getDouble(1);
                            qty += qtyOnHand;
                            line.add(qtyOnHand);
                            line.add(null);
                            line.add(rs.getDouble(3));
                            line.add(rs.getDouble(2));
                            line.add(rs.getString(7));
                            Object asi = rs.getString(4);
                            if (showDetail && (asi == null || ((String)asi).length() == 0)) {
                                asi = "{" + rs.getInt(5) + "}";
                            }
                            line.add(asi);
                            line.add(null);
                            line.add(rs.getString(6));
                            data.add(line);
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, (String)sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            sql = "SELECT COALESCE(ol.DatePromised, o.DatePromised) AS DatePromised, ol.QtyReserved, productAttribute(ol.M_AttributeSetInstance_ID), ol.M_AttributeSetInstance_ID, dt.DocBaseType, bp.Name, dt.PrintName || ' ' || o.DocumentNo As DocumentNo, w.Name FROM C_Order o INNER JOIN C_OrderLine ol ON (o.C_Order_ID=ol.C_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (ol.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN C_BPartner bp  ON (o.C_BPartner_ID=bp.C_BPartner_ID) WHERE ol.QtyReserved<>0 AND ol.M_Product_ID=?";
            if (m_M_Warehouse_ID != 0) {
                sql = (String)sql + " AND ol.M_Warehouse_ID=?";
            }
            if (this.m_M_AttributeSetInstance_ID > 0) {
                sql = (String)sql + " AND ol.M_AttributeSetInstance_ID=?";
            }
            sql = (String)sql + " ORDER BY o.DatePromised";
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, m_M_Product_ID);
                    if (m_M_Warehouse_ID != 0) {
                        pstmt.setInt(2, m_M_Warehouse_ID);
                    }
                    if (this.m_M_AttributeSetInstance_ID > 0) {
                        pstmt.setInt(3, this.m_M_AttributeSetInstance_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        line = new Vector(9);
                        line.add(rs.getTimestamp(1));
                        double oq = rs.getDouble(2);
                        String DocBaseType = rs.getString(5);
                        Double qtyReserved = null;
                        Double qtyOrdered = null;
                        if ("POO".equals(DocBaseType)) {
                            qtyOrdered = oq;
                            qty += oq;
                        } else {
                            qtyReserved = oq;
                            qty -= oq;
                        }
                        line.add(qty);
                        line.add(rs.getString(6));
                        line.add(qtyOrdered);
                        line.add(qtyReserved);
                        line.add(null);
                        Object asi = rs.getString(3);
                        if (showDetail && (asi == null || ((String)asi).length() == 0)) {
                            asi = "{" + rs.getInt(4) + "}";
                        }
                        line.add(asi);
                        line.add(rs.getString(7));
                        line.add(rs.getString(8));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, (String)sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block27;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        ListModelTable model = new ListModelTable(data);
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"QtyOnHand"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"QtyOrdered"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"QtyReserved"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Locator_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_AttributeSetInstance_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Warehouse_ID"));
        this.m_tableAtp.setData(model, columnNames);
    }

    public boolean isShowDetailATP() {
        return this.chbShowDetailAtp.isChecked();
    }

    @Override
    protected void showHistory() {
        Integer M_Product_ID;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("");
        }
        if ((M_Product_ID = this.getIntSelectedRowKey(208)) == null) {
            return;
        }
        int M_Warehouse_ID = this.getSelectedWarehouseId();
        int M_AttributeSetInstance_ID = this.m_M_AttributeSetInstance_ID;
        if (this.m_M_AttributeSetInstance_ID < -1) {
            M_AttributeSetInstance_ID = 0;
        }
        InvoiceHistory ih = new InvoiceHistory(this, 0, M_Product_ID, M_Warehouse_ID, M_AttributeSetInstance_ID);
        ih.setVisible(true);
        ih = null;
    }

    @Override
    protected boolean hasHistory() {
        return true;
    }

    @Override
    protected void saveSelectionDetail() {
        int row = this.contentPanel.getSelectedRow();
        if (row == -1) {
            return;
        }
        super.saveSelectionDetail();
        if (this.m_M_AttributeSetInstance_ID == -1) {
            Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID", (String)"0");
            Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)"M_Locator_ID", (String)"0");
        } else {
            Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID", (String)String.valueOf(this.m_M_AttributeSetInstance_ID));
            Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)"M_Locator_ID", (String)String.valueOf(this.m_M_Locator_ID));
        }
        Integer ID = this.getIntSelectedRowKey(208);
        Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)"M_Product_ID", (String)(ID == null ? "0" : ID.toString()));
    }

    @Override
    protected void prepareTable(ColumnInfo[] layout, String from, String where, String orderBy) {
        if (Util.isEmpty((String)orderBy) && this.getSelectedWarehouseId() > 0) {
            orderBy = "QtyAvailable DESC";
        }
        super.prepareTable(layout, from, where, orderBy);
    }

    @Override
    protected void executeQuery() {
        super.executeQuery();
        if (this.m_PAttributeButton != null) {
            this.m_PAttributeButton.setEnabled(false);
        }
    }

    @Override
    protected void updateSubcontent() {
        super.updateSubcontent();
        int row = this.contentPanel.getSelectedRow();
        if (row < 0) {
            if (this.warehouseTbl != null && this.warehouseTbl.getModel() != null) {
                this.warehouseTbl.getModel().clear();
            }
            if (this.substituteTbl != null && this.substituteTbl.getModel() != null) {
                this.substituteTbl.getModel().clear();
            }
            if (this.relatedTbl != null && this.relatedTbl.getModel() != null) {
                this.relatedTbl.getModel().clear();
            }
            if (this.m_tableAtp != null && this.m_tableAtp.getModel() != null) {
                this.m_tableAtp.getModel().clear();
            }
            if (this.productpriceTbl != null && this.productpriceTbl.getModel() != null) {
                this.productpriceTbl.getModel().clear();
            }
            if (this.fieldDescription != null) {
                this.fieldDescription.setText("");
            }
        }
    }
}

