/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.EditorBox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.InfoSchedule;
import org.adempiere.webui.window.WAssignmentDialog;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.model.MProduct;
import org.compiere.model.MResourceAssignment;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;

public class WAssignmentEditor
extends WEditor
implements ContextMenuListener {
    private static final String RETRIEVE_RESOURCE_ASSIGNMENT_SQL = "SELECT r.Name,ra.AssignDateFrom,ra.Qty,COALESCE(uom.UOMSymbol,uom.Name) FROM S_ResourceAssignment ra, S_Resource r, S_ResourceType rt, C_UOM uom WHERE ra.S_ResourceAssignment_ID=? AND ra.S_Resource_ID=r.S_Resource_ID AND r.S_ResourceType_ID=rt.S_ResourceType_ID and rt.C_UOM_ID=uom.C_UOM_ID";
    private static final CLogger log = CLogger.getCLogger(WAssignmentEditor.class);
    private static final String[] LISTENER_EVENTS = new String[]{"onClick"};
    private boolean m_readWrite;
    private Object m_value;
    private DateFormat m_dateFormat = DisplayType.getDateFormat((int)16);
    private NumberFormat m_qtyFormat = DisplayType.getNumberFormat((int)29);

    public WAssignmentEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WAssignmentEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new EditorBox(), gridField, tableEditor, editorConfiguration);
        this.initComponents();
    }

    private void initComponents() {
        this.getComponent().getTextbox().setReadonly(true);
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass("z-icon-Assignment");
        } else {
            this.getComponent().setButtonImage(ThemeManager.getThemeResource("images/Assignment16.png"));
        }
        this.popupMenu = new WEditorPopupMenu(true, false, false);
        this.popupMenu.addMenuListener(this);
        this.addChangeLogMenu(this.popupMenu);
        if (this.gridField != null) {
            this.getComponent().getTextbox().setPlaceholder(this.gridField.getPlaceholder());
        }
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    public EditorBox getComponent() {
        return (EditorBox)this.component;
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public boolean isReadWrite() {
        return this.m_readWrite;
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.m_readWrite = readWrite;
        this.getComponent().setEnabled(readWrite);
        this.getComponent().getTextbox().setReadonly(true);
    }

    @Override
    public void setValue(Object value) {
        block10: {
            if (value == this.m_value) {
                return;
            }
            this.m_value = value;
            int S_ResourceAssignment_ID = 0;
            if (this.m_value != null && this.m_value instanceof Integer) {
                S_ResourceAssignment_ID = (Integer)this.m_value;
            }
            if (S_ResourceAssignment_ID == 0) {
                this.getComponent().setText("");
                return;
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)RETRIEVE_RESOURCE_ASSIGNMENT_SQL, null);
                    pstmt.setInt(1, S_ResourceAssignment_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        StringBuilder sb = new StringBuilder(rs.getString(1));
                        sb.append(" ").append(this.m_dateFormat.format(rs.getTimestamp(2))).append(" ").append(this.m_qtyFormat.format(rs.getBigDecimal(3))).append(" ").append(rs.getString(4).trim());
                        this.getComponent().setText(sb.toString());
                    } else {
                        this.getComponent().setText("<" + S_ResourceAssignment_ID + ">");
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
    }

    public void onEvent(Event event) throws Exception {
        if ("onClick".equalsIgnoreCase(event.getName())) {
            final Integer oldValue = (Integer)this.getValue();
            int S_ResourceAssignment_ID = oldValue == null ? 0 : oldValue;
            MResourceAssignment ma = new MResourceAssignment(Env.getCtx(), S_ResourceAssignment_ID, null);
            if (S_ResourceAssignment_ID == 0 && this.gridField != null && this.gridField.getGridTab() != null) {
                MProduct prod;
                Object prd;
                Object org = this.gridField.getGridTab().getValue("AD_Org_ID");
                if (org != null && org instanceof Integer) {
                    ma.setAD_Org_ID(((Integer)org).intValue());
                }
                if ((prd = this.gridField.getGridTab().getValue("M_Product_ID")) != null && prd instanceof Integer && (prod = MProduct.get((Properties)Env.getCtx(), (int)((Integer)prd))) != null && prod.getS_Resource_ID() > 0) {
                    ma.setS_Resource_ID(prod.getS_Resource_ID());
                }
            }
            if (S_ResourceAssignment_ID != 0) {
                final WAssignmentDialog vad = new WAssignmentDialog(ma, true, true);
                vad.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        if (!vad.isCancelled()) {
                            MResourceAssignment ma = vad.getMResourceAssignment();
                            WAssignmentEditor.this.processNewValue(oldValue, ma);
                        }
                    }
                });
                vad.setTitle(null);
                LayoutUtils.openPopupWindow((Component)this.getComponent().getTextbox(), vad);
            } else {
                InfoSchedule is = new InfoSchedule(ma, true, new Callback<MResourceAssignment>(){

                    public void onCallback(MResourceAssignment ma) {
                        WAssignmentEditor.this.processNewValue(oldValue, ma);
                    }
                });
                AEnv.showWindow(is);
                is.focus();
            }
        }
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        } else if ("ZOOM".equals(evt.getContextEvent())) {
            this.actionZoom();
        }
    }

    private void actionZoom() {
        AEnv.zoom(this.gridField.getGridTab().getAD_Table_ID(), (Integer)this.getValue());
    }

    private void processNewValue(Integer oldValue, MResourceAssignment ma) {
        if (ma != null && ma.getS_ResourceAssignment_ID() != 0) {
            this.setValue(ma.getS_ResourceAssignment_ID());
            ValueChangeEvent vce = new ValueChangeEvent(this, this.gridField.getColumnName(), oldValue, this.getValue());
            this.fireValueChange(vce);
        }
    }

    @Override
    public void setTableEditor(boolean b) {
        super.setTableEditor(b);
        this.getComponent().setTableEditorMode(b);
    }
}

