/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.awt.print.Pageable;
import java.io.File;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JasperPrint;
import org.adempiere.base.Core;
import org.adempiere.base.upload.IUploadService;
import org.adempiere.exceptions.DBException;
import org.adempiere.pdf.Document;
import org.adempiere.util.Callback;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.Extensions;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.BusyDialog;
import org.adempiere.webui.apps.ProcessModalDialog;
import org.adempiere.webui.apps.WReport;
import org.adempiere.webui.apps.form.WReportCustomization;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Mask;
import org.adempiere.webui.component.ProcessInfoDialog;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.desktop.IDesktop;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WStringEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.event.DrillEvent;
import org.adempiere.webui.event.ZoomEvent;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.StatusBarPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.IServerPushCallback;
import org.adempiere.webui.util.ServerPushTemplate;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.util.ZkContextRunnable;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.FindWindow;
import org.adempiere.webui.window.IReportViewerExportSource;
import org.adempiere.webui.window.JasperPrintRenderer;
import org.adempiere.webui.window.WEMailDialog;
import org.adempiere.webui.window.WReportExportDialog;
import org.adempiere.webui.window.WReportUploadDialog;
import org.compiere.model.GridField;
import org.compiere.model.MArchive;
import org.compiere.model.MAttachment;
import org.compiere.model.MAuthorizationAccount;
import org.compiere.model.MClient;
import org.compiere.model.MLanguage;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MToolBarButtonRestrict;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.model.X_AD_ToolBarButton;
import org.compiere.print.ArchiveEngine;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.idempiere.ui.zk.media.IMediaView;
import org.idempiere.ui.zk.media.WMediaOptions;
import org.idempiere.ui.zk.report.IReportViewerRenderer;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.A;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.North;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.Vlayout;
import org.zkoss.zul.impl.Utils;

public class ZkReportViewer
extends Window
implements EventListener<Event>,
IReportViewerExportSource {
    private static final long serialVersionUID = 3732290698059632847L;
    protected static final String CSV_OUTPUT_TYPE = "CSV";
    protected static final String HTML_OUTPUT_TYPE = "HTML";
    protected static final String PDF_OUTPUT_TYPE = "PDF";
    protected static final String XLS_OUTPUT_TYPE = "XLS";
    protected static final String XLSX_OUTPUT_TYPE = "XLSX";
    protected int m_WindowNo = -1;
    private Properties m_ctx;
    private boolean m_setting = false;
    protected ReportEngine m_reportEngine;
    private int m_AD_Table_ID = 0;
    private boolean m_isCanExport;
    private int m_AD_Process_ID = 0;
    private MQuery m_ddQ = null;
    private MQuery m_daQ = null;
    private Menuitem m_ddM = null;
    private Menuitem m_daM = null;
    private static final CLogger log = CLogger.getCLogger(ZkReportViewer.class);
    private StatusBarPanel statusBar = new StatusBarPanel();
    private Toolbar toolBar = new Toolbar();
    private ToolBarButton bSendMail = new ToolBarButton();
    private ToolBarButton bArchive = new ToolBarButton();
    private ToolBarButton bAttachment = new ToolBarButton();
    private ToolBarButton bCustomize = new ToolBarButton();
    private ToolBarButton bFind = new ToolBarButton();
    private ToolBarButton bExport = new ToolBarButton();
    private ToolBarButton bWizard = new ToolBarButton();
    private Listbox comboReport = new Listbox();
    private Listitem previousSelected = new Listitem();
    private WTableDirEditor wLanguage;
    protected Listbox previewType = new Listbox();
    private ToolBarButton bRefresh = new ToolBarButton();
    private ToolBarButton bReRun = new ToolBarButton();
    private Iframe iframe;
    private Checkbox summary = new Checkbox();
    protected AMedia media;
    private int mediaVersion = 0;
    private A reportLink;
    private boolean init = false;
    private BusyDialog progressWindow;
    private Mask mask;
    private static final String ON_RENDER_REPORT_EVENT = "onRenderReport";
    private Popup toolbarPopup;
    private ToolBarButton bCloudUpload = new ToolBarButton();
    protected Map<MAuthorizationAccount, IUploadService> uploadServicesMap = new HashMap<MAuthorizationAccount, IUploadService>();
    private Label rowCount;
    private final Map<IReportViewerExportSource.ExportFormat, String> exportMap = new LinkedHashMap<IReportViewerExportSource.ExportFormat, String>();
    private final Map<String, IReportViewerRenderer> rendererMap = new TreeMap<String, IReportViewerRenderer>();
    private Center center;
    private FindWindow find;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    private JasperPrintRenderer jasperPrintRenderer = null;
    private boolean ToolBarMenuRestictionLoaded = false;

    public ZkReportViewer(ReportEngine re, String title) {
        this.m_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
        this.setAttribute("desktop.windowno", this.m_WindowNo);
        Env.setContext((Properties)re.getCtx(), (int)this.m_WindowNo, (String)"_WinInfo_IsReportViewer", (String)"Y");
        this.m_reportEngine = re;
        this.m_AD_Table_ID = re.getPrintFormat().getAD_Table_ID();
        this.setTitle(Util.cleanAmp((String)(Msg.getMsg((Properties)Env.getCtx(), (String)"Report") + ": " + this.m_reportEngine.getPrintFormat().get_Translation("Name"))));
        if (!MRole.getDefault().isCanReport(this.m_AD_Table_ID)) {
            Dialog.error(this.m_WindowNo, "AccessCannotReport", this.m_reportEngine.getName());
            this.onClose();
            return;
        }
        this.m_isCanExport = MRole.getDefault().isCanExport(this.m_AD_Table_ID);
        this.addEventListener(ON_RENDER_REPORT_EVENT, this);
        this.addEventListener("onPostInit", e -> this.postRenderReportEvent());
        this.initMediaSuppliers();
    }

    private String toRendererId(String contentType, String fileExtension) {
        for (Map.Entry<IReportViewerExportSource.ExportFormat, String> entry : this.exportMap.entrySet()) {
            if (!entry.getKey().contentType.equals(contentType) || !entry.getKey().extension.equals(fileExtension)) continue;
            return entry.getValue();
        }
        return null;
    }

    private void initMediaSuppliers() {
        List<IReportViewerRenderer> renderers = Extensions.getReportViewerRenderers();
        Collections.sort(renderers, new Comparator<IReportViewerRenderer>(){

            @Override
            public int compare(IReportViewerRenderer r1, IReportViewerRenderer r2) {
                return r1.getExportLabel().compareTo(r2.getExportLabel());
            }
        });
        for (IReportViewerRenderer renderer : renderers) {
            if (renderer.isExport()) {
                IReportViewerExportSource.ExportFormat exportFormat = new IReportViewerExportSource.ExportFormat(renderer.getExportLabel(), renderer.getFileExtension(), renderer.getContentType());
                this.exportMap.put(exportFormat, renderer.getId());
            }
            this.rendererMap.put(renderer.getId(), renderer);
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null && !this.init && this.m_reportEngine != null) {
            try {
                this.m_ctx = this.m_reportEngine.getCtx();
                this.init();
                this.dynInit();
                SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this);
                this.addEventListener("onCloseWindowShortcut", this);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "", (Throwable)e);
                Dialog.error(this.m_WindowNo, "LoadError", e.getLocalizedMessage());
                this.onClose();
            }
        }
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        try {
            SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", this);
            this.removeEventListener("onCloseWindowShortcut", this);
        }
        catch (Exception exception) {}
        this.cleanUp();
    }

    private void init() {
        MPrintFormat pf;
        Borderlayout layout = new Borderlayout();
        layout.setWidth("100%");
        layout.setHeight("100%");
        this.appendChild((Component)layout);
        this.setWidth("100%");
        this.setHeight("100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.toolBar, "32px");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.toolBar, "100%");
        this.previewType.setMold("select");
        this.setupPreviewType();
        this.toolBar.appendChild((Component)this.previewType);
        this.previewType.addEventListener("onSelect", this);
        this.toolBar.appendChild((Component)new Separator("vertical"));
        String type = null;
        type = this.m_reportEngine.getReportType() != null ? this.m_reportEngine.getReportType() : (this.m_reportEngine.getPrintFormat().isForm() || this.m_reportEngine.getPrintFormat().getJasperProcess_ID() > 0 ? MSysConfig.getValue((String)"ZK_REPORT_FORM_OUTPUT_TYPE", (String)PDF_OUTPUT_TYPE, (int)Env.getAD_Client_ID((Properties)this.m_ctx), (int)Env.getAD_Org_ID((Properties)this.m_ctx)) : MSysConfig.getValue((String)"ZK_REPORT_TABLE_OUTPUT_TYPE", (String)PDF_OUTPUT_TYPE, (int)Env.getAD_Client_ID((Properties)this.m_ctx), (int)Env.getAD_Org_ID((Properties)this.m_ctx)));
        int defaultIndex = -1;
        int i = 0;
        while (i < this.previewType.getItemCount()) {
            ListItem item = this.previewType.getItemAtIndex(i);
            if (item.getValue().equals(type)) {
                this.previewType.setSelectedIndex(i);
                break;
            }
            if (item.getValue().equals(PDF_OUTPUT_TYPE)) {
                defaultIndex = i;
            }
            ++i;
        }
        if (this.previewType.getSelectedIndex() < 0) {
            this.previewType.setSelectedIndex(defaultIndex >= 0 ? defaultIndex : 0);
        }
        Vlayout toolbarPopupLayout = null;
        if (ClientInfo.maxWidth(699)) {
            this.toolbarPopup = new Popup();
            this.appendChild((Component)this.toolbarPopup);
            toolbarPopupLayout = new Vlayout();
            this.toolbarPopup.appendChild((Component)toolbarPopupLayout);
        }
        if (this.toolbarPopup == null) {
            this.toolBar.appendChild((Component)new Separator("vertical"));
        }
        this.comboReport.setMold("select");
        this.comboReport.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"AD_PrintFormat_ID"));
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.comboReport);
        } else {
            this.toolBar.appendChild((Component)this.comboReport);
            this.toolBar.appendChild((Component)new Separator("vertical"));
        }
        MClient client = MClient.get((Properties)this.m_ctx);
        if (client.isMultiLingualDocument()) {
            try {
                MLanguage language;
                this.wLanguage = AEnv.getListDocumentLanguage(client);
                this.wLanguage.getComponent().setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"AD_PrintFormat_ID"));
                if (this.toolbarPopup != null) {
                    toolbarPopupLayout.appendChild((Component)this.wLanguage.getComponent());
                } else {
                    this.toolBar.appendChild((Component)this.wLanguage.getComponent());
                }
                int languageID = 0;
                if (this.m_reportEngine.getPrintFormat() != null && this.m_reportEngine.getPrintFormat().getLanguage() != null && (language = MLanguage.get((Properties)this.m_ctx, (Language)this.m_reportEngine.getPrintFormat().getLanguage())) != null) {
                    languageID = language.getAD_Language_ID();
                }
                if (this.m_reportEngine.getLanguageID() > 0) {
                    languageID = this.m_reportEngine.getLanguageID();
                }
                this.wLanguage.setValue(languageID);
                this.wLanguage.getComponent().addEventListener("onSelect", this);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage());
            }
        }
        if (this.toolbarPopup == null && client.isMultiLingualDocument()) {
            this.toolBar.appendChild((Component)new Separator("vertical"));
        }
        this.summary.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Summary"));
        this.summary.setChecked(this.m_reportEngine.isSummary());
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.summary);
        } else {
            this.toolBar.appendChild((Component)this.summary);
            this.toolBar.appendChild((Component)new Separator("vertical"));
        }
        this.bCustomize.setName("Customize");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bCustomize.setIconSclass("z-icon-Preference");
        } else {
            this.bCustomize.setImage(ThemeManager.getThemeResource("images/Preference24.png"));
        }
        this.bCustomize.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"PrintCustomize")));
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.bCustomize);
            this.bCustomize.setLabel(this.bCustomize.getTooltiptext());
        } else {
            this.toolBar.appendChild((Component)this.bCustomize);
        }
        this.bCustomize.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bCustomize);
        }
        this.bFind.setName("Find");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bFind.setIconSclass("z-icon-Find");
        } else {
            this.bFind.setImage(ThemeManager.getThemeResource("images/Find24.png"));
        }
        this.bFind.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Find")));
        this.bFind.addEventListener("onClick", this);
        if (this.getAD_Tab_ID(this.m_reportEngine.getPrintFormat().getAD_Table_ID()) <= 0) {
            this.bFind.setVisible(false);
        }
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.bFind);
            this.bFind.setLabel(this.bFind.getTooltiptext());
        } else {
            this.toolBar.appendChild((Component)this.bFind);
            this.toolBar.appendChild((Component)new Separator("vertical"));
        }
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bFind);
        }
        this.bSendMail.setName("SendMail");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bSendMail.setIconSclass("z-icon-SendMail");
        } else {
            this.bSendMail.setImage(ThemeManager.getThemeResource("images/SendMail24.png"));
        }
        this.bSendMail.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"SendMail")));
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.bSendMail);
            this.bSendMail.setLabel(this.bSendMail.getTooltiptext());
        } else {
            this.toolBar.appendChild((Component)this.bSendMail);
        }
        this.bSendMail.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bSendMail);
        }
        this.bArchive.setName("Archive");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bArchive.setIconSclass("z-icon-Archive");
        } else {
            this.bArchive.setImage(ThemeManager.getThemeResource("images/Archive24.png"));
        }
        this.bArchive.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Archive")));
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.bArchive);
            this.bArchive.setLabel(this.bArchive.getTooltiptext());
        } else {
            this.toolBar.appendChild((Component)this.bArchive);
        }
        this.bArchive.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bArchive);
        }
        int tableId = this.m_reportEngine.getPrintInfo().getAD_Table_ID();
        int recordId = this.m_reportEngine.getPrintInfo().getRecord_ID();
        if (tableId > 0 && recordId > 0) {
            this.bAttachment.setName("Attachment");
            if (ThemeManager.isUseFontIconForImage()) {
                this.bAttachment.setIconSclass("z-icon-Attachment");
            } else {
                this.bAttachment.setImage(ThemeManager.getThemeResource("images/Attachment24.png"));
            }
            this.bAttachment.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Attachment")));
            if (this.toolbarPopup != null) {
                toolbarPopupLayout.appendChild((Component)this.bAttachment);
                this.bAttachment.setLabel(this.bAttachment.getTooltiptext());
            } else {
                this.toolBar.appendChild((Component)this.bAttachment);
            }
            this.bAttachment.addEventListener("onClick", this);
            if (ThemeManager.isUseFontIconForImage()) {
                LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bAttachment);
            }
        }
        if (this.m_isCanExport) {
            this.bExport.setName("Export");
            if (ThemeManager.isUseFontIconForImage()) {
                this.bExport.setIconSclass("z-icon-Export");
            } else {
                this.bExport.setImage(ThemeManager.getThemeResource("images/Export24.png"));
            }
            this.bExport.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Export")));
            if (this.toolbarPopup != null) {
                toolbarPopupLayout.appendChild((Component)this.bExport);
                this.bExport.setLabel(this.bExport.getTooltiptext());
            } else {
                this.toolBar.appendChild((Component)this.bExport);
            }
            this.bExport.addEventListener("onClick", this);
            if (ThemeManager.isUseFontIconForImage()) {
                LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bExport);
            }
        }
        if (this.toolbarPopup == null) {
            this.toolBar.appendChild((Component)new Separator("vertical"));
        }
        this.bRefresh.setName("Refresh");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bRefresh.setIconSclass("z-icon-Refresh");
        } else {
            this.bRefresh.setImage(ThemeManager.getThemeResource("images/Refresh24.png"));
        }
        this.bRefresh.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh")));
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.bRefresh);
            this.bRefresh.setLabel(this.bRefresh.getTooltiptext());
        } else {
            this.toolBar.appendChild((Component)this.bRefresh);
        }
        this.bRefresh.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bRefresh);
        }
        if ((pf = this.m_reportEngine.getPrintFormat()) != null && !pf.isForm() && pf.getAD_ReportView_ID() > 0) {
            this.bReRun.setName("ReRun");
            if (ThemeManager.isUseFontIconForImage()) {
                this.bReRun.setIconSclass("z-icon-ReRun");
            } else {
                this.bReRun.setImage(ThemeManager.getThemeResource("images/ReRun24.png"));
            }
            this.bReRun.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"ReRun")));
            if (this.toolbarPopup != null) {
                toolbarPopupLayout.appendChild((Component)this.bReRun);
                this.bReRun.setLabel(this.bReRun.getTooltiptext());
            } else {
                this.toolBar.appendChild((Component)this.bReRun);
            }
            this.bReRun.addEventListener("onClick", this);
            if (ThemeManager.isUseFontIconForImage()) {
                LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bReRun);
            }
        }
        this.bWizard.setName("Wizard");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bWizard.setIconSclass("z-icon-Wizard");
        } else {
            this.bWizard.setImage(ThemeManager.getThemeResource("images/Wizard24.png"));
        }
        this.bWizard.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"PrintWizard")));
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.bWizard);
            this.bWizard.setLabel(this.bWizard.getTooltiptext());
        } else {
            this.toolBar.appendChild((Component)this.bWizard);
        }
        this.bWizard.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bWizard);
        }
        if (this.toolbarPopup != null) {
            ToolBarButton more = new ToolBarButton();
            if (ThemeManager.isUseFontIconForImage()) {
                more.setIconSclass("z-icon-Expand");
            } else {
                more.setImage(ThemeManager.getThemeResource("images/expand-header.png"));
            }
            this.toolBar.appendChild((Component)more);
            LayoutUtils.addSclass("space-between-content", (HtmlBasedComponent)this.toolBar);
            more.addEventListener("onClick", evt -> this.toolbarPopup.open((Component)more, "before_end"));
        }
        if (this.m_isCanExport) {
            this.uploadServicesMap = MAuthorizationAccount.getUserUploadServices();
            if (this.uploadServicesMap.size() > 0) {
                this.bCloudUpload.setName("CloudUpload");
                if (ThemeManager.isUseFontIconForImage()) {
                    this.bCloudUpload.setIconSclass("z-icon-FileImport");
                } else {
                    this.bCloudUpload.setImage(ThemeManager.getThemeResource("images/FileImport24.png"));
                }
                this.bCloudUpload.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"CloudUpload")));
                if (this.toolbarPopup != null) {
                    toolbarPopupLayout.appendChild((Component)this.bCloudUpload);
                    this.bCloudUpload.setLabel(this.bCloudUpload.getTooltiptext());
                } else {
                    this.toolBar.appendChild((Component)this.bCloudUpload);
                }
                this.bCloudUpload.addEventListener("onClick", this);
            }
        }
        North north = new North();
        layout.appendChild((Component)north);
        north.appendChild((Component)this.toolBar);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)north, "min");
        this.center = new Center();
        layout.appendChild((Component)this.center);
        this.iframe = new Iframe();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.iframe, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.iframe, "100%");
        this.iframe.setId("reportFrame");
        this.center.appendChild((Component)this.iframe);
        South south = new South();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)south, "50px");
        layout.appendChild((Component)south);
        this.reportLink = new A();
        this.reportLink.setTarget("_blank");
        Div linkDiv = new Div();
        linkDiv.setStyle("width:100%; height: 40px; padding: 4px;");
        linkDiv.appendChild((Component)this.reportLink);
        this.rowCount = new Label();
        this.rowCount.setStyle("float: right;");
        linkDiv.appendChild((Component)this.rowCount);
        if (this.m_reportEngine.getPrintData() != null) {
            this.rowCount.setText(Msg.getMsg((Properties)this.m_ctx, (String)"RowCount", (Object[])new Object[]{this.m_reportEngine.getPrintData().getRowCount(false)}));
        }
        south.appendChild((Component)linkDiv);
        int AD_Window_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_reportEngine.getWindowNo(), (String)"_WinInfo_AD_Window_ID", (boolean)true);
        if (AD_Window_ID == 0) {
            AD_Window_ID = Env.getZoomWindowID((MQuery)this.m_reportEngine.getQuery());
        }
        this.m_AD_Process_ID = this.m_reportEngine.getPrintInfo() != null ? this.m_reportEngine.getPrintInfo().getAD_Process_ID() : 0;
        this.updateToolbarAccess(AD_Window_ID, this.m_AD_Process_ID);
        this.setBorder("normal");
        this.addEventListener("onZoom", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event instanceof ZoomEvent) {
                    Clients.clearBusy();
                    ZoomEvent ze = (ZoomEvent)event;
                    if (ze.getData() != null && ze.getData() instanceof MQuery) {
                        AEnv.zoom((MQuery)ze.getData());
                    }
                }
            }
        });
        this.addEventListener("onDrillAcross", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event instanceof DrillEvent) {
                    Clients.clearBusy();
                    DrillEvent de = (DrillEvent)event;
                    if (de.getData() != null && de.getData() instanceof DrillEvent.DrillData) {
                        DrillEvent.DrillData data = (DrillEvent.DrillData)de.getData();
                        AEnv.actionDrill(data, ZkReportViewer.this.m_WindowNo, ZkReportViewer.this.m_AD_Process_ID);
                    }
                }
            }
        });
        this.addEventListener("onDrillDown", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event instanceof DrillEvent) {
                    Clients.clearBusy();
                    DrillEvent de = (DrillEvent)event;
                    if (de.getData() != null && de.getData() instanceof DrillEvent.DrillData) {
                        DrillEvent.DrillData data = (DrillEvent.DrillData)de.getData();
                        ZkReportViewer.this.executeDrillDown(data, event.getTarget());
                    }
                }
            }
        });
        this.init = true;
        Events.echoEvent((String)"onPostInit", (Component)this, null);
        this.setTabOnCloseHandler();
    }

    private void setupPreviewType() {
        String selectedValue = null;
        if (this.previewType.getItemCount() > 0) {
            if (this.previewType.getSelectedIndex() >= 0) {
                selectedValue = (String)this.previewType.getSelectedItem().getValue();
            }
            this.previewType.getChildren().clear();
        }
        if (this.m_reportEngine.getPrintFormat().getJasperProcess_ID() > 0) {
            ValueNamePair[] valueNamePairArray = JasperPrintRenderer.getPreviewType(this.m_isCanExport);
            int n = valueNamePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValueNamePair vnp = valueNamePairArray[n2];
                ListItem li = this.previewType.appendItem(vnp.getName(), vnp.getValue());
                if (selectedValue != null && selectedValue.equals(li.getValue())) {
                    this.previewType.setSelectedItem(li);
                }
                ++n2;
            }
            if (this.summary != null) {
                this.summary.setVisible(false);
            }
        } else {
            for (String id : this.rendererMap.keySet()) {
                IReportViewerRenderer renderer = this.rendererMap.get(id);
                if (!renderer.isPreview(this.m_isCanExport)) continue;
                ListItem li = this.previewType.appendItem(renderer.getPreviewLabel(), renderer.getId());
                if (selectedValue == null || !selectedValue.equals(li.getValue())) continue;
                this.previewType.setSelectedItem(li);
            }
            if (this.summary != null) {
                this.summary.setVisible(true);
            }
        }
    }

    private void setTabOnCloseHandler() {
        Component parent = this.getParent();
        while (parent != null) {
            if (parent instanceof Tabpanel) {
                Tabpanel parentTabPanel = (Tabpanel)parent;
                parentTabPanel.setOnCloseHandler(t -> {});
                break;
            }
            parent = parent.getParent();
        }
    }

    private int getAD_Tab_ID(int AD_Table_ID) {
        int AD_Tab_ID = DB.getSQLValueEx(null, (String)"SELECT t.AD_Tab_ID FROM AD_Tab t INNER JOIN AD_Window w ON (t.AD_Window_ID=w.AD_Window_ID) INNER JOIN AD_Table tt ON (t.AD_Table_ID=tt.AD_Table_ID) WHERE tt.AD_Table_ID=? ORDER BY w.IsDefault DESC, t.SeqNo, ABS (tt.AD_Window_ID-t.AD_Window_ID)", (Object[])new Object[]{AD_Table_ID});
        return AD_Tab_ID;
    }

    private void renderReport() {
        this.media = null;
        ListItem selected = this.previewType.getSelectedItem();
        new RendererRunnable(this, (String)selected.getValue()).run();
    }

    private void onPreviewReport() {
        try {
            if (this.media == null) {
                this.iframe.setSrc(null);
                this.iframe.setContent(null);
                this.reportLink.setHref("");
                this.reportLink.setLabel("");
                if (this.rowCount != null) {
                    this.rowCount.setText("");
                }
                return;
            }
            ++this.mediaVersion;
            String url = Utils.getDynamicMediaURI((AbstractComponent)this, (int)this.mediaVersion, (String)this.media.getName(), (String)this.media.getFormat());
            String pdfJsUrl = AEnv.toPdfJsUrl(url);
            HttpServletRequest request = (HttpServletRequest)Executions.getCurrent().getNativeRequest();
            if (url.startsWith(request.getContextPath() + "/")) {
                url = url.substring((request.getContextPath() + "/").length());
            }
            this.reportLink.setHref(url);
            this.reportLink.setLabel(this.media.getName());
            ListItem selected = this.previewType.getSelectedItem();
            String outputType = (String)this.previewType.getSelectedItem().getValue();
            if (ClientInfo.isMobile()) {
                if (selected == null || PDF_OUTPUT_TYPE.equals(selected.getValue())) {
                    this.attachIFrame();
                    this.iframe.setSrc(pdfJsUrl);
                } else if (HTML_OUTPUT_TYPE.equals(outputType)) {
                    this.attachIFrame();
                    this.iframe.setSrc(null);
                    this.iframe.setContent((Media)this.media);
                } else {
                    IMediaView view = null;
                    boolean showOptions = false;
                    if (XLS_OUTPUT_TYPE.equals(outputType) || XLSX_OUTPUT_TYPE.equals(outputType)) {
                        view = XLS_OUTPUT_TYPE.equals(outputType) ? Extensions.getMediaView(EXCEL_MIME_TYPE, "xls", true) : Extensions.getMediaView(EXCEL_XML_MIME_TYPE, "xlsx", true);
                        showOptions = true;
                    } else if (CSV_OUTPUT_TYPE.equals(outputType)) {
                        view = Extensions.getMediaView(CSV_MIME_TYPE, "csv", true);
                        showOptions = true;
                    }
                    if (showOptions && (view != null || this.uploadServicesMap.size() > 0)) {
                        this.detachIFrame();
                        IMediaView fview = view;
                        WMediaOptions options = new WMediaOptions(this.media, fview != null ? () -> {
                            Component component = fview.renderMediaView((Component)this.center, this.media, true);
                        } : null, this.uploadServicesMap);
                        options.setPage(this.getPage());
                        options.doHighlighted();
                    } else {
                        this.attachIFrame();
                        this.iframe.setSrc(null);
                        this.iframe.setContent(null);
                        String script = "zk.Widget.$('#" + this.reportLink.getUuid() + "').$n().click();";
                        Clients.evalJavaScript((String)script);
                    }
                }
            } else if (MSysConfig.getBooleanValue((String)"ZK_USE_PDF_JS_VIEWER", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx())) && (selected == null || PDF_OUTPUT_TYPE.equals(selected.getValue()))) {
                this.attachIFrame();
                this.iframe.setSrc(pdfJsUrl);
            } else {
                IMediaView view = null;
                boolean showOptions = false;
                if (XLS_OUTPUT_TYPE.equals(outputType) || XLSX_OUTPUT_TYPE.equals(outputType)) {
                    view = XLS_OUTPUT_TYPE.equals(outputType) ? Extensions.getMediaView(EXCEL_MIME_TYPE, "xls", false) : Extensions.getMediaView(EXCEL_XML_MIME_TYPE, "xlsx", false);
                    showOptions = true;
                } else if (CSV_OUTPUT_TYPE.equals(outputType)) {
                    view = Extensions.getMediaView(CSV_MIME_TYPE, "csv", false);
                    showOptions = true;
                }
                if (showOptions && (view != null || this.uploadServicesMap.size() > 0)) {
                    this.detachIFrame();
                    IMediaView fview = view;
                    WMediaOptions options = new WMediaOptions(this.media, fview != null ? () -> {
                        Component component = fview.renderMediaView((Component)this.center, this.media, true);
                    } : null, this.uploadServicesMap);
                    options.setPage(this.getPage());
                    options.doHighlighted();
                } else {
                    this.attachIFrame();
                    this.iframe.setSrc(null);
                    this.iframe.setContent((Media)this.media);
                }
            }
            this.revalidate();
        }
        finally {
            this.hideBusyDialog();
        }
    }

    private void detachIFrame() {
        this.center.getChildren().clear();
    }

    private void attachIFrame() {
        if (this.iframe != null && this.iframe.getPage() == null) {
            this.center.getChildren().clear();
            this.center.appendChild((Component)this.iframe);
        }
    }

    private void dynInit() {
        this.summary.addActionListener(this);
        this.fillComboReport(this.m_reportEngine.getPrintFormat().get_ID());
        this.revalidate();
        if ("replace".equals(this.getAttribute("insertPosition")) && this.m_reportEngine != null && this.m_reportEngine.getProcessInfo() != null) {
            ProcessInfo pi = this.m_reportEngine.getProcessInfo();
            this.checkProcessInfo(pi);
        }
    }

    private void checkProcessInfo(ProcessInfo pi) {
        ProcessInfoUtil.setLogFromDB((ProcessInfo)pi);
        if (pi.isError() || pi.getLogs() != null && pi.getLogs().length > 0) {
            ProcessInfoDialog dialog = new ProcessInfoDialog(pi, false);
            dialog.setAutoCloseAfterZoom(false);
            dialog.setPage(this.getPage());
            dialog.doHighlighted();
        }
    }

    private void fillComboReport(int AD_PrintFormat_ID) {
        KeyNamePair pp;
        block11: {
            this.comboReport.removeEventListener("onSelect", this);
            this.comboReport.getItems().clear();
            KeyNamePair selectValue = null;
            int AD_Window_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_reportEngine.getWindowNo(), (String)"_WinInfo_AD_Window_ID", (boolean)true);
            if (AD_Window_ID == 0) {
                AD_Window_ID = Env.getZoomWindowID((MQuery)this.m_reportEngine.getQuery());
            }
            int reportViewID = this.m_reportEngine.getPrintFormat().getAD_ReportView_ID();
            String sql = MRole.getDefault().addAccessSQL("SELECT * FROM AD_PrintFormat WHERE AD_Table_ID=? AND IsActive='Y' " + (AD_Window_ID > 0 ? "AND (AD_Window_ID=? OR AD_Window_ID IS NULL) " : "") + (reportViewID > 0 ? "AND AD_ReportView_ID=? " : "") + "ORDER BY Name", "AD_PrintFormat", false, false);
            int AD_Table_ID = this.m_reportEngine.getPrintFormat().getAD_Table_ID();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    int idx = 1;
                    pstmt.setInt(idx++, AD_Table_ID);
                    if (AD_Window_ID > 0) {
                        pstmt.setInt(idx++, AD_Window_ID);
                    }
                    if (reportViewID > 0) {
                        pstmt.setInt(idx++, reportViewID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MPrintFormat printFormat = new MPrintFormat(Env.getCtx(), rs, null);
                        pp = new KeyNamePair(printFormat.get_ID(), printFormat.get_Translation("Name", Env.getAD_Language((Properties)Env.getCtx()), true));
                        ListItem li = this.comboReport.appendItem(pp.getName(), pp.getKey());
                        if (rs.getInt(1) != AD_PrintFormat_ID) continue;
                        selectValue = pp;
                        if (selectValue != null) {
                            this.previousSelected = this.comboReport.getSelectedItem();
                        }
                        this.comboReport.setSelectedItem(li);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        int pfAD_Window_ID = MPrintFormat.getZoomWindowID((int)AD_PrintFormat_ID);
        if (MRole.getDefault().isTableAccess(493, false) && Boolean.TRUE.equals(MRole.getDefault().getWindowAccess(pfAD_Window_ID))) {
            StringBuffer sb = new StringBuffer("** ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"NewReport")).append(" **");
            pp = new KeyNamePair(-1, sb.toString());
            this.comboReport.appendItem(pp.getName(), pp.getKey());
            sb = new StringBuffer("** ").append(Msg.getMsg((Properties)this.m_ctx, (String)"CopyReport")).append(" **");
            pp = new KeyNamePair(-2, sb.toString());
            this.comboReport.addItem(pp);
        }
        this.comboReport.addEventListener("onSelect", this);
    }

    private void revalidate() {
        this.setTitle(Util.cleanAmp((String)(Msg.getMsg((Properties)Env.getCtx(), (String)"Report") + ": " + this.m_reportEngine.getName())));
        StringBuilder sb = new StringBuilder();
        sb.append(Msg.getMsg((Properties)Env.getCtx(), (String)"DataCols")).append("=").append(this.m_reportEngine.getColumnCount()).append(", ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"DataRows")).append("=").append(this.m_reportEngine.getRowCount());
        this.statusBar.setStatusLine(sb.toString());
        this.bWizard.setDisabled(this.m_reportEngine.getPrintFormat() == null || this.m_reportEngine.getPrintFormat().getAD_Client_ID() == 0 && Env.getAD_Client_ID((Properties)Env.getCtx()) != 0 || this.m_reportEngine.getPrintFormat().isForm());
        this.updateRowCount();
        this.invalidate();
    }

    public void onClose() {
        this.cleanUp();
        super.onClose();
    }

    private void cleanUp() {
        if (this.m_reportEngine != null || this.m_WindowNo >= 0) {
            SessionManager.getAppDesktop().unregisterWindow(this.m_WindowNo);
            this.m_reportEngine = null;
            this.m_ctx = null;
            this.m_WindowNo = -1;
        }
    }

    public void onEvent(Event event) throws Exception {
        if (event.getName().equals("onClick") || event.getName().equals("onSelect")) {
            this.actionPerformed(event);
        } else if (event.getTarget() == this.summary) {
            this.m_reportEngine.setSummary(this.summary.isSelected());
            this.cmd_report();
        } else if (event.getName().equals(ON_RENDER_REPORT_EVENT)) {
            this.onRenderReportEvent();
        } else if (event.getName().equals("onCtrlKey")) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (LayoutUtils.isReallyVisible((Component)this)) {
                this.onCtrlKeyEvent(keyEvent);
            }
        } else if (event.getTarget() instanceof ProcessModalDialog) {
            if ("onWindowClose".equals(event.getName())) {
                ProcessInfo pi;
                this.hideBusyMask();
                ProcessModalDialog dialog = (ProcessModalDialog)event.getTarget();
                if (dialog.isCancel() && this.getDesktop() != null) {
                    this.clearTabOnCloseHandler();
                }
                if ((pi = dialog.getProcessInfo()) != null) {
                    this.checkProcessInfo(pi);
                }
            }
        } else if ("onCloseWindowShortcut".equals(event.getName())) {
            IDesktop desktop = SessionManager.getAppDesktop();
            if (this.m_WindowNo > 0 && desktop.isCloseTabWithShortcut()) {
                desktop.closeWindow(this.m_WindowNo);
            } else {
                desktop.setCloseTabWithShortcut(true);
            }
        }
    }

    private void cmd_upload() {
        if (this.media == null) {
            return;
        }
        WReportUploadDialog winUploadFile = new WReportUploadDialog(this);
        winUploadFile.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"CloudUpload") + ": " + this.getTitle());
        winUploadFile.setAttribute("mode", "highlighted");
        AEnv.showWindow(winUploadFile);
    }

    private void onCtrlKeyEvent(KeyEvent keyEvent) {
        if ((keyEvent.isAltKey() && keyEvent.getKeyCode() == 88 || keyEvent.getKeyCode() == 27 && this.isUseEscForTabClosing) && this.m_WindowNo > 0) {
            keyEvent.stopPropagation();
            SessionManager.getAppDesktop().closeWindow(this.m_WindowNo);
        }
    }

    private void onRenderReportEvent() {
        this.renderReport();
    }

    public void actionPerformed(Event e) {
        if (this.m_setting) {
            return;
        }
        if (e.getTarget() == this.comboReport) {
            this.cmd_report();
        } else if (MClient.get((Properties)this.m_ctx).isMultiLingualDocument() && e.getTarget() == this.wLanguage.getComponent()) {
            this.cmd_report();
        } else if (e.getTarget() == this.bFind) {
            this.cmd_find();
        } else if (e.getTarget() == this.bExport) {
            this.cmd_export();
        } else if (e.getTarget() == this.previewType) {
            this.cmd_render();
        } else if (e.getTarget() == this.bSendMail) {
            this.cmd_sendMail();
        } else if (e.getTarget() == this.bArchive) {
            this.cmd_archive();
        } else if (e.getTarget() == this.bAttachment) {
            this.cmd_attachment();
        } else if (e.getTarget() == this.bCustomize) {
            this.cmd_customize();
        } else if (e.getTarget() == this.bWizard) {
            this.cmd_Wizard();
        } else if (e.getTarget() == this.bRefresh) {
            this.cmd_refresh();
        } else if (e.getTarget() == this.bReRun) {
            this.cmd_reRun();
        } else if (e.getTarget() == this.m_ddM) {
            this.cmd_window(this.m_ddQ);
        } else if (e.getTarget() == this.m_daM) {
            this.cmd_window(this.m_daQ);
        } else if (e.getTarget() == this.bCloudUpload) {
            this.cmd_upload();
        }
    }

    private void cmd_render() {
        this.postRenderReportEvent();
    }

    private void executeDrillDown(DrillEvent.DrillData data, Component component) {
        int AD_Table_ID = MTable.getTable_ID((String)data.getQuery().getTableName());
        if (!MRole.getDefault().isCanReport(AD_Table_ID)) {
            Dialog.error(this.m_WindowNo, "AccessCannotReport", data.getQuery().getTableName());
            return;
        }
        if (AD_Table_ID != 0) {
            new WReport(AD_Table_ID, data.getQuery(), component, this.m_WindowNo);
        } else {
            log.warning("No Table found for " + data.getQuery().getWhereClause(true));
        }
    }

    private void cmd_window(MQuery query) {
        if (query == null) {
            return;
        }
        AEnv.zoom(query);
    }

    private void cmd_sendMail() {
        String to = "";
        MUser from = MUser.get((Properties)Env.getCtx(), (int)Env.getAD_User_ID((Properties)Env.getCtx()));
        String subject = this.m_reportEngine.getName();
        String message = "";
        File attachment = null;
        try {
            attachment = new File(FileUtil.getTempMailName((String)subject, (String)".pdf"));
            this.m_reportEngine.getPDF(attachment);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        WEMailDialog dialog = new WEMailDialog(Msg.getMsg((Properties)Env.getCtx(), (String)"SendMail"), from, to, subject, message, (DataSource)new FileDataSource(attachment), this.m_WindowNo, this.m_reportEngine.getPrintInfo().getAD_Table_ID(), this.m_reportEngine.getPrintInfo().getRecord_ID(), this.m_reportEngine.getPrintInfo().getRecord_UU(), this.m_reportEngine.getPrintInfo());
        AEnv.showWindow(dialog);
    }

    private void cmd_archive() {
        boolean success = false;
        byte[] data = Document.getPDFAsArray((Pageable)this.m_reportEngine.getLayout().getPageable(false));
        if (data != null) {
            MArchive archive = new MArchive(Env.getCtx(), this.m_reportEngine.getPrintInfo(), null);
            archive.setBinaryData(data);
            success = archive.save();
        }
        if (success) {
            Dialog.info(this.m_WindowNo, "Archived");
        } else {
            Dialog.error(this.m_WindowNo, "ArchiveError");
        }
    }

    private void cmd_attachment() {
        int tableId = this.m_reportEngine.getPrintInfo().getAD_Table_ID();
        int recordId = this.m_reportEngine.getPrintInfo().getRecord_ID();
        if (tableId == 0 || recordId == 0) {
            return;
        }
        boolean success = false;
        MTable table2 = MTable.get((int)tableId);
        PO po = table2.getPO(recordId, null);
        MAttachment attachment = po.createAttachment();
        byte[] data = this.media.isBinary() ? this.media.getByteData() : this.media.getStringData().getBytes();
        String fileName = this.m_reportEngine.getName().replace(" ", "_") + "." + this.media.getFormat();
        attachment.addEntry(fileName, data);
        success = attachment.save();
        if (success) {
            Dialog.info(this.m_WindowNo, "DocumentAttached", fileName);
        } else {
            Dialog.error(this.m_WindowNo, "AttachError");
        }
    }

    private void cmd_export() {
        if (!this.m_isCanExport) {
            Dialog.error(this.m_WindowNo, "AccessCannotExport", this.getTitle());
            return;
        }
        WReportExportDialog winExportFile = new WReportExportDialog(this);
        winExportFile.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"Export") + ": " + this.getTitle());
        winExportFile.setAttribute("mode", "highlighted");
        AEnv.showWindow(winExportFile);
    }

    private void resetPrintFormatTrl(MPrintFormat pf) {
        String sql = "UPDATE AD_PrintFormat_Trl pf  SET Name = '" + pf.getName() + "'  WHERE pf.AD_PrintFormat_ID = " + pf.getAD_PrintFormat_ID();
        DB.executeUpdate((String)sql, null);
    }

    private void cmd_report() {
        ListItem li = this.comboReport.getSelectedItem();
        if (li == null || li.getValue() == null) {
            return;
        }
        Object pp = li.getValue();
        if (pp == null) {
            return;
        }
        this.jasperPrintRenderer = null;
        this.setTabOnCloseHandler();
        MPrintFormat pf = null;
        int AD_PrintFormat_ID = Integer.valueOf(pp.toString());
        if (AD_PrintFormat_ID == -1) {
            WStringEditor editor = new WStringEditor();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)((WEditor)editor).getComponent(), "98%");
            Dialog.askForInputWithCancel(this.m_WindowNo, editor, "CreateNewPrintFormat", Msg.getMsg((Properties)this.m_ctx, (String)"CreateNewPrintFormatTitle"), new Callback<Map.Entry<Boolean, Object>>(){

                public void onCallback(Map.Entry<Boolean, Object> result) {
                    if (result == null || !(result.getValue() instanceof String) || !result.getKey().booleanValue()) {
                        ZkReportViewer.this.comboReport.setSelectedItem(ZkReportViewer.this.previousSelected);
                        return;
                    }
                    MPrintFormat pf = null;
                    if (!Util.isEmpty((String)((String)result.getValue()))) {
                        int AD_ReportView_ID = ZkReportViewer.this.m_reportEngine.getPrintFormat().getAD_ReportView_ID();
                        if (AD_ReportView_ID != 0) {
                            String name = (String)result.getValue();
                            pf = MPrintFormat.createFromReportView((Properties)ZkReportViewer.this.m_ctx, (int)AD_ReportView_ID, (String)name);
                        } else {
                            int AD_Table_ID = ZkReportViewer.this.m_reportEngine.getPrintFormat().getAD_Table_ID();
                            pf = MPrintFormat.createFromTable((Properties)ZkReportViewer.this.m_ctx, (int)AD_Table_ID);
                        }
                        if (pf != null) {
                            pf.setName((String)result.getValue());
                            if (!pf.save()) {
                                Calendar cal = Calendar.getInstance();
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                                String dt = sdf.format(cal.getTime());
                                pf.setName(pf.getName() + "_" + dt);
                                pf.saveEx();
                            }
                        } else {
                            return;
                        }
                        ZkReportViewer.this.resetPrintFormatTrl(pf);
                        ZkReportViewer.this.fillComboReport(pf.get_ID());
                        if (ZkReportViewer.this.m_reportEngine.getPrintFormat() != null) {
                            ZkReportViewer.this.setLanguage();
                            pf.setLanguage(ZkReportViewer.this.m_reportEngine.getPrintFormat().getLanguage());
                            pf.setTranslationLanguage(ZkReportViewer.this.m_reportEngine.getPrintFormat().getLanguage());
                        }
                        if (ZkReportViewer.this.m_reportEngine.getPrintFormat().getJasperProcess_ID() != pf.getJasperProcess_ID()) {
                            ZkReportViewer.this.m_reportEngine.setPrintFormat(pf);
                            ZkReportViewer.this.setupPreviewType();
                            if (ZkReportViewer.this.m_reportEngine.getPrintFormat().getJasperProcess_ID() == 0) {
                                ZkReportViewer.this.m_reportEngine.setQuery(ZkReportViewer.this.m_reportEngine.getQuery());
                                ZkReportViewer.this.m_reportEngine.getLayout();
                            }
                        } else {
                            ZkReportViewer.this.m_reportEngine.setPrintFormat(pf);
                        }
                        ZkReportViewer.this.m_reportEngine.initName();
                        ZkReportViewer.this.postRenderReportEvent();
                    } else {
                        ZkReportViewer.this.comboReport.setSelectedItem(ZkReportViewer.this.previousSelected);
                    }
                }
            });
        } else if (AD_PrintFormat_ID == -2) {
            WStringEditor editor = new WStringEditor();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)((WEditor)editor).getComponent(), "90%");
            Dialog.askForInputWithCancel(this.m_WindowNo, editor, "CreatePrintFormatCopy", Msg.getMsg((Properties)this.m_ctx, (String)"CreatePrintFormatCopyTitle"), new Callback<Map.Entry<Boolean, Object>>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void onCallback(Map.Entry<Boolean, Object> result) {
                    if (result == null || !(result.getValue() instanceof String) || !result.getKey().booleanValue()) {
                        ZkReportViewer.this.comboReport.setSelectedItem(ZkReportViewer.this.previousSelected);
                        return;
                    }
                    MPrintFormat pf = null;
                    if (!Util.isEmpty((String)((String)result.getValue()))) {
                        MPrintFormat current = ZkReportViewer.this.m_reportEngine.getPrintFormat();
                        if (current == null) return;
                        pf = MPrintFormat.copyToClient((Properties)ZkReportViewer.this.m_ctx, (int)current.getAD_PrintFormat_ID(), (int)Env.getAD_Client_ID((Properties)ZkReportViewer.this.m_ctx));
                        if (pf == null) return;
                        pf.setName((String)result.getValue());
                        if (!pf.save()) {
                            Calendar cal = Calendar.getInstance();
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                            String dt = sdf.format(cal.getTime());
                            pf.setName(pf.getName() + "_" + dt);
                            pf.saveEx();
                        }
                        ZkReportViewer.this.resetPrintFormatTrl(pf);
                        ZkReportViewer.this.fillComboReport(pf.get_ID());
                        if (ZkReportViewer.this.m_reportEngine.getPrintFormat() != null) {
                            ZkReportViewer.this.setLanguage();
                            pf.setLanguage(ZkReportViewer.this.m_reportEngine.getPrintFormat().getLanguage());
                            pf.setTranslationLanguage(ZkReportViewer.this.m_reportEngine.getPrintFormat().getLanguage());
                        }
                        ZkReportViewer.this.m_reportEngine.initName();
                        if (ZkReportViewer.this.m_reportEngine.getPrintFormat().getJasperProcess_ID() != pf.getJasperProcess_ID()) {
                            ZkReportViewer.this.m_reportEngine.setPrintFormat(pf);
                            ZkReportViewer.this.setupPreviewType();
                            if (ZkReportViewer.this.m_reportEngine.getPrintFormat().getJasperProcess_ID() == 0) {
                                ZkReportViewer.this.m_reportEngine.setQuery(ZkReportViewer.this.m_reportEngine.getQuery());
                                ZkReportViewer.this.m_reportEngine.getLayout();
                            }
                        } else {
                            ZkReportViewer.this.m_reportEngine.setPrintFormat(pf);
                        }
                        ZkReportViewer.this.postRenderReportEvent();
                        return;
                    } else {
                        ZkReportViewer.this.comboReport.setSelectedItem(ZkReportViewer.this.previousSelected);
                    }
                }
            });
        } else {
            pf = MPrintFormat.get((Properties)Env.getCtx(), (int)AD_PrintFormat_ID, (boolean)true);
            if (this.m_reportEngine.getPrintFormat() != null) {
                this.setLanguage();
                pf.setLanguage(this.m_reportEngine.getPrintFormat().getLanguage());
                pf.setTranslationLanguage(this.m_reportEngine.getPrintFormat().getLanguage());
            }
            if (this.m_reportEngine.getPrintFormat().getJasperProcess_ID() != pf.getJasperProcess_ID()) {
                this.m_reportEngine.setPrintFormat(pf);
                this.setupPreviewType();
                if (this.m_reportEngine.getPrintFormat().getJasperProcess_ID() == 0) {
                    this.m_reportEngine.setQuery(this.m_reportEngine.getQuery());
                    this.m_reportEngine.getLayout();
                }
            } else {
                this.m_reportEngine.setPrintFormat(pf);
            }
            this.m_reportEngine.initName();
            this.postRenderReportEvent();
        }
        this.setTitle(Util.cleanAmp((String)(Msg.getMsg((Properties)Env.getCtx(), (String)"Report") + ": " + this.m_reportEngine.getName())));
    }

    private void cmd_refresh() {
        int AD_Process_ID;
        int n = AD_Process_ID = this.m_reportEngine.getPrintInfo() != null ? this.m_reportEngine.getPrintInfo().getAD_Process_ID() : 0;
        if (AD_Process_ID <= 0 || this.m_reportEngine.getPrintInfo().getRecord_ID() > 0) {
            this.cmd_report();
        } else {
            this.cmd_reRun("S");
        }
    }

    private void cmd_reRun() {
        this.cmd_reRun(null);
    }

    private void cmd_reRun(String showHelp) {
        int AD_Process_ID;
        int n = AD_Process_ID = this.m_reportEngine.getPrintInfo() != null ? this.m_reportEngine.getPrintInfo().getAD_Process_ID() : 0;
        if (AD_Process_ID <= 0) {
            return;
        }
        ProcessInfo pi = new ProcessInfo("RefreshWithParameters", AD_Process_ID);
        pi.setLanguageID(this.m_reportEngine.getLanguageID());
        pi.setReportType(this.m_reportEngine.getReportType());
        pi.setSerializableObject((Serializable)this.m_reportEngine.getPrintFormat());
        pi.setReplaceTabContent();
        if (!Util.isEmpty((String)showHelp)) {
            pi.setShowHelp(showHelp);
        }
        this.setTabOnCloseHandler();
        String predefined = (String)this.getAttribute("__PredefinedContextVariables__");
        if (!Util.isEmpty((String)predefined, (boolean)true)) {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"__PredefinedContextVariables__", (String)predefined);
            Env.setPredefinedVariables((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)predefined);
        }
        if (this.getAttribute("IsSOTrx") != null) {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"IsSOTrx", (String)this.getAttribute("IsSOTrx").toString());
        }
        ProcessModalDialog processModalDialog = new ProcessModalDialog(this, this.m_WindowNo, pi);
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)processModalDialog, 850);
        this.getParent().appendChild((Component)processModalDialog);
        if (ClientInfo.isMobile()) {
            processModalDialog.doHighlighted();
        } else {
            this.showBusyMask(processModalDialog);
            LayoutUtils.openOverlappedWindow((Component)this, processModalDialog, "middle_center");
        }
        processModalDialog.focus();
    }

    protected void setLanguage() {
        if (MClient.get((Properties)this.m_ctx).isMultiLingualDocument() && this.wLanguage != null && this.wLanguage.getValue() != null) {
            MLanguage language = new MLanguage(this.m_ctx, ((Integer)this.wLanguage.getValue()).intValue(), null);
            Language lang = new Language(language.getName(), language.getAD_Language(), language.getLocale());
            this.m_reportEngine.setLanguageID(language.getAD_Language_ID());
            this.m_reportEngine.getPrintFormat().setLanguage(lang);
            this.m_reportEngine.getPrintFormat().setTranslationLanguage(lang);
        }
    }

    protected void setPreviewType() {
        String type = Objects.toString(this.previewType.getValue());
        if (type == null) {
            type = this.m_reportEngine.getPrintFormat().isForm() ? MSysConfig.getValue((String)"ZK_REPORT_FORM_OUTPUT_TYPE", (String)PDF_OUTPUT_TYPE, (int)Env.getAD_Client_ID((Properties)this.m_ctx), (int)Env.getAD_Org_ID((Properties)this.m_ctx)) : MSysConfig.getValue((String)"ZK_REPORT_TABLE_OUTPUT_TYPE", (String)PDF_OUTPUT_TYPE, (int)Env.getAD_Client_ID((Properties)this.m_ctx), (int)Env.getAD_Org_ID((Properties)this.m_ctx));
        }
        this.m_reportEngine.setReportType(type);
    }

    private void postRenderReportEvent() {
        this.showBusyDialog();
        this.setLanguage();
        this.setPreviewType();
        Events.echoEvent((String)ON_RENDER_REPORT_EVENT, (Component)this, null);
    }

    private void cmd_find() {
        String title = null;
        String tableName = null;
        int AD_Table_ID = this.m_reportEngine.getPrintFormat().getAD_Table_ID();
        int AD_Tab_ID = this.getAD_Tab_ID(AD_Table_ID);
        MClient client = MClient.get((Properties)Env.getCtx());
        Object ASPFilter = "";
        if (client.isUseASP()) {
            ASPFilter = "     AND (   AD_Tab_ID IN (               SELECT t.AD_Tab_ID                 FROM ASP_Tab t, ASP_Window w, ASP_Level l, ASP_ClientLevel cl                WHERE w.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID                  AND t.ASP_Window_ID = w.ASP_Window_ID                  AND t.IsActive = 'Y'                  AND w.IsActive = 'Y'                  AND l.IsActive = 'Y'                  AND cl.IsActive = 'Y'                  AND t.ASP_Status = 'S')         OR AD_Tab_ID IN (               SELECT AD_Tab_ID                 FROM ASP_ClientException ce                WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND ce.IsActive = 'Y'                  AND ce.AD_Tab_ID IS NOT NULL                  AND ce.AD_Field_ID IS NULL                  AND ce.ASP_Status = 'S')        )    AND AD_Tab_ID NOT IN (           SELECT AD_Tab_ID             FROM ASP_ClientException ce            WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y'              AND ce.AD_Tab_ID IS NOT NULL              AND ce.AD_Field_ID IS NULL              AND ce.ASP_Status = 'H')";
        }
        String sql = null;
        sql = !Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Tab") ? "SELECT Name, TableName FROM AD_Tab_vt WHERE AD_Tab_ID=? AND AD_Language='" + Env.getAD_Language((Properties)Env.getCtx()) + "' " + (String)ASPFilter : "SELECT Name, TableName FROM AD_Tab_v WHERE AD_Tab_ID=? " + (String)ASPFilter;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, AD_Tab_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    title = rs.getString(1);
                    tableName = rs.getString(2);
                }
            }
            catch (SQLException e) {
                throw new DBException((Exception)e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        GridField[] findFields = null;
        if (tableName != null) {
            findFields = GridField.createFields((Properties)this.m_ctx, (int)this.m_WindowNo, (int)0, (int)AD_Tab_ID);
        }
        if (findFields == null) {
            this.bFind.setVisible(false);
        } else {
            if (this.find == null) {
                this.find = Extensions.getFindWindow(this.m_WindowNo, 0, title, AD_Table_ID, tableName, this.m_reportEngine.getWhereExtended(), findFields, 1, AD_Tab_ID, null);
                if (!this.find.initialize()) {
                    this.find = null;
                    return;
                }
                this.find.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        if (!ZkReportViewer.this.find.isCancel()) {
                            ZkReportViewer.this.m_reportEngine.setQuery(ZkReportViewer.this.find.getQuery());
                            ZkReportViewer.this.postRenderReportEvent();
                        }
                    }
                });
                this.setupFindwindow(this.find);
            }
            this.getParent().appendChild((Component)this.find);
            LayoutUtils.openHighlightedWindow((Component)this.toolBar, this.find, "after_start");
            LayoutUtils.sameWidth((HtmlBasedComponent)this.find, (HtmlBasedComponent)this);
        }
    }

    private void cmd_customize() {
        int AD_PrintFormat_ID = this.m_reportEngine.getPrintFormat().get_ID();
        int pfAD_Window_ID = MPrintFormat.getZoomWindowID((int)AD_PrintFormat_ID);
        AEnv.zoom(pfAD_Window_ID, MQuery.getEqualQuery((String)"AD_PrintFormat_ID", (int)AD_PrintFormat_ID));
    }

    private void cmd_Wizard() {
        ADForm form = ADForm.openForm(200002);
        WReportCustomization av = (WReportCustomization)form.getICustomForm();
        av.setReportEngine(this.m_reportEngine);
        form.setClosable(true);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)form, "70%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)form, "85%");
        form.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if ("onWindowClose".equals(event.getName())) {
                    ZkReportViewer.this.fillComboReport(ZkReportViewer.this.m_reportEngine.getPrintFormat().get_ID());
                    ZkReportViewer.this.cmd_report();
                }
            }
        });
        form.setAttribute("mode", "highlighted");
        SessionManager.getAppDesktop().showWindow(form);
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    public void updateToolbarAccess(int AD_Window_ID, int AD_Process_ID) {
        int[] restrictionList;
        if (this.ToolBarMenuRestictionLoaded) {
            return;
        }
        Properties m_ctx = Env.getCtx();
        int ToolBarButton_ID = 0;
        int[] nArray = restrictionList = AD_Window_ID > 0 ? MToolBarButtonRestrict.getOfWindow((Properties)m_ctx, (int)MRole.getDefault().getAD_Role_ID(), (int)AD_Window_ID, (boolean)true, null) : MToolBarButtonRestrict.getOfReport((Properties)m_ctx, (int)MRole.getDefault().getAD_Role_ID(), (int)AD_Process_ID, null);
        if (log.isLoggable(Level.INFO)) {
            log.info("restrictionList=" + restrictionList.toString());
        }
        int i = 0;
        while (i < restrictionList.length) {
            ToolBarButton_ID = restrictionList[i];
            X_AD_ToolBarButton tbt = new X_AD_ToolBarButton(m_ctx, ToolBarButton_ID, null);
            if ("R".equals(tbt.getAction())) {
                String restrictName = tbt.getComponentName();
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("tbt=" + tbt.getAD_ToolBarButton_ID() + " / " + restrictName);
                }
                Component p2 = this.toolBar.getFirstChild();
                while (p2 != null) {
                    if (p2 instanceof Toolbarbutton && restrictName.equals(((ToolBarButton)p2).getName())) {
                        this.toolBar.removeChild(p2);
                        break;
                    }
                    p2 = p2.getNextSibling();
                }
            }
            ++i;
        }
        this.ToolBarMenuRestictionLoaded = true;
    }

    private void showBusyDialog() {
        this.progressWindow = new BusyDialog();
        this.progressWindow.setStyle("position: absolute;");
        this.appendChild((Component)this.progressWindow);
        this.showBusyMask(this.progressWindow);
        LayoutUtils.openOverlappedWindow((Component)this, this.progressWindow, "middle_center");
    }

    private Div getMask() {
        if (this.mask == null) {
            this.mask = new Mask();
        }
        return this.mask;
    }

    private void showBusyMask(Window window) {
        this.getParent().appendChild((Component)this.getMask());
        StringBuilder script = new StringBuilder("(function(){let w=zk.Widget.$('#");
        script.append(this.getParent().getUuid()).append("');");
        if (window != null) {
            script.append("let d=zk.Widget.$('#").append(window.getUuid()).append("');w.busy=d;");
        } else {
            script.append("w.busy=true;");
        }
        script.append("})()");
        Clients.response((AuResponse)new AuScript(script.toString()));
    }

    public void hideBusyMask() {
        if (this.mask != null && this.mask.getParent() != null) {
            this.mask.detach();
            StringBuilder script = new StringBuilder("(function(){let w=zk.Widget.$('#");
            script.append(this.getParent().getUuid()).append("');if(w){w.busy=false;}");
            script.append("})()");
            Clients.response((AuResponse)new AuScript(script.toString()));
        }
    }

    private void hideBusyDialog() {
        this.hideBusyMask();
        if (this.progressWindow != null) {
            this.progressWindow.dispose();
            this.progressWindow = null;
        }
        if (this.getDesktop() != null) {
            this.clearTabOnCloseHandler();
        }
    }

    private void clearTabOnCloseHandler() {
        Executions.schedule((Desktop)this.getDesktop(), e -> {
            Component parent = this.getParent();
            while (parent != null) {
                if (parent instanceof Tabpanel) {
                    Tabpanel parentTabPanel = (Tabpanel)parent;
                    parentTabPanel.setOnCloseHandler(null);
                    break;
                }
                parent = parent.getParent();
            }
        }, (Event)new Event("onClearTabOnCloseHandler"));
    }

    private void createNewMedia(String rendererId) {
        this.media = null;
        this.media = this.getMedia(rendererId);
    }

    @Override
    public AMedia getMedia(String contentType, String fileExtension) {
        if (this.jasperPrintRenderer != null) {
            return this.jasperPrintRenderer.getMedia(contentType, fileExtension);
        }
        IReportViewerRenderer renderer = this.rendererMap.get(this.toRendererId(contentType, fileExtension));
        if (renderer.isSameContentForExportAndPreview() && this.media != null && this.media.getContentType().equals(contentType) && this.media.getFormat().equals(fileExtension)) {
            return this.media;
        }
        return renderer != null ? renderer.renderMedia(this, true) : null;
    }

    public AMedia getMedia(String rendererId) {
        if (this.jasperPrintRenderer != null) {
            return this.jasperPrintRenderer.getMedia(JasperPrintRenderer.getMIMEType(rendererId), JasperPrintRenderer.getFileExtension(rendererId));
        }
        IReportViewerRenderer renderer = this.rendererMap.get(rendererId);
        return renderer != null ? renderer.renderMedia(this, false) : null;
    }

    @Override
    public IReportViewerExportSource.ExportFormat[] getExportFormats() {
        if (this.jasperPrintRenderer != null) {
            return this.jasperPrintRenderer.getExportFormats();
        }
        return this.exportMap.keySet().toArray(new IReportViewerExportSource.ExportFormat[0]);
    }

    @Override
    public String getContentType() {
        return this.media != null ? this.media.getContentType() : null;
    }

    @Override
    public String getFileExtension() {
        return this.media != null ? this.media.getFormat() : null;
    }

    @Override
    public Map<MAuthorizationAccount, IUploadService> getUploadServiceMap() {
        return Collections.unmodifiableMap(this.uploadServicesMap);
    }

    @Override
    public String getReportName() {
        return this.m_reportEngine.getName();
    }

    public ReportEngine getReportEngine() {
        return this.m_reportEngine;
    }

    private void setupFindwindow(FindWindow findWindow) {
        findWindow.setTitle(null);
        findWindow.setBorder("none");
        if (ClientInfo.maxHeight(699)) {
            ZKUpdateUtil.setHeight((HtmlBasedComponent)findWindow, "100%");
        } else {
            ZKUpdateUtil.setHeight((HtmlBasedComponent)findWindow, "60%");
        }
        findWindow.setSizable(false);
        findWindow.setContentStyle("background-color: #fff; width: 99%; margin: auto;");
    }

    private void updateRowCount() {
        if (this.rowCount != null) {
            if (this.jasperPrintRenderer != null) {
                this.rowCount.setValue("");
            } else if (this.m_reportEngine.getPrintData() != null) {
                this.rowCount.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"RowCount", (Object[])new Object[]{this.m_reportEngine.getPrintData().getRowCount(false)}));
            } else {
                this.rowCount.setValue("");
            }
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)ZkReportViewer.this);
        }

        public Media getMedia(String pathInfo) {
            return ZkReportViewer.this.media;
        }
    }

    private static class RendererRunnable
    extends ZkContextRunnable
    implements IServerPushCallback {
        private ZkReportViewer viewer;
        private String rendererId;

        public RendererRunnable(ZkReportViewer viewer, String rendererId) {
            this.viewer = viewer;
            this.rendererId = rendererId;
        }

        @Override
        public void updateUI() {
            this.viewer.onPreviewReport();
        }

        protected void doRun() {
            try {
                try {
                    if (this.viewer.m_reportEngine.getPrintFormat().getJasperProcess_ID() > 0) {
                        if (this.viewer.jasperPrintRenderer == null) {
                            MPrintFormat format = this.viewer.m_reportEngine.getPrintFormat();
                            PrintInfo printInfo = this.viewer.m_reportEngine.getPrintInfo();
                            ProcessInfo jasperProcessInfo = new ProcessInfo(this.viewer.getTitle(), format.getJasperProcess_ID());
                            jasperProcessInfo.setRecord_ID(printInfo.getRecord_ID());
                            jasperProcessInfo.setTable_ID(printInfo.getAD_Table_ID());
                            jasperProcessInfo.setSerializableObject((Serializable)format);
                            ArrayList<ProcessInfoParameter> jasperPrintParams = new ArrayList<ProcessInfoParameter>();
                            ProcessInfoParameter pip = new ProcessInfoParameter("PRINT_FORMAT", (Object)format, null, null, null);
                            jasperPrintParams.add(pip);
                            pip = new ProcessInfoParameter("PRINT_INFO", (Object)printInfo, null, null, null);
                            jasperPrintParams.add(pip);
                            jasperProcessInfo.setParameter(jasperPrintParams.toArray(new ProcessInfoParameter[0]));
                            jasperProcessInfo.setExport(true);
                            jasperProcessInfo.setExportFileExtension("JasperPrint");
                            ProcessCall pc = Core.getProcess((String)"org.adempiere.report.jasper.ReportStarter");
                            pc.startProcess(Env.getCtx(), jasperProcessInfo, null);
                            JasperPrint jasperPrint = (JasperPrint)jasperProcessInfo.getInternalReportObject();
                            this.viewer.jasperPrintRenderer = new JasperPrintRenderer(jasperPrint, this.viewer.getTitle());
                            this.viewer.jasperPrintRenderer.setRowCount(jasperProcessInfo.getRowCount());
                        }
                    } else {
                        this.viewer.m_reportEngine.initName();
                        List<String> archiveList = Arrays.asList(ZkReportViewer.PDF_OUTPUT_TYPE, ZkReportViewer.HTML_OUTPUT_TYPE, ZkReportViewer.XLS_OUTPUT_TYPE, ZkReportViewer.XLSX_OUTPUT_TYPE);
                        if (archiveList.contains(this.rendererId) && !ArchiveEngine.isValid((LayoutEngine)this.viewer.m_reportEngine.getLayout())) {
                            log.warning("Cannot archive Document");
                        }
                    }
                    this.viewer.createNewMedia(this.rendererId);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
            finally {
                Desktop desktop = AEnv.getDesktop();
                if (desktop != null && desktop.isAlive()) {
                    new ServerPushTemplate(desktop).executeAsync(this);
                }
            }
        }
    }
}

