/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.util;

import fi.jawsy.jawwa.zk.atmosphere.AtmosphereServerPush;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import org.compiere.Adempiere;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class DesktopWatchDog {
    private static final DesktopWatchDog INSTANCE = new DesktopWatchDog();
    private final ConcurrentLinkedDeque<DesktopEntry> desktops = new ConcurrentLinkedDeque();

    private DesktopWatchDog() {
        Adempiere.getThreadPoolExecutor().scheduleWithFixedDelay(() -> this.doMonitoring(), 60L, 40L, TimeUnit.SECONDS);
    }

    private void doMonitoring() {
        Iterator<DesktopEntry> iterator = this.desktops.iterator();
        while (iterator.hasNext()) {
            ServerPush spush;
            DesktopEntry entry = iterator.next();
            if (!entry.desktop.isAlive()) {
                iterator.remove();
                continue;
            }
            if (!entry.desktop.isServerPushEnabled()) {
                ++entry.noAtmosphereResourceCount;
            }
            if ((spush = ((DesktopCtrl)entry.desktop).getServerPush()) == null) {
                ++entry.noAtmosphereResourceCount;
            } else if (spush instanceof AtmosphereServerPush) {
                AtmosphereServerPush asp = (AtmosphereServerPush)spush;
                entry.noAtmosphereResourceCount = !asp.hasAtmosphereResource() ? ++entry.noAtmosphereResourceCount : 0;
            }
            if (entry.noAtmosphereResourceCount < 5) continue;
            iterator.remove();
            try {
                WebApp wapp = entry.desktop.getWebApp();
                Session session = entry.desktop.getSession();
                DesktopCache desktopCache = ((WebAppCtrl)wapp).getDesktopCache(session);
                desktopCache.removeDesktop(entry.desktop);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void addDesktop(Desktop desktop) {
        DesktopWatchDog.INSTANCE.desktops.add(new DesktopEntry(desktop));
    }

    public static void removeDesktop(Desktop desktop) {
        Iterator<DesktopEntry> iterator = DesktopWatchDog.INSTANCE.desktops.iterator();
        while (iterator.hasNext()) {
            DesktopEntry entry = iterator.next();
            if (entry.desktop != desktop) continue;
            iterator.remove();
            break;
        }
    }

    public static void removeOtherDesktopsInSession(Desktop desktop) {
        Iterator<DesktopEntry> iterator = DesktopWatchDog.INSTANCE.desktops.iterator();
        while (iterator.hasNext()) {
            DesktopEntry entry = iterator.next();
            if (entry.desktop == desktop || entry.desktop.getSession() != desktop.getSession()) continue;
            iterator.remove();
            try {
                WebApp wapp = desktop.getWebApp();
                Session session = desktop.getSession();
                DesktopCache desktopCache = ((WebAppCtrl)wapp).getDesktopCache(session);
                desktopCache.removeDesktop(entry.desktop);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static final class DesktopEntry {
        Desktop desktop;
        int noAtmosphereResourceCount = 0;

        private DesktopEntry(Desktop desktop) {
            this.desktop = desktop;
        }
    }
}

