/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.ArrayList;
import java.util.List;
import org.adempiere.webui.component.Row;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Div;
import org.zkoss.zul.Label;
import org.zkoss.zul.Span;

public class Group
extends org.zkoss.zul.Group {
    private static final long serialVersionUID = -6735090880559291438L;
    public static final String GROUP_ROW_VISIBLE_KEY = "groupRowVisible";
    private List<Row> m_rows = new ArrayList<Row>();

    public Group() {
        this.setZclass("z-group");
    }

    public Group(String label) {
        super(label);
        this.setZclass("z-group");
    }

    public <T> Group(String label, T value) {
        super(label, value);
        this.setZclass("z-group");
    }

    public String getLabel() {
        Component cell = this.getFirstChild();
        return cell != null && cell instanceof GroupHeader ? ((GroupHeader)cell).getTitle() : null;
    }

    public void setLabel(String label) {
        this.autoFirstCell().setTitle(label);
    }

    private GroupHeader autoFirstCell() {
        Object cell = this.getFirstChild();
        if (cell == null || cell instanceof GroupHeader) {
            if (cell == null) {
                cell = new GroupHeader();
            }
            cell.applyProperties();
            cell.setParent((Component)this);
            return (GroupHeader)((Object)cell);
        }
        throw new UiException("Unsupported child for setLabel: " + String.valueOf(cell));
    }

    public void setOpen(boolean open) {
        super.setOpen(open);
        this.autoFirstCell().setOpen(this.isOpen());
        if (this.getParent() != null) {
            for (org.zkoss.zul.Row row : this.m_rows) {
                boolean visible = true;
                String value = (String)row.getAttribute(GROUP_ROW_VISIBLE_KEY);
                if (value != null) {
                    visible = value.equals("true");
                }
                row.setVisible(this.isOpen() && visible);
            }
        }
    }

    public void add(Row row) {
        this.m_rows.add(row);
    }

    public static class GroupHeader
    extends Cell
    implements EventListener<Event> {
        private static final long serialVersionUID = -4070011056533999557L;
        private Span span;
        private Label lbl;
        private String title;
        private boolean open;

        public GroupHeader() {
            this.init();
            this.setTitle(null);
            this.setOpen(true);
        }

        private void init() {
            this.setZclass("z-group-header");
            Div div = new Div();
            div.setZclass("z-group-header-body");
            this.appendChild((Component)div);
            this.span = new Span();
            div.appendChild((Component)this.span);
            this.span.addEventListener("onClick", (EventListener)this);
            this.span.setZclass("z-group-icon");
            this.lbl = new Label();
            this.lbl.setStyle("cursor: pointer");
            this.lbl.addEventListener("onClick", (EventListener)this);
            div.appendChild((Component)this.lbl);
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
            this.lbl.setValue(this.title);
        }

        public boolean isOpen() {
            return this.open;
        }

        public void setOpen(boolean open) {
            this.open = open;
            this.span.setSclass(this.open ? "z-group-icon-open" : "z-group-icon-close");
        }

        public void onEvent(Event e) throws Exception {
            if (e.getName().equals("onClick")) {
                ((Group)this.getParent()).setOpen(!this.isOpen());
            }
        }
    }
}

