/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.model.ZoomInfoFactory;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.compiere.model.MQuery;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.Popup;

public class WZoomAcross {
    private Menupopup m_popup = new Menupopup();
    private static final CLogger log = CLogger.getCLogger(WZoomAcross.class);
    private final List<ZoomInfoFactory.ZoomInfo> zoomInfos = new ArrayList<ZoomInfoFactory.ZoomInfo>();

    public WZoomAcross(Component invoker, String tableName, int windowID, MQuery query) {
        this(invoker, new Query(Env.getCtx(), tableName, query.getWhereClause(), null).first(), windowID);
    }

    public WZoomAcross(Component invoker, PO po, int windowID) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("PO=" + String.valueOf(po) + ", WindowID=" + windowID);
        }
        this.mkZoomTargets(po, windowID);
        for (final ZoomInfoFactory.ZoomInfo zoomInfo : this.zoomInfos) {
            String label = zoomInfo.destinationDisplay + " (#" + zoomInfo.query.getRecordCount() + ")";
            Menuitem menuItem = new Menuitem(label);
            menuItem.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    WZoomAcross.this.launchZoom(zoomInfo);
                }
            });
            this.m_popup.appendChild((Component)menuItem);
        }
        if (this.zoomInfos.isEmpty()) {
            Menuitem menuItem = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"NoZoomTarget"));
            this.m_popup.appendChild((Component)menuItem);
        }
        this.m_popup.setStyle("overflow: auto;max-height: 80%;");
        Popup popup = LayoutUtils.findPopup(invoker);
        if (popup != null) {
            popup.appendChild((Component)this.m_popup);
        } else {
            this.m_popup.setPage(invoker.getPage());
            LayoutUtils.autoDetachOnClose((Popup)this.m_popup);
        }
        this.m_popup.open(invoker, "after_start");
    }

    private void mkZoomTargets(PO po, int windowID) {
        for (ZoomInfoFactory.ZoomInfo zoomInfo : ZoomInfoFactory.retrieveZoomInfos((PO)po, (int)windowID)) {
            if (zoomInfo.query.getRecordCount() == 0) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("No target records for destination " + zoomInfo.destinationDisplay);
                continue;
            }
            this.zoomInfos.add(zoomInfo);
        }
    }

    private void launchZoom(ZoomInfoFactory.ZoomInfo zoomInfo) {
        int AD_Window_ID = zoomInfo.windowId;
        MQuery query = zoomInfo.query;
        if (log.isLoggable(Level.INFO)) {
            log.info("AD_Window_ID=" + AD_Window_ID + " - " + String.valueOf(query));
        }
        AEnv.zoom(AD_Window_ID, query);
    }
}

