/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.util.Objects;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.DateRangePicker;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zul.Div;

public class DateRangeEditor
extends Div
implements ValueChangeListener {
    private static final long serialVersionUID = 3329360781729704243L;
    private static final String IMAGES_CONTEXT_CALENDAR_PNG = "images/Calendar16.png";
    private Textbox textbox;
    private ToolBarButton popupBtn;
    private DateRangePicker popup;
    private WEditor editor;
    private WEditor editor2;
    private Label dateRangeText;

    public DateRangeEditor(WEditor editor, WEditor editor2) {
        this.editor = editor;
        this.editor2 = editor2;
        this.init();
    }

    private void init() {
        this.setWidth("100%");
        ZkCssHelper.appendStyle((HtmlBasedComponent)this, "display: inline-block; position: relative;");
        this.textbox = new Textbox();
        this.textbox.setStyle("width: 100%; background: white !important");
        this.textbox.setReadonly(true);
        this.appendChild((Component)this.textbox);
        this.popupBtn = new ToolBarButton();
        this.popupBtn.addSclass("date-picker-calendar-button");
        if (ThemeManager.isUseFontIconForImage()) {
            this.popupBtn.setIconSclass("z-icon-Calendar");
        } else {
            this.popupBtn.setImage(ThemeManager.getThemeResource(IMAGES_CONTEXT_CALENDAR_PNG));
        }
        this.appendChild((Component)this.popupBtn);
        this.popup = new DateRangePicker(this.editor, this.editor2);
        this.popupBtn.addEventListener("onClick", event -> {
            this.popup.setPage(this.popupBtn.getPage());
            this.popup.open((Component)this.popupBtn, "after_center");
            LayoutUtils.autoDetachOnClose(this.popup);
        });
        this.popup.addValueChangeListener(this);
        this.dateRangeText = new Label();
        this.appendChild((Component)this.dateRangeText);
        this.dateRangeText.setStyle("font-size: x-small;font-weight: normal;position: absolute;display: block;");
        this.dateRangeText.setVisible(false);
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        this.textbox.setValue(evt.getNewValue() != null ? evt.getNewValue().toString() : "");
        if (evt.getNewValue() != null) {
            if (this.textbox.getValue().equals(this.popup.getDateRangeText())) {
                this.dateRangeText.setValue("");
                this.dateRangeText.setVisible(false);
            } else {
                this.dateRangeText.setValue(this.popup.getDateRangeText());
                this.dateRangeText.setVisible(true);
                if (this.getPage() != null) {
                    LayoutUtils.positionComponent((Component)this.popupBtn, (Component)this.dateRangeText, "start_before");
                }
            }
        } else {
            this.dateRangeText.setValue("");
            this.dateRangeText.setVisible(false);
        }
    }

    public void setFieldMandatoryStyle() {
        if (this.isMandatoryStyle()) {
            LayoutUtils.addSclass("idempiere-mandatory", (HtmlBasedComponent)this.textbox);
        } else {
            LayoutUtils.removeSclass("idempiere-mandatory", (HtmlBasedComponent)this.textbox);
        }
    }

    private boolean isMandatoryStyle() {
        return this.editor.isMandatory() && this.editor.isReadWrite() && this.editor.getGridField().isEditable(true) && this.isNullOrEmpty(this.editor) || this.editor2.isMandatory() && this.editor2.isReadWrite() && this.editor2.getGridField().isEditable(true) && this.isNullOrEmpty(this.editor2);
    }

    private boolean isNullOrEmpty(WEditor editor) {
        Object value = editor.getValue();
        return Util.isEmpty((String)Objects.toString(value, ""), (boolean)true);
    }

    public void setReadOnly(boolean readOnly) {
        this.popupBtn.setDisabled(readOnly);
        if (readOnly) {
            this.textbox.setStyle("width: 100%;");
        } else {
            this.textbox.setStyle("width: 100%; background: white !important");
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null && this.dateRangeText.isVisible() && !Util.isEmpty((String)this.dateRangeText.getValue())) {
            LayoutUtils.positionComponent((Component)this.popupBtn, (Component)this.dateRangeText, "start_before");
        }
    }
}

