/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.IReportViewerExportSource;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Vbox;

public class WReportExportDialog
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 8580712975224551032L;
    private Listbox cboType = new Listbox();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private IReportViewerExportSource viewer;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    private static final CLogger log = CLogger.getCLogger(WReportExportDialog.class);

    public WReportExportDialog(IReportViewerExportSource viewer) {
        this.viewer = viewer;
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 450);
        ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 150);
        this.setClosable(true);
        this.setBorder("normal");
        this.setSclass("popup-dialog");
        this.setStyle("position:absolute");
        this.cboType.setMold("select");
        this.cboType.getItems().clear();
        IReportViewerExportSource.ExportFormat[] exportFormats = viewer.getExportFormats();
        Arrays.sort(exportFormats, new Comparator<IReportViewerExportSource.ExportFormat>(){

            @Override
            public int compare(IReportViewerExportSource.ExportFormat ef0, IReportViewerExportSource.ExportFormat ef1) {
                return ef0.label.compareTo(ef1.label);
            }
        });
        IReportViewerExportSource.ExportFormat[] exportFormatArray = exportFormats;
        int n = exportFormats.length;
        int n2 = 0;
        while (n2 < n) {
            IReportViewerExportSource.ExportFormat exportFormat = exportFormatArray[n2];
            ListItem item = this.cboType.appendItem(exportFormat.label, exportFormat);
            if (viewer.getContentType().equals(exportFormat.contentType) && viewer.getFileExtension().equals(exportFormat.extension)) {
                item.setSelected(true);
            }
            ++n2;
        }
        Hbox hb = new Hbox();
        hb.setSclass("dialog-content");
        hb.setAlign("center");
        hb.setPack("start");
        Div div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"FilesOfType")));
        hb.appendChild((Component)div);
        hb.appendChild((Component)this.cboType);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.cboType, "100%");
        Vbox vb = new Vbox();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vb, "100%");
        this.appendChild((Component)vb);
        vb.appendChild((Component)hb);
        vb.appendChild((Component)this.confirmPanel);
        LayoutUtils.addSclass("dialog-footer", (HtmlBasedComponent)this.confirmPanel);
        this.confirmPanel.addActionListener(this);
        this.addEventListener("onCancel", e -> this.onCancel());
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget().getId().equals("Cancel")) {
            this.onCancel();
        } else if (event.getTarget().getId().equals("Ok")) {
            this.exportFile();
        }
    }

    private void onCancel() {
        if (this.isUseEscForTabClosing) {
            SessionManager.getAppDesktop().setCloseTabWithShortcut(false);
        }
        this.onClose();
    }

    private void exportFile() {
        try {
            AMedia media = null;
            ListItem li = this.cboType.getSelectedItem();
            if (li == null || li.getValue() == null) {
                Dialog.error(-1, "FileInvalidExtension");
                return;
            }
            IReportViewerExportSource.ExportFormat exportFormat = (IReportViewerExportSource.ExportFormat)li.getValue();
            media = this.viewer.getMedia(exportFormat.contentType, exportFormat.extension);
            this.onClose();
            Filedownload.save((Media)media, (String)(this.viewer.getReportName() + "." + exportFormat.extension));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to export content.", (Throwable)e);
        }
    }
}

