/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.MField;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUserDefField;
import org.compiere.model.MUserDefTab;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Trx;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;

public class CustomizeUserDefTabGridView
extends Panel {
    private static final long serialVersionUID = 7728908639309012238L;
    protected MUserDefTab userDefTab = null;
    private int m_WindowNo;
    protected static final CLogger log = CLogger.getCLogger(CustomizeUserDefTabGridView.class);
    private int m_AD_UserDef_Tab_ID;
    private Label noLabel = new Label();
    private Label yesLabel = new Label();
    private Button bAdd = ButtonFactory.createButton(null, ThemeManager.getThemeResource("images/MoveRight16.png"), null);
    private Button bRemove = ButtonFactory.createButton(null, ThemeManager.getThemeResource("images/MoveLeft16.png"), null);
    private Button bUp = ButtonFactory.createButton(null, ThemeManager.getThemeResource("images/MoveUp16.png"), null);
    private Button bDown = ButtonFactory.createButton(null, ThemeManager.getThemeResource("images/MoveDown16.png"), null);
    private SimpleListModel noModel = new SimpleListModel();
    private SimpleListModel yesModel = new SimpleListModel();
    private Listbox noList = new Listbox();
    private Listbox yesList = new Listbox();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true, false, true, false, false, false);
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));

    public CustomizeUserDefTabGridView(int AD_UserDef_Tab_ID, int windowNo) {
        this.m_AD_UserDef_Tab_ID = AD_UserDef_Tab_ID;
        this.m_WindowNo = windowNo;
        this.setStyle("position : relative;height: 100%; width:100%; margin: none; border: none; padding: none;");
    }

    private void init() throws Exception {
        Borderlayout layout = new Borderlayout();
        layout.setStyle("width: 100%; height: 100%; border: none; margin: none; padding: none;");
        Center center = new Center();
        this.noLabel.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"Available"));
        this.yesLabel.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected"));
        ZKUpdateUtil.setVflex(this.yesList, true);
        ZKUpdateUtil.setVflex(this.noList, true);
        EventListener<Event> mouseListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if ("onDoubleClick".equals(event.getName())) {
                    CustomizeUserDefTabGridView.this.migrateValueAcrossLists(event);
                }
            }
        };
        this.yesList.addDoubleClickListener(mouseListener);
        this.noList.addDoubleClickListener(mouseListener);
        Object actionListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                CustomizeUserDefTabGridView.this.migrateValueAcrossLists(event);
            }
        };
        this.yesModel.setMultiple(true);
        this.noModel.setMultiple(true);
        LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)this.bAdd);
        LayoutUtils.addSclass("btn-sorttab small-img-btn", (HtmlBasedComponent)this.bAdd);
        this.bAdd.addEventListener("onClick", (EventListener)actionListener);
        LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)this.bRemove);
        LayoutUtils.addSclass("btn-sorttab small-img-btn", (HtmlBasedComponent)this.bRemove);
        this.bRemove.addEventListener("onClick", (EventListener)actionListener);
        DragListener crossListMouseListener = new DragListener();
        this.yesList.addOnDropListener(crossListMouseListener);
        this.noList.addOnDropListener(crossListMouseListener);
        if (!ClientInfo.isMobile()) {
            this.yesList.setItemDraggable(true);
            this.noList.setItemDraggable(true);
        }
        actionListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                CustomizeUserDefTabGridView.this.migrateValueWithinYesList(event);
            }
        };
        LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)this.bUp);
        LayoutUtils.addSclass("btn-sorttab small-img-btn", (HtmlBasedComponent)this.bUp);
        this.bUp.addEventListener("onClick", (EventListener)actionListener);
        LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)this.bDown);
        LayoutUtils.addSclass("btn-sorttab small-img-btn", (HtmlBasedComponent)this.bDown);
        this.bDown.addEventListener("onClick", (EventListener)actionListener);
        ListHead listHead = new ListHead();
        listHead.setParent((Component)this.yesList);
        ListHeader listHeader = new ListHeader();
        listHeader.appendChild((Component)this.yesLabel);
        Hlayout yesButtonLayout = new Hlayout();
        yesButtonLayout.appendChild((Component)this.bUp);
        yesButtonLayout.appendChild((Component)this.bDown);
        listHeader.appendChild((Component)yesButtonLayout);
        yesButtonLayout.setStyle("display: inline-block; float: right;");
        listHeader.setParent((Component)listHead);
        listHead = new ListHead();
        listHead.setParent((Component)this.noList);
        listHeader = new ListHeader();
        listHeader.appendChild((Component)this.noLabel);
        listHeader.setSort("auto");
        listHeader.setSortDirection("ascending");
        this.noList.setAttribute("org.zkoss.zul.listbox.autoSort", "true");
        Hlayout noButtonLayout = new Hlayout();
        noButtonLayout.appendChild((Component)this.bRemove);
        noButtonLayout.appendChild((Component)this.bAdd);
        listHeader.appendChild((Component)noButtonLayout);
        noButtonLayout.setStyle("display: inline-block; float: right;");
        listHeader.setParent((Component)listHead);
        Hlayout hlayout = new Hlayout();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)hlayout, "true");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)hlayout, "true");
        hlayout.setStyle("margin: auto; margin-top: 2px;");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.noList, "1");
        ZKUpdateUtil.setVflex(this.noList, true);
        hlayout.appendChild((Component)this.noList);
        ZKUpdateUtil.setVflex(this.yesList, true);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.yesList, "1");
        hlayout.appendChild((Component)this.yesList);
        center.appendChild((Component)hlayout);
        layout.appendChild((Component)center);
        South south = new South();
        south.setStyle("border: none; margin: 0; padding: 0; ");
        Panel southPanel = new Panel();
        Separator sep = new Separator();
        sep.setSpacing("2px");
        southPanel.appendChild((Component)sep);
        LayoutUtils.addSclass("dialog-footer", (HtmlBasedComponent)this.confirmPanel);
        EventListener<Event> onClickListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event.getTarget().equals((Object)CustomizeUserDefTabGridView.this.confirmPanel.getButton("Ok"))) {
                    CustomizeUserDefTabGridView.this.onOk();
                } else if (event.getTarget().equals((Object)CustomizeUserDefTabGridView.this.confirmPanel.getButton("Cancel"))) {
                    CustomizeUserDefTabGridView.this.onCancel();
                } else if (event.getTarget().equals((Object)CustomizeUserDefTabGridView.this.confirmPanel.getButton("Reset"))) {
                    CustomizeUserDefTabGridView.this.onReset();
                }
            }
        };
        this.confirmPanel.addActionListener(onClickListener);
        southPanel.appendChild((Component)this.confirmPanel);
        south.appendChild((Component)southPanel);
        layout.appendChild((Component)south);
        this.appendChild((Component)layout);
    }

    public void onReset() {
        this.loadData();
    }

    public void onOk() {
        this.saveData();
    }

    public void onCancel() {
        if (this.isUseEscForTabClosing) {
            SessionManager.getAppDesktop().setCloseTabWithShortcut(false);
        }
        this.getParent().detach();
    }

    public void loadData() {
        this.userDefTab = new MUserDefTab(Env.getCtx(), this.m_AD_UserDef_Tab_ID, null);
        Query ufQuery = new Query(Env.getCtx(), "AD_UserDef_Field", "AD_UserDef_Tab_ID=?", null);
        List userDefFields = ufQuery.setParameters(new Object[]{this.m_AD_UserDef_Tab_ID}).list();
        this.yesModel.removeAllElements();
        this.noModel.removeAllElements();
        boolean baseLanguage = Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Field");
        Query query = new Query(Env.getCtx(), "AD_Field", "AD_Field.AD_Tab_ID=? AND AD_Field.IsActive='Y'", null);
        query.addJoinClause("LEFT JOIN AD_UserDef_Field u ON (AD_Field.AD_Field_ID=u.AD_Field_ID AND u.IsActive='Y' AND u.AD_UserDef_Tab_ID=" + this.m_AD_UserDef_Tab_ID + ")");
        query.setOrderBy("CASE WHEN Coalesce(u.SeqNoGrid,0) > 0 THEN u.SeqNoGrid ELSE AD_Field.SeqNoGrid END, Coalesce(u.Name,AD_Field.Name), CASE WHEN Coalesce(u.SeqNo,0) > 0 THEN u.SeqNo ELSE AD_Field.SeqNo END");
        query.setParameters(new Object[]{this.userDefTab.getAD_Tab_ID()});
        query.setApplyAccessFilter(true);
        try {
            List fields = query.list();
            for (MField field : fields) {
                boolean displayGrid;
                Optional<MUserDefField> optional = userDefFields.stream().filter(e -> e.getAD_Field_ID() == field.getAD_Field_ID()).findFirst();
                MUserDefField userDefField = optional.orElse(null);
                String name = null;
                name = baseLanguage ? field.getName() : field.get_Translation("Name");
                if (userDefField != null && userDefField.getName() != null) {
                    name = userDefField.getName();
                }
                ListElement pp = new ListElement(field.get_ID(), name, userDefField);
                boolean bl = displayGrid = userDefField != null && userDefField.getIsDisplayedGrid() != null ? "Y".equals(userDefField.getIsDisplayedGrid()) : field.isDisplayedGrid();
                if (displayGrid) {
                    this.yesModel.addElement((Object)pp);
                    continue;
                }
                this.noModel.addElement((Object)pp);
            }
        }
        catch (DBException e2) {
            log.log(Level.SEVERE, e2.getMessage(), (Throwable)e2);
        }
        this.bAdd.setEnabled(true);
        this.bRemove.setEnabled(true);
        this.bUp.setEnabled(true);
        this.bDown.setEnabled(true);
        this.yesList.setEnabled(true);
        this.noList.setEnabled(true);
        this.yesList.setItemRenderer(this.yesModel);
        this.yesList.setModel((ListModel)this.yesModel);
        this.noList.setItemRenderer(this.noModel);
        this.noList.setModel((ListModel)this.noModel);
    }

    protected void migrateValueAcrossLists(Event event) {
        Component source = event.getTarget();
        if (source instanceof ListItem) {
            source = ((ListItem)source).getListbox();
        }
        Listbox listFrom = source == this.bAdd || source == this.noList ? this.noList : this.yesList;
        Listbox listTo = source == this.bAdd || source == this.noList ? this.yesList : this.noList;
        int endIndex = this.yesList.getIndexOfItem(listTo.getSelectedItem());
        if (endIndex < 0) {
            endIndex = 0;
        }
        this.migrateLists(listFrom, listTo, endIndex);
    }

    protected void migrateLists(Listbox listFrom, Listbox listTo, int endIndex) {
        int index = 0;
        SimpleListModel lmFrom = (SimpleListModel)listFrom.getModel();
        SimpleListModel lmTo = (SimpleListModel)listTo.getModel();
        Set selectedItems = listFrom.getSelectedItems();
        ArrayList<ListElement> selObjects = new ArrayList<ListElement>();
        for (Object obj : selectedItems) {
            ListItem listItem = (ListItem)((Object)obj);
            index = listFrom.getIndexOfItem(listItem);
            ListElement selObject = (ListElement)((Object)lmFrom.getElementAt(index));
            selObjects.add(selObject);
        }
        for (ListElement selObject : selObjects) {
            if (selObject == null) continue;
            lmFrom.removeElement((Object)selObject);
            lmTo.add(endIndex, (Object)selObject);
            ++endIndex;
            index = lmTo.indexOf((Object)selObject);
            listTo.setSelectedIndex(index);
        }
    }

    protected void migrateValueWithinYesList(int endIndex, List<ListElement> selObjects) {
        int iniIndex = 0;
        Arrays.sort(selObjects.toArray());
        ListElement endObject = (ListElement)((Object)this.yesModel.getElementAt(endIndex));
        for (ListElement selected : selObjects) {
            iniIndex = this.yesModel.indexOf((Object)selected);
            ListElement selObject = (ListElement)((Object)this.yesModel.getElementAt(iniIndex));
            this.yesModel.removeElement((Object)selObject);
            endIndex = this.yesModel.indexOf((Object)endObject);
            this.yesModel.add(endIndex, (Object)selObject);
        }
    }

    protected void migrateValueWithinYesList(Event event) {
        Object[] selObjects = this.yesList.getSelectedItems().toArray();
        if (selObjects == null) {
            return;
        }
        int length = selObjects.length;
        if (length == 0) {
            return;
        }
        int[] indices = this.yesList.getSelectedIndices();
        Arrays.sort(indices);
        boolean change = false;
        Component source = event.getTarget();
        if (source == this.bUp) {
            i = 0;
            while (i < length) {
                int index = indices[i];
                if (index != 0) {
                    ListElement selObject = (ListElement)((Object)this.yesModel.getElementAt(index));
                    ListElement newObject = (ListElement)((Object)this.yesModel.getElementAt(index - 1));
                    this.yesModel.setElementAt((Object)newObject, index);
                    this.yesModel.setElementAt((Object)selObject, index - 1);
                    indices[i] = index - 1;
                    change = true;
                    ++i;
                    continue;
                }
                break;
            }
        } else if (source == this.bDown) {
            i = length - 1;
            while (i >= 0) {
                int index = indices[i];
                if (index < this.yesModel.getSize() - 1) {
                    ListElement selObject = (ListElement)((Object)this.yesModel.getElementAt(index));
                    ListElement newObject = (ListElement)((Object)this.yesModel.getElementAt(index + 1));
                    this.yesModel.setElementAt((Object)newObject, index);
                    this.yesModel.setElementAt((Object)selObject, index + 1);
                    this.yesList.setSelectedIndex(index + 1);
                    indices[i] = index + 1;
                    change = true;
                    --i;
                    continue;
                }
                break;
            }
        }
        if (change) {
            this.yesList.setSelectedIndices(indices);
            if (this.yesList.getSelectedItem() != null) {
                AuFocus focus = new AuFocus((Component)this.yesList.getSelectedItem());
                Clients.response((AuResponse)focus);
            }
        }
    }

    public void saveData() {
        try (Trx trx = Trx.get((String)Trx.createTrxName((String)"saveData"), (boolean)true);){
            try {
                ListElement pp;
                int prevSeqNo = 0;
                int i = 0;
                while (i < this.yesModel.getSize()) {
                    pp = (ListElement)((Object)this.yesModel.getElementAt(i));
                    MField field = MField.get((int)pp.getKey());
                    MUserDefField userDefField = pp.getUserDefField();
                    if (userDefField != null) {
                        if (!field.isDisplayedGrid()) {
                            userDefField.setIsDisplayedGrid("Y");
                        } else {
                            userDefField.setIsDisplayedGrid(null);
                        }
                        int n = seqNo = userDefField.getSeqNoGrid() > 0 ? userDefField.getSeqNoGrid() : field.getSeqNoGrid();
                        if (seqNo <= prevSeqNo) {
                            userDefField.setSeqNoGrid(prevSeqNo += 5);
                        } else if (i < this.yesModel.getSize() - 1) {
                            next = (ListElement)((Object)this.yesModel.getElementAt(i + 1));
                            nextField = MField.get((int)next.getKey());
                            nextUDF = pp.getUserDefField();
                            int n2 = nextSeqNo = nextUDF != null && nextUDF.getSeqNoGrid() > 0 ? nextUDF.getSeqNoGrid() : nextField.getSeqNoGrid();
                            if (seqNo >= nextSeqNo) {
                                userDefField.setSeqNoGrid(prevSeqNo += 5);
                            }
                        }
                        int n3 = prevSeqNo = userDefField.getSeqNoGrid() > 0 ? userDefField.getSeqNoGrid() : seqNo;
                        if (userDefField.is_Changed()) {
                            userDefField.saveEx(trx.getTrxName());
                        }
                    } else if (!field.isDisplayedGrid()) {
                        this.newUserDefField(field, prevSeqNo += 5, trx);
                    } else {
                        seqNo = field.getSeqNoGrid();
                        if (seqNo <= prevSeqNo) {
                            this.newUserDefField(field, prevSeqNo += 5, trx);
                        } else if (i < this.yesModel.getSize() - 1) {
                            next = (ListElement)((Object)this.yesModel.getElementAt(i + 1));
                            nextField = MField.get((int)next.getKey());
                            nextUDF = pp.getUserDefField();
                            int n = nextSeqNo = nextUDF != null && nextUDF.getSeqNoGrid() > 0 ? nextUDF.getSeqNoGrid() : nextField.getSeqNoGrid();
                            if (seqNo >= nextSeqNo) {
                                this.newUserDefField(field, prevSeqNo += 5, trx);
                            } else {
                                prevSeqNo = seqNo;
                            }
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < this.noModel.getSize()) {
                    pp = (ListElement)((Object)this.noModel.getElementAt(i));
                    MUserDefField userDefField = pp.getUserDefField();
                    MField field = MField.get((int)pp.getKey());
                    if (field.isDisplayedGrid()) {
                        if (userDefField == null) {
                            userDefField = new MUserDefField(Env.getCtx(), 0, null);
                            userDefField.setAD_UserDef_Tab_ID(this.m_AD_UserDef_Tab_ID);
                            userDefField.setAD_Field_ID(field.getAD_Field_ID());
                        }
                        userDefField.setIsDisplayedGrid("N");
                        userDefField.setSeqNoGrid(0);
                        userDefField.saveEx(trx.getTrxName());
                    } else if (userDefField != null && "Y".equals(userDefField.getIsDisplayedGrid())) {
                        userDefField.setIsDisplayedGrid(null);
                        userDefField.setSeqNoGrid(0);
                        userDefField.saveEx(trx.getTrxName());
                    }
                    ++i;
                }
                trx.commit(true);
                this.getParent().detach();
            }
            catch (Exception e) {
                trx.rollback();
                Dialog.error(this.m_WindowNo, "SaveError", e.getMessage());
                trx.close();
            }
        }
    }

    private void newUserDefField(MField field, int seqNoGrid, Trx trx) {
        MUserDefField userDefField = new MUserDefField(Env.getCtx(), 0, null);
        userDefField.setAD_UserDef_Tab_ID(this.m_AD_UserDef_Tab_ID);
        userDefField.setAD_Field_ID(field.getAD_Field_ID());
        userDefField.setSeqNoGrid(seqNoGrid);
        if (!field.isDisplayedGrid()) {
            userDefField.setIsDisplayedGrid("Y");
        }
        userDefField.saveEx(trx.getTrxName());
    }

    public void createUI() {
        try {
            this.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private class DragListener
    implements EventListener<Event> {
        private DragListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (event instanceof DropEvent) {
                int endIndex = 0;
                DropEvent me = (DropEvent)event;
                ListItem endItem = (ListItem)me.getTarget();
                ListItem startItem = (ListItem)me.getDragged();
                if (!startItem.isSelected()) {
                    startItem.setSelected(true);
                }
                if (startItem.getListbox() != endItem.getListbox()) {
                    Listbox listFrom = (Listbox)startItem.getListbox();
                    Listbox listTo = (Listbox)endItem.getListbox();
                    endIndex = CustomizeUserDefTabGridView.this.yesList.getIndexOfItem(endItem);
                    CustomizeUserDefTabGridView.this.migrateLists(listFrom, listTo, endIndex);
                } else if (startItem.getListbox() == endItem.getListbox() && startItem.getListbox() == CustomizeUserDefTabGridView.this.yesList) {
                    ArrayList<ListElement> selObjects = new ArrayList<ListElement>();
                    endIndex = CustomizeUserDefTabGridView.this.yesList.getIndexOfItem(endItem);
                    for (Object obj : CustomizeUserDefTabGridView.this.yesList.getSelectedItems()) {
                        ListItem listItem = (ListItem)((Object)obj);
                        int index = CustomizeUserDefTabGridView.this.yesList.getIndexOfItem(listItem);
                        ListElement selObject = (ListElement)((Object)CustomizeUserDefTabGridView.this.yesModel.getElementAt(index));
                        selObjects.add(selObject);
                    }
                    CustomizeUserDefTabGridView.this.migrateValueWithinYesList(endIndex, selObjects);
                    CustomizeUserDefTabGridView.this.yesList.clearSelection();
                }
            }
        }
    }

    private static class ListElement
    extends NamePair {
        private static final long serialVersionUID = -689533804854437328L;
        private int m_AD_Field_ID;
        private MUserDefField userDefField;

        public ListElement(int key, String name, MUserDefField userDefField) {
            super(name);
            this.m_AD_Field_ID = key;
            this.userDefField = userDefField;
        }

        public int getKey() {
            return this.m_AD_Field_ID;
        }

        public String getID() {
            return this.m_AD_Field_ID != -1 ? String.valueOf(this.m_AD_Field_ID) : null;
        }

        public int hashCode() {
            return this.m_AD_Field_ID;
        }

        public MUserDefField getUserDefField() {
            return this.userDefField;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListElement) {
                ListElement li = (ListElement)((Object)obj);
                return li.getKey() == this.m_AD_Field_ID && li.getName() != null && li.getName().equals(this.getName());
            }
            return false;
        }

        public String toString() {
            Object s = super.toString();
            if (s == null || ((String)s).trim().length() == 0) {
                s = "<" + this.getKey() + ">";
            }
            return s;
        }
    }
}

