/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import com.google.common.base.Objects;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.component.DatetimeBox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.model.MClientInfo;
import org.compiere.model.MOrgInfo;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

public class WDatetimeEditor
extends WEditor
implements ContextMenuListener {
    private static final String[] LISTENER_EVENTS = new String[]{"onChange", "onOK"};
    private static final CLogger logger = CLogger.getCLogger(WDatetimeEditor.class);
    private Timestamp oldValue = new Timestamp(0L);

    public WDatetimeEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WDatetimeEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new DatetimeBox(), gridField, tableEditor, editorConfiguration);
        this.init();
    }

    public WDatetimeEditor(String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super((Component)new DatetimeBox(), label, description, mandatory, readonly, updateable);
        this.setColumnName("Datetime");
        this.init();
    }

    public WDatetimeEditor() {
        this(Msg.getMsg((Properties)Env.getCtx(), (String)"DateTime"), Msg.getMsg((Properties)Env.getCtx(), (String)"DateTime"), false, false, true);
    }

    public WDatetimeEditor(String columnName, boolean mandatory, boolean readonly, boolean updateable, String title) {
        super((Component)new DatetimeBox(), columnName, title, null, mandatory, readonly, updateable);
        this.init();
    }

    private void init() {
        this.popupMenu = new WEditorPopupMenu(false, false, this.isShowPreference());
        this.popupMenu.addMenuListener(this);
        this.addChangeLogMenu(this.popupMenu);
        if (this.gridField != null) {
            this.getComponent().getDatebox().setPlaceholder(this.gridField.getPlaceholder());
        }
        if (this.isTimestampWithTimeZone()) {
            TimeZone tz;
            MClientInfo clientInfo;
            MOrgInfo orgInfo = MOrgInfo.get((int)Env.getAD_Org_ID((Properties)Env.getCtx()));
            String timezoneId = orgInfo.getTimeZone();
            if (Util.isEmpty((String)timezoneId, (boolean)true) && Util.isEmpty((String)(timezoneId = (clientInfo = MClientInfo.get()).getTimeZone()), (boolean)true)) {
                timezoneId = Env.getContext((Properties)Env.getCtx(), (String)"#clientInfo_timeZone");
            }
            if (!Util.isEmpty((String)timezoneId, (boolean)true) && (tz = TimeZone.getTimeZone(timezoneId)) != null && timezoneId.equals(tz.getID())) {
                this.getComponent().setTimeZone(tz);
                this.getComponent().getTimebox().setFormat("hh:mm:ss a z");
            }
        }
    }

    private boolean isTimestampWithTimeZone() {
        if (this.gridField != null) {
            int displayType = this.gridField.getDisplayType();
            return DisplayType.isTimestampWithTimeZone((int)displayType);
        }
        return false;
    }

    public void onEvent(Event event) {
        if ("onChange".equalsIgnoreCase(event.getName()) || "onOK".equalsIgnoreCase(event.getName())) {
            Date date = this.getComponent().getValue();
            Timestamp newValue = null;
            if (date != null) {
                newValue = this.isTimestampWithTimeZone() ? Timestamp.from(date.toInstant()) : Timestamp.valueOf(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            }
            if (this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
                return;
            }
            if (this.oldValue == null && newValue == null) {
                return;
            }
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
            super.fireValueChange(changeEvent);
            this.oldValue = newValue;
        }
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    @Override
    public Object getValue() {
        if (this.getComponent().getValue() == null) {
            return null;
        }
        return Timestamp.valueOf(this.getComponent().getValue().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
    }

    @Override
    public void setValue(Object value) {
        if (value == null || value.toString().trim().length() == 0) {
            Timestamp currentValue = this.oldValue;
            this.oldValue = null;
            this.getComponent().setValue(null);
            if (currentValue != null && !this.readOnly) {
                ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), currentValue, null);
                super.fireValueChange(changeEvent);
            }
        } else if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            if (this.isTimestampWithTimeZone()) {
                Timestamp currentValue = this.oldValue;
                ZonedDateTime zdt = ts.toInstant().atZone(this.getComponent().getDatebox().getTimeZone().toZoneId());
                this.getComponent().setValueInZonedDateTime(zdt);
                this.oldValue = Timestamp.from(zdt.toInstant());
                if (!Objects.equal((Object)currentValue, (Object)this.oldValue) && !this.readOnly) {
                    ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), currentValue, this.oldValue);
                    super.fireValueChange(changeEvent);
                }
            } else {
                Timestamp currentValue = this.oldValue;
                LocalDateTime localTime = ts.toLocalDateTime();
                this.getComponent().setValueInLocalDateTime(localTime);
                this.oldValue = Timestamp.valueOf(localTime);
                if (!Objects.equal((Object)currentValue, (Object)this.oldValue) && !this.readOnly) {
                    ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), currentValue, this.oldValue);
                    super.fireValueChange(changeEvent);
                }
            }
        } else {
            Timestamp currentValue = this.oldValue;
            try {
                this.getComponent().setText(value.toString());
            }
            catch (Exception exception) {}
            if (this.getComponent().getValue() != null) {
                this.oldValue = this.isTimestampWithTimeZone() ? Timestamp.from(this.getComponent().getDatebox().getValue().toInstant()) : Timestamp.valueOf(this.getComponent().getDatebox().getValue().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
                if (!Objects.equal((Object)currentValue, (Object)this.oldValue) && !this.readOnly) {
                    ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), currentValue, this.oldValue);
                    super.fireValueChange(changeEvent);
                }
            } else {
                this.oldValue = null;
                if (currentValue != null && !this.readOnly) {
                    ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), currentValue, null);
                    super.fireValueChange(changeEvent);
                }
            }
        }
    }

    public DatetimeBox getComponent() {
        return (DatetimeBox)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        } else if ("VALUE_PREFERENCE".equals(evt.getContextEvent()) && this.isShowPreference()) {
            ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
        }
    }

    @Override
    protected void setFieldStyle(String style) {
        this.getComponent().getDatebox().setStyle(style);
        this.getComponent().getTimebox().setStyle(style);
    }
}

