/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.util.logging.Level;
import org.adempiere.webui.dashboard.DashboardRunnable;
import org.adempiere.webui.desktop.DashboardController;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.compiere.model.GridField;
import org.compiere.model.MDashboardContent;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Div;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Panelchildren;

public class WDashboardContentEditor
extends WEditor {
    private static final String ON_RENDER_CONTENT = "onRenderContent";
    private DashboardController dashboardController = new DashboardController();
    private MDashboardContent content;
    private String fieldStyle;
    private static final CLogger logger = CLogger.getCLogger(WDashboardContentEditor.class);

    public WDashboardContentEditor(GridField gridField, int windowNo) {
        this(gridField, windowNo, false, null);
    }

    public WDashboardContentEditor(GridField gridField, int windowNo, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new Panel(), gridField, tableEditor, editorConfiguration);
        this.content = new MDashboardContent(Env.getCtx(), gridField.getPA_DashboardContent_ID(), null);
        Panelchildren pc = new Panelchildren();
        this.getComponent().appendChild((Component)pc);
        if (this.content.get_ID() > 0) {
            Caption caption = new Caption(this.content.get_Translation("Name"));
            this.getComponent().appendChild((Component)caption);
        }
        this.getComponent().addEventListener(ON_RENDER_CONTENT, (EventListener)this);
    }

    public void onEvent(Event event) throws Exception {
        if (event.getName().equals(ON_RENDER_CONTENT)) {
            try {
                this.render();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setReadWrite(boolean readWrite) {
    }

    @Override
    public boolean isReadWrite() {
        return false;
    }

    @Override
    public void setValue(Object value) {
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public String getDisplay() {
        return null;
    }

    @Override
    public void dynamicDisplay() {
        super.dynamicDisplay();
        Events.postEvent((String)ON_RENDER_CONTENT, (Component)this.getComponent(), null);
    }

    public Panel getComponent() {
        return (Panel)super.getComponent();
    }

    private void render() throws Exception {
        Panel panel = this.getComponent();
        panel.setSclass("dashboard-field-panel");
        Panelchildren pc = panel.getPanelchildren();
        pc.getChildren().clear();
        Div div = new Div();
        if (!Util.isEmpty((String)this.fieldStyle)) {
            div.setStyle(this.fieldStyle);
        }
        DashboardRunnable dashboardRunnable = new DashboardRunnable(panel.getDesktop());
        this.dashboardController.render((Component)div, this.content, dashboardRunnable);
        pc.appendChild((Component)div);
    }

    @Override
    protected void setFieldStyle(String style) {
        this.fieldStyle = style;
    }
}

