/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Tabpanels;

public class Tabs
extends org.zkoss.zul.Tabs
implements EventListener<Event> {
    private static final long serialVersionUID = 4939779587719677815L;

    public void setParent(Component parent) {
        super.setParent(parent);
        if (parent == null || !(parent instanceof Tabbox)) {
            return;
        }
        Tabbox tabBox = (Tabbox)parent;
        for (org.zkoss.zul.Tab tabAdded : this.getChildren()) {
            if (tabBox.isSupportTabDragDrop()) {
                this.setDragDropTab(tabAdded);
                continue;
            }
            this.unsetDragDropTab(tabAdded);
        }
        if (tabBox.isSupportTabDragDrop()) {
            this.addEventListener("onDrop", this);
            this.setDroppable(Boolean.TRUE.toString());
        } else {
            this.removeEventListener("onDrop", this);
            this.setDroppable(Boolean.FALSE.toString());
        }
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        if (this.getTabbox() != null && this.getTabbox() instanceof Tabbox) {
            Tabbox tabbox = (Tabbox)this.getTabbox();
            if (child instanceof org.zkoss.zul.Tab && tabbox.isSupportTabDragDrop()) {
                org.zkoss.zul.Tab tab = (org.zkoss.zul.Tab)child;
                this.setDragDropTab(tab);
            }
        }
    }

    protected void setDragDropTab(org.zkoss.zul.Tab tab) {
        tab.setDraggable("true");
        tab.setDroppable("true");
        tab.addEventListener("onDrop", (EventListener)this);
    }

    protected void unsetDragDropTab(org.zkoss.zul.Tab tab) {
        tab.setDraggable("false");
        tab.setDroppable("false");
        tab.removeEventListener("onDrop", (EventListener)this);
    }

    public void onEvent(Event event) throws Exception {
        if (event != null && event instanceof DropEvent) {
            this.dragDropTab((DropEvent)event);
        }
    }

    protected void dragDropTab(DropEvent dropEvent) {
        Component draggComp;
        Component dropComp = dropEvent.getTarget();
        if (!this.isValidateDragDropComponent(dropComp, draggComp = dropEvent.getDragged())) {
            return;
        }
        Tabpanels tabpanels = this.getTabbox().getTabpanels();
        int dropIndex = -1;
        Component dropPanel = null;
        if (dropComp instanceof org.zkoss.zul.Tab) {
            dropIndex = this.getChildren().indexOf(dropComp);
            dropPanel = (Component)tabpanels.getChildren().get(dropIndex);
        }
        int draggIndex = this.getChildren().indexOf(draggComp);
        Component draggPanel = (Component)tabpanels.getChildren().get(draggIndex);
        if (dropIndex != -1 && draggIndex < dropIndex) {
            if (dropComp.getNextSibling() == null) {
                dropIndex = -1;
                dropComp = null;
                dropPanel = null;
            } else {
                dropComp = dropComp.getNextSibling();
                dropPanel = (Component)tabpanels.getChildren().get(++dropIndex);
            }
        }
        this.insertBefore(draggComp, dropComp);
        tabpanels.insertBefore(draggPanel, dropPanel);
        if (draggPanel.getPage() != null) {
            StringBuilder script = new StringBuilder("zk.Widget.$('#").append(draggPanel.getUuid()).append("').rerender(0);");
            Clients.evalJavaScript((String)script.toString());
        }
    }

    protected boolean isValidateDragDropComponent(Component dropComp, Component draggComp) {
        if (dropComp == null || draggComp == null || !(dropComp instanceof org.zkoss.zul.Tab) && !(dropComp instanceof org.zkoss.zul.Tabs) || !(draggComp instanceof org.zkoss.zul.Tab)) {
            return false;
        }
        if (dropComp instanceof org.zkoss.zul.Tabs && dropComp != this) {
            return false;
        }
        if (dropComp instanceof org.zkoss.zul.Tab && this != dropComp.getParent() || this != draggComp.getParent()) {
            return false;
        }
        return (!(dropComp instanceof Tab) || !((Tab)dropComp).isDisableDraggDrop()) && (!(draggComp instanceof Tab) || !((Tab)draggComp).isDisableDraggDrop());
    }
}

