/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.base.IServiceHolder;
import org.adempiere.util.Callback;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.action.Actions;
import org.adempiere.webui.action.IAction;
import org.adempiere.webui.adwindow.ADSortTab;
import org.adempiere.webui.adwindow.ADTabpanel;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.GridView;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.adwindow.ProcessButtonPopup;
import org.adempiere.webui.adwindow.ToolbarCustomButton;
import org.adempiere.webui.component.ADTabListModel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.ToolBar;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.CustomizeGridViewDialog;
import org.adempiere.webui.window.WRecordInfo;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.GridTab;
import org.compiere.model.MToolBarButton;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.zhtml.Text;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.A;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.LayoutRegion;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Space;
import org.zkoss.zul.Tabpanels;
import org.zkoss.zul.Tabs;

public class DetailPane
extends Panel
implements EventListener<Event>,
IdSpace {
    private static final long serialVersionUID = 3764215603459946930L;
    public static final String BTN_PROCESS_ID = "BtnProcess";
    public static final String BTN_DELETE_ID = "BtnDelete";
    public static final String BTN_EDIT_ID = "BtnEdit";
    public static final String BTN_NEW_ID = "BtnNew";
    public static final String BTN_SAVE_ID = "BtnSave";
    public static final String BTN_QUICK_FORM_ID = "BtnQuickForm";
    public static final String BTN_CUSTOMIZE_ID = "BtnCustomize";
    private static final String BTN_TOGGLE_ID = "BtnToggle";
    private static final String TABBOX_ONSELECT_ATTRIBUTE = "detailpane.tabbox.onselect";
    private static final String ON_POST_SELECT_TAB_EVENT = "onPostSelectTab";
    private static final String STATUS_TEXT_ATTRIBUTE = "status.text";
    private static final String STATUS_ERROR_ATTRIBUTE = "status.error";
    private static final String CUSTOMIZE_IMAGE = "images/Customize16.png";
    private static final String DELETE_IMAGE = "images/Delete16.png";
    private static final String EDIT_IMAGE = "images/EditRecord16.png";
    private static final String NEW_IMAGE = "images/New16.png";
    private static final String PROCESS_IMAGE = "images/Process16.png";
    private static final String SAVE_IMAGE = "images/Save16.png";
    private static final String QUICK_FORM_IMAGE = "images/QuickForm16.png";
    private static final String TOGGLE_IMAGE = "images/Multi16.png";
    private Tabbox tabbox;
    private EventListener<Event> eventListener;
    private Map<Integer, Hbox> messageContainers = new HashMap<Integer, Hbox>();
    private Div msgPopupCnt;
    private Window msgPopup;
    private int prevSelectedIndex = 0;
    public static final String ON_ACTIVATE_DETAIL_EVENT = "onActivateDetail";
    public static final String ON_DELETE_EVENT = "onDelete";
    public static final String ON_NEW_EVENT = "onNew";
    public static final String ON_EDIT_EVENT = "onEdit";
    public static final String ON_SAVE_EVENT = "onSave";
    public static final String ON_QUICK_FORM_EVENT = "onQuickForm";
    public static final String ON_RECORD_NAVIGATE_EVENT = "onRecordNavigate";

    public DetailPane() {
        this.tabbox = new Tabbox();
        this.tabbox.setParent((Component)this);
        this.tabbox.addEventListener("onSelect", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                DetailPane.this.fireActivateDetailEvent();
                Events.postEvent((Event)new Event(DetailPane.ON_POST_SELECT_TAB_EVENT, (Component)DetailPane.this));
                Executions.getCurrent().setAttribute(DetailPane.TABBOX_ONSELECT_ATTRIBUTE, (Object)Boolean.TRUE);
            }
        });
        this.tabbox.setSclass("adwindow-detailpane-tabbox");
        this.tabbox.setTabscroll(true);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.tabbox, "100%");
        this.createPopup();
        this.setSclass("adwindow-detailpane");
        this.addEventListener("onRedraw", this);
        this.setId("detailPane");
    }

    public int getSelectedIndex() {
        return this.tabbox.getSelectedIndex();
    }

    public void setSelectedIndex(int curTabIndex) {
        this.tabbox.setSelectedIndex(curTabIndex);
        this.prevSelectedIndex = curTabIndex;
    }

    public int getTabcount() {
        int count = 0;
        Tabs tabs = this.tabbox.getTabs();
        if (tabs != null) {
            count = tabs.getChildren().size();
        }
        return count;
    }

    public void undoLastTabSelection() {
        this.tabbox.setSelectedIndex(this.prevSelectedIndex);
    }

    public void refresh() {
        this.tabbox.invalidate();
    }

    public void setADTabpanel(int index, IADTabpanel tabPanel, ADTabListModel.ADTabLabel tabLabel) {
        if (index < this.getTabcount()) {
            this.tabbox.getTabpanel(index).appendChild(tabPanel);
        } else {
            this.addADTabpanel(tabPanel, tabLabel);
        }
    }

    public void setADTabpanel(int index, IADTabpanel tabPanel, ADTabListModel.ADTabLabel tabLabel, boolean enabled) {
        if (index < this.getTabcount()) {
            this.tabbox.getTabpanel(index).appendChild(tabPanel);
        } else {
            this.addADTabpanel(tabPanel, tabLabel, enabled);
        }
    }

    public void addADTabpanel(IADTabpanel tabPanel, ADTabListModel.ADTabLabel tabLabel) {
        this.addADTabpanel(tabPanel, tabLabel, true);
    }

    public void addADTabpanel(IADTabpanel tabPanel, ADTabListModel.ADTabLabel tabLabel, boolean enabled) {
        MToolBarButton[] officialButtons;
        Tabs tabs = this.tabbox.getTabs();
        if (tabs == null) {
            tabs = new Tabs();
            this.tabbox.appendChild((Component)tabs);
        }
        Tab tab = new Tab();
        tabs.appendChild((Component)tab);
        tab.setLabel(tabLabel.label);
        if (!enabled) {
            tab.setDisabled(true);
            tab.setSclass("adwindow-detailpane-sub-tab");
        }
        tab.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Tab tab = (Tab)event.getTarget();
                if (!tab.isSelected()) {
                    return;
                }
                if (Executions.getCurrent().getAttribute(DetailPane.TABBOX_ONSELECT_ATTRIBUTE) != null) {
                    return;
                }
                org.zkoss.zul.Tabpanel zkTabpanel = tab.getLinkedPanel();
                IADTabpanel adtab = null;
                for (Component c : zkTabpanel.getChildren()) {
                    if (!(c instanceof IADTabpanel)) continue;
                    adtab = (IADTabpanel)c;
                    break;
                }
                if (adtab != null && adtab.isDetailPaneMode()) {
                    DetailPane.this.onEdit(adtab.getGridTab().isSingleRow());
                }
            }
        });
        Tabpanels tabpanels = this.tabbox.getTabpanels();
        if (tabpanels == null) {
            tabpanels = new Tabpanels();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)tabpanels, "100%");
            this.tabbox.appendChild((Component)tabpanels);
        }
        Tabpanel tp = new Tabpanel();
        tabpanels.appendChild((Component)tp);
        ToolBar toolbar = tp.getToolbar();
        HashMap<String, ToolBarButton> buttons = new HashMap<String, ToolBarButton>();
        ToolBarButton button = new ToolBarButton();
        if (ThemeManager.isUseFontIconForImage()) {
            button.setIconSclass("z-icon-New");
        } else {
            button.setImage(ThemeManager.getThemeResource(NEW_IMAGE));
        }
        button.setId(BTN_NEW_ID);
        button.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event.getTarget().isVisible()) {
                    DetailPane.this.onNew();
                }
            }
        });
        button.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"SaveCreate")) + "    Shift+Alt+N");
        buttons.put(BTN_NEW_ID.substring(3, BTN_NEW_ID.length()), button);
        button = new ToolBarButton();
        if (ThemeManager.isUseFontIconForImage()) {
            button.setIconSclass("z-icon-Edit");
        } else {
            button.setImage(ThemeManager.getThemeResource(EDIT_IMAGE));
        }
        button.setId(BTN_EDIT_ID);
        button.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event.getTarget().isVisible()) {
                    DetailPane.this.onEdit(true);
                }
            }
        });
        button.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"EditRecord")) + "    Shift+Alt+E");
        buttons.put(BTN_EDIT_ID.substring(3, BTN_EDIT_ID.length()), button);
        button = new ToolBarButton();
        if (ThemeManager.isUseFontIconForImage()) {
            button.setIconSclass("z-icon-Delete");
        } else {
            button.setImage(ThemeManager.getThemeResource(DELETE_IMAGE));
        }
        button.setId(BTN_DELETE_ID);
        button.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event.getTarget().isVisible()) {
                    Event openEvent = new Event(DetailPane.ON_DELETE_EVENT, (Component)DetailPane.this);
                    DetailPane.this.eventListener.onEvent(openEvent);
                }
            }
        });
        button.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Delete")) + "    Shift+Alt+D");
        buttons.put(BTN_DELETE_ID.substring(3, BTN_DELETE_ID.length()), button);
        button = new ToolBarButton();
        if (ThemeManager.isUseFontIconForImage()) {
            button.setIconSclass("z-icon-Save");
        } else {
            button.setImage(ThemeManager.getThemeResource(SAVE_IMAGE));
        }
        button.setId(BTN_SAVE_ID);
        button.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event.getTarget().isVisible()) {
                    Event openEvent = new Event(DetailPane.ON_SAVE_EVENT, (Component)DetailPane.this);
                    DetailPane.this.eventListener.onEvent(openEvent);
                }
            }
        });
        button.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Save")) + "    Shift+Alt+S");
        buttons.put(BTN_SAVE_ID.substring(3, BTN_SAVE_ID.length()), button);
        if (!tabPanel.getGridTab().isSortTab()) {
            button = new ToolBarButton();
            if (ThemeManager.isUseFontIconForImage()) {
                button.setIconSclass("z-icon-Process");
            } else {
                button.setImage(ThemeManager.getThemeResource(PROCESS_IMAGE));
            }
            button.setId(BTN_PROCESS_ID);
            button.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    if (event.getTarget().isVisible()) {
                        DetailPane.this.onProcess(event.getTarget());
                    }
                }
            });
            button.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Process")) + "    Shift+Alt+O");
            buttons.put(BTN_PROCESS_ID.substring(3, BTN_PROCESS_ID.length()), button);
        }
        button = new ToolBarButton();
        if (ThemeManager.isUseFontIconForImage()) {
            button.setIconSclass("z-icon-QuickForm");
        } else {
            button.setImage(ThemeManager.getThemeResource(QUICK_FORM_IMAGE));
        }
        button.setId(BTN_QUICK_FORM_ID);
        button.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event.getTarget().isVisible()) {
                    Event openEvent = new Event(DetailPane.ON_QUICK_FORM_EVENT, (Component)DetailPane.this);
                    DetailPane.this.eventListener.onEvent(openEvent);
                }
            }
        });
        button.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"QuickForm")) + "    Shift+Alt+F");
        buttons.put(BTN_QUICK_FORM_ID.substring(3, BTN_QUICK_FORM_ID.length()), button);
        button = new ToolBarButton();
        if (ThemeManager.isUseFontIconForImage()) {
            button.setIconSclass("z-icon-Customize");
        } else {
            button.setImage(ThemeManager.getThemeResource(CUSTOMIZE_IMAGE));
        }
        button.setId(BTN_CUSTOMIZE_ID);
        button.addEventListener("onClick", e -> {
            if (e.getTarget().isVisible()) {
                this.onCustomize(e);
            }
        });
        button.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Customize")));
        buttons.put(BTN_CUSTOMIZE_ID.substring(3, BTN_CUSTOMIZE_ID.length()), button);
        button = new ToolBarButton();
        if (ThemeManager.isUseFontIconForImage()) {
            button.setIconSclass("z-icon-Multi");
        } else {
            button.setImage(ThemeManager.getThemeResource(TOGGLE_IMAGE));
        }
        button.setId(BTN_TOGGLE_ID);
        button.addEventListener("onClick", e -> {
            if (e.getTarget().isVisible()) {
                this.onToggle(e);
            }
        });
        button.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Toggle")) + "    Shift+Alt+T");
        buttons.put(BTN_TOGGLE_ID.substring(3, BTN_TOGGLE_ID.length()), button);
        MToolBarButton[] mToolBarButtonArray = officialButtons = MToolBarButton.getToolbarButtons((String)"D", null);
        int n = officialButtons.length;
        int n2 = 0;
        while (n2 < n) {
            MToolBarButton toolbarButton = mToolBarButtonArray[n2];
            if (!toolbarButton.isActive()) {
                buttons.remove(toolbarButton.getComponentName());
            } else if (toolbarButton.isCustomization()) {
                String actionId = toolbarButton.getActionClassName();
                IServiceHolder<IAction> serviceHolder = Actions.getAction(actionId);
                if (serviceHolder != null && serviceHolder.getService() != null) {
                    String iconSclass;
                    String labelKey = actionId + ".label";
                    String tooltipKey = actionId + ".tooltip";
                    String label = Msg.getMsg((Properties)Env.getCtx(), (String)labelKey, (boolean)true);
                    String tooltiptext = Msg.getMsg((Properties)Env.getCtx(), (String)labelKey, (boolean)false);
                    if (Util.isEmpty((String)tooltiptext, (boolean)true)) {
                        tooltiptext = Msg.getMsg((Properties)Env.getCtx(), (String)tooltipKey, (boolean)true);
                    }
                    if (labelKey.equals(label)) {
                        label = toolbarButton.getName();
                    }
                    if (tooltipKey.equals(tooltiptext) || labelKey.equals(tooltiptext)) {
                        tooltiptext = label;
                    }
                    ToolBarButton btn = new ToolBarButton();
                    btn.setName("Btn" + toolbarButton.getComponentName());
                    btn.setId("Btn" + toolbarButton.getComponentName());
                    btn.setTooltiptext(tooltiptext);
                    btn.setDisabled(false);
                    btn.setIconSclass(null);
                    if (ThemeManager.isUseFontIconForImage() && !Util.isEmpty((String)(iconSclass = Actions.getActionIconSclass(actionId)), (boolean)true)) {
                        btn.setIconSclass(iconSclass);
                        LayoutUtils.addSclass("font-icon-toolbar-button", (HtmlBasedComponent)btn);
                    }
                    if (Util.isEmpty((String)btn.getIconSclass(), (boolean)true)) {
                        AImage aImage = Actions.getActionImage(actionId);
                        if (aImage != null) {
                            btn.setImageContent((Image)aImage);
                        } else {
                            btn.setLabel(label);
                        }
                    }
                    ToolbarCustomButton toolbarCustomBtn = new ToolbarCustomButton(toolbarButton, btn, actionId, tabPanel.getGridTab().getWindowNo(), tabPanel.getGridTab().getTabNo());
                    tp.toolbarCustomButtons.put(btn, toolbarCustomBtn);
                    toolbar.appendChild((Component)btn);
                }
            } else if (buttons.get(toolbarButton.getComponentName()) != null) {
                toolbar.appendChild((Component)buttons.get(toolbarButton.getComponentName()));
                if (toolbarButton.isAddSeparator()) {
                    toolbar.appendChild((Component)new Separator("vertical"));
                }
            }
            ++n2;
        }
        Hbox messageContainer = new Hbox();
        messageContainer.setPack("end");
        messageContainer.setAlign("center");
        messageContainer.setSclass("adwindow-detailpane-message");
        messageContainer.setId("messages");
        if (ClientInfo.minWidth(700)) {
            toolbar.appendChild((Component)new Space());
        }
        toolbar.appendChild((Component)messageContainer);
        toolbar.setSclass("adwindow-detailpane-toolbar");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)toolbar, "0");
        this.messageContainers.put(tabLabel.AD_Tab_ID, messageContainer);
        tabPanel.setAttribute("AD_Tab_ID", tabLabel.AD_Tab_ID);
        if (ClientInfo.isMobile() && ClientInfo.maxWidth(700)) {
            tp.createOverflowButton();
        }
        RecordToolbar recordToolbar = new RecordToolbar(tabPanel.getGridTab());
        recordToolbar.addEventListener(ON_RECORD_NAVIGATE_EVENT, this.eventListener);
        tp.setRecordToolbar(recordToolbar);
        tp.setADTabpanel(tabPanel);
        if (tabPanel instanceof ADTabpanel) {
            ADTabpanel adTabpanel = (ADTabpanel)tabPanel;
            tp.addEventListener("onSwipeRight", e -> {
                RecordToolbar rtb = tp.getRecordToolbar();
                if (rtb != null && rtb.isVisible() && !rtb.btnPrevious.isDisabled()) {
                    LayoutUtils.addSclass("slide-right-out", (HtmlBasedComponent)aDTabpanel.form);
                    Events.sendEvent((String)"onClick", (Component)rtb.btnPrevious, null);
                }
            });
            tp.addEventListener("onSwipeLeft", e -> {
                RecordToolbar rtb = tp.getRecordToolbar();
                if (rtb != null && rtb.isVisible() && !rtb.btnNext.isDisabled()) {
                    LayoutUtils.addSclass("slide-left-out", (HtmlBasedComponent)aDTabpanel.form);
                    Events.sendEvent((String)"onClick", (Component)rtb.btnNext, null);
                }
            });
            adTabpanel.setupFormSwipeListener((HtmlBasedComponent)tp);
        }
        if (tabPanel.getGridView() != null) {
            tabPanel.addEventListener("onDynamicDisplay", this);
            tabPanel.getGridView().addEventListener(ON_EDIT_EVENT, (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    GridView gridView = (GridView)event.getTarget();
                    if (gridView.isDetailPaneMode()) {
                        DetailPane.this.onEdit(true);
                    }
                }
            });
        }
    }

    protected void onToggle(Event e) {
        IADTabpanel adTabPanel = this.getSelectedADTabpanel();
        if (!(adTabPanel instanceof ADSortTab)) {
            adTabPanel.switchRowPresentation();
            ToolBarButton btnCustomize = this.getSelectedPanel().getToolbarButton(BTN_CUSTOMIZE_ID);
            if (btnCustomize != null) {
                btnCustomize.setDisabled(!adTabPanel.isGridView());
            }
            Tabpanel tabPanel = (Tabpanel)this.tabbox.getSelectedTabpanel();
            tabPanel.setToggleToFormView(!adTabPanel.isGridView());
            tabPanel.afterToggle();
            if (adTabPanel != null && adTabPanel instanceof HtmlBasedComponent) {
                ((HtmlBasedComponent)adTabPanel).focus();
            }
        }
    }

    protected void onCustomize(Event e) {
        if (this.getSelectedADTabpanel() instanceof ADTabpanel) {
            ADTabpanel tabPanel = (ADTabpanel)this.getSelectedADTabpanel();
            CustomizeGridViewDialog.onCustomize(tabPanel, (Callback<Boolean>)((Callback)b -> {
                ADWindow adwindow = ADWindow.findADWindow((Component)this);
                if (adwindow != null) {
                    adwindow.getADWindowContent().focusToLastFocusEditor();
                }
            }));
        }
    }

    protected void onProcess(Component button) {
        ProcessButtonPopup popup = new ProcessButtonPopup();
        IADTabpanel adtab = this.getSelectedADTabpanel();
        if (adtab.getToolbarButtons() != null && adtab.getToolbarButtons().size() > 0) {
            popup.render(adtab.getToolbarButtons());
        }
        if (popup.getChildren().size() > 0) {
            popup.setPage(button.getPage());
            popup.open(button, "after_start");
        }
    }

    public void setEventListener(EventListener<Event> listener) {
        this.eventListener = listener;
    }

    public void reset() {
        if (this.tabbox.getTabs() != null) {
            this.tabbox.getTabs().getChildren().clear();
        }
        if (this.tabbox.getTabpanels() != null) {
            this.tabbox.getTabpanels().getChildren().clear();
        }
    }

    public IADTabpanel getADTabpanel(int index) {
        if (index < 0 || index >= this.tabbox.getTabpanels().getChildren().size()) {
            return null;
        }
        org.adempiere.webui.component.Tabpanel tabPanel = this.tabbox.getTabpanel(index);
        for (Component c : tabPanel.getChildren()) {
            if (!(c instanceof IADTabpanel)) continue;
            return (IADTabpanel)c;
        }
        return null;
    }

    public IADTabpanel getSelectedADTabpanel() {
        org.zkoss.zul.Tabpanel selectedPanel = this.tabbox.getSelectedPanel();
        if (selectedPanel != null) {
            for (Component c : selectedPanel.getChildren()) {
                if (!(c instanceof IADTabpanel)) continue;
                return (IADTabpanel)c;
            }
        }
        return null;
    }

    public Tabpanel getSelectedPanel() {
        return (Tabpanel)this.tabbox.getSelectedPanel();
    }

    public void setStatusMessage(String status, boolean error) {
        Tabpanel tp;
        IADTabpanel tabPanel = this.getSelectedADTabpanel();
        if (tabPanel == null) {
            return;
        }
        Hbox messageContainer = this.messageContainers.get(tabPanel.getAttribute("AD_Tab_ID"));
        Execution execution = Executions.getCurrent();
        if (execution != null) {
            String key = ((Object)((Object)this)).getClass().getName() + "." + messageContainer.getUuid();
            Object o = execution.getAttribute(key);
            if (o != null) {
                if (status == null || status.trim().length() == 0) {
                    return;
                }
            } else {
                execution.setAttribute(key, (Object)Boolean.TRUE);
            }
        }
        messageContainer.getChildren().clear();
        messageContainer.setAttribute(STATUS_ERROR_ATTRIBUTE, (Object)error);
        messageContainer.setAttribute(STATUS_TEXT_ATTRIBUTE, (Object)status);
        messageContainer.setSclass(error ? "docstatus-error" : "docstatus-normal");
        if (status == null || status.trim().length() == 0) {
            return;
        }
        String labelText = this.buildLabelText(status);
        if (error) {
            Component ref = this.isCollapsed(this) ? this.findTabpanel((Component)this) : this.findTabpanel((Component)messageContainer);
            Clients.showNotification((String)this.buildNotificationText(status), (String)"error", (Component)ref, (String)"top_left", (int)3500, (boolean)true);
        }
        Label label = new Label(labelText);
        messageContainer.appendChild((Component)label);
        if (labelText.length() != status.length()) {
            label.addEventListener("onClick", this);
            label.setStyle("cursor: pointer");
            label = new Label(" ...");
            label.setStyle("cursor: pointer");
            messageContainer.appendChild((Component)label);
            label.addEventListener("onClick", this);
        } else if (ClientInfo.maxWidth(700)) {
            label.addEventListener("onClick", this);
            label.setStyle("cursor: pointer");
        }
        messageContainer.appendChild((Component)new Space());
        if (!tabPanel.isGridView() && (tp = (Tabpanel)this.tabbox.getSelectedTabpanel()).getRecordToolbar() != null) {
            tp.getRecordToolbar().dynamicDisplay();
        }
    }

    private boolean isCollapsed(DetailPane detailPane) {
        Component parent = detailPane.getParent();
        while (parent != null) {
            if (parent instanceof LayoutRegion) {
                LayoutRegion lr = (LayoutRegion)parent;
                return !lr.isOpen();
            }
            parent = parent.getParent();
        }
        return false;
    }

    private String buildLabelText(String statusText) {
        if (statusText == null) {
            return "";
        }
        if (statusText.length() <= 80) {
            return statusText;
        }
        int index = statusText.indexOf(" - java.lang.Exception");
        if (index > 0) {
            return statusText.substring(0, index);
        }
        return statusText.substring(0, 80);
    }

    private String buildNotificationText(String statusText) {
        if (statusText == null) {
            return "";
        }
        if (statusText.length() <= 140) {
            return statusText;
        }
        int index = statusText.indexOf(" - java.lang.Exception");
        if (index > 0) {
            return statusText.substring(0, index);
        }
        return statusText.substring(0, 136) + " ...";
    }

    public void onEvent(Event event) throws Exception {
        if (event.getName().equals("onClick")) {
            Component messageContainer = event.getTarget().getParent();
            Boolean error = (Boolean)messageContainer.getAttribute(STATUS_ERROR_ATTRIBUTE);
            String status = (String)messageContainer.getAttribute(STATUS_TEXT_ATTRIBUTE);
            this.showPopup(error, status);
        } else if (event.getName().equals("onDynamicDisplay")) {
            if (LayoutUtils.isReallyVisible((Component)this)) {
                this.updateProcessToolbar();
            }
        } else if (event.getName().equals("onRedraw")) {
            ExecutionCtrl ctrl = (ExecutionCtrl)Executions.getCurrent();
            Event evt = ctrl.getNextEvent();
            if (evt != null) {
                Events.sendEvent((Event)evt);
                Events.postEvent((Event)new Event("onRedraw", (Component)this));
                return;
            }
            LayoutUtils.redraw((AbstractComponent)this);
        } else if (event.getName().equals("onCtrlKey")) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (LayoutUtils.isReallyVisible((Component)this)) {
                this.onCtrlKeyEvent(keyEvent);
            }
        }
    }

    protected void createPopupContent(String status) {
        Text t = new Text(status);
        this.msgPopupCnt.getChildren().clear();
        this.msgPopupCnt.appendChild((Component)t);
    }

    private void showPopup(boolean error, String msg) {
        Clients.showNotification((String)this.buildNotificationText(msg), (String)"error", null, (String)"at_pointer", (int)3500, (boolean)true);
    }

    private void createPopup() {
        this.msgPopupCnt = new Div();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.msgPopupCnt, "1");
        this.msgPopup = new Window();
        this.msgPopup.setVisible(false);
        this.msgPopup.setBorder(true);
        this.msgPopup.setClosable(true);
        this.msgPopup.setSizable(true);
        this.msgPopup.setContentStyle("overflow: auto");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.msgPopup, "500px");
        this.msgPopup.appendChild((Component)this.msgPopupCnt);
        this.msgPopup.setPage(SessionManager.getAppDesktop().getComponent().getPage());
        this.msgPopup.setShadow(true);
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this.msgPopup != null) {
            this.msgPopup.detach();
        }
        try {
            SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", this);
        }
        catch (Exception exception) {}
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null) {
            SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this);
        }
    }

    public void setVflex(String flex) {
        if (this.getHeight() != null) {
            this.setHeight(null);
        }
        super.setVflex(flex);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabbox, flex);
    }

    public void updateToolbar(boolean changed, boolean readOnly) {
        boolean enableNew;
        boolean deleteRecord;
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this.getTabcount()) {
            return;
        }
        Tabpanel tabpanel = (Tabpanel)this.tabbox.getTabpanel(index);
        ToolBar toolbar = tabpanel.getToolbar();
        IADTabpanel adtab = this.getADTabpanel(index);
        if (adtab == null) {
            return;
        }
        if (adtab.getGridTab().isSortTab() || adtab.getGridTab().isReadOnly()) {
            readOnly = true;
        }
        boolean insertRecord = !readOnly;
        boolean bl = deleteRecord = !readOnly;
        if (insertRecord) {
            insertRecord = adtab.getGridTab().isInsertRecord();
        }
        boolean bl2 = enableNew = insertRecord && !adtab.getGridTab().isSortTab();
        if (deleteRecord) {
            deleteRecord = adtab.getGridTab().isDeleteRecord();
        }
        boolean enableDelete = !changed && deleteRecord && !adtab.getGridTab().isSortTab() && !adtab.getGridTab().isProcessed();
        boolean enableCustomize = !adtab.getGridTab().isSortTab() && adtab.isGridView();
        ADWindow adwindow = ADWindow.findADWindow((Component)this);
        if (adwindow == null) {
            return;
        }
        List<String> tabRestrictList = adwindow.getTabToolbarRestrictList(adtab.getGridTab().getAD_Tab_ID());
        List<String> windowRestrictList = adwindow.getWindowToolbarRestrictList();
        for (Component c : toolbar.getChildren()) {
            if (!(c instanceof ToolBarButton)) continue;
            ToolBarButton btn = (ToolBarButton)c;
            if (BTN_NEW_ID.equals(btn.getId())) {
                btn.setDisabled(!enableNew);
            } else if (BTN_DELETE_ID.equals(btn.getId())) {
                btn.setDisabled(!enableDelete);
            } else if (BTN_EDIT_ID.equals(btn.getId())) {
                btn.setDisabled(false);
            } else if (BTN_SAVE_ID.equals(btn.getId())) {
                btn.setDisabled(!adtab.needSave(true, false));
            } else if (BTN_CUSTOMIZE_ID.equals(btn.getId())) {
                btn.setDisabled(!enableCustomize);
            } else if (BTN_QUICK_FORM_ID.equals(btn.getId())) {
                btn.setDisabled(!adtab.isEnableQuickFormButton() || adtab.getGridTab().isReadOnly());
            } else if (BTN_TOGGLE_ID.equals(btn.getId())) {
                btn.setDisabled(adtab.getGridTab().isSortTab());
            }
            if (windowRestrictList.contains(btn.getId())) {
                btn.setVisible(false);
                continue;
            }
            if (tabRestrictList.contains(btn.getId())) {
                btn.setVisible(false);
                continue;
            }
            if (tabpanel.toolbarCustomButtons.containsKey((Object)btn)) {
                ToolbarCustomButton customButton = tabpanel.toolbarCustomButtons.get((Object)btn);
                customButton.dynamicDisplay();
                continue;
            }
            btn.setVisible(true);
        }
        adtab.updateDetailToolbar(toolbar);
    }

    private void updateProcessToolbar() {
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this.getTabcount()) {
            return;
        }
        Tabpanel tabpanel = (Tabpanel)this.tabbox.getTabpanel(index);
        ToolBar toolbar = tabpanel.getToolbar();
        IADTabpanel adtab = this.getADTabpanel(index);
        if (adtab == null) {
            return;
        }
        for (Component c : toolbar.getChildren()) {
            ToolBarButton btn;
            if (!(c instanceof ToolBarButton) || !BTN_PROCESS_ID.equals((btn = (ToolBarButton)c).getId())) continue;
            if (adtab.getGridTab().isSortTab()) {
                btn.setDisabled(true);
                break;
            }
            boolean isToolbarDisabled = adtab.getToolbarButtons() == null || adtab.getToolbarButtons().isEmpty();
            btn.setDisabled(isToolbarDisabled);
            break;
        }
    }

    public void onEdit(boolean formView) throws Exception {
        Event openEvent = new Event(ON_EDIT_EVENT, (Component)this, (Object)formView);
        this.eventListener.onEvent(openEvent);
    }

    public void fireActivateDetailEvent() {
        int index = this.tabbox.getSelectedIndex();
        IADTabpanel tabPanel = (IADTabpanel)this.tabbox.getTabpanel(index).getChildren().get(1);
        Event activateEvent = new Event(ON_ACTIVATE_DETAIL_EVENT, (Component)tabPanel, (Object)this.prevSelectedIndex);
        Events.sendEvent((Event)activateEvent);
    }

    public void setTabVisibility(int tabIndex, boolean visible) {
        if (tabIndex < 0 || this.tabbox.getTabs() == null || tabIndex >= this.tabbox.getTabs().getChildren().size()) {
            return;
        }
        Tab tab = (Tab)((Object)this.tabbox.getTabs().getChildren().get(tabIndex));
        tab.setVisible(visible);
        if (tab.isSelected()) {
            tab.setSelected(false);
        }
        if (tab.getLinkedPanel() != null) {
            tab.getLinkedPanel().setVisible(visible);
        }
    }

    public boolean isTabVisible(int tabIndex) {
        if (tabIndex < 0 || this.tabbox.getTabs() == null || tabIndex >= this.tabbox.getTabs().getChildren().size()) {
            return false;
        }
        return ((Component)this.tabbox.getTabs().getChildren().get(tabIndex)).isVisible();
    }

    public boolean isTabEnabled(int tabIndex) {
        if (tabIndex < 0 || this.tabbox.getTabs() == null || tabIndex >= this.tabbox.getTabs().getChildren().size()) {
            return false;
        }
        Tab tab = (Tab)((Object)this.tabbox.getTabs().getChildren().get(tabIndex));
        return !tab.isDisabled();
    }

    public void setTabEnabled(int tabIndex, boolean enabled) {
        if (tabIndex < 0 || this.tabbox.getTabs() == null || tabIndex >= this.tabbox.getTabs().getChildren().size()) {
            return;
        }
        Tab tab = (Tab)((Object)this.tabbox.getTabs().getChildren().get(tabIndex));
        tab.setDisabled(!enabled);
    }

    public void disableToolbar() {
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this.getTabcount()) {
            return;
        }
        Tabpanel tabpanel = (Tabpanel)this.tabbox.getTabpanel(index);
        ToolBar toolbar = tabpanel.getToolbar();
        for (Component c : toolbar.getChildren()) {
            if (!(c instanceof ToolBarButton)) continue;
            ToolBarButton btn = (ToolBarButton)c;
            btn.setDisabled(true);
        }
    }

    private Component findTabpanel(Component comp) {
        Component parent = comp.getParent();
        while (parent != null) {
            if (parent instanceof org.adempiere.webui.component.Tabpanel) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public void onNew() throws Exception {
        Event openEvent = new Event(ON_NEW_EVENT, (Component)this);
        this.eventListener.onEvent(openEvent);
    }

    private void onCtrlKeyEvent(KeyEvent keyEvent) {
        ToolBarButton btn = null;
        if (keyEvent.isAltKey() && !keyEvent.isCtrlKey() && keyEvent.isShiftKey()) {
            if (keyEvent.getKeyCode() == 78) {
                btn = this.getSelectedPanel().getToolbarButton(BTN_NEW_ID);
            } else if (keyEvent.getKeyCode() == 84) {
                btn = this.getSelectedPanel().getToolbarButton(BTN_TOGGLE_ID);
            } else if (keyEvent.getKeyCode() == 36) {
                btn = this.getSelectedPanel().getRecordToolbar().btnFirst;
            } else if (keyEvent.getKeyCode() == 35) {
                btn = this.getSelectedPanel().getRecordToolbar().btnLast;
            } else if (keyEvent.getKeyCode() == 37) {
                btn = this.getSelectedPanel().getRecordToolbar().btnPrevious;
            } else if (keyEvent.getKeyCode() == 39) {
                btn = this.getSelectedPanel().getRecordToolbar().btnNext;
            } else if (keyEvent.getKeyCode() == 36) {
                btn = this.getSelectedPanel().getRecordToolbar().btnFirst;
            } else if (keyEvent.getKeyCode() == 69) {
                btn = this.getSelectedPanel().getToolbarButton(BTN_EDIT_ID);
            } else if (keyEvent.getKeyCode() == 83) {
                btn = this.getSelectedPanel().getToolbarButton(BTN_SAVE_ID);
            } else if (keyEvent.getKeyCode() == 68) {
                btn = this.getSelectedPanel().getToolbarButton(BTN_DELETE_ID);
            } else if (keyEvent.getKeyCode() == 79) {
                btn = this.getSelectedPanel().getToolbarButton(BTN_PROCESS_ID);
            } else if (keyEvent.getKeyCode() == 70) {
                btn = this.getSelectedPanel().getToolbarButton(BTN_QUICK_FORM_ID);
            }
        }
        if (btn != null) {
            keyEvent.stopPropagation();
            if (!btn.isDisabled() && btn.isVisible()) {
                Events.sendEvent((Component)btn, (Event)new Event("onClick", (Component)btn));
                String script = "(function(){let w=zk.Widget.$('#" + btn.getUuid() + "'); zWatch.fire('onFloatUp', w);})()";
                Clients.response((AuResponse)new AuScript(script));
            }
        }
    }

    private static class RecordToolbar
    extends Hlayout {
        private static final long serialVersionUID = -3369063577339438823L;
        private ToolBarButton btnFirst;
        private ToolBarButton btnPrevious;
        private ToolBarButton btnRecordInfo;
        private ToolBarButton btnNext;
        private ToolBarButton btnLast;
        private GridTab gridTab;

        private RecordToolbar(GridTab gridTab) {
            this.gridTab = gridTab;
            this.btnFirst = this.createButton("First", "First", "First");
            this.btnFirst.setTooltiptext(this.btnFirst.getTooltiptext() + "    Shift+Alt+Home");
            this.appendChild((Component)this.btnFirst);
            this.btnFirst.addEventListener("onClick", e -> {
                Event ne = new Event(DetailPane.ON_RECORD_NAVIGATE_EVENT, (Component)this, (Object)"first");
                Events.sendEvent((Component)this, (Event)ne);
            });
            this.btnPrevious = this.createButton("Previous", "Previous", "Previous");
            this.btnPrevious.setTooltiptext(this.btnPrevious.getTooltiptext() + "    Shift+Alt+Left");
            this.appendChild((Component)this.btnPrevious);
            this.btnPrevious.addEventListener("onClick", e -> {
                Event ne = new Event(DetailPane.ON_RECORD_NAVIGATE_EVENT, (Component)this, (Object)"previous");
                Events.sendEvent((Component)this, (Event)ne);
            });
            this.btnRecordInfo = new ToolBarButton();
            this.btnRecordInfo.setLabel("");
            this.btnRecordInfo.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Who")));
            this.btnRecordInfo.addEventListener("onClick", e -> {
                if (gridTab.isNew() || gridTab.getRowCount() == 0) {
                    return;
                }
                DataStatusEvent dse = new DataStatusEvent((Object)gridTab, gridTab.getRowCount(), gridTab.needSave(true, true), true, false);
                dse.AD_Table_ID = gridTab.getAD_Table_ID();
                gridTab.updateDataStatusEventProperties(dse);
                dse.setCurrentRow(gridTab.getCurrentRow());
                String title = Msg.getMsg((Properties)Env.getCtx(), (String)"Who") + this.btnRecordInfo.getLabel();
                new WRecordInfo(title, dse, gridTab);
            });
            this.btnRecordInfo.setSclass("breadcrumb-record-info link");
            this.btnRecordInfo.setId("recordInfo");
            this.btnRecordInfo.setStyle("float: none; display: inline-flex; width: auto;");
            this.appendChild((Component)this.btnRecordInfo);
            this.btnNext = this.createButton("Next", "Next", "Next");
            this.btnNext.setTooltiptext(this.btnNext.getTooltiptext() + "    Shift+Alt+Right");
            this.btnNext.addEventListener("onClick", e -> {
                Event ne = new Event(DetailPane.ON_RECORD_NAVIGATE_EVENT, (Component)this, (Object)"next");
                Events.sendEvent((Component)this, (Event)ne);
            });
            this.appendChild((Component)this.btnNext);
            this.btnLast = this.createButton("Last", "Last", "Last");
            this.btnLast.setTooltiptext(this.btnLast.getTooltiptext() + "    Shift+Alt+End");
            this.btnLast.addEventListener("onClick", e -> {
                Event ne = new Event(DetailPane.ON_RECORD_NAVIGATE_EVENT, (Component)this, (Object)"last");
                Events.sendEvent((Component)this, (Event)ne);
            });
            this.appendChild((Component)this.btnLast);
            this.setValign("middle");
        }

        private ToolBarButton createButton(String name, String image, String tooltip) {
            ToolBarButton btn = new ToolBarButton("");
            btn.setName("Btn" + name);
            btn.setId(name);
            String suffix = "16.png";
            if (ThemeManager.isUseFontIconForImage()) {
                btn.setIconSclass("z-icon-" + image + "Record");
            } else {
                btn.setImage(ThemeManager.getThemeResource("images/" + image + suffix));
            }
            btn.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)tooltip));
            btn.setSclass("breadcrumb-toolbar-button");
            this.appendChild((Component)btn);
            btn.setTabindex(0);
            btn.setDisabled(true);
            btn.setStyle("float: none");
            return btn;
        }

        private void dynamicDisplay() {
            int rowCount = this.gridTab.getRowCount();
            int currentRow = this.gridTab.getCurrentRow() + 1;
            this.btnRecordInfo.setLabel(currentRow + "/" + rowCount);
            this.btnFirst.setDisabled(currentRow <= 1);
            this.btnPrevious.setDisabled(currentRow <= 1);
            this.btnNext.setDisabled(currentRow == rowCount);
            this.btnLast.setDisabled(currentRow == rowCount);
            this.invalidate();
        }
    }

    public static class Tabpanel
    extends org.adempiere.webui.component.Tabpanel {
        private static final long serialVersionUID = -2502140440194514450L;
        private ToolBar toolbar;
        private RecordToolbar recordToolBar;
        private Div pagingControl;
        private boolean toggleToFormView = false;
        private IADTabpanel adTabPanel;
        private HashMap<ToolBarButton, ToolbarCustomButton> toolbarCustomButtons = new HashMap();
        private A overflowButton;
        private Popup overflowPopup;

        public Tabpanel() {
            this.setSclass("adwindow-detailpane-tabpanel");
            this.toolbar = new ToolBar();
            this.appendChild((Component)this.toolbar);
        }

        public void afterToggle() {
            if (this.getPagingControl() != null) {
                this.getPagingControl().setVisible(!this.toggleToFormView);
            }
            if (this.getRecordToolbar() != null) {
                this.getRecordToolbar().setVisible(this.toggleToFormView);
                if (this.getRecordToolbar().isVisible()) {
                    this.getRecordToolbar().dynamicDisplay();
                }
            }
            boolean enableCustomize = !this.adTabPanel.getGridTab().isSortTab() && this.adTabPanel.isGridView();
            Optional<ToolBarButton> optional = this.getToolbarButtons().stream().filter(e -> DetailPane.BTN_CUSTOMIZE_ID.equals(e.getId())).findFirst();
            if (optional.isPresent()) {
                optional.get().setDisabled(!enableCustomize);
            }
        }

        public void setToggleToFormView(boolean b) {
            this.toggleToFormView = b;
        }

        public boolean isToggleToFormView() {
            return this.toggleToFormView;
        }

        public void setADTabpanel(IADTabpanel tabPanel) {
            this.appendChild(tabPanel);
            this.adTabPanel = tabPanel;
            if (tabPanel instanceof ADTabpanel) {
                tabPanel.addEventListener("onSwitchView", e -> {
                    if (this.recordToolBar != null && tabPanel.isGridView()) {
                        this.recordToolBar.setVisible(false);
                    }
                });
            }
        }

        public ToolBar getToolbar() {
            return this.toolbar;
        }

        public void setRecordToolbar(RecordToolbar rtb) {
            this.recordToolBar = rtb;
            Object parent = this.overflowPopup != null ? this.overflowPopup : this.toolbar;
            parent.appendChild((Component)rtb);
            rtb.setVisible(false);
            if (this.overflowPopup == null) {
                rtb.setSclass("adwindow-detailpane-adtab-grid-south");
            }
        }

        public RecordToolbar getRecordToolbar() {
            return this.recordToolBar;
        }

        public void setPagingControl(Div pagingControl) {
            Object parent;
            Object object = parent = this.overflowPopup != null ? this.overflowPopup : this.toolbar;
            if (pagingControl.getParent() != parent) {
                parent.appendChild((Component)pagingControl);
                ZKUpdateUtil.setHflex((HtmlBasedComponent)pagingControl, "0");
                if (this.overflowPopup == null) {
                    pagingControl.setSclass("adwindow-detailpane-adtab-grid-south");
                }
            }
            this.pagingControl = pagingControl;
        }

        public Div getPagingControl() {
            return this.pagingControl;
        }

        public ToolBarButton getToolbarButton(String id) {
            Optional<ToolBarButton> optional = this.getToolbarButtons().stream().filter(e -> e.getId().equals(id)).findFirst();
            return optional.isPresent() ? optional.get() : null;
        }

        private List<ToolBarButton> getToolbarButtons() {
            ArrayList<ToolBarButton> list = new ArrayList<ToolBarButton>();
            for (Component c : this.toolbar.getChildren()) {
                if (!(c instanceof ToolBarButton)) continue;
                list.add((ToolBarButton)c);
            }
            return list;
        }

        private void createOverflowButton() {
            this.overflowButton = new A();
            this.overflowButton.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"ShowMore"));
            this.overflowButton.setIconSclass("z-icon-ShowMore");
            this.overflowButton.setSclass("font-icon-toolbar-button toolbar-button mobile-overflow-link");
            this.toolbar.appendChild((Component)this.overflowButton);
            this.newOverflowPopup();
            this.toolbar.appendChild((Component)this.overflowPopup);
            this.overflowButton.addEventListener("onClick", e -> {
                Long ts = (Long)this.overflowPopup.removeAttribute("popup.close");
                if (ts != null && System.currentTimeMillis() - ts < 500L) {
                    return;
                }
                this.overflowPopup.open((Component)this.overflowButton, "after_end");
            });
        }

        private void newOverflowPopup() {
            this.overflowPopup = new Popup();
            this.overflowPopup.setHflex("min");
            this.overflowPopup.setVflex("min");
        }
    }
}

