/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.AdempiereWebUI;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.North;
import org.zkoss.zul.South;

public class WMediaDialog
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -329919930778203892L;
    private static final CLogger log = CLogger.getCLogger(WMediaDialog.class);
    private Object m_data;
    private boolean m_change = false;
    private Iframe preview = new Iframe();
    private Button bDelete = new Button();
    private Button bSave = new Button();
    private Button bLoad = new Button();
    private Button bCancel = new Button();
    private Button bOk = new Button();
    private Panel previewPanel = new Panel();
    private Borderlayout mainPanel = new Borderlayout();
    private Hbox toolBar = new Hbox();
    private Hbox confirmPanel = new Hbox();
    private boolean m_cancel;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));

    public WMediaDialog(String title, Object data) {
        this.setTitle(title);
        try {
            this.staticInit();
            this.m_data = data;
            this.displayData();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    protected void staticInit() throws Exception {
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 500);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 500);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> this.afterPageAttached());
        }
        this.setSclass("media-dialog");
        this.setClosable(true);
        this.setSizable(true);
        this.setMaximizable(true);
        this.setBorder("normal");
        this.appendChild((Component)this.mainPanel);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.mainPanel, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.mainPanel, "100%");
        North northPanel = new North();
        northPanel.setCollapsible(false);
        northPanel.setSplittable(false);
        this.toolBar.appendChild((Component)this.bLoad);
        this.toolBar.appendChild((Component)this.bDelete);
        this.toolBar.appendChild((Component)this.bSave);
        this.mainPanel.appendChild((Component)northPanel);
        northPanel.appendChild((Component)this.toolBar);
        this.bSave.setEnabled(false);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bSave.setIconSclass("z-icon-Export");
        } else {
            this.bSave.setImage(ThemeManager.getThemeResource("images/Download24.png"));
        }
        this.bSave.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"AttachmentSave"));
        this.bSave.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bLoad.setIconSclass("z-icon-Import");
        } else {
            this.bLoad.setImage(ThemeManager.getThemeResource("images/Upload24.png"));
        }
        this.bLoad.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Load"));
        this.bLoad.addEventListener("onUpload", this);
        this.bLoad.setUpload(AdempiereWebUI.getUploadSetting());
        if (ThemeManager.isUseFontIconForImage()) {
            this.bDelete.setIconSclass("z-icon-Delete");
        } else {
            this.bDelete.setImage(ThemeManager.getThemeResource("images/Delete24.png"));
        }
        this.bDelete.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Delete"));
        this.bDelete.addEventListener("onClick", this);
        this.previewPanel.appendChild((Component)this.preview);
        ZkCssHelper.appendStyle((HtmlBasedComponent)this.previewPanel, "margin-top: 10px; margin-bottom: 10px;");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.preview, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.preview, "100%");
        Center centerPane = new Center();
        centerPane.setAutoscroll(true);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.previewPanel, "true");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.previewPanel, "true");
        this.mainPanel.appendChild((Component)centerPane);
        centerPane.appendChild((Component)this.previewPanel);
        South southPane = new South();
        this.mainPanel.appendChild((Component)southPane);
        southPane.appendChild((Component)this.confirmPanel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)southPane, "min");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bOk.setIconSclass("z-icon-Ok");
        } else {
            this.bOk.setImage(ThemeManager.getThemeResource("images/Ok24.png"));
        }
        this.bOk.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bCancel.setIconSclass("z-icon-Cancel");
        } else {
            this.bCancel.setImage(ThemeManager.getThemeResource("images/Cancel24.png"));
        }
        this.bCancel.addEventListener("onClick", this);
        this.confirmPanel.appendChild((Component)this.bOk);
        this.confirmPanel.appendChild((Component)this.bCancel);
        this.confirmPanel.setStyle("float: right;");
        this.addEventListener("onCancel", e -> this.onCancel());
    }

    private void afterPageAttached() {
        ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
        ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
    }

    @Override
    public void dispose() {
        this.preview = null;
        this.detach();
    }

    private void displayData() {
        this.preview.setVisible(false);
        this.bDelete.setEnabled(false);
        this.bSave.setEnabled(false);
        if (this.m_data != null) {
            this.bSave.setEnabled(true);
            this.bDelete.setEnabled(true);
            try {
                AMedia media = this.createMedia();
                this.preview.setContent((Media)media);
                this.preview.setClientAttribute("sandbox", "");
                this.preview.setVisible(true);
                this.preview.invalidate();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to preview content", (Throwable)e);
            }
        }
    }

    private AMedia createMedia() throws SQLException {
        AMedia media;
        String contentType = null;
        if (this.m_data instanceof byte[]) {
            media = new AMedia(this.getTitle(), null, contentType, (byte[])this.m_data);
        } else if (this.m_data instanceof Blob) {
            media = new AMedia(this.getTitle(), null, contentType, ((Blob)this.m_data).getBinaryStream());
        } else if (this.m_data instanceof Clob) {
            Clob clob = (Clob)this.m_data;
            long length = clob.length() > 100L ? 100L : clob.length();
            String data = ((Clob)this.m_data).getSubString(1L, Long.valueOf(length).intValue());
            contentType = data.toUpperCase().indexOf("<html>") >= 0 ? "text/html" : "text/plain";
            media = new AMedia(this.getTitle(), null, contentType, ((Clob)this.m_data).getCharacterStream());
        } else {
            contentType = "text/plain";
            media = new AMedia(this.getTitle(), null, contentType, this.m_data.toString());
        }
        return media;
    }

    public void onEvent(Event e) {
        if (e.getTarget() == this.bOk) {
            this.dispose();
        } else if (e.getTarget() == this.bCancel) {
            this.onCancel();
        } else if (e.getTarget() == this.bDelete) {
            this.m_data = null;
            this.m_change = true;
            this.displayData();
        } else if (e.getTarget() == this.bSave) {
            this.save();
        } else if (e instanceof UploadEvent) {
            UploadEvent ue = (UploadEvent)e;
            this.processUploadMedia(ue.getMedia());
        }
    }

    private void onCancel() {
        if (this.isUseEscForTabClosing) {
            SessionManager.getAppDesktop().setCloseTabWithShortcut(false);
        }
        this.m_cancel = true;
        this.dispose();
    }

    private void processUploadMedia(Media media) {
        if (media == null) {
            return;
        }
        String fileName = media.getName();
        if (log.isLoggable(Level.CONFIG)) {
            log.config(fileName);
        }
        this.m_change = true;
        this.m_data = media.getByteData();
        this.displayData();
    }

    private void save() {
        if (this.m_data == null) {
            return;
        }
        try {
            AMedia media = this.createMedia();
            Filedownload.save((Media)media);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to export content.", (Throwable)e);
        }
    }

    public boolean isCancel() {
        return this.m_cancel;
    }

    public boolean isChange() {
        return this.m_change;
    }

    public Object getData() {
        return this.m_data;
    }

    public void focus() {
        super.focus();
        this.bLoad.focus();
    }
}

