/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.DBException;
import org.adempiere.webui.component.AutoComplete;
import org.compiere.grid.ed.CityVO;
import org.compiere.model.MSysConfig;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zul.Timer;

public class WAutoCompleterCity
extends AutoComplete
implements EventListener<Event> {
    private static final long serialVersionUID = -5130826429569842714L;
    private static final int PopupDelayMillis = 500;
    private final Timer timer = new Timer(500);
    private CityVO m_city = null;
    private ArrayList<CityVO> m_cities = new ArrayList();
    private ArrayList<CityVO> m_citiesShow = new ArrayList();
    private final int m_maxRows = MSysConfig.getIntValue((String)"LOCATION_MAX_CITY_ROWS", (int)7);
    public static final CityVO ITEM_More = new CityVO(-1, "...", -1, "");
    private final int m_windowNo;

    public WAutoCompleterCity(int m_windowNo) {
        this.m_windowNo = m_windowNo;
        this.addEventListener("onSelect", this);
    }

    private void showPopupDelayed() {
        this.timer.setRepeats(false);
        this.timer.start();
    }

    @Override
    public void onChanging(InputEvent evt) {
        this.showPopupDelayed();
        this.refreshData(evt.getValue());
        super.onChanging(evt);
    }

    public void refreshData(String val) {
        String search = val;
        if (this.m_city != null && this.m_city.CityName.compareTo(search) != 0) {
            this.setCity(null);
        }
        this.m_citiesShow.clear();
        this.removeAllItems();
        this.setDict(null);
        this.setDescription(null);
        boolean truncated = false;
        search = search.toUpperCase();
        int i = 0;
        for (CityVO vo : this.m_cities) {
            if (!vo.CityName.toUpperCase().startsWith(search)) continue;
            if (i > 0 && i == this.m_maxRows + 1) {
                this.m_citiesShow.add(ITEM_More);
                truncated = true;
                break;
            }
            this.m_citiesShow.add(vo);
            ++i;
        }
        if (this.m_citiesShow.isEmpty()) {
            return;
        }
        CityVO city = this.m_citiesShow.get(0);
        if (city.CityName.equalsIgnoreCase(search)) {
            this.m_city = city;
            return;
        }
        if (!truncated && this.m_citiesShow.size() == 1 && this.m_city != null && this.m_citiesShow.get(0).equals((Object)this.m_city)) {
            return;
        }
        String[] cityValues = new String[this.m_citiesShow.size()];
        String[] cityDesc = new String[this.m_citiesShow.size()];
        i = 0;
        for (CityVO vo : this.m_citiesShow) {
            cityValues[i] = vo.CityName;
            cityDesc[i] = vo.RegionName;
            ++i;
        }
        this.removeAllItems();
        this.setDict(cityValues, false);
        this.setDescription(cityDesc);
    }

    public void fillList() {
        this.m_cities.clear();
        this.m_citiesShow.clear();
        ArrayList<Integer> params = new ArrayList<Integer>();
        StringBuilder sql = new StringBuilder("SELECT cy.C_City_ID, cy.Name, cy.C_Region_ID, r.Name FROM C_City cy LEFT OUTER JOIN C_Region r ON (r.C_Region_ID=cy.C_Region_ID) WHERE cy.AD_Client_ID IN (0,?) AND cy.IsActive = 'Y'");
        params.add(this.getAD_Client_ID());
        if (this.getC_Region_ID() > 0) {
            sql.append(" AND cy.C_Region_ID=?");
            params.add(this.getC_Region_ID());
        }
        if (this.getC_Country_ID() > 0) {
            sql.append(" AND cy.C_Country_ID=?");
            params.add(this.getC_Country_ID());
        }
        sql.append(" ORDER BY cy.Name, r.Name");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), null);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                int i = 0;
                while (rs.next()) {
                    CityVO vo = new CityVO(rs.getInt(1), rs.getString(2), rs.getInt(3), rs.getString(4));
                    this.m_cities.add(vo);
                    if (i <= this.m_maxRows) {
                        this.m_citiesShow.add(vo);
                    } else if (i == this.m_maxRows + 1 && i > 0) {
                        this.m_citiesShow.add(ITEM_More);
                    }
                    ++i;
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        this.refreshData("");
    }

    private void setCity(CityVO vo) {
        this.m_city = vo;
    }

    public int getC_City_ID() {
        return this.m_city != null ? this.m_city.C_City_ID : -1;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public int getC_Country_ID() {
        return Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_windowNo, (int)1113, (String)"C_Country_ID");
    }

    public int getC_Region_ID() {
        return Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_windowNo, (int)1113, (String)"C_Region_ID");
    }

    public void onEvent(Event event) throws Exception {
        int index = this.getSelectedIndex();
        if (index >= 0) {
            CityVO city = this.m_citiesShow.get(index);
            if (event == null || city.equals((Object)ITEM_More)) {
                this.setCity(null);
                return;
            }
            this.setCity(city);
            Env.setContext((Properties)Env.getCtx(), (int)this.m_windowNo, (int)1113, (String)"C_Region_ID", (String)String.valueOf(city.C_Region_ID));
            this.setText(city.CityName);
        }
    }
}

