/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.scheduler;

import java.util.Properties;
import org.adempiere.base.Core;
import org.adempiere.util.Callback;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.action.IAction;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.ADWindowContent;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MScheduler;
import org.compiere.server.AdempiereServerMgr;
import org.compiere.server.IServerManager;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.distributed.IClusterService;
import org.idempiere.server.cluster.ClusterServerMgr;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Toolbarbutton;

@org.osgi.service.component.annotations.Component(name="org.adempiere.webui.scheduler.ChangeStateAction", service={IAction.class})
public class ChangeStateAction
implements IAction,
EventListener<Event> {
    private static final String ON_START_SCHEDULER_EVENT = "onStartScheduler";
    private static final String ON_STOP_SCHEDULER_EVENT = "onStopScheduler";
    private static final String ON_ADD_SCHEDULER_EVENT = "onAddScheduler";
    private static final String SCHEDULER_MODEL = "scheduler.model";
    private static final String SCHEDULER_STATE = "scheduler.state";

    @Override
    public void execute(Object target) {
        ADWindow adwindow;
        ADWindowContent content;
        GridTab gridTab;
        if (target instanceof ADWindow && "AD_Scheduler".equals((gridTab = (content = (adwindow = (ADWindow)target).getADWindowContent()).getADTab().getADTabpanel(0).getGridTab()).getTableName()) && gridTab.getRecord_ID() > 0) {
            MScheduler scheduler = new MScheduler(Env.getCtx(), gridTab.getRecord_ID(), null);
            IServerManager serverMgr = this.getServerMgr();
            int status = serverMgr.getServerStatus(scheduler.getServerID());
            String label = null;
            if (status == 0) {
                label = Msg.getMsg((Properties)Env.getCtx(), (String)"SchedulerNotSchedule");
            } else if (status == 1) {
                label = Msg.getMsg((Properties)Env.getCtx(), (String)"SchedulerStarted");
            } else if (status == 2) {
                label = Msg.getMsg((Properties)Env.getCtx(), (String)"SchedulerStopped");
            } else {
                Dialog.error(content.getWindowNo(), "CantReadCurrentSchedulerState");
            }
            if (label == null) {
                return;
            }
            Button btn = ButtonFactory.createButton(label, null, null);
            btn.setAttribute(SCHEDULER_STATE, status);
            btn.setAttribute(SCHEDULER_MODEL, scheduler);
            btn.addActionListener(this);
            Popup popup = new Popup();
            popup.appendChild((Component)btn);
            content.getComponent().appendChild((Component)popup);
            popup.open((Component)content.getToolbar().getButton("SchedulerState"), "after_end");
            GridField descriptionField = gridTab.getField("Description");
            if (!descriptionField.isEditable(Env.getCtx(), true, false)) {
                btn.setEnabled(false);
            }
            btn.addEventListener(ON_START_SCHEDULER_EVENT, evt -> {
                Object schedulerAttr = evt.getTarget().getAttribute(SCHEDULER_MODEL);
                if (schedulerAttr != null && schedulerAttr instanceof MScheduler) {
                    MScheduler model = (MScheduler)schedulerAttr;
                    String error = serverMgr.start(model.getServerID());
                    if (error == null) {
                        Dialog.info(0, "SchedulerStartSuccess");
                    } else {
                        Dialog.error(0, "SchedulerStartFail", error);
                    }
                    Clients.clearBusy();
                }
            });
            btn.addEventListener(ON_STOP_SCHEDULER_EVENT, evt -> {
                Object schedulerAttr = evt.getTarget().getAttribute(SCHEDULER_MODEL);
                if (schedulerAttr != null && schedulerAttr instanceof MScheduler) {
                    MScheduler model = (MScheduler)schedulerAttr;
                    String error = serverMgr.stop(model.getServerID());
                    if (error == null) {
                        Dialog.info(0, "SchedulerStopSuccess");
                    } else {
                        Dialog.error(0, "SchedulerStopFail", error);
                    }
                    Clients.clearBusy();
                }
            });
            btn.addEventListener(ON_ADD_SCHEDULER_EVENT, evt -> {
                Object schedulerAttr = evt.getTarget().getAttribute(SCHEDULER_MODEL);
                if (schedulerAttr != null && schedulerAttr instanceof MScheduler) {
                    String error = serverMgr.addScheduler(scheduler);
                    if (error == null) {
                        Dialog.info(0, "SchedulerAddAndStartSuccess");
                    } else {
                        Dialog.error(0, "SchedulerAddAndStartFail", error);
                    }
                    Clients.clearBusy();
                }
            });
        }
    }

    private IServerManager getServerMgr() {
        Object serverMgr = null;
        IClusterService service = Core.getClusterService();
        serverMgr = service != null ? ClusterServerMgr.getInstance() : AdempiereServerMgr.get((boolean)false);
        return serverMgr;
    }

    @Override
    public void decorate(Toolbarbutton toolbarButton) {
        if (Util.isEmpty((String)toolbarButton.getTooltiptext())) {
            toolbarButton.setTooltiptext(toolbarButton.getLabel());
        }
        toolbarButton.setIconSclass("z-icon-spinner");
        toolbarButton.setLabel(null);
        toolbarButton.setImageContent(null);
        LayoutUtils.addSclass("font-icon-toolbar-button", (HtmlBasedComponent)toolbarButton);
    }

    public void onEvent(final Event evt) throws Exception {
        Object stateAttr = evt.getTarget().getAttribute(SCHEDULER_STATE);
        Object schedulerAttr = evt.getTarget().getAttribute(SCHEDULER_MODEL);
        if (stateAttr != null && stateAttr instanceof Number && schedulerAttr != null && schedulerAttr instanceof MScheduler) {
            int state = ((Number)stateAttr).intValue();
            if (state == 0) {
                Dialog.ask(0, "SchedulerAddAndStartPrompt", new Callback<Boolean>(){

                    public void onCallback(Boolean result) {
                        if (result.booleanValue()) {
                            Clients.showBusy((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
                            Events.echoEvent((String)ChangeStateAction.ON_ADD_SCHEDULER_EVENT, (Component)evt.getTarget(), null);
                        }
                    }
                });
            } else if (state == 1) {
                Dialog.ask(0, "SchedulerStopPrompt", new Callback<Boolean>(){

                    public void onCallback(Boolean result) {
                        if (result.booleanValue()) {
                            Clients.showBusy((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
                            Events.echoEvent((String)ChangeStateAction.ON_STOP_SCHEDULER_EVENT, (Component)evt.getTarget(), null);
                        }
                    }
                });
            } else if (state == 2) {
                Dialog.ask(0, "SchedulerStartPrompt", new Callback<Boolean>(){

                    public void onCallback(Boolean result) {
                        if (result.booleanValue()) {
                            Clients.showBusy((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
                            Events.echoEvent((String)ChangeStateAction.ON_START_SCHEDULER_EVENT, (Component)evt.getTarget(), null);
                        }
                    }
                });
            }
        }
    }
}

