/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.ADWindowContent;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.ComboEditorBox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.IZoomableEditor;
import org.adempiere.webui.editor.InfoListSubModel;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.DrillEvent;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.factory.InfoManager;
import org.adempiere.webui.grid.WQuickEntry;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.panel.InfoPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.util.Clients;

public class WSearchEditor
extends WEditor
implements ContextMenuListener,
ValueChangeListener,
IZoomableEditor {
    private static final int DEFAULT_MAX_AUTO_COMPLETE_ROWS = 500;
    private static final String[] LISTENER_EVENTS = new String[]{"onClick", "onChange", "onOK"};
    public static final String ATTRIBUTE_IS_INFO_PANEL_OPEN = "ATTRIBUTE_IS_INFO_PANEL_OPEN";
    protected Lookup lookup;
    private String m_tableName = null;
    private String m_keyColumnName = null;
    private String columnName;
    private Object value;
    protected InfoPanel infoPanel = null;
    private String imageUrl;
    private InfoListSubModel listModel = null;
    private static final CLogger log = CLogger.getCLogger(WSearchEditor.class);
    private static final String IN_PROGRESS_IMAGE = "~./zk/img/progress3.gif";
    protected ADWindow adwindow;
    private EventListener<InputEvent> autoCompleteListener;
    protected boolean multipleSelection = false;

    public WSearchEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WSearchEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new CustomSearchBox(), gridField, tableEditor, editorConfiguration);
        this.lookup = gridField.getLookup();
        if (this.lookup != null) {
            this.columnName = this.lookup.getColumnName();
        }
        this.init();
        this.getComponent().setAttribute(ATTRIBUTE_IS_INFO_PANEL_OPEN, false);
        this.multipleSelection = true;
    }

    public ComboEditorBox getComponent() {
        return (ComboEditorBox)super.getComponent();
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    public WSearchEditor(Lookup lookup, String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super((Component)new CustomSearchBox(), label, description, mandatory, readonly, updateable);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        this.columnName = lookup.getColumnName();
        super.setColumnName(this.columnName);
        this.init();
        this.multipleSelection = false;
    }

    public WSearchEditor(String columnName, boolean mandatory, boolean readonly, boolean updateable, Lookup lookup) {
        super((Component)new CustomSearchBox(), null, null, mandatory, readonly, updateable);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        this.columnName = columnName;
        super.setColumnName(columnName);
        this.init();
        this.multipleSelection = false;
    }

    private void init() {
        this.columnName = this.getColumnName();
        if (Util.isEmpty((String)this.m_tableName)) {
            this.setTableAndKeyColumn();
        }
        boolean enableDrill = false;
        if (this.getGridField() != null && this.getGridField().getGridTab() != null && this.getGridField().getColumnName().endsWith("_ID") && MRole.getDefault().isCanReport(this.getGridField().getGridTab().getAD_Table_ID())) {
            enableDrill = true;
        }
        if (this.m_tableName.equals("C_BPartner")) {
            this.popupMenu = new WEditorPopupMenu(true, true, this.isShowPreference(), true, true, false, enableDrill, this.lookup);
            this.imageUrl = ThemeManager.isUseFontIconForImage() ? "z-icon-BPartner" : ThemeManager.getThemeResource("images/BPartner16.png");
        } else if (this.m_tableName.equals("M_Product")) {
            this.popupMenu = new WEditorPopupMenu(true, true, this.isShowPreference(), false, false, false, enableDrill, this.lookup);
            this.imageUrl = ThemeManager.isUseFontIconForImage() ? "z-icon-Product" : ThemeManager.getThemeResource("images/Product16.png");
        } else {
            this.popupMenu = new WEditorPopupMenu(true, true, this.isShowPreference(), false, false, false, enableDrill, this.lookup);
            this.imageUrl = ThemeManager.isUseFontIconForImage() ? "z-icon-More" : ThemeManager.getThemeResource("images/PickOpen16.png");
        }
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass(this.imageUrl);
        } else {
            this.getComponent().getButton().setImage(this.imageUrl);
        }
        this.addChangeLogMenu(this.popupMenu);
        if (this.gridField != null) {
            this.getComponent().getCombobox().setPlaceholder(this.gridField.getPlaceholder());
        }
        if (this.gridField != null && this.gridField.isAutocomplete()) {
            this.enableAutoComplete();
        } else {
            this.getComponent().getCombobox().setAutodrop(false);
        }
    }

    public void enableAutoComplete() {
        if (this.autoCompleteListener != null) {
            return;
        }
        if (this.m_tableName == null) {
            this.setTableAndKeyColumn();
        }
        this.listModel = new InfoListSubModel(this.lookup, this.gridField, this.m_tableName, this.m_keyColumnName);
        int maxRows = MSysConfig.getIntValue((String)"ZK_SEARCH_AUTO_COMPLETE_MAX_ROWS", (int)500, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        this.getComponent().getCombobox().setModel(this.listModel.getSubModel(null, maxRows));
        this.autoCompleteListener = e -> {
            if (!e.isChangingBySelectBack()) {
                this.listModel.setWhereClause(this.getWhereClause());
                String s = e.getValue();
                this.getComponent().getCombobox().setModel(this.listModel.getSubModel(s, maxRows));
            }
        };
        this.getComponent().getCombobox().addEventListener("onChanging", this.autoCompleteListener);
        this.getComponent().getCombobox().setAutodrop(true);
    }

    public void disableAutoComplete() {
        if (this.autoCompleteListener != null) {
            this.getComponent().getCombobox().removeEventListener("onChanging", this.autoCompleteListener);
            this.getComponent().getCombobox().setAutodrop(false);
            this.getComponent().getCombobox().setModel(null);
            this.listModel = null;
            this.autoCompleteListener = null;
        }
    }

    @Override
    public void setValue(Object value) {
        Object curValue = this.value;
        this.value = value;
        if (value != null && !"".equals(String.valueOf(value))) {
            NamePair namePair = this.lookup.get(value);
            if (namePair != null) {
                String text = namePair.toString();
                if (text.startsWith("_")) {
                    text = text.substring(1);
                }
                this.getComponent().setText(text);
            } else if (value instanceof Integer && this.gridField != null && this.gridField.getDisplayType() != 13 && (this.gridTab == null || !this.gridTab.getTableModel().isImporting())) {
                String refTable;
                MColumn col;
                MRole role = MRole.getDefault((Properties)Env.getCtx(), (boolean)false);
                int refTableID = -1;
                if (this.gridTab != null && (col = MColumn.get((Properties)Env.getCtx(), (int)this.gridField.getAD_Column_ID())).get_ID() > 0 && (refTable = col.getReferenceTableName()) != null) {
                    MTable table2 = MTable.get((Properties)Env.getCtx(), (String)refTable);
                    refTableID = table2.getAD_Table_ID();
                }
                if (refTableID > 0 && !role.isRecordAccess(refTableID, ((Integer)value).intValue(), false)) {
                    this.setReadWrite(false);
                } else {
                    this.getComponent().setText("");
                    if (curValue == null) {
                        curValue = value;
                    }
                    ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), curValue, null);
                    super.fireValueChange(changeEvent);
                    this.value = null;
                }
            }
        } else {
            this.getComponent().setText("");
        }
        this.popupMenu.showDrillAssistant(value != null);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    public void onEvent(Event e) {
        if ("onChange".equals(e.getName())) {
            if (this.infoPanel != null) {
                this.infoPanel.detach();
                this.infoPanel = null;
            }
            if ("".equals(this.getComponent().getText().trim())) {
                this.actionCombo(null);
                this.resetButtonState();
                return;
            }
            this.actionText(this.getComponent().getText());
        } else if ("onOK".equals(e.getName())) {
            boolean isQuickFormComp = false;
            if (this.getComponent().getAttribute("IS_QUICK_FORM_COMPONENT") != null) {
                isQuickFormComp = (Boolean)this.getComponent().getAttribute("IS_QUICK_FORM_COMPONENT");
            }
            if ((this.getComponent().getText() == null || this.getComponent().getText().length() == 0) && !isQuickFormComp && this.isReadWrite()) {
                if (this.infoPanel != null) {
                    this.infoPanel.detach();
                    this.infoPanel = null;
                }
                this.actionText(this.getComponent().getText());
            } else {
                this.actionRefresh(this.getValue());
            }
        } else if ("onClick".equals(e.getName())) {
            if (this.infoPanel != null) {
                this.infoPanel.detach();
                this.infoPanel = null;
            }
            this.actionButton("");
        }
    }

    protected void actionRefresh(Object value) {
        this.setValue(value);
    }

    @Override
    public void actionZoom() {
        AEnv.actionZoom(this.lookup, this.getValue());
    }

    private void actionZoom(Object value) {
        AEnv.actionZoom(this.lookup, value);
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("REQUERY".equals(evt.getContextEvent())) {
            this.actionRefresh(this.getValue());
        } else if ("ZOOM".equals(evt.getContextEvent())) {
            this.actionZoom();
        } else {
            if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
                if (this.isShowPreference()) {
                    ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
                }
                return;
            }
            if ("NEW_RECORD".equals(evt.getContextEvent())) {
                if (this.infoPanel != null) {
                    this.infoPanel.detach();
                    this.infoPanel = null;
                }
                this.actionQuickEntry(true);
            } else if ("UPDATE_RECORD".equals(evt.getContextEvent())) {
                if (this.infoPanel != null) {
                    this.infoPanel.detach();
                    this.infoPanel = null;
                }
                this.actionQuickEntry(false);
            } else if ("CHANGE_LOG".equals(evt.getContextEvent())) {
                WFieldRecordInfo.start(this.gridField);
            } else if ("DRILL".equals(evt.getContextEvent())) {
                this.actionDrill();
            }
        }
    }

    protected void actionText(String text) {
        InfoPanel ip;
        if (text == null || text.length() == 0 || text.equals("%")) {
            this.actionButton(text);
            this.resetButtonState();
            return;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(this.getColumnName() + " - " + text);
        }
        Object id = null;
        if (this.m_tableName == null) {
            this.setTableAndKeyColumn();
        }
        if ((ip = InfoManager.create(this.lookup, this.gridField, this.m_tableName, this.m_keyColumnName, this.getComponent().getText(), this.multipleSelection, this.getWhereClause())) != null && ip.loadedOK() && ip.getRowCount() == 1) {
            if (ip.getFirstRowKey() instanceof Integer) {
                key = (Integer)ip.getFirstRowKey();
                if (key != null && (Integer)key > 0) {
                    id = (Integer)key;
                }
            } else {
                key = ip.getFirstRowKey();
                if (key != null && key.toString().length() > 0) {
                    id = key.toString();
                }
            }
        }
        if (id == null || id instanceof Integer && (Integer)id <= 0) {
            if (ip != null && ip.loadedOK()) {
                this.showInfoPanel(ip);
            } else {
                this.actionButton(this.getComponent().getText());
            }
            this.resetButtonState();
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getColumnName() + " - Unique ID=" + String.valueOf(id));
        }
        this.actionCombo(id);
        this.focusNext();
        String uid = this.getComponent().getCombobox().getUuid();
        String script = "setTimeout(function(){try{let e = zk.Widget.$('#" + uid + "').$n(); if (jq(':focus').size() == 0) e.focus();} catch(error){}}, 100);";
        Clients.response((AuResponse)new AuScript(script));
        this.resetButtonState();
    }

    protected void actionDrill() {
        if (this.getGridField() == null || this.getGridField().getGridTab() == null) {
            return;
        }
        if (!this.m_keyColumnName.endsWith("_ID")) {
            return;
        }
        MQuery query = new MQuery(this.m_tableName);
        query.addRestriction(this.m_keyColumnName, "=", this.value);
        int windowNo = this.getGridField().getGridTab().getWindowNo();
        DrillEvent.DrillData data = new DrillEvent.DrillData(query, this.m_keyColumnName, this.value, null, null);
        AEnv.actionDrill(data, windowNo);
    }

    protected void resetButtonState() {
        this.getComponent().getButton().setEnabled(true);
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass(this.imageUrl);
        } else {
            this.getComponent().getButton().setImage(this.imageUrl);
        }
        this.getComponent().invalidate();
    }

    protected void actionCombo(Object value) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Value=" + String.valueOf(value));
        }
        try {
            if (this.gridField != null) {
                this.gridField.setLookupEditorSettingValue(true);
            }
            ValueChangeEvent evt = new ValueChangeEvent(this, this.getColumnName(), this.getValue(), value);
            this.fireValueChange(evt);
            boolean updated = false;
            if (value instanceof Object[] && ((Object[])value).length > 0) {
                value = ((Object[])value)[0];
            }
            if (value == null && this.getValue() == null) {
                updated = true;
            } else if (value != null && value.equals(this.getValue())) {
                updated = true;
                this.getComponent().setText(this.lookup.getDisplay(value));
            }
            if (!updated) {
                this.setValue(value);
            }
        }
        finally {
            if (this.gridField != null) {
                this.gridField.setLookupEditorSettingValue(false);
            }
        }
    }

    protected void actionQuickEntry(boolean newRecord) {
        String tableName;
        int zoomWinID;
        if (!this.getComponent().isEnabled()) {
            return;
        }
        int zoomWindowId = -1;
        int Record_ID = 0;
        if (!newRecord) {
            if (this.value instanceof Integer) {
                Record_ID = (Integer)this.value;
            } else if (this.value != null && "".compareTo(this.value.toString()) != 0) {
                Record_ID = Integer.parseInt(this.value.toString());
            }
        }
        if (this.lookup.getColumnName() != null && (zoomWinID = Env.getZoomWindowID((int)MTable.getTable_ID((String)(tableName = this.lookup.getColumnName().substring(0, this.lookup.getColumnName().indexOf(".")))), (int)Record_ID, (int)this.lookup.getWindowNo())) > 0) {
            zoomWindowId = zoomWinID;
        }
        if (zoomWindowId < 0) {
            zoomWindowId = this.gridField != null ? this.lookup.getZoom(Env.isSOTrx((Properties)Env.getCtx(), (int)this.gridField.getWindowNo())) : this.lookup.getZoom(Env.isSOTrx((Properties)Env.getCtx()));
        }
        int tabNo = this.gridField != null && this.gridField.getGridTab() != null ? this.gridField.getGridTab().getTabNo() : 0;
        final WQuickEntry vqe = new WQuickEntry(this.lookup.getWindowNo(), tabNo, zoomWindowId);
        if (vqe.getQuickFields() <= 0) {
            return;
        }
        vqe.loadRecord(Record_ID);
        final int finalRecord_ID = Record_ID;
        vqe.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                int result;
                if (WSearchEditor.this.adwindow != null) {
                    WSearchEditor.this.adwindow.getADWindowContent().hideBusyMask();
                    WSearchEditor.this.adwindow = null;
                }
                if ((result = vqe.getRecord_ID()) == 0 && result == finalRecord_ID) {
                    return;
                }
                WSearchEditor.this.lookup.getDirect((Object)result, false, true);
                WSearchEditor.this.setValue(result);
                WSearchEditor.this.actionCombo(result);
                WSearchEditor.this.lookup.refresh();
            }
        });
        vqe.setSizable(true);
        this.adwindow = ADWindow.findADWindow((Component)this.getComponent());
        if (this.adwindow != null && !ClientInfo.isMobile()) {
            ADWindowContent content = this.adwindow.getADWindowContent();
            content.getComponent().getParent().appendChild((Component)vqe);
            content.showBusyMask(vqe);
            LayoutUtils.openOverlappedWindow(content.getComponent().getParent(), vqe, "middle_center");
        } else {
            AEnv.showWindow(vqe);
        }
    }

    protected void actionButton(String queryValue) {
        InfoPanel ip;
        if (this.lookup == null) {
            return;
        }
        String whereClause = this.getWhereClause();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.lookup.getColumnName() + ", Zoom=" + this.lookup.getZoom() + " (" + whereClause + ")");
        }
        if (queryValue.length() == 0 && this.getComponent().getText().length() > 0) {
            queryValue = this.getComponent().getText();
        }
        if (this.m_tableName == null) {
            this.setTableAndKeyColumn();
        }
        if ((ip = InfoManager.create(this.lookup, this.gridField, this.m_tableName, this.m_keyColumnName, queryValue, this.multipleSelection, whereClause)) != null) {
            this.showInfoPanel(ip);
        }
    }

    public void showInfoPanel(final InfoPanel ip) {
        ip.setVisible(true);
        ip.setStyle("border: 2px");
        ip.setClosable(true);
        ip.addValueChangeListener(this);
        this.infoPanel = ip;
        this.getComponent().setAttribute(ATTRIBUTE_IS_INFO_PANEL_OPEN, true);
        ip.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Component component = SessionManager.getAppDesktop().getActiveWindow();
                if (component instanceof IHelpContext) {
                    Events.sendEvent((Event)new Event("onWindowContainerSelectionChanged", component));
                } else {
                    SessionManager.getAppDesktop().updateHelpContext("H", 0);
                }
                boolean cancelled = ip.isCancelled();
                Object[] result = ip.getSelectedKeys();
                WSearchEditor.this.infoPanel = null;
                if (result != null && result.length > 0) {
                    if (result.length > 1) {
                        WSearchEditor.this.actionCombo(result);
                    } else {
                        WSearchEditor.this.actionCombo(result[0]);
                    }
                    WSearchEditor.this.focusNext();
                } else if (cancelled) {
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config(WSearchEditor.this.getColumnName() + " - Result = null (cancelled)");
                    }
                    if (WSearchEditor.this.value != null) {
                        if (!WSearchEditor.this.lookup.getDisplay(WSearchEditor.this.value).equals(WSearchEditor.this.getComponent().getText())) {
                            WSearchEditor.this.getComponent().setText(WSearchEditor.this.lookup.getDisplay(WSearchEditor.this.value));
                        }
                    } else {
                        WSearchEditor.this.getComponent().setText("");
                        WSearchEditor.this.actionCombo(null);
                    }
                    WSearchEditor.this.getComponent().getCombobox().focus();
                } else {
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config(WSearchEditor.this.getColumnName() + " - Result = null (not cancelled)");
                    }
                    WSearchEditor.this.getComponent().getCombobox().focus();
                    WSearchEditor.this.getComponent().setAttribute(WSearchEditor.ATTRIBUTE_IS_INFO_PANEL_OPEN, false);
                }
            }
        });
        ip.setId(ip.getTitle() + "_" + ip.getWindowNo());
        AEnv.showWindow(ip);
    }

    private void setTableAndKeyColumn() {
        if (this.lookup != null && this.lookup instanceof MLookup) {
            this.m_keyColumnName = ((MLookup)this.lookup).getColumnName();
            if (this.m_keyColumnName.contains(".")) {
                this.m_tableName = this.m_keyColumnName.substring(0, this.m_keyColumnName.indexOf("."));
                this.m_keyColumnName = this.m_keyColumnName.substring(this.m_keyColumnName.indexOf(".") + 1);
            } else {
                this.m_tableName = this.m_keyColumnName.substring(0, this.m_keyColumnName.length() - 3);
            }
        } else if (this.getGridField() != null && this.getGridField().getGridTab() != null && this.getGridField().getAD_Column_ID() > 0) {
            MColumn column = MColumn.get((Properties)Env.getCtx(), (int)this.getGridField().getAD_Column_ID());
            this.m_tableName = column.getReferenceTableName();
            MTable table2 = MTable.get((Properties)Env.getCtx(), (String)this.m_tableName);
            this.m_keyColumnName = table2.getKeyColumns()[0];
        } else {
            this.m_keyColumnName = this.getColumnName();
            this.m_tableName = this.m_keyColumnName.substring(0, this.m_keyColumnName.length() - 3);
        }
        if (this.m_keyColumnName.equals("M_Product_ID")) {
            Env.setContext((Properties)Env.getCtx(), (int)this.lookup.getWindowNo(), (int)1113, (String)"M_Product_ID", (String)"0");
            Env.setContext((Properties)Env.getCtx(), (int)this.lookup.getWindowNo(), (int)1113, (String)"M_AttributeSetInstance_ID", (String)"0");
            Env.setContext((Properties)Env.getCtx(), (int)this.lookup.getWindowNo(), (int)1113, (String)"M_Locator_ID", (String)"0");
        }
    }

    private String getWhereClause() {
        String validation;
        Object whereClause = "";
        if (this.lookup == null) {
            return "";
        }
        if (this.lookup.getZoomQuery() != null) {
            whereClause = this.lookup.getZoomQuery().getWhereClause();
        }
        if ((validation = this.lookup.getValidation()) == null) {
            validation = "";
        }
        if (((String)whereClause).length() == 0) {
            whereClause = validation;
        } else if (validation.length() > 0) {
            whereClause = (String)whereClause + " AND " + validation;
        }
        if (((String)whereClause).indexOf(64) != -1) {
            String validated = Env.parseContext((Properties)Env.getCtx(), (int)this.lookup.getWindowNo(), (String)whereClause, (boolean)false);
            if (validated.length() == 0) {
                log.severe(this.getColumnName() + " - Cannot Parse=" + (String)whereClause);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.getColumnName() + " - Parsed: " + validated);
                }
                return validated;
            }
        }
        return whereClause;
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        if ("zoom".equals(evt.getPropertyName())) {
            this.actionZoom(evt.getNewValue());
        } else if (evt.getNewValue() != null) {
            this.actionCombo(evt.getNewValue());
        }
    }

    @Override
    public void setTableEditor(boolean b) {
        super.setTableEditor(b);
        this.getComponent().setTableEditorMode(b);
    }

    public boolean isShowingDialog() {
        return this.infoPanel != null;
    }

    public static WSearchEditor createBPartner(int windowNo) {
        int AD_Column_ID = 3499;
        try {
            MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)windowNo, (int)0, (int)AD_Column_ID, (int)30);
            return new WSearchEditor("C_BPartner_ID", false, false, true, (Lookup)lookup);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
            return null;
        }
    }

    public static WSearchEditor createProduct(int windowNo) {
        int AD_Column_ID = 3840;
        try {
            MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)windowNo, (int)0, (int)AD_Column_ID, (int)30);
            return new WSearchEditor("M_Product_ID", false, false, true, (Lookup)lookup);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
            return null;
        }
    }

    @Override
    public void dynamicDisplay(Properties ctx) {
        if (this.lookup instanceof MLookup) {
            ((MLookup)this.lookup).getLookupInfo().ctx = ctx;
        }
        super.dynamicDisplay(ctx);
    }

    @Override
    public String getDisplayTextForGridView(Object value) {
        String separator;
        String s = super.getDisplayTextForGridView(value);
        if (s != null && ClientInfo.isMobile() && MSysConfig.getBooleanValue((String)"ZK_GRID_MOBILE_LINE_BREAK_AS_IDENTIFIER_SEPARATOR", (boolean)true) && !Util.isEmpty((String)(separator = MSysConfig.getValue((String)"IDENTIFIER_SEPARATOR", null, (int)Env.getAD_Client_ID((Properties)Env.getCtx()))), (boolean)true) && s.indexOf(separator) >= 0) {
            s = s.replace(separator, "\n");
        }
        return s;
    }

    public boolean isMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
    }

    static class CustomSearchBox
    extends ComboEditorBox {
        private static final long serialVersionUID = 7490301044763375829L;

        CustomSearchBox() {
        }

        public void onPageAttached(Page newpage, Page oldpage) {
            super.onPageAttached(newpage, oldpage);
            if (newpage != null) {
                String w = "try{let btn=jq('#'+this.parent.uuid+' @button').zk.$();}catch(err){}";
                if (ThemeManager.isUseFontIconForImage()) {
                    String sclass = "z-icon-spinner z-icon-spin";
                    this.getCombobox().setWidgetListener("onChange", "try{" + w + "btn.setIconSclass('" + sclass + "');btn.setDisabled(true, {adbs: false, skip: false});}catch(err){}");
                } else {
                    this.getCombobox().setWidgetListener("onChange", "try{" + w + "btn.setImage(\"" + Executions.getCurrent().encodeURL(WSearchEditor.IN_PROGRESS_IMAGE) + "\");btn.setDisabled(true, {adbs: false, skip: false});}catch(err){}");
                }
            }
        }

        public void onPageDetached(Page page) {
            this.setWidgetListener("onChange", null);
            super.onPageDetached(page);
        }
    }
}

