/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import org.adempiere.webui.component.FilenameBox;
import org.adempiere.webui.component.FolderBrowser;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.model.GridField;
import org.compiere.util.CLogger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;

public class WFileDirectoryEditor
extends WEditor {
    private static final String[] LISTENER_EVENTS = new String[]{"onClick", "onChange", "onOK"};
    private static final CLogger log = CLogger.getCLogger(WFileDirectoryEditor.class);
    private String oldValue;

    public WFileDirectoryEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WFileDirectoryEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new FilenameBox(), gridField, tableEditor, editorConfiguration);
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass("z-icon-Open");
        } else {
            this.getComponent().setButtonImage(ThemeManager.getThemeResource("images/Open16.png"));
        }
        this.getComponent().getButton().setUpload("false");
        if (gridField != null) {
            this.getComponent().getTextbox().setPlaceholder(gridField.getPlaceholder());
        }
    }

    public FilenameBox getComponent() {
        return (FilenameBox)this.component;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.oldValue = null;
            this.getComponent().setText("");
        } else {
            this.oldValue = String.valueOf(value);
            this.getComponent().setText(this.oldValue);
        }
    }

    @Override
    public Object getValue() {
        return this.getComponent().getText();
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    public void onEvent(Event event) {
        String newValue = null;
        if ("onChange".equals(event.getName()) || "onOK".equals(event.getName())) {
            newValue = this.getComponent().getText();
        } else if ("onClick".equals(event.getName())) {
            this.cmd_file();
        } else {
            return;
        }
        if (this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
            return;
        }
        if (this.oldValue == null && newValue == null) {
            return;
        }
        this.processNewValue(newValue);
    }

    protected void processNewValue(String newValue) {
        if (this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
            return;
        }
        if (this.oldValue == null && newValue == null) {
            return;
        }
        ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
        this.fireValueChange(changeEvent);
    }

    private void cmd_file() {
        final FolderBrowser directoryDialog = new FolderBrowser(true);
        directoryDialog.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                String directory = directoryDialog.getPath();
                WFileDirectoryEditor.this.getComponent().setText(directory);
                WFileDirectoryEditor.this.getComponent().getTextbox().focus();
                WFileDirectoryEditor.this.processNewValue(WFileDirectoryEditor.this.getComponent().getText());
            }
        });
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }
}

