/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.graph.jfreegraph;

import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.apps.graph.GraphBuilder;
import org.adempiere.apps.graph.GraphColumn;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.graph.IChartRendererService;
import org.adempiere.webui.apps.graph.jfreegraph.ChartRenderer;
import org.adempiere.webui.apps.graph.jfreegraph.PerformanceGraphBuilder;
import org.adempiere.webui.apps.graph.model.ChartModel;
import org.adempiere.webui.apps.graph.model.GoalModel;
import org.adempiere.webui.apps.graph.model.IndicatorModel;
import org.compiere.model.MGoal;
import org.compiere.model.MQuery;
import org.compiere.util.CLogger;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.MouseEvent;
import org.zkoss.zul.Area;
import org.zkoss.zul.Imagemap;

@Deprecated
public class ChartRendererServiceImpl
implements IChartRendererService {
    private static final CLogger log = CLogger.getCLogger(ChartRendererServiceImpl.class);

    @Override
    public boolean renderPerformanceIndicator(Component parent, int chartWidth, int chartHeight, IndicatorModel model) {
        PerformanceGraphBuilder builder = new PerformanceGraphBuilder();
        JFreeChart chart = builder.createIndicatorChart(model);
        chart.setBackgroundPaint((Paint)model.chartBackground);
        chart.setAntiAlias(true);
        BufferedImage bi = chart.createBufferedImage(chartWidth, chartHeight, 3, null);
        try {
            byte[] bytes = EncoderUtil.encode((BufferedImage)bi, (String)"png", (boolean)true);
            AImage image = new AImage("", bytes);
            org.zkoss.zul.Image myImage = new org.zkoss.zul.Image();
            myImage.setContent((Image)image);
            parent.appendChild((Component)myImage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean renderPerformanceGraph(Component parent, int chartWidth, int chartHeight, final GoalModel goalModel) {
        GraphBuilder builder = new GraphBuilder();
        builder.setMGoal(goalModel.goal);
        builder.setXAxisLabel(goalModel.xAxisLabel);
        builder.setYAxisLabel(goalModel.yAxisLabel);
        builder.loadDataSet(goalModel.columnList);
        JFreeChart chart = builder.createChart(goalModel.chartType);
        ChartRenderingInfo info = new ChartRenderingInfo();
        chart.getPlot().setForegroundAlpha(0.6f);
        if (goalModel.zoomFactor > 0) {
            chartWidth = chartWidth * goalModel.zoomFactor / 100;
            chartHeight = chartHeight * goalModel.zoomFactor / 100;
        }
        if (!goalModel.showTitle) {
            chart.setTitle("");
        }
        BufferedImage bi = chart.createBufferedImage(chartWidth, chartHeight, 3, info);
        try {
            byte[] bytes = EncoderUtil.encode((BufferedImage)bi, (String)"png", (boolean)true);
            AImage image = new AImage("", bytes);
            Imagemap myImage = new Imagemap();
            myImage.setContent((Image)image);
            parent.appendChild((Component)myImage);
            int count = 0;
            for (ChartEntity entity : info.getEntityCollection().getEntities()) {
                Comparable sectionKey;
                String key = null;
                if (entity instanceof CategoryItemEntity) {
                    Comparable colKey = ((CategoryItemEntity)entity).getColumnKey();
                    if (colKey != null) {
                        key = colKey.toString();
                    }
                } else if (entity instanceof PieSectionEntity && (sectionKey = ((PieSectionEntity)entity).getSectionKey()) != null) {
                    key = sectionKey.toString();
                }
                if (key == null) continue;
                Area area = new Area();
                myImage.appendChild((Component)area);
                area.setCoords(entity.getShapeCoords());
                area.setShape(entity.getShapeType());
                area.setTooltiptext(entity.getToolTipText());
                area.setId(count + "_WG_" + key);
                ++count;
            }
            myImage.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    MouseEvent me = (MouseEvent)event;
                    String areaId = me.getArea();
                    if (areaId != null) {
                        List<GraphColumn> list = goalModel.columnList;
                        int i = 0;
                        while (i < list.size()) {
                            String s = "_WG_" + list.get(i).getLabel();
                            if (areaId.endsWith(s)) {
                                ChartRendererServiceImpl.this.chartMouseClicked(goalModel.goal, list.get(i));
                                return;
                            }
                            ++i;
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
            return false;
        }
        return true;
    }

    private void chartMouseClicked(MGoal goal, GraphColumn bgc) {
        if (bgc == null) {
            return;
        }
        MQuery query = bgc.getMQuery(goal);
        if (query != null) {
            AEnv.zoom(query);
        } else {
            log.warning("Nothing to zoom to - " + String.valueOf(bgc));
        }
    }

    @Override
    public boolean renderChart(Component parent, int width, int height, ChartModel chartModel, boolean showTitle) {
        ChartRenderer renderer = new ChartRenderer(chartModel.chart);
        renderer.render(parent, width, height, showTitle);
        return true;
    }
}

