/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.editor.WNumberEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WYesNoEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.SimplePDFViewer;
import org.compiere.apps.form.PayPrint;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaymentBatch;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.South;

@Form(name="org.compiere.apps.form.VPayPrint")
public class WPayPrint
extends PayPrint
implements IFormController,
EventListener<Event>,
ValueChangeListener {
    private CustomForm form = new CustomForm();
    protected ConfirmPanel southPanel = new ConfirmPanel(true, false, false, false, false, false, false);
    protected Button bPrint = this.southPanel.createButton("Print");
    protected Button bExport = this.southPanel.createButton("Export");
    protected Button bCancel = this.southPanel.getButton("Cancel");
    protected Button bProcess = this.southPanel.createButton("Process");
    protected Panel centerPanel = new Panel();
    protected Grid centerLayout = GridFactory.newGridLayout();
    protected Label lPaySelect = new Label();
    protected WSearchEditor paySelectSearch = null;
    protected Label lBank = new Label();
    protected Label fBank = new Label();
    protected Label lPaymentRule = new Label();
    protected Listbox fPaymentRule = ListboxFactory.newDropdownListbox();
    protected Label lDocumentNo = new Label();
    protected WNumberEditor fDocumentNo = new WNumberEditor();
    protected Label lNoPayments = new Label();
    protected Label fNoPayments = new Label();
    protected Label lBalance = new Label();
    protected WNumberEditor fBalance = new WNumberEditor();
    protected Label lCurrency = new Label();
    protected Label fCurrency = new Label();
    protected Label lDepositBatch = new Label();
    protected WYesNoEditor fDepositBatch = new WYesNoEditor("", "", "Book as one post", false, false, true);
    protected Label lSumPayments = new Label();
    protected WNumberEditor fSumPayments = new WNumberEditor();

    public WPayPrint() {
        try {
            this.m_WindowNo = this.form.getWindowNo();
            this.dynInit();
            this.zkInit();
            Borderlayout contentLayout = new Borderlayout();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)contentLayout, "100%");
            ZKUpdateUtil.setHeight((HtmlBasedComponent)contentLayout, "100%");
            this.form.appendChild((Component)contentLayout);
            Center center = new Center();
            contentLayout.appendChild((Component)center);
            center.appendChild((Component)this.centerPanel);
            center.setAutoscroll(true);
            South south = new South();
            south.setStyle("border: none");
            contentLayout.appendChild((Component)south);
            south.appendChild((Component)this.southPanel);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    protected void zkInit() throws Exception {
        this.centerPanel.appendChild((Component)this.centerLayout);
        this.bPrint.addActionListener(this);
        this.bExport.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.bProcess.setEnabled(false);
        this.bProcess.addActionListener(this);
        this.lPaySelect.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_PaySelection_ID"));
        this.lBank.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BankAccount_ID"));
        this.lPaymentRule.setText(Msg.translate((Properties)Env.getCtx(), (String)"PaymentRule"));
        this.fPaymentRule.addActionListener(this);
        this.lDocumentNo.setText(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
        this.fDocumentNo.getComponent().setIntegral(true);
        this.lNoPayments.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"NoOfPayments"));
        this.fNoPayments.setText("0");
        this.lBalance.setText(Msg.translate((Properties)Env.getCtx(), (String)"CurrentBalance"));
        this.fBalance.setReadWrite(false);
        this.fBalance.getComponent().setIntegral(false);
        this.lCurrency.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        this.lDepositBatch.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_DepositBatch_ID"));
        this.lSumPayments.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Sum"));
        this.fSumPayments.setReadWrite(false);
        this.fSumPayments.getComponent().setIntegral(false);
        this.southPanel.addButton(this.bExport);
        this.southPanel.addButton(this.bPrint);
        this.southPanel.addButton(this.bProcess);
        Rows rows = this.centerLayout.newRows();
        Row row = rows.newRow();
        row.appendChild(this.lPaySelect.rightAlign());
        row.appendChild((Component)this.paySelectSearch.getComponent());
        row = rows.newRow();
        row.appendChild(this.lBank.rightAlign());
        row.appendChild((Component)this.fBank);
        row.appendChild(this.lBalance.rightAlign());
        row.appendChild((Component)this.fBalance.getComponent());
        row = rows.newRow();
        row.appendChild(this.lPaymentRule.rightAlign());
        row.appendChild((Component)this.fPaymentRule);
        row.appendChild(this.lCurrency.rightAlign());
        row.appendChild((Component)this.fCurrency);
        row = rows.newRow();
        row.appendChild(this.lDocumentNo.rightAlign());
        row.appendChild((Component)this.fDocumentNo.getComponent());
        row.appendChild(this.lNoPayments.rightAlign());
        row.appendChild((Component)this.fNoPayments);
        row = rows.newRow();
        row.appendChild(this.lDepositBatch.rightAlign());
        row.appendChild((Component)this.fDepositBatch.getComponent());
        row.appendChild(this.lSumPayments.rightAlign());
        row.appendChild((Component)this.fSumPayments.getComponent());
        if (ClientInfo.maxWidth(1000)) {
            Columns cols = new Columns();
            this.centerLayout.appendChild((Component)cols);
            Column col = new Column();
            col.setHflex("min");
            cols.appendChild((Component)col);
            col = new Column();
            col.setHflex("1");
            cols.appendChild((Component)col);
            LayoutUtils.compactTo(this.centerLayout, 2);
        }
        this.southPanel.getButton("Ok").setVisible(false);
        this.bExport.setDisabled(true);
        this.bPrint.setDisabled(true);
        this.fDepositBatch.setReadWrite(false);
    }

    protected void dynInit() {
        int AD_Column_ID = 7670;
        MLookup lookupPS = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.paySelectSearch = new WSearchEditor("C_PaySelection_ID", true, false, true, (Lookup)lookupPS);
        this.paySelectSearch.addValueChangeListener(this);
    }

    public void dispose() {
        SessionManager.getAppDesktop().closeActiveWindow();
    }

    public void setPaySelection(int C_PaySelection_ID) {
        if (C_PaySelection_ID == 0) {
            return;
        }
        this.m_C_PaySelection_ID = C_PaySelection_ID;
        this.paySelectSearch.setValue(this.m_C_PaySelection_ID);
        this.loadPaySelectInfo();
    }

    public void onEvent(Event e) {
        if (e.getTarget() == this.bCancel) {
            this.dispose();
        } else {
            if (this.m_C_PaySelection_ID <= 0) {
                return;
            }
            if (e.getTarget() == this.fPaymentRule) {
                this.loadPaymentRuleInfo();
            } else if (e.getTarget() == this.bExport) {
                this.cmd_export();
            } else if (e.getTarget() == this.bProcess) {
                this.cmd_EFT();
            } else if (e.getTarget() == this.bPrint) {
                this.confirm_cmd_print();
            }
        }
    }

    protected void loadPaySelectInfo() {
        if (this.m_C_PaySelection_ID <= 0) {
            return;
        }
        this.loadPaySelectInfo(this.m_C_PaySelection_ID);
        this.fBank.setText(this.bank);
        this.fCurrency.setText(this.currency);
        this.fBalance.setValue(this.balance);
        this.loadPaymentRule();
    }

    protected void loadPaymentRule() {
        if (this.m_C_BankAccount_ID == -1) {
            return;
        }
        this.fPaymentRule.removeAllItems();
        ArrayList data = this.loadPaymentRule(this.m_C_PaySelection_ID);
        for (ValueNamePair pp : data) {
            this.fPaymentRule.addItem(pp);
        }
        if (this.fPaymentRule.getItemCount() > 0) {
            this.fPaymentRule.setSelectedIndex(0);
        }
        this.loadPaymentRuleInfo();
    }

    protected void loadPaymentRuleInfo() {
        if (this.fPaymentRule.getSelectedItem() == null) {
            return;
        }
        ValueNamePair pp = this.fPaymentRule.getSelectedItem().toValueNamePair();
        if (pp == null) {
            return;
        }
        String PaymentRule = pp.getValue();
        this.fNoPayments.setText(" ");
        String msg = this.loadPaymentRuleInfo(this.m_C_PaySelection_ID, PaymentRule);
        if (this.noPayments != null) {
            this.fNoPayments.setText(this.noPayments);
        }
        if (this.sumPayments != null) {
            this.fSumPayments.setValue(this.sumPayments);
        }
        this.bProcess.setEnabled(PaymentRule.equals("T"));
        if (this.documentNo != null) {
            this.fDocumentNo.setValue(this.documentNo);
        }
        if (msg != null && msg.length() > 0) {
            Dialog.error(this.m_WindowNo, msg);
        }
        this.getPluginFeatures();
    }

    protected void getPluginFeatures() {
        if (this.m_C_PaySelection_ID != 0) {
            if (this.loadPaymentExportClass(null) >= 0) {
                this.bExport.setDisabled(false);
                this.fDepositBatch.setValue(this.m_PaymentExport.getDefaultDepositBatch());
                if (this.m_PaymentExport.supportsDepositBatch() && this.m_PaymentExport.supportsSeparateBooking()) {
                    this.fDepositBatch.setReadWrite(true);
                } else {
                    this.fDepositBatch.setReadWrite(false);
                }
            } else {
                this.bExport.setDisabled(true);
            }
            if (this.printFormatId != null && this.printFormatId != 0) {
                this.bPrint.setEnabled(true);
            } else {
                this.bPrint.setEnabled(false);
            }
        }
    }

    protected void cmd_export() {
        if (this.fPaymentRule.getSelectedItem() == null) {
            return;
        }
        String PaymentRule = this.fPaymentRule.getSelectedItem().toValueNamePair().getValue();
        if (!this.getChecks(PaymentRule)) {
            return;
        }
        try {
            int no = 0;
            StringBuffer err = new StringBuffer("");
            if (this.m_PaymentExportClass == null || this.m_PaymentExportClass.trim().length() == 0) {
                this.m_PaymentExportClass = "org.compiere.util.GenericPaymentExport";
            }
            File tempFile = null;
            Object filenameForDownload = "";
            no = this.loadPaymentExportClass(err);
            if (no >= 0) {
                tempFile = File.createTempFile(this.m_PaymentExport.getFilenamePrefix(), null);
                no = this.m_PaymentExport.exportToFile(this.m_checks, ((Boolean)this.fDepositBatch.getValue()).booleanValue(), PaymentRule, tempFile, err);
                filenameForDownload = this.m_PaymentExport.getFilenamePrefix() + this.m_PaymentExport.getFilenameSuffix();
            }
            if (no >= 0) {
                Filedownload.save((InputStream)new FileInputStream(tempFile), (String)this.m_PaymentExport.getContentType(), (String)filenameForDownload);
                Dialog.info(this.m_WindowNo, "Saved", Msg.getMsg((Properties)Env.getCtx(), (String)"NoOfLines") + "=" + no);
                Dialog.ask(this.m_WindowNo, "VPayPrintSuccess?", new Callback<Boolean>(){

                    public void onCallback(Boolean result) {
                        if (result.booleanValue()) {
                            MPaySelectionCheck.confirmPrint((MPaySelectionCheck[])WPayPrint.this.m_checks, (MPaymentBatch)WPayPrint.this.m_batch, (boolean)((Boolean)WPayPrint.this.fDepositBatch.getValue()));
                        }
                    }
                });
            } else {
                Dialog.error(this.m_WindowNo, "Error", err.toString());
            }
            this.dispose();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void cmd_EFT() {
        String PaymentRule = this.fPaymentRule.getSelectedItem().toValueNamePair().getValue();
        if (!this.getChecks(PaymentRule)) {
            return;
        }
        this.dispose();
    }

    protected void confirm_cmd_print() {
        Dialog.ask(this.m_WindowNo, "CreatePayments?", new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    WPayPrint.this.cmd_print();
                }
            }
        });
    }

    protected void cmd_print() {
        String PaymentRule = this.fPaymentRule.getSelectedItem().toValueNamePair().getValue();
        if (!this.getChecks(PaymentRule)) {
            return;
        }
        int startDocumentNo = ((Number)this.fDocumentNo.getValue()).intValue();
        if (log.isLoggable(Level.CONFIG)) {
            log.config("DocumentNo=" + startDocumentNo);
        }
        List pdfList = null;
        try {
            pdfList = this.createCheckDocuments(startDocumentNo, PaymentRule);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            return;
        }
        SimplePDFViewer chequeViewer = null;
        try {
            File outFile = File.createTempFile("WPayPrint", null);
            AEnv.mergePdf(pdfList, outFile);
            chequeViewer = new SimplePDFViewer(this.form.getFormName(), new FileInputStream(outFile));
            chequeViewer.setAttribute("mode", "embedded");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)chequeViewer, "100%");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            return;
        }
        final SimplePDFViewer chequeViewerRef = chequeViewer;
        Dialog.ask(this.m_WindowNo, "VPayPrintPrintRemittance", new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                SimplePDFViewer remitViewer = null;
                if (result.booleanValue()) {
                    List pdfList = WPayPrint.this.createRemittanceDocuments();
                    try {
                        File outFile = File.createTempFile("WPayPrint", null);
                        AEnv.mergePdf(pdfList, outFile);
                        String name = Msg.translate((Properties)Env.getCtx(), (String)"Remittance");
                        remitViewer = new SimplePDFViewer(WPayPrint.this.form.getFormName() + " - " + name, new FileInputStream(outFile));
                        remitViewer.setAttribute("mode", "embedded");
                        ZKUpdateUtil.setWidth((HtmlBasedComponent)remitViewer, "100%");
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                WPayPrint.this.dispose();
                if (chequeViewerRef != null) {
                    SessionManager.getAppDesktop().showWindow(chequeViewerRef);
                }
                if (remitViewer != null) {
                    SessionManager.getAppDesktop().showWindow(remitViewer);
                }
            }
        });
    }

    protected boolean getChecks(String PaymentRule) {
        AtomicReference error = new AtomicReference();
        boolean ok = this.getChecks(PaymentRule, this.fDocumentNo.getValue(), error, null);
        if (!ok && error.get() != null) {
            Dialog.error(this.m_WindowNo, ((ValueNamePair)error.get()).getValue(), ((ValueNamePair)error.get()).getName());
        }
        return ok;
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }

    @Override
    public void valueChange(ValueChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        if (log.isLoggable(Level.CONFIG)) {
            log.config(name + "=" + String.valueOf(value));
        }
        if (value == null) {
            return;
        }
        if (name.equals("C_PaySelection_ID")) {
            this.paySelectSearch.setValue(value);
            this.m_C_PaySelection_ID = (Integer)value;
            this.loadPaySelectInfo();
        }
    }
}

