/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.WListItemRenderer;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.apps.form.Charge;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;

@Form(name="org.compiere.apps.form.VCharge")
public class WCharge
extends Charge
implements IFormController,
EventListener<Event>,
Serializable {
    private static final long serialVersionUID = 4571016052942218676L;
    private CustomForm form = new CustomForm();
    private static final String AD_MESSAGE_CREATE = "Create";
    private static final CLogger log = CLogger.getCLogger(WCharge.class);
    private Grid m_grdNew = GridFactory.newGridLayout();
    private Label m_lblValue = new Label();
    private Textbox m_txbValueField = new Textbox();
    private Checkbox m_chbIsExpense = new Checkbox();
    private Label m_lblName = new Label();
    private Textbox m_txbNameField = new Textbox();
    private Button m_btnNew = new Button();
    private Panel m_pnlAccount = new Panel();
    private Button m_btnAccount = new Button();
    private WListbox m_tblData = new WListbox();
    private int m_selectedCount;

    public WCharge() {
        this.m_WindowNo = this.form.getWindowNo();
        this.initForm();
    }

    protected void initForm() {
        if (log.isLoggable(Level.INFO)) {
            log.info("");
        }
        try {
            this.staticInitialise();
            this.dynamicInitialise();
            this.zkInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void staticInitialise() {
        this.createNewChargePanel();
        this.createAccountPanel();
    }

    private void zkInit() {
        Borderlayout contentPane = new Borderlayout();
        this.form.appendChild((Component)contentPane);
        North north = new North();
        contentPane.appendChild((Component)north);
        north.appendChild((Component)this.m_grdNew);
        north.setCollapsible(true);
        north.setSplittable(true);
        Center center = new Center();
        contentPane.appendChild((Component)center);
        center.appendChild((Component)this.m_pnlAccount);
    }

    private void createAccountPanel() {
        Borderlayout borderlayout = new Borderlayout();
        borderlayout.setStyle("position: relative");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)borderlayout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)borderlayout, "100%");
        this.m_pnlAccount.appendChild((Component)borderlayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.m_pnlAccount, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.m_pnlAccount, "100%");
        North north = new North();
        north.setBorder("none");
        borderlayout.appendChild((Component)north);
        Label label = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"ChargeFromAccount"));
        label.setStyle("font-weight: bold;");
        north.appendChild((Component)label);
        Center center = new Center();
        center.setBorder("none");
        center.setAutoscroll(true);
        borderlayout.appendChild((Component)center);
        center.appendChild((Component)this.m_tblData);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.m_tblData, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.m_tblData, "1");
        South south = new South();
        south.setBorder("none");
        borderlayout.appendChild((Component)south);
        Panel southPanel = new Panel();
        southPanel.setStyle("text-align: right;");
        south.appendChild((Component)southPanel);
        this.m_btnAccount.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)AD_MESSAGE_CREATE) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"From") + " " + Msg.getElement((Properties)Env.getCtx(), (String)"Account_ID"));
        this.m_btnAccount.addEventListener("onClick", this);
        this.m_btnAccount.setDisabled(true);
        southPanel.appendChild((Component)new Separator());
        southPanel.appendChild((Component)this.m_btnAccount);
    }

    private void createNewChargePanel() {
        this.m_lblValue.setValue(Msg.getElement((Properties)Env.getCtx(), (String)Charge.EColumn.VALUE.title()));
        this.m_txbValueField.setCols(10);
        this.m_chbIsExpense.setChecked(true);
        this.m_chbIsExpense.setLabel(Msg.getElement((Properties)Env.getCtx(), (String)Charge.EColumn.EXPENSE.title()));
        this.m_lblName.setValue(Msg.getElement((Properties)Env.getCtx(), (String)Charge.EColumn.NAME.title()));
        this.m_txbNameField.setCols(20);
        this.m_btnNew.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)AD_MESSAGE_CREATE) + " " + Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"New")));
        this.m_btnNew.addEventListener("onClick", this);
        Rows rows = new Rows();
        this.m_grdNew.appendChild((Component)rows);
        Row row = new Row();
        rows.appendChild((Component)row);
        Label label = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"ChargeNewAccount"));
        label.setStyle("font-weight: bold;");
        row.appendCellChild((Component)label, 3);
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(this.m_lblValue.rightAlign());
        row.appendChild((Component)this.m_txbValueField);
        row.appendChild((Component)this.m_chbIsExpense);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.m_txbValueField, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(this.m_lblName.rightAlign());
        row.appendChild((Component)this.m_txbNameField);
        row.appendChild((Component)this.m_btnNew);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.m_txbNameField, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendCellChild((Component)new Separator(), 3);
    }

    private void dynamicInitialise() {
        ListModelTable model = new ListModelTable(this.getData());
        this.m_tblData.setData(model, this.getColumnNames());
        this.setColumnClass(this.m_tblData);
        this.m_selectedCount = 0;
        WListItemRenderer renderer = (WListItemRenderer)this.m_tblData.getItemRenderer();
        renderer.addTableValueChangeListener(e -> {
            if (e.getColumn() == Charge.EColumn.SELECT.index() && e.getNewValue() instanceof Boolean) {
                Boolean b = (Boolean)e.getNewValue();
                this.m_selectedCount = b.booleanValue() ? ++this.m_selectedCount : --this.m_selectedCount;
                this.m_btnAccount.setDisabled(this.m_selectedCount == 0);
            }
        });
    }

    public void onEvent(Event event) {
        if (log.isLoggable(Level.INFO)) {
            log.info(event.getName());
        }
        if (event.getTarget().getId().equals("Ok") || this.m_C_Element_ID == 0) {
            this.close();
        } else if (event.getTarget().equals((Object)this.m_btnNew)) {
            this.createNew();
        } else if (event.getTarget().equals((Object)this.m_btnAccount)) {
            this.createAccount();
        }
    }

    private void createNew() {
        String value;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("");
        }
        if ((value = this.m_txbValueField.getValue()).length() == 0) {
            throw new WrongValueException((Component)this.m_txbValueField, Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory") + this.m_lblValue.getValue());
        }
        String name = this.m_txbNameField.getText();
        if (name.length() == 0) {
            throw new WrongValueException((Component)this.m_txbNameField, Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory") + this.m_lblName.getValue());
        }
        int elementValueId = this.createElementValue(value, name, this.m_chbIsExpense.isChecked());
        if (elementValueId == 0) {
            Dialog.error(this.form.getWindowNo(), "ChargeNotCreated", name);
            return;
        }
        int chargeId = this.createCharge(name, elementValueId);
        if (chargeId == 0) {
            Dialog.error(this.form.getWindowNo(), "ChargeNotCreated", name);
            return;
        }
        Dialog.info(this.form.getWindowNo(), "ChargeCreated", name);
    }

    private void createAccount() {
        this.createAccount(this.m_tblData);
        if (this.listCreated.length() > 0) {
            Dialog.info(this.form.getWindowNo(), "ChargeCreated", this.listCreated.toString());
        }
        if (this.listRejected.length() > 0) {
            Dialog.error(this.form.getWindowNo(), "ChargeNotCreated", this.listRejected.toString());
        }
        this.m_selectedCount = 0;
        this.m_btnAccount.setDisabled(true);
    }

    public void close() {
        SessionManager.getAppDesktop().closeActiveWindow();
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }
}

