/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.Callback;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.DatetimeBox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.DateRangeButton;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.WEMailDialog;
import org.compiere.apps.form.Archive;
import org.compiere.model.Lookup;
import org.compiere.model.MArchive;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.tools.FileUtil;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Space;
import org.zkoss.zul.impl.Utils;

@Form(name="org.compiere.apps.form.ArchiveViewer")
public class WArchiveViewer
extends Archive
implements IFormController,
EventListener<Event> {
    private static final String ONCLOSE_TIMESTAMP_ATTR = "onclose.timestamp";
    private CustomForm form;
    private Checkbox reportField = new Checkbox();
    private Label processLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"AD_Process_ID"));
    private Listbox processField = new Listbox();
    private Label tableLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"AD_Table_ID"));
    private Listbox tableField = new Listbox();
    private Label bPartnerLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
    private WSearchEditor bPartnerField = null;
    private Label nameQLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Name"));
    private Textbox nameQField = new Textbox();
    private Label descriptionQLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
    private Textbox descriptionQField = new Textbox();
    private Label helpQLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Help"));
    private Textbox helpQField = new Textbox();
    private Label createdByQLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"CreatedBy"));
    private Listbox createdByQField = new Listbox();
    private Label createdQLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Created"));
    private WDateEditor createdQFrom = new WDateEditor();
    private WDateEditor createdQTo = new WDateEditor();
    private Button bBack = new Button();
    private Button bNext = new Button();
    private Label positionInfo = new Label(".");
    private Label createdByLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"CreatedBy"));
    private Textbox createdByField = new Textbox();
    private DatetimeBox createdField = new DatetimeBox();
    private Label nameLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Name"));
    private Textbox nameField = new Textbox();
    private Label descriptionLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
    private Textbox descriptionField = new Textbox();
    private Label helpLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Help"));
    private Textbox helpField = new Textbox();
    private Button updateArchive = new Button();
    private Button deleteArchive = new Button();
    private Button bEmail = new Button();
    private Iframe iframe = new Iframe();
    private Button bRefresh = new Button();
    private Tabbox tabbox = new Tabbox();
    private Tabs tabs = new Tabs();
    private Tabpanels tabpanels = new Tabpanels();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private boolean showQuery = true;
    private int mediaVersion = 0;
    private AMedia media;

    public WArchiveViewer() {
        if (log.isLoggable(Level.INFO)) {
            log.info("");
        }
        this.form = new WArchiveViewerForm();
        this.m_WindowNo = this.form.getWindowNo();
    }

    private void dynInit() {
        this.processField = new Listbox();
        KeyNamePair[] keyNamePair = this.getProcessData();
        int i = 0;
        while (i < keyNamePair.length) {
            this.processField.appendItem(keyNamePair[i].getName(), keyNamePair[i]);
            ++i;
        }
        this.tableField = new Listbox();
        keyNamePair = this.getTableData();
        i = 0;
        while (i < keyNamePair.length) {
            this.tableField.appendItem(keyNamePair[i].getName(), keyNamePair[i]);
            ++i;
        }
        this.createdByQField = new Listbox();
        keyNamePair = this.getUserData();
        i = 0;
        while (i < keyNamePair.length) {
            this.createdByQField.appendItem(keyNamePair[i].getName(), keyNamePair[i]);
            ++i;
        }
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (int)2762, (int)30);
        this.bPartnerField = new WSearchEditor((Lookup)lookup, Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"), "", true, false, true);
    }

    private void reportViewer(String name, byte[] data) {
        this.media = new AMedia(name + ".pdf", "pdf", "application/pdf", data);
        if (ClientInfo.isMobile() || MSysConfig.getBooleanValue((String)"ZK_USE_PDF_JS_VIEWER", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()))) {
            ++this.mediaVersion;
            if (this.form.getDesktop() == null) {
                this.iframe.setContent(null);
                this.iframe.setSrc(null);
            } else {
                String url = Utils.getDynamicMediaURI((AbstractComponent)this.form, (int)this.mediaVersion, (String)this.media.getName(), (String)this.media.getFormat());
                String pdfJsUrl = AEnv.toPdfJsUrl(url);
                this.iframe.setContent(null);
                this.iframe.setSrc(pdfJsUrl);
            }
        } else {
            this.iframe.setContent((Media)this.media);
        }
        this.iframe.invalidate();
    }

    private void zkInit() throws Exception {
        Row row;
        Rows rows;
        Column column;
        Columns columns;
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.tabbox, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabbox, "1");
        this.tabbox.appendChild((Component)this.tabs);
        this.tabbox.appendChild((Component)this.tabpanels);
        this.tabbox.addEventListener("onSelect", this);
        this.processField.setMold("select");
        this.processField.setRows(1);
        this.tableField.setMold("select");
        this.tableField.setRows(1);
        this.createdByQField.setMold("select");
        this.createdByQField.setRows(1);
        if (ThemeManager.isUseFontIconForImage()) {
            this.updateArchive.setIconSclass("z-icon-Ok");
        } else {
            this.updateArchive.setImage(ThemeManager.getThemeResource("images/Ok24.png"));
        }
        this.updateArchive.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Update"));
        this.updateArchive.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.deleteArchive.setIconSclass("z-icon-Delete");
        } else {
            this.deleteArchive.setImage(ThemeManager.getThemeResource("images/Delete24.png"));
        }
        this.deleteArchive.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Delete"));
        this.deleteArchive.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bRefresh.setIconSclass("z-icon-Refresh");
        } else {
            this.bRefresh.setImage(ThemeManager.getThemeResource("images/Refresh24.png"));
        }
        this.bRefresh.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh"));
        this.bRefresh.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bEmail.setIconSclass("z-icon-SendMail");
        } else {
            this.bEmail.setImage(ThemeManager.getThemeResource("images/SendMail24.png"));
        }
        this.bEmail.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"EMail"));
        this.bEmail.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bBack.setIconSclass("z-icon-Previous");
        } else {
            this.bBack.setImage(ThemeManager.getThemeResource("images/wfBack24.png"));
        }
        this.bBack.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Previous"));
        this.bBack.addEventListener("onClick", this);
        LayoutUtils.addSclass("btn-medium", (HtmlBasedComponent)this.bBack);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bNext.setIconSclass("z-icon-Next");
        } else {
            this.bNext.setImage(ThemeManager.getThemeResource("images/wfNext24.png"));
        }
        this.bNext.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Next"));
        this.bNext.addEventListener("onClick", this);
        LayoutUtils.addSclass("btn-medium", (HtmlBasedComponent)this.bNext);
        this.nameField.addEventListener("onChange", this);
        this.descriptionField.addEventListener("onChange", this);
        this.helpField.addEventListener("onChange", this);
        this.reportField.setLabel(Msg.translate((Properties)Env.getCtx(), (String)"IsReport"));
        this.reportField.addEventListener("onCheck", this);
        if (this.showQuery) {
            Grid gridQuery = GridFactory.newGridLayout();
            gridQuery.setStyle("margin:0; padding:0;");
            gridQuery.makeNoStrip();
            gridQuery.setOddRowSclass("even");
            columns = new Columns();
            gridQuery.appendChild((Component)columns);
            column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "35%");
            column.setAlign("right");
            columns.appendChild((Component)column);
            column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "40%");
            column.setAlign("left");
            columns.appendChild((Component)column);
            column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "25%");
            column.setAlign("left");
            columns.appendChild((Component)column);
            rows = new Rows();
            gridQuery.appendChild((Component)rows);
            row = new Row();
            rows.appendChild((Component)row);
            row.setAlign("right");
            row.appendCellChild((Component)this.reportField, 2);
            row.appendChild((Component)new Space());
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)this.processLabel);
            row.appendChild((Component)this.processField);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.processField, "1");
            row.appendChild((Component)new Space());
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)this.bPartnerLabel);
            row.appendChild((Component)this.bPartnerField.getComponent());
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.bPartnerField.getComponent(), "1");
            row.appendChild((Component)new Space());
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)this.tableLabel);
            row.appendChild((Component)this.tableField);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.tableField, "1");
            row.appendChild((Component)new Space());
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)this.nameQLabel);
            row.appendChild((Component)this.nameQField);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.nameQField, "1");
            row.appendChild((Component)new Space());
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)this.descriptionQLabel);
            row.appendChild((Component)this.descriptionQField);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.descriptionQField, "1");
            row.appendChild((Component)new Space());
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)this.helpQLabel);
            row.appendChild((Component)this.helpQField);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.helpQField, "1");
            row.appendChild((Component)new Space());
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)this.createdByQLabel);
            row.appendChild((Component)this.createdByQField);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.createdByQField, "1");
            row.appendChild((Component)new Space());
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)this.createdQLabel);
            Hbox hbox = new Hbox();
            hbox.appendChild((Component)this.createdQFrom.getComponent());
            hbox.appendChild((Component)this.createdQTo.getComponent());
            DateRangeButton drb = new DateRangeButton(this.createdQFrom, this.createdQTo);
            hbox.appendChild((Component)drb);
            row.appendChild((Component)hbox);
            row.appendChild((Component)new Space());
            Tabpanel tabQueryPanel = new Tabpanel();
            tabQueryPanel.appendChild((Component)gridQuery);
            Tab tabQuery = new Tab(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"ViewerQuery")));
            this.tabpanels.appendChild((Component)tabQueryPanel);
            this.tabs.appendChild((Component)tabQuery);
        }
        Grid gridView = GridFactory.newGridLayout();
        gridView.setStyle("margin:0; padding:0;");
        gridView.makeNoStrip();
        gridView.setOddRowSclass("even");
        columns = new Columns();
        gridView.appendChild((Component)columns);
        column = new Column();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "min");
        column.setAlign("left");
        columns.appendChild((Component)column);
        column = new Column();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "1");
        column.setAlign("center");
        columns.appendChild((Component)column);
        column = new Column();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "min");
        column.setAlign("right");
        columns.appendChild((Component)column);
        rows = new Rows();
        gridView.appendChild((Component)rows);
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)this.bBack);
        row.appendChild((Component)this.positionInfo);
        row.appendChild((Component)this.bNext);
        row = new Row();
        rows.appendChild((Component)row);
        row.appendCellChild((Component)this.createdByLabel, 3);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.createdByLabel, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendCellChild((Component)this.createdByField, 3);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.createdByField, "1");
        row = new Row();
        rows.appendChild((Component)row);
        Cell cell = new Cell();
        cell.setColspan(3);
        cell.setRowspan(1);
        cell.setAlign("right");
        cell.appendChild((Component)this.createdField);
        row.appendChild((Component)cell);
        row = new Row();
        rows.appendChild((Component)row);
        row.appendCellChild((Component)this.nameLabel, 3);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.nameLabel, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendCellChild((Component)this.nameField, 3);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.nameField, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendCellChild((Component)this.descriptionLabel, 3);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.descriptionLabel, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendCellChild((Component)this.descriptionField, 3);
        this.descriptionField.setRows(3);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.descriptionField, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendCellChild((Component)this.helpLabel, 3);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.helpLabel, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendCellChild((Component)this.helpField, 3);
        this.helpField.setRows(3);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.helpField, "1");
        row = new Row();
        rows.appendChild((Component)row);
        Hbox hbox = new Hbox();
        hbox.appendChild((Component)this.deleteArchive);
        hbox.appendChild((Component)this.bRefresh);
        hbox.appendChild((Component)this.bEmail);
        hbox.appendChild((Component)this.updateArchive);
        cell = new Cell();
        cell.setColspan(3);
        cell.setRowspan(1);
        cell.setAlign("right");
        cell.appendChild((Component)hbox);
        row.appendChild((Component)cell);
        this.createdByField.setReadonly(true);
        this.createdField.setEnabled(false);
        this.createdField.getDatebox().setReadonly(true);
        this.createdField.getTimebox().setReadonly(true);
        Tab tabView = new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"ViewerResult"));
        Tabpanel tabViewPanel = new Tabpanel();
        Hbox boxViewSeparator = new Hbox();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)boxViewSeparator, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)boxViewSeparator, "100%");
        cell = new Cell();
        cell.appendChild((Component)this.iframe);
        boxViewSeparator.appendChild((Component)cell);
        if (ClientInfo.maxWidth(699)) {
            ZKUpdateUtil.setHflex((HtmlBasedComponent)cell, "1");
            cell = new Cell();
            ZKUpdateUtil.setHflex((HtmlBasedComponent)cell, "min");
            ToolBarButton more = new ToolBarButton();
            if (ThemeManager.isUseFontIconForImage()) {
                more.setIconSclass("z-icon-Expand");
            } else {
                more.setImage(ThemeManager.getThemeResource("images/expand-header.png"));
            }
            cell.appendChild((Component)more);
            boxViewSeparator.appendChild((Component)cell);
            Popup sidePopup = new Popup();
            sidePopup.setWidth("300px");
            sidePopup.setVflex("min");
            sidePopup.setStyle("max-height: 100%; overflow-y: auto;");
            sidePopup.addEventListener("onOpen", evt -> {
                if (!evt.isOpen()) {
                    sidePopup.setAttribute(ONCLOSE_TIMESTAMP_ATTR, (Object)System.currentTimeMillis());
                }
            });
            tabViewPanel.appendChild((Component)sidePopup);
            sidePopup.appendChild((Component)gridView);
            more.addEventListener("onClick", evt -> {
                Long ts = (Long)sidePopup.removeAttribute(ONCLOSE_TIMESTAMP_ATTR);
                if (ts != null && System.currentTimeMillis() - ts < 500L) {
                    return;
                }
                sidePopup.open((Component)more, "after_end");
            });
        } else {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)cell, "70%");
            cell = new Cell();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)cell, "30%");
            cell.appendChild((Component)gridView);
            boxViewSeparator.appendChild((Component)cell);
        }
        tabViewPanel.appendChild((Component)boxViewSeparator);
        this.tabs.appendChild((Component)tabView);
        this.tabpanels.appendChild((Component)tabViewPanel);
        this.confirmPanel.addActionListener(this);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.confirmPanel, "min");
        this.confirmPanel.setStyle("padding-top: 2px;padding-bottom: 2px;");
        this.updateQDisplay();
        this.iframe.setId("reportFrame");
        int height = Double.valueOf((double)SessionManager.getAppDesktop().getClientInfo().desktopHeight * 0.8).intValue();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.iframe, (height -= 50) + "px");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.iframe, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.form, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.form, "100%");
        this.form.appendChild((Component)this.tabbox);
        this.form.appendChild((Component)this.confirmPanel);
    }

    public void onEvent(Event e) throws Exception {
        if (e.getTarget() == this.updateArchive) {
            this.cmd_updateArchive();
        } else if (e.getTarget() == this.deleteArchive) {
            this.cmd_deleteArchive();
        } else if (e.getTarget().getId().equals("Cancel")) {
            SessionManager.getAppDesktop().closeActiveWindow();
        } else if (e.getTarget().getId().equals("Ok")) {
            if (this.showQuery && this.tabbox.getSelectedIndex() == 0) {
                this.cmd_query();
            } else {
                SessionManager.getAppDesktop().closeActiveWindow();
            }
        } else if (e.getTarget() == this.reportField) {
            this.updateQDisplay();
        } else if (e.getTarget() == this.bBack) {
            this.updateVDisplay(false);
        } else if (e.getTarget() == this.bNext) {
            this.updateVDisplay(true);
        } else if (e.getTarget() == this.bEmail) {
            this.sendMail();
        } else if (e.getTarget() == this.bRefresh) {
            this.iframe.invalidate();
        } else if (e.getTarget() instanceof Tab && this.tabbox.getSelectedIndex() == (this.showQuery ? 1 : 0)) {
            this.iframe.invalidate();
        }
        if (e.getName().equals("onChange") && this.m_archives.length > 0) {
            this.updateArchive.setEnabled(true);
        }
    }

    private void updateQDisplay() {
        if (!this.showQuery) {
            return;
        }
        boolean reports = this.reportField.isChecked();
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Reports=" + reports);
        }
        this.processLabel.setVisible(reports);
        this.processField.setVisible(reports);
        this.processLabel.getParent().setVisible(reports);
        this.bPartnerLabel.setVisible(!reports);
        this.bPartnerField.setVisible(!reports);
        this.bPartnerLabel.getParent().setVisible(!reports);
    }

    public void cmd_deleteArchive() {
        Dialog.ask(this.m_WindowNo, "DeleteRecord?", new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    MArchive ar = WArchiveViewer.this.m_archives[WArchiveViewer.this.m_index];
                    ar.deleteEx(true);
                    WArchiveViewer.this.tabbox.setSelectedIndex(0);
                    WArchiveViewer.this.cmd_query();
                    WArchiveViewer.this.dynInit();
                }
            }
        });
    }

    private void sendMail() {
        MArchive ar = this.m_archives[this.m_index];
        MUser from = MUser.get((Properties)Env.getCtx(), (int)Env.getAD_User_ID((Properties)Env.getCtx()));
        File attachment = new File(FileUtil.getTempMailName((String)ar.getName(), (String)".pdf"));
        try {
            Files.write(attachment.toPath(), ar.getBinaryData(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new AdempiereException((Throwable)e);
        }
        WEMailDialog dialog = new WEMailDialog(Msg.getMsg((Properties)Env.getCtx(), (String)"SendMail"), from, "", "", "", (DataSource)new FileDataSource(attachment), this.m_WindowNo, ar.getAD_Table_ID(), ar.getRecord_ID(), ar.getRecord_UU(), null);
        AEnv.showWindow(dialog);
    }

    private void updateVDisplay(boolean next) {
        block18: {
            if (this.m_archives == null) {
                this.m_archives = new MArchive[0];
            }
            this.m_index = next ? ++this.m_index : --this.m_index;
            if (this.m_index >= this.m_archives.length - 1) {
                this.m_index = this.m_archives.length - 1;
            }
            if (this.m_index < 0) {
                this.m_index = 0;
            }
            this.bBack.setEnabled(this.m_index > 0);
            this.bNext.setEnabled(this.m_index < this.m_archives.length - 1);
            this.deleteArchive.setEnabled(this.m_archives.length > 0);
            this.updateArchive.setEnabled(false);
            if (log.isLoggable(Level.INFO)) {
                log.info("Index=" + this.m_index + ", Length=" + this.m_archives.length);
            }
            if (this.m_archives.length == 0) {
                this.positionInfo.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"NoRecordsFound"));
                this.createdByField.setText("");
                this.createdField.setValue(null);
                this.nameField.setText("");
                this.descriptionField.setText("");
                this.helpField.setText("");
                this.iframe.getChildren().clear();
                return;
            }
            this.positionInfo.setValue(this.m_index + 1 + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"of") + " " + this.m_archives.length);
            MArchive ar = this.m_archives[this.m_index];
            this.createdByField.setText(ar.getCreatedByName());
            this.createdField.setValue(ar.getCreated());
            this.nameField.setText(ar.getName());
            this.descriptionField.setText(ar.getDescription());
            this.helpField.setText(ar.getHelp());
            InputStream in = null;
            try {
                try {
                    in = ar.getInputStream();
                    if (in != null) {
                        this.reportViewer(ar.getName(), ar.getBinaryData());
                        break block18;
                    }
                    this.iframe.getChildren().clear();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                    this.iframe.getChildren().clear();
                    if (in == null) break block18;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void cmd_updateArchive() {
        String newText;
        MArchive ar = this.m_archives[this.m_index];
        boolean update = false;
        if (!this.isSame(this.nameField.getText(), ar.getName()) && (newText = this.nameField.getText()) != null && newText.length() > 0) {
            ar.setName(newText);
            update = true;
        }
        if (!this.isSame(this.descriptionField.getText(), ar.getDescription())) {
            ar.setDescription(this.descriptionField.getText());
            update = true;
        }
        if (!this.isSame(this.helpField.getText(), ar.getHelp())) {
            ar.setHelp(this.helpField.getText());
            update = true;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Update=" + update);
        }
        if (update) {
            ar.saveEx();
        }
        ++this.m_index;
        this.updateVDisplay(false);
    }

    public void query(boolean isReport, int AD_Table_ID, int Record_ID) {
        this.query(isReport, AD_Table_ID, Record_ID, null);
    }

    public void query(boolean isReport, int AD_Table_ID, int Record_ID, String Record_UU) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Report=" + isReport + ", AD_Table_ID=" + AD_Table_ID + ", Record_ID=" + Record_ID + ", Record_UU=" + Record_UU);
        }
        this.reportField.setChecked(isReport);
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_Record_ID = Record_ID;
        this.m_Record_UU = Record_UU;
        this.cmd_query();
    }

    private void cmd_query() {
        boolean reports = this.reportField.isChecked();
        KeyNamePair process = null;
        Integer C_BPartner_ID = null;
        String name = null;
        String description = null;
        String help = null;
        KeyNamePair table2 = null;
        KeyNamePair createdBy = null;
        Timestamp createdFrom = null;
        Timestamp createdTo = null;
        if (this.showQuery) {
            ListItem listitem = this.processField.getSelectedItem();
            process = null;
            if (listitem != null) {
                process = (KeyNamePair)listitem.getValue();
            }
            listitem = this.tableField.getSelectedItem();
            table2 = null;
            if (listitem != null) {
                table2 = (KeyNamePair)listitem.getValue();
            }
            C_BPartner_ID = (Integer)this.bPartnerField.getValue();
            name = this.nameQField.getText();
            description = this.descriptionQField.getText();
            help = this.helpQField.getText();
            listitem = this.createdByQField.getSelectedItem();
            createdBy = null;
            if (listitem != null) {
                createdBy = (KeyNamePair)listitem.getValue();
            }
            Timestamp date = null;
            createdFrom = null;
            if (this.createdQFrom.getValue() != null) {
                date = this.createdQFrom.getValue();
                createdFrom = new Timestamp(((Date)date).getTime());
            }
            createdTo = null;
            if (this.createdQTo.getValue() != null) {
                date = this.createdQTo.getValue();
                createdTo = new Timestamp(((Date)date).getTime());
            }
        }
        this.cmd_query(reports, process, table2, C_BPartner_ID, name, description, help, createdBy, createdFrom, createdTo);
        this.m_index = 1;
        if (this.showQuery) {
            this.tabbox.setSelectedIndex(1);
        }
        this.updateVDisplay(false);
    }

    public void setShowQuery(boolean showQuery) {
        this.showQuery = showQuery;
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }

    private class WArchiveViewerForm
    extends CustomForm {
        private static final long serialVersionUID = 4919349386488325L;

        private WArchiveViewerForm() {
        }

        public Object getExtraCtrl() {
            return new ExtraCtrl();
        }

        public void onPageAttached(Page newpage, Page oldpage) {
            super.onPageAttached(newpage, oldpage);
            if (newpage != null) {
                try {
                    WArchiveViewer.this.dynInit();
                    WArchiveViewer.this.zkInit();
                    if ((ClientInfo.isMobile() || MSysConfig.getBooleanValue((String)"ZK_USE_PDF_JS_VIEWER", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()))) && WArchiveViewer.this.media != null && WArchiveViewer.this.iframe.getSrc() == null) {
                        String url = Utils.getDynamicMediaURI((AbstractComponent)WArchiveViewer.this.form, (int)WArchiveViewer.this.mediaVersion, (String)WArchiveViewer.this.media.getName(), (String)WArchiveViewer.this.media.getFormat());
                        String pdfJsUrl = AEnv.toPdfJsUrl(url);
                        WArchiveViewer.this.iframe.setSrc(pdfJsUrl);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "init", (Throwable)e);
                }
            }
        }

        protected class ExtraCtrl
        extends HtmlBasedComponent.ExtraCtrl
        implements DynamicMedia {
            protected ExtraCtrl() {
                super((HtmlBasedComponent)WArchiveViewerForm.this);
            }

            public Media getMedia(String pathInfo) {
                return ((WArchiveViewerForm)WArchiveViewerForm.this).WArchiveViewer.this.media;
            }
        }
    }
}

