/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.compiere.model.AttachmentData;
import org.compiere.model.MAttachment;
import org.compiere.model.MImage;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;

public class ManageImageCache {
    protected static final CLogger log = CLogger.getCLogger(ManageImageCache.class);
    private final CCache<String, Image> imageCache = new CCache(null, "WindowImageCache", 50, 0, false);
    private static final ManageImageCache instance = new ManageImageCache();

    private ManageImageCache() {
    }

    public static ManageImageCache instance() {
        return instance;
    }

    public static URL getImageInternalUrl(MImage image) {
        if (image == null) {
            return null;
        }
        return ManageImageCache.getImageInternalUrl(image.getImageURL());
    }

    public static URL getImageInternalUrl(String url) {
        if (url == null || url.trim().length() == 0 || url.indexOf("://") > 0 || MAttachment.isAttachmentURLPath((String)url)) {
            return null;
        }
        URL urlRsource = Core.getResourceFinder().getResource(url);
        return urlRsource;
    }

    protected static byte[] loadImageData(String imagePath) {
        byte[] data;
        block3: {
            data = null;
            try {
                URL url = new URL(imagePath);
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                InputStream is = conn.getInputStream();
                byte[] buffer = new byte[8192];
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int length = -1;
                while ((length = is.read(buffer)) != -1) {
                    os.write(buffer, 0, length);
                }
                is.close();
                data = os.toByteArray();
                os.close();
            }
            catch (IOException e) {
                if (!log.isLoggable(Level.CONFIG)) break block3;
                log.config(e.toString());
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(String imagePath) {
        if (imagePath == null || imagePath.trim().length() == 0) {
            return null;
        }
        Image aImage = null;
        boolean hasCache = false;
        CCache<String, Image> cCache = this.imageCache;
        synchronized (cCache) {
            hasCache = this.imageCache.containsKey((Object)imagePath);
        }
        if (!hasCache) {
            try {
                int mImageId = Integer.parseInt(imagePath);
                this.loadImage(MImage.get((Properties)Env.getCtx(), (int)mImageId));
            }
            catch (NumberFormatException numberFormatException) {
                this.loadExtend(imagePath);
            }
        }
        CCache<String, Image> cCache2 = this.imageCache;
        synchronized (cCache2) {
            aImage = (Image)this.imageCache.get((Object)imagePath);
        }
        return aImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(URL url) {
        if (url == null) {
            return null;
        }
        Image image = null;
        boolean hasCache = false;
        CCache<String, Image> cCache = this.imageCache;
        synchronized (cCache) {
            hasCache = this.imageCache.containsKey((Object)url.toString());
            if (hasCache) {
                image = (Image)this.imageCache.get((Object)url.toString());
            }
        }
        if (!hasCache) {
            try {
                image = new AImage(url);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            }
            cCache = this.imageCache;
            synchronized (cCache) {
                this.imageCache.put((Object)url.toString(), (Object)image);
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadImage(MImage mImage) {
        if (mImage == null) {
            return null;
        }
        boolean hasCache = false;
        String strId = String.valueOf(mImage.get_ID());
        CCache<String, Image> cCache = this.imageCache;
        synchronized (cCache) {
            hasCache = this.imageCache.containsKey((Object)strId);
        }
        if (hasCache) {
            return strId;
        }
        if (mImage.getBinaryData() != null) {
            cCache = this.imageCache;
            synchronized (cCache) {
                AImage loadImage = null;
                try {
                    loadImage = new AImage(mImage.getName(), mImage.getBinaryData());
                }
                catch (IOException iOException) {}
                this.imageCache.put((Object)String.valueOf(mImage.get_ID()), (Object)loadImage);
            }
            return strId;
        }
        if (mImage.getImageURL() != null && mImage.getImageURL().trim().length() > 0 && ManageImageCache.getImageInternalUrl(mImage.getImageURL()) == null) {
            cCache = this.imageCache;
            synchronized (cCache) {
                hasCache = this.imageCache.containsKey((Object)mImage.getImageURL());
            }
            if (!hasCache) {
                this.loadExtend(mImage.getImageURL());
            }
            return mImage.getImageURL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadExtend(String imagePath) {
        AImage aImage = null;
        if (MAttachment.isAttachmentURLPath((String)imagePath)) {
            AttachmentData data = MAttachment.getDataFromAttachmentURLPath((String)imagePath);
            if (data != null && data.data() != null && data.data().length > 0) {
                try {
                    aImage = new AImage(data.name(), data.data());
                }
                catch (IOException iOException) {
                    aImage = null;
                }
            }
        } else {
            try {
                aImage = new AImage(new URL(imagePath));
            }
            catch (IOException iOException) {
                aImage = null;
            }
        }
        CCache<String, Image> cCache = this.imageCache;
        synchronized (cCache) {
            this.imageCache.put((Object)imagePath, (Object)aImage);
        }
    }
}

